/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class SAXSerializer
implements Attributes {
    transient NamedNodeMap attrs;
    transient LinkedList namespaces;

    boolean isDefined(String prefix, String uri) {
        Iterator i = this.namespaces.iterator();
        while (i.hasNext()) {
            HashMap ctx = (HashMap)i.next();
            if (!uri.equals(ctx.get(prefix))) continue;
            return true;
        }
        return false;
    }

    void define(String prefix, String uri) {
        HashMap ctx;
        Iterator i = this.namespaces.iterator();
        while (i.hasNext()) {
            HashMap ctx2 = (HashMap)i.next();
            if (!ctx2.containsKey(prefix)) continue;
            HashMap newCtx = new HashMap();
            newCtx.put(prefix, uri);
            this.namespaces.addFirst(newCtx);
            return;
        }
        if (this.namespaces.isEmpty()) {
            ctx = new HashMap();
            this.namespaces.add(ctx);
        } else {
            ctx = (HashMap)this.namespaces.getFirst();
        }
        ctx.put(prefix, uri);
    }

    void undefine(String prefix, String uri) {
        Iterator i = this.namespaces.iterator();
        while (i.hasNext()) {
            HashMap ctx = (HashMap)i.next();
            if (!uri.equals(ctx.get(prefix))) continue;
            ctx.remove(prefix);
            if (ctx.isEmpty()) {
                this.namespaces.remove(ctx);
            }
            return;
        }
    }

    public int getLength() {
        return this.attrs.getLength();
    }

    public String getURI(int index) {
        return this.attrs.item(index).getNamespaceURI();
    }

    public String getLocalName(int index) {
        return this.attrs.item(index).getLocalName();
    }

    public String getQName(int index) {
        return this.attrs.item(index).getNodeName();
    }

    public String getType(int index) {
        Attr attr = (Attr)this.attrs.item(index);
        return attr.isId() ? "ID" : "CDATA";
    }

    public String getValue(int index) {
        return this.attrs.item(index).getNodeValue();
    }

    public int getIndex(String uri, String localName) {
        int len = this.attrs.getLength();
        int i = 0;
        while (i < len) {
            Node attr = this.attrs.item(i);
            String a_uri = attr.getNamespaceURI();
            String a_localName = attr.getLocalName();
            if ((a_uri == null && uri == null || a_uri != null && a_uri.equals(uri)) && a_localName.equals(localName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getIndex(String qName) {
        int len = this.attrs.getLength();
        int i = 0;
        while (i < len) {
            Node attr = this.attrs.item(i);
            String a_name = attr.getNodeName();
            if (a_name.equals(qName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getType(String uri, String localName) {
        Attr attr = (Attr)this.attrs.getNamedItemNS(uri, localName);
        return attr.isId() ? "ID" : "CDATA";
    }

    public String getType(String qName) {
        Attr attr = (Attr)this.attrs.getNamedItem(qName);
        return attr.isId() ? "ID" : "CDATA";
    }

    public String getValue(String uri, String localName) {
        return this.attrs.getNamedItemNS(uri, localName).getNodeValue();
    }

    public String getValue(String qName) {
        return this.attrs.getNamedItem(qName).getNodeValue();
    }

    void serialize(Node node2, ContentHandler ch, LexicalHandler lh) throws SAXException {
        this.attrs = node2.getAttributes();
        Node next = node2.getNextSibling();
        switch (node2.getNodeType()) {
            case 1: {
                String uri = node2.getNamespaceURI();
                String prefix = node2.getPrefix();
                boolean defined = this.isDefined(prefix, uri);
                if (!defined) {
                    this.define(prefix, uri);
                    ch.startPrefixMapping(prefix, uri);
                }
                String localName = node2.getLocalName();
                String qName = node2.getNodeName();
                ch.startElement(uri, localName, qName, this);
                Node children = node2.getFirstChild();
                if (children != null) {
                    this.serialize(children, ch, lh);
                }
                ch.endElement(uri, localName, qName);
                if (defined) break;
                ch.endPrefixMapping(prefix);
                this.undefine(prefix, uri);
                break;
            }
            case 3: {
                char[] chars = node2.getNodeValue().toCharArray();
                ch.characters(chars, 0, chars.length);
                break;
            }
            case 4: {
                char[] cdata = node2.getNodeValue().toCharArray();
                if (lh != null) {
                    lh.startCDATA();
                    ch.characters(cdata, 0, cdata.length);
                    lh.endCDATA();
                    break;
                }
                ch.characters(cdata, 0, cdata.length);
                break;
            }
            case 8: {
                if (lh == null) break;
                char[] comment = node2.getNodeValue().toCharArray();
                lh.comment(comment, 0, comment.length);
                break;
            }
            case 9: 
            case 11: {
                ch.startDocument();
                Node children = node2.getFirstChild();
                if (children != null) {
                    this.serialize(children, ch, lh);
                }
                ch.endDocument();
                break;
            }
            case 10: {
                if (lh == null) break;
                DocumentType doctype = (DocumentType)node2;
                String publicId = doctype.getPublicId();
                String systemId = doctype.getSystemId();
                lh.startDTD(node2.getNodeName(), publicId, systemId);
                NamedNodeMap entities = doctype.getEntities();
                int len = entities.getLength();
                int i = 0;
                while (i < len) {
                    Node entity = entities.item(i);
                    String entityName = entity.getNodeName();
                    lh.startEntity(entityName);
                    lh.endEntity(entityName);
                    ++i;
                }
                lh.endDTD();
                break;
            }
            case 7: {
                ch.processingInstruction(node2.getNodeName(), node2.getNodeValue());
                break;
            }
            case 5: {
                ch.skippedEntity(node2.getNodeName());
                break;
            }
        }
        this.attrs = null;
        if (next != null) {
            this.serialize(next, ch, lh);
        }
    }

    private final /* synthetic */ void this() {
        this.namespaces = new LinkedList();
    }

    SAXSerializer() {
        this.this();
    }
}

