/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PrintStream
extends FilterOutputStream {
    private static final char[] line_separator = System.getProperty("line.separator").toCharArray();
    private String encoding;
    private boolean error_occurred;
    private boolean auto_flush;

    public boolean checkError() {
        this.flush();
        return this.error_occurred;
    }

    protected void setError() {
        this.error_occurred = true;
    }

    public void close() {
        try {
            this.flush();
            this.out.close();
        }
        catch (InterruptedIOException iioe) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            this.setError();
        }
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (InterruptedIOException iioe) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            this.setError();
        }
    }

    private final synchronized void print(String str, boolean println) {
        try {
            this.writeChars(str, 0, str.length());
            if (println) {
                this.writeChars(line_separator, 0, line_separator.length);
            }
            if (this.auto_flush) {
                this.flush();
            }
        }
        catch (InterruptedIOException iioe) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            this.setError();
        }
    }

    private final synchronized void print(char[] chars, int pos, int len, boolean println) {
        try {
            this.writeChars(chars, pos, len);
            if (println) {
                this.writeChars(line_separator, 0, line_separator.length);
            }
            if (this.auto_flush) {
                this.flush();
            }
        }
        catch (InterruptedIOException iioe) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            this.setError();
        }
    }

    private final void writeChars(char[] buf, int offset, int count) throws IOException {
        byte[] bytes = new String(buf, offset, count).getBytes(this.encoding);
        this.out.write(bytes, 0, bytes.length);
    }

    private final void writeChars(String str, int offset, int count) throws IOException {
        byte[] bytes = str.substring(offset, offset + count).getBytes(this.encoding);
        this.out.write(bytes, 0, bytes.length);
    }

    public void print(boolean bool) {
        this.print(String.valueOf(bool), false);
    }

    public void print(int inum) {
        this.print(String.valueOf(inum), false);
    }

    public void print(long lnum) {
        this.print(String.valueOf(lnum), false);
    }

    public void print(float fnum) {
        this.print(String.valueOf(fnum), false);
    }

    public void print(double dnum) {
        this.print(String.valueOf(dnum), false);
    }

    public void print(Object obj) {
        this.print(obj == null ? "null" : obj.toString(), false);
    }

    public void print(String str) {
        this.print(str == null ? "null" : str, false);
    }

    public synchronized void print(char ch) {
        this.print(new char[]{ch}, 0, 1, false);
    }

    public void print(char[] charArray) {
        this.print(charArray, 0, charArray.length, false);
    }

    public void println() {
        this.print(line_separator, 0, line_separator.length, false);
    }

    public void println(boolean bool) {
        this.print(String.valueOf(bool), true);
    }

    public void println(int inum) {
        this.print(String.valueOf(inum), true);
    }

    public void println(long lnum) {
        this.print(String.valueOf(lnum), true);
    }

    public void println(float fnum) {
        this.print(String.valueOf(fnum), true);
    }

    public void println(double dnum) {
        this.print(String.valueOf(dnum), true);
    }

    public void println(Object obj) {
        this.print(obj == null ? "null" : obj.toString(), true);
    }

    public void println(String str) {
        this.print(str == null ? "null" : str, true);
    }

    public synchronized void println(char ch) {
        this.print(new char[]{ch}, 0, 1, true);
    }

    public void println(char[] charArray) {
        this.print(charArray, 0, charArray.length, true);
    }

    public void write(int oneByte) {
        try {
            this.out.write(oneByte & 0xFF);
            if (this.auto_flush && oneByte == 10) {
                this.flush();
            }
        }
        catch (InterruptedIOException iioe) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            this.setError();
        }
    }

    public void write(byte[] buffer, int offset, int len) {
        try {
            this.out.write(buffer, offset, len);
            if (this.auto_flush) {
                this.flush();
            }
        }
        catch (InterruptedIOException iioe) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            this.setError();
        }
    }

    private final /* synthetic */ void this() {
        this.error_occurred = false;
    }

    public PrintStream(OutputStream out) {
        this(out, false);
    }

    public PrintStream(OutputStream out, boolean auto_flush) {
        super(out);
        this.this();
        try {
            this.encoding = System.getProperty("file.encoding");
        }
        catch (SecurityException e) {
            this.encoding = "ISO8859_1";
        }
        catch (IllegalArgumentException e) {
            this.encoding = "ISO8859_1";
        }
        catch (NullPointerException e) {
            this.encoding = "ISO8859_1";
        }
        this.auto_flush = auto_flush;
    }

    public PrintStream(OutputStream out, boolean auto_flush, String encoding) throws UnsupportedEncodingException {
        super(out);
        this.this();
        new String(new byte[1], encoding);
        this.encoding = encoding;
        this.auto_flush = auto_flush;
    }
}

