'''OpenGL extension NV.generate_mipmap_sRGB

This module customises the behaviour of the 
OpenGL.raw.GLES2.NV.generate_mipmap_sRGB to provide a more 
Python-friendly API

Overview (from the spec)
	
	EXT_sRGB requires GenerateMipmap() to throw INVALID_OPERATION on textures
	with sRGB encoding. NV_generate_mipmap_sRGB lifts this restriction.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/generate_mipmap_sRGB.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.NV.generate_mipmap_sRGB import *
from OpenGL.raw.GLES2.NV.generate_mipmap_sRGB import _EXTENSION_NAME

def glInitGenerateMipmapSrgbNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION