/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.glyphs.Glyph;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.claribole.zvtm.glyphs.projection.ProjectedCoords;

public class VPoint
extends Glyph {
    ProjectedCoords[] pc;

    public VPoint() {
        this.vx = 0L;
        this.vy = 0L;
        this.size = 1.0f;
        this.setColor(Color.white);
    }

    public VPoint(long x, long y, Color c) {
        this.vx = x;
        this.vy = y;
        this.vz = 0;
        this.size = 1.0f;
        this.setColor(c);
    }

    public VPoint(long x, long y, int z, Color c) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.size = 1.0f;
        this.setColor(c);
    }

    public void initCams(int nbCam) {
        this.pc = new ProjectedCoords[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new ProjectedCoords();
        }
    }

    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                ProjectedCoords[] ta = this.pc;
                this.pc = new ProjectedCoords[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new ProjectedCoords();
            } else {
                System.err.println("VPoint:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new ProjectedCoords[1];
            this.pc[0] = new ProjectedCoords();
        } else {
            System.err.println("VPoint:Error while adding camera " + verifIndex);
        }
    }

    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
    }

    public void sizeTo(float factor) {
    }

    public void reSize(float factor) {
    }

    public void orientTo(float angle) {
    }

    public float getSize() {
        return 1.0f;
    }

    public float getOrient() {
        return 0.0f;
    }

    public boolean fillsView(long w, long h, int camIndex) {
        return false;
    }

    public boolean coordInside(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        return jpx == this.pc[camIndex].cx && jpy == this.pc[camIndex].cy;
    }

    public boolean visibleInDisc(long dvx, long dvy, long dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return Math.sqrt(Math.pow(this.vx - dvx, 2.0) + Math.pow(this.vy - dvy, 2.0)) <= (double)dvr;
    }

    public short mouseInOut(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        if (this.coordInside(jpx, jpy, camIndex, cvx, cvy)) {
            if (!this.pc[camIndex].prevMouseIn) {
                this.pc[camIndex].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[camIndex].prevMouseIn) {
            this.pc[camIndex].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = d.width / 2 + Math.round((float)(this.vx - c.posx) * this.coef);
        this.pc[i].cy = d.height / 2 - Math.round((float)(this.vy - c.posy) * this.coef);
    }

    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, long lensx, long lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * lensMag;
        this.pc[i].lcx = lensWidth / 2 + Math.round((float)(this.vx - lensx) * this.coef);
        this.pc[i].lcy = lensHeight / 2 - Math.round((float)(this.vy - lensy) * this.coef);
    }

    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        g.setColor(this.color);
        g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
    }

    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        g.setColor(this.color);
        g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
    }

    public Object clone() {
        VPoint res = new VPoint(this.vx, this.vy, this.color);
        res.mouseInsideColor = this.mouseInsideColor;
        return res;
    }

    public void highlight(boolean b, Color selectedColor) {
        boolean update = false;
        if (b) {
            if (this.mouseInsideColor != null) {
                this.color = this.mouseInsideColor;
                update = true;
            }
        } else if (this.isSelected() && selectedColor != null) {
            this.color = selectedColor;
            update = true;
        } else if (this.mouseInsideColor != null) {
            this.color = this.fColor;
            update = true;
        }
        if (update) {
            try {
                this.vsm.repaintNow();
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
        }
    }
}

