require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_AARCH64_CPU_H_)) {
    eval 'sub _AARCH64_CPU_H_ () {1;}' unless defined(&_AARCH64_CPU_H_);
    require 'arm/cpu.ph';
    if(defined(&__aarch64__)) {
	if(defined(&_KERNEL_OPT)) {
	    require './aarch64/opt_gprof.ph';
	    require './aarch64/opt_multiprocessor.ph';
	    require './aarch64/opt_pmap.ph';
	}
	require 'sys/param.ph';
	if(defined(&_KERNEL) || defined(&_KMEMUSER)) {
	    require 'sys/evcnt.ph';
	    require 'aarch64/armreg.ph';
	    require 'aarch64/frame.ph';
	    eval 'sub CLKF_USERMODE {
	        my($cf) = @_;
    		eval q((((($cf)-> ($cf_tf->{tf_spsr})) & 0xf) == 0));
	    }' unless defined(&CLKF_USERMODE);
	    eval 'sub CLKF_PC {
	        my($cf) = @_;
    		eval q((($cf)-> ($cf_tf->{tf_pc})));
	    }' unless defined(&CLKF_PC);
	    eval 'sub CLKF_INTR {
	        my($cf) = @_;
    		eval q((( &void)($cf),  &curcpu()-> &ci_intr_depth > 1));
	    }' unless defined(&CLKF_INTR);
	    eval 'sub LWP_PC {
	        my($l) = @_;
    		eval q((($l)-> ($l_md->{md_utf}->{tf_pc})));
	    }' unless defined(&LWP_PC);
	    require 'sys/cpu_data.ph';
	    require 'sys/device_if.ph';
	    require 'sys/intr.ph';
	    eval 'sub MAX_CACHE_LEVEL () {8;}' unless defined(&MAX_CACHE_LEVEL);
	    eval 'sub CACHE_TYPE_VPIPT () {0;}' unless defined(&CACHE_TYPE_VPIPT);
	    eval 'sub CACHE_TYPE_VIVT () {1;}' unless defined(&CACHE_TYPE_VIVT);
	    eval 'sub CACHE_TYPE_VIPT () {2;}' unless defined(&CACHE_TYPE_VIPT);
	    eval 'sub CACHE_TYPE_PIPT () {3;}' unless defined(&CACHE_TYPE_PIPT);
	    eval 'sub CACHE_CACHEABLE_NONE () {0;}' unless defined(&CACHE_CACHEABLE_NONE);
	    eval 'sub CACHE_CACHEABLE_ICACHE () {1;}' unless defined(&CACHE_CACHEABLE_ICACHE);
	    eval 'sub CACHE_CACHEABLE_DCACHE () {2;}' unless defined(&CACHE_CACHEABLE_DCACHE);
	    eval 'sub CACHE_CACHEABLE_IDCACHE () {3;}' unless defined(&CACHE_CACHEABLE_IDCACHE);
	    eval 'sub CACHE_CACHEABLE_UNIFIED () {4;}' unless defined(&CACHE_CACHEABLE_UNIFIED);
	    eval 'sub LPI_SAVE_RESTORE_CORE () { &__BIT(0);}' unless defined(&LPI_SAVE_RESTORE_CORE);
	    eval 'sub LPI_SAVE_RESTORE_TRACE () { &__BIT(1);}' unless defined(&LPI_SAVE_RESTORE_TRACE);
	    eval 'sub LPI_SAVE_RESTORE_GICR () { &__BIT(2);}' unless defined(&LPI_SAVE_RESTORE_GICR);
	    eval 'sub LPI_SAVE_RESTORE_GICD () { &__BIT(3);}' unless defined(&LPI_SAVE_RESTORE_GICD);
	    eval 'sub LPI_REG_ADDR_WFI () {0xffffffff;}' unless defined(&LPI_REG_ADDR_WFI);
	    if(defined(&PMAP_MI)) {
	    }
	    eval 'sub ci_midr () { ($ci_id->{ac_midr});}' unless defined(&ci_midr);
	    if(defined(&GPROF)  && defined(&MULTIPROCESSOR)) {
	    }
	    if(defined(&_KERNEL)) {
		eval 'sub __attribute__ () {
		    eval q((( &const))  &aarch64_curlwp( &void) { \'struct lwp\' * &l;  &__asm(\\"mrs %0, tpidr_el1\\" : \\"=r\\"( &l));  &l; });
		}' unless defined(&__attribute__);
		eval 'sub curcpu () {
		    eval q(( &lwp_getcpu( &aarch64_curlwp())));
		}' unless defined(&curcpu);
		eval 'sub setsoftast {
		    my($ci) = @_;
    		    eval q(( &cpu_signotify(($ci)-> &ci_onproc)));
		}' unless defined(&setsoftast);
		undef(&curlwp) if defined(&curlwp);
		eval 'sub curlwp () {( &aarch64_curlwp());}' unless defined(&curlwp);
		eval 'sub curpcb () {( &lwp_getpcb( &curlwp));}' unless defined(&curpcb);
		eval 'sub CPU_INFO_ITERATOR () {\'int\';}' unless defined(&CPU_INFO_ITERATOR);
		if(defined(&MULTIPROCESSOR) || defined(&_MODULE)) {
		    eval 'sub cpu_number () {
		        eval q(( &curcpu()-> &ci_index));
		    }' unless defined(&cpu_number);
		    eval 'sub CPU_IS_PRIMARY {
		        my($ci) = @_;
    			eval q((($ci)-> &ci_index == 0));
		    }' unless defined(&CPU_IS_PRIMARY);
		    eval 'sub CPU_INFO_FOREACH {
		        my($cii, $ci) = @_;
    			eval q($cii = 0, $ci =  $cpu_info[0]; $cii < ( &ncpu ?  &ncpu : 1)  && ($ci =  $cpu_info[$cii]) !=  &NULL; $cii++);
		    }' unless defined(&CPU_INFO_FOREACH);
		} else {
		    eval 'sub cpu_number () {
		        eval q(0);
		    }' unless defined(&cpu_number);
		    eval 'sub CPU_IS_PRIMARY {
		        my($ci) = @_;
    			eval q( &true);
		    }' unless defined(&CPU_IS_PRIMARY);
		    eval 'sub CPU_INFO_FOREACH {
		        my($cii, $ci) = @_;
    			eval q($cii = 0,  &__USE($cii), $ci =  &curcpu(); $ci !=  &NULL; $ci =  &NULL);
		    }' unless defined(&CPU_INFO_FOREACH);
		}
		eval 'sub LWP0_CPU_INFO () {( $cpu_info_store[0]);}' unless defined(&LWP0_CPU_INFO);
		eval 'sub __HAVE_CPU_DOSOFTINTS_CI () {1;}' unless defined(&__HAVE_CPU_DOSOFTINTS_CI);
# some #ifdef were dropped here -- fill in the blanks
		eval 'sub cpu_dosoftints_ci {
		    my($ci) = @_;
    		    eval q({ });
		}' unless defined(&cpu_dosoftints_ci);
# some #ifdef were dropped here -- fill in the blanks
		eval 'sub cpu_dosoftints {
		    my($void) = @_;
    		    eval q({ });
		}' unless defined(&cpu_dosoftints);
	    }
	}
    }
}
1;
