/*
 * Copyright (C) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
 * SPDX-License-Identifier: MIT
 */

#ifndef VATOMIC_CORE_U16_H
#define VATOMIC_CORE_U16_H
/*******************************************************************************
 * @file core_u16.h
 * @brief Atomic functions for vatomic16_t variables.
 *
 * This file declares and documents the core atomic functions operating on
 * vatomic16_t variables.
 *
 * Please do not include this file directly, instead use:
 * ```c
 * #include <vsync/atomic/core.h>
 * ```
 ******************************************************************************/
/* !!!Warning: File generated by tmplr; DO NOT EDIT.!!! */
#ifndef VATOMIC_CORE_H
    #error "File included directly. Include <vsync/atomic/core.h> instead!"
#endif

/**
 * Initializes the atomic variable a with value v.
 *
 * The initialization is equivalent to an vatomic16_write().
 *
 * @param a atomic variable
 * @param v initial value
 * @memord seq_cst
 */
static inline void vatomic16_init(vatomic16_t *a, vuint16_t v);

/**
 * Returns the value of the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @return current value
 * @memord seq_cst
 */
static inline vuint16_t vatomic16_read(const vatomic16_t *a);
/**
 * Returns the value of the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @return current value
 * @memord acquire
 */
static inline vuint16_t vatomic16_read_acq(const vatomic16_t *a);
/**
 * Returns the value of the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @return current value
 * @memord relaxed
 */
static inline vuint16_t vatomic16_read_rlx(const vatomic16_t *a);

/**
 * Writes value v in the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @param v new value
 * @memord seq_cst
 */
static inline void vatomic16_write(vatomic16_t *a, vuint16_t v);
/**
 * Writes value v in the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @param v new value
 * @memord release
 */
static inline void vatomic16_write_rel(vatomic16_t *a, vuint16_t v);
/**
 * Writes value v in the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @param v new value
 * @memord relaxed
 */
static inline void vatomic16_write_rlx(vatomic16_t *a, vuint16_t v);

/**
 * Writes v in a and returns old value.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord seq_cst
 */
static inline vuint16_t vatomic16_xchg(vatomic16_t *a, vuint16_t v);
/**
 * Writes v in a and returns old value.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord acquire
 */
static inline vuint16_t vatomic16_xchg_acq(vatomic16_t *a, vuint16_t v);
/**
 * Writes v in a and returns old value.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord release
 */
static inline vuint16_t vatomic16_xchg_rel(vatomic16_t *a, vuint16_t v);
/**
 * Writes v in a and returns old value.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord relaxed
 */
static inline vuint16_t vatomic16_xchg_rlx(vatomic16_t *a, vuint16_t v);

/**
 * Writes value v in a if e is the current value.
 *
 * @param a atomic variable
 * @param e expected value
 * @param v new value
 * @return old value
 */
static inline vuint16_t vatomic16_cmpxchg(vatomic16_t *a, vuint16_t e,
                                          vuint16_t v);
/**
 * Writes value v in a if e is the current value.
 *
 * @param a atomic variable
 * @param e expected value
 * @param v new value
 * @return old value
 */
static inline vuint16_t vatomic16_cmpxchg_acq(vatomic16_t *a, vuint16_t e,
                                              vuint16_t v);
/**
 * Writes value v in a if e is the current value.
 *
 * @param a atomic variable
 * @param e expected value
 * @param v new value
 * @return old value
 */
static inline vuint16_t vatomic16_cmpxchg_rel(vatomic16_t *a, vuint16_t e,
                                              vuint16_t v);
/**
 * Writes value v in a if e is the current value.
 *
 * @param a atomic variable
 * @param e expected value
 * @param v new value
 * @return old value
 */
static inline vuint16_t vatomic16_cmpxchg_rlx(vatomic16_t *a, vuint16_t e,
                                              vuint16_t v);

/**
 * Writes v to a if v is greater than *a and returns the old value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return old max value
 * @memord seq_cst
 */
static inline vuint16_t vatomic16_get_max(vatomic16_t *a, vuint16_t v);
/**
 * Writes v to a if v is greater than *a and returns the old value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return old max value
 * @memord acquire
 */
static inline vuint16_t vatomic16_get_max_acq(vatomic16_t *a, vuint16_t v);
/**
 * Writes v to a if v is greater than *a and returns the old value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return old max value
 * @memord release
 */
static inline vuint16_t vatomic16_get_max_rel(vatomic16_t *a, vuint16_t v);
/**
 * Writes v to a if v is greater than *a and returns the old value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return old max value
 * @memord relaxed
 */
static inline vuint16_t vatomic16_get_max_rlx(vatomic16_t *a, vuint16_t v);

/**
 * Writes v to a if v is greater than *a and returns the new value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return new max value
 * @memord seq_cst
 */
static inline vuint16_t vatomic16_max_get(vatomic16_t *a, vuint16_t v);
/**
 * Writes v to a if v is greater than *a and returns the new value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return new max value
 * @memord acquire
 */
static inline vuint16_t vatomic16_max_get_acq(vatomic16_t *a, vuint16_t v);
/**
 * Writes v to a if v is greater than *a and returns the new value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return new max value
 * @memord release
 */
static inline vuint16_t vatomic16_max_get_rel(vatomic16_t *a, vuint16_t v);
/**
 * Writes v to a if v is greater than *a and returns the new value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return new max value
 * @memord relaxed
 */
static inline vuint16_t vatomic16_max_get_rlx(vatomic16_t *a, vuint16_t v);

/**
 * Writes v to a if v is greater than *a.
 *
 * @param a atomic variable
 * @param v potential max value
 * @memord seq_cst
 */
static inline void vatomic16_max(vatomic16_t *a, vuint16_t v);
/**
 * Writes v to a if v is greater than *a.
 *
 * @param a atomic variable
 * @param v potential max value
 * @memord release
 */
static inline void vatomic16_max_rel(vatomic16_t *a, vuint16_t v);
/**
 * Writes v to a if v is greater than *a.
 *
 * @param a atomic variable
 * @param v potential max value
 * @memord relaxed
 */
static inline void vatomic16_max_rlx(vatomic16_t *a, vuint16_t v);

/**
 * Applies bitwise and to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord seq_cst
 */
static inline vuint16_t vatomic16_get_and(vatomic16_t *a, vuint16_t v);
/**
 * Applies bitwise and to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord acquire
 */
static inline vuint16_t vatomic16_get_and_acq(vatomic16_t *a, vuint16_t v);
/**
 * Applies bitwise and to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord release
 */
static inline vuint16_t vatomic16_get_and_rel(vatomic16_t *a, vuint16_t v);
/**
 * Applies bitwise and to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord relaxed
 */
static inline vuint16_t vatomic16_get_and_rlx(vatomic16_t *a, vuint16_t v);

/**
 * Applies bitwise and operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord seq_cst
 */
static inline vuint16_t vatomic16_and_get(vatomic16_t *a, vuint16_t v);
/**
 * Applies bitwise and operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord acquire
 */
static inline vuint16_t vatomic16_and_get_acq(vatomic16_t *a, vuint16_t v);
/**
 * Applies bitwise and operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord release
 */
static inline vuint16_t vatomic16_and_get_rel(vatomic16_t *a, vuint16_t v);
/**
 * Applies bitwise and operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord relaxed
 */
static inline vuint16_t vatomic16_and_get_rlx(vatomic16_t *a, vuint16_t v);

/**
 * Applies bitwise and operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord seq_cst
 */
static inline void vatomic16_and(vatomic16_t *a, vuint16_t v);
/**
 * Applies bitwise and operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord release
 */
static inline void vatomic16_and_rel(vatomic16_t *a, vuint16_t v);
/**
 * Applies bitwise and operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord relaxed
 */
static inline void vatomic16_and_rlx(vatomic16_t *a, vuint16_t v);

/**
 * Applies bitwise or operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord seq_cst
 */
static inline vuint16_t vatomic16_get_or(vatomic16_t *a, vuint16_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord acquire
 */
static inline vuint16_t vatomic16_get_or_acq(vatomic16_t *a, vuint16_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord release
 */
static inline vuint16_t vatomic16_get_or_rel(vatomic16_t *a, vuint16_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord relaxed
 */
static inline vuint16_t vatomic16_get_or_rlx(vatomic16_t *a, vuint16_t v);

/**
 * Applies bitwise or operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord seq_cst
 */
static inline vuint16_t vatomic16_or_get(vatomic16_t *a, vuint16_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord acquire
 */
static inline vuint16_t vatomic16_or_get_acq(vatomic16_t *a, vuint16_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord release
 */
static inline vuint16_t vatomic16_or_get_rel(vatomic16_t *a, vuint16_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord relaxed
 */
static inline vuint16_t vatomic16_or_get_rlx(vatomic16_t *a, vuint16_t v);

/**
 * Applies bitwise or operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord seq_cst
 */
static inline void vatomic16_or(vatomic16_t *a, vuint16_t v);
/**
 * Applies bitwise or operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord release
 */
static inline void vatomic16_or_rel(vatomic16_t *a, vuint16_t v);
/**
 * Applies bitwise or operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord relaxed
 */
static inline void vatomic16_or_rlx(vatomic16_t *a, vuint16_t v);

/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord seq_cst
 */
static inline vuint16_t vatomic16_get_xor(vatomic16_t *a, vuint16_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord acquire
 */
static inline vuint16_t vatomic16_get_xor_acq(vatomic16_t *a, vuint16_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord release
 */
static inline vuint16_t vatomic16_get_xor_rel(vatomic16_t *a, vuint16_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord relaxed
 */
static inline vuint16_t vatomic16_get_xor_rlx(vatomic16_t *a, vuint16_t v);

/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord seq_cst
 */
static inline vuint16_t vatomic16_xor_get(vatomic16_t *a, vuint16_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord acquire
 */
static inline vuint16_t vatomic16_xor_get_acq(vatomic16_t *a, vuint16_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord release
 */
static inline vuint16_t vatomic16_xor_get_rel(vatomic16_t *a, vuint16_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord relaxed
 */
static inline vuint16_t vatomic16_xor_get_rlx(vatomic16_t *a, vuint16_t v);

/**
 * Applies bitwise xor opeation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord seq_cst
 */
static inline void vatomic16_xor(vatomic16_t *a, vuint16_t v);
/**
 * Applies bitwise xor opeation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord release
 */
static inline void vatomic16_xor_rel(vatomic16_t *a, vuint16_t v);
/**
 * Applies bitwise xor opeation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord relaxed
 */
static inline void vatomic16_xor_rlx(vatomic16_t *a, vuint16_t v);

/**
 * Adds v to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return old value
 * @memord seq_cst
 */
static inline vuint16_t vatomic16_get_add(vatomic16_t *a, vuint16_t v);
/**
 * Adds v to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return old value
 * @memord acquire
 */
static inline vuint16_t vatomic16_get_add_acq(vatomic16_t *a, vuint16_t v);
/**
 * Adds v to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return old value
 * @memord release
 */
static inline vuint16_t vatomic16_get_add_rel(vatomic16_t *a, vuint16_t v);
/**
 * Adds v to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return old value
 * @memord relaxed
 */
static inline vuint16_t vatomic16_get_add_rlx(vatomic16_t *a, vuint16_t v);

/**
 * Adds v to the value of a and returns the new value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return new value
 * @memord seq_cst
 */
static inline vuint16_t vatomic16_add_get(vatomic16_t *a, vuint16_t v);
/**
 * Adds v to the value of a and returns the new value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return new value
 * @memord acquire
 */
static inline vuint16_t vatomic16_add_get_acq(vatomic16_t *a, vuint16_t v);
/**
 * Adds v to the value of a and returns the new value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return new value
 * @memord release
 */
static inline vuint16_t vatomic16_add_get_rel(vatomic16_t *a, vuint16_t v);
/**
 * Adds v to the value of a and returns the new value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return new value
 * @memord relaxed
 */
static inline vuint16_t vatomic16_add_get_rlx(vatomic16_t *a, vuint16_t v);

/**
 * Adds v to the value of a.
 *
 * @param a atomic variable
 * @param v addend value
 * @memord seq_cst
 */
static inline void vatomic16_add(vatomic16_t *a, vuint16_t v);
/**
 * Adds v to the value of a.
 *
 * @param a atomic variable
 * @param v addend value
 * @memord release
 */
static inline void vatomic16_add_rel(vatomic16_t *a, vuint16_t v);
/**
 * Adds v to the value of a.
 *
 * @param a atomic variable
 * @param v addend value
 * @memord relaxed
 */
static inline void vatomic16_add_rlx(vatomic16_t *a, vuint16_t v);

/**
 * Increments the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord seq_cst
 */
static inline vuint16_t vatomic16_get_inc(vatomic16_t *a);
/**
 * Increments the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord acquire
 */
static inline vuint16_t vatomic16_get_inc_acq(vatomic16_t *a);
/**
 * Increments the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord release
 */
static inline vuint16_t vatomic16_get_inc_rel(vatomic16_t *a);
/**
 * Increments the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord relaxed
 */
static inline vuint16_t vatomic16_get_inc_rlx(vatomic16_t *a);

/**
 * Increments the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return  new value
 * @memord seq_cst
 */
static inline vuint16_t vatomic16_inc_get(vatomic16_t *a);
/**
 * Increments the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return  new value
 * @memord acquire
 */
static inline vuint16_t vatomic16_inc_get_acq(vatomic16_t *a);
/**
 * Increments the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return  new value
 * @memord release
 */
static inline vuint16_t vatomic16_inc_get_rel(vatomic16_t *a);
/**
 * Increments the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return  new value
 * @memord relaxed
 */
static inline vuint16_t vatomic16_inc_get_rlx(vatomic16_t *a);

/**
 * Increments the value of a.
 *
 * @param a atomic variable
 * @memord seq_cst
 */
static inline void vatomic16_inc(vatomic16_t *a);
/**
 * Increments the value of a.
 *
 * @param a atomic variable
 * @memord release
 */
static inline void vatomic16_inc_rel(vatomic16_t *a);
/**
 * Increments the value of a.
 *
 * @param a atomic variable
 * @memord relaxed
 */
static inline void vatomic16_inc_rlx(vatomic16_t *a);

/**
 * Subtracts v from a and returns the old value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return old value
 * @memord seq_cst
 */
static inline vuint16_t vatomic16_get_sub(vatomic16_t *a, vuint16_t v);
/**
 * Subtracts v from a and returns the old value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return old value
 * @memord acquire
 */
static inline vuint16_t vatomic16_get_sub_acq(vatomic16_t *a, vuint16_t v);
/**
 * Subtracts v from a and returns the old value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return old value
 * @memord release
 */
static inline vuint16_t vatomic16_get_sub_rel(vatomic16_t *a, vuint16_t v);
/**
 * Subtracts v from a and returns the old value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return old value
 * @memord relaxed
 */
static inline vuint16_t vatomic16_get_sub_rlx(vatomic16_t *a, vuint16_t v);

/**
 * Subtracts v from a and returns the new value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return new value
 * @memord seq_cst
 */
static inline vuint16_t vatomic16_sub_get(vatomic16_t *a, vuint16_t v);
/**
 * Subtracts v from a and returns the new value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return new value
 * @memord acquire
 */
static inline vuint16_t vatomic16_sub_get_acq(vatomic16_t *a, vuint16_t v);
/**
 * Subtracts v from a and returns the new value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return new value
 * @memord release
 */
static inline vuint16_t vatomic16_sub_get_rel(vatomic16_t *a, vuint16_t v);
/**
 * Subtracts v from a and returns the new value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return new value
 * @memord relaxed
 */
static inline vuint16_t vatomic16_sub_get_rlx(vatomic16_t *a, vuint16_t v);

/**
 * Subtracts v from a.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @memord seq_cst
 */
static inline void vatomic16_sub(vatomic16_t *a, vuint16_t v);
/**
 * Subtracts v from a.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @memord release
 */
static inline void vatomic16_sub_rel(vatomic16_t *a, vuint16_t v);
/**
 * Subtracts v from a.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @memord relaxed
 */
static inline void vatomic16_sub_rlx(vatomic16_t *a, vuint16_t v);

/**
 * Decrements the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord seq_cst
 */
static inline vuint16_t vatomic16_get_dec(vatomic16_t *a);
/**
 * Decrements the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord acquire
 */
static inline vuint16_t vatomic16_get_dec_acq(vatomic16_t *a);
/**
 * Decrements the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord release
 */
static inline vuint16_t vatomic16_get_dec_rel(vatomic16_t *a);
/**
 * Decrements the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord relaxed
 */
static inline vuint16_t vatomic16_get_dec_rlx(vatomic16_t *a);

/**
 * Decrements the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return new value
 * @memord seq_cst
 */
static inline vuint16_t vatomic16_dec_get(vatomic16_t *a);
/**
 * Decrements the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return new value
 * @memord acquire
 */
static inline vuint16_t vatomic16_dec_get_acq(vatomic16_t *a);
/**
 * Decrements the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return new value
 * @memord release
 */
static inline vuint16_t vatomic16_dec_get_rel(vatomic16_t *a);
/**
 * Decrements the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return new value
 * @memord relaxed
 */
static inline vuint16_t vatomic16_dec_get_rlx(vatomic16_t *a);

/**
 * Decrements the value of a.
 *
 * @param a atomic variable
 * @memord seq_cst
 */
static inline void vatomic16_dec(vatomic16_t *a);
/**
 * Decrements the value of a.
 *
 * @param a atomic variable
 * @memord release
 */
static inline void vatomic16_dec_rel(vatomic16_t *a);
/**
 * Decrements the value of a.
 *
 * @param a atomic variable
 * @memord relaxed
 */
static inline void vatomic16_dec_rlx(vatomic16_t *a);

#endif
