/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute;

import java.io.Serializable;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.PrintJobAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.UnmodifiableSetException;

public final class AttributeSetUtilities {
    public static final AttributeSet synchronizedView(AttributeSet attributeSet) {
        return new SynchronizedAttributeSet(attributeSet);
    }

    public static final DocAttributeSet synchronizedView(DocAttributeSet attributeSet) {
        return new SynchronizedDocAttributeSet(attributeSet);
    }

    public static final PrintJobAttributeSet synchronizedView(PrintJobAttributeSet attributeSet) {
        return new SynchronizedPrintJobAttributeSet(attributeSet);
    }

    public static final PrintRequestAttributeSet synchronizedView(PrintRequestAttributeSet attributeSet) {
        return new SynchronizedPrintRequestAttributeSet(attributeSet);
    }

    public static final PrintServiceAttributeSet synchronizedView(PrintServiceAttributeSet attributeSet) {
        return new SynchronizedPrintServiceAttributeSet(attributeSet);
    }

    public static final AttributeSet unmodifiableView(AttributeSet attributeSet) {
        return new UnmodifiableAttributeSet(attributeSet);
    }

    public static final DocAttributeSet unmodifiableView(DocAttributeSet attributeSet) {
        return new UnmodifiableDocAttributeSet(attributeSet);
    }

    public static final PrintJobAttributeSet unmodifiableView(PrintJobAttributeSet attributeSet) {
        return new UnmodifiablePrintJobAttributeSet(attributeSet);
    }

    public static final PrintRequestAttributeSet unmodifiableView(PrintRequestAttributeSet attributeSet) {
        return new UnmodifiablePrintRequestAttributeSet(attributeSet);
    }

    public static final PrintServiceAttributeSet unmodifiableView(PrintServiceAttributeSet attributeSet) {
        return new UnmodifiablePrintServiceAttributeSet(attributeSet);
    }

    public static final Class verifyAttributeCategory(Object object, Class interfaceName) {
        if (object == null) {
            throw new NullPointerException("object may not be null");
        }
        Class clazz = (Class)object;
        if (interfaceName.isAssignableFrom(clazz)) {
            return clazz;
        }
        throw new ClassCastException();
    }

    public static final Attribute verifyAttributeValue(Object object, Class interfaceName) {
        if (object == null) {
            throw new NullPointerException("object may not be null");
        }
        if (interfaceName.isInstance(object)) {
            return (Attribute)object;
        }
        throw new ClassCastException();
    }

    public static final void verifyCategoryForValue(Class category, Attribute attribute) {
        if (category == null) {
            throw new NullPointerException("object may not be null");
        }
        if (category.equals(attribute.getCategory())) {
            throw new IllegalArgumentException("category of attribute not equal to category");
        }
    }

    private AttributeSetUtilities() {
    }

    private static class SynchronizedAttributeSet
    implements AttributeSet,
    Serializable {
        private AttributeSet set;

        public synchronized boolean add(Attribute attribute) {
            return this.set.add(attribute);
        }

        public synchronized boolean addAll(AttributeSet attributes) {
            return this.set.addAll(attributes);
        }

        public synchronized void clear() {
            this.set.clear();
        }

        public synchronized boolean containsKey(Class category) {
            return this.set.containsKey(category);
        }

        public synchronized boolean containsValue(Attribute attribute) {
            return this.set.containsValue(attribute);
        }

        public synchronized boolean equals(Object obj) {
            return this.set.equals(obj);
        }

        public synchronized Attribute get(Class interfaceName) {
            return this.set.get(interfaceName);
        }

        public synchronized int hashCode() {
            return this.set.hashCode();
        }

        public synchronized boolean isEmpty() {
            return this.set.isEmpty();
        }

        public synchronized boolean remove(Class category) {
            return this.set.remove(category);
        }

        public synchronized boolean remove(Attribute attribute) {
            return this.set.remove(attribute);
        }

        public synchronized int size() {
            return this.set.size();
        }

        public synchronized Attribute[] toArray() {
            return this.set.toArray();
        }

        public SynchronizedAttributeSet(AttributeSet attributeSet) {
            if (attributeSet == null) {
                throw new NullPointerException("attributeSet may not be null");
            }
            this.set = attributeSet;
        }
    }

    private static class SynchronizedDocAttributeSet
    extends SynchronizedAttributeSet
    implements DocAttributeSet,
    Serializable {
        public SynchronizedDocAttributeSet(DocAttributeSet attributeSet) {
            super(attributeSet);
        }
    }

    private static class SynchronizedPrintJobAttributeSet
    extends SynchronizedAttributeSet
    implements PrintJobAttributeSet,
    Serializable {
        public SynchronizedPrintJobAttributeSet(PrintJobAttributeSet attributeSet) {
            super(attributeSet);
        }
    }

    private static class SynchronizedPrintRequestAttributeSet
    extends SynchronizedAttributeSet
    implements PrintRequestAttributeSet,
    Serializable {
        public SynchronizedPrintRequestAttributeSet(PrintRequestAttributeSet attributeSet) {
            super(attributeSet);
        }
    }

    private static class SynchronizedPrintServiceAttributeSet
    extends SynchronizedAttributeSet
    implements PrintServiceAttributeSet,
    Serializable {
        public SynchronizedPrintServiceAttributeSet(PrintServiceAttributeSet attributeSet) {
            super(attributeSet);
        }
    }

    private static class UnmodifiableAttributeSet
    implements AttributeSet,
    Serializable {
        private AttributeSet set;

        public boolean add(Attribute attribute) {
            throw new UnmodifiableSetException();
        }

        public boolean addAll(AttributeSet attributes) {
            throw new UnmodifiableSetException();
        }

        public void clear() {
            throw new UnmodifiableSetException();
        }

        public boolean containsKey(Class category) {
            return this.set.containsKey(category);
        }

        public boolean containsValue(Attribute attribute) {
            return this.set.containsValue(attribute);
        }

        public boolean equals(Object obj) {
            return this.set.equals(obj);
        }

        public Attribute get(Class interfaceName) {
            return this.set.get(interfaceName);
        }

        public int hashCode() {
            return this.set.hashCode();
        }

        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        public boolean remove(Class category) {
            throw new UnmodifiableSetException();
        }

        public boolean remove(Attribute attribute) {
            throw new UnmodifiableSetException();
        }

        public int size() {
            return this.set.size();
        }

        public Attribute[] toArray() {
            return this.set.toArray();
        }

        public UnmodifiableAttributeSet(AttributeSet attributeSet) {
            if (attributeSet == null) {
                throw new NullPointerException("attributeSet may not be null");
            }
            this.set = attributeSet;
        }
    }

    private static class UnmodifiableDocAttributeSet
    extends UnmodifiableAttributeSet
    implements DocAttributeSet,
    Serializable {
        public UnmodifiableDocAttributeSet(DocAttributeSet attributeSet) {
            super(attributeSet);
        }
    }

    private static class UnmodifiablePrintJobAttributeSet
    extends UnmodifiableAttributeSet
    implements PrintJobAttributeSet,
    Serializable {
        public UnmodifiablePrintJobAttributeSet(PrintJobAttributeSet attributeSet) {
            super(attributeSet);
        }
    }

    private static class UnmodifiablePrintRequestAttributeSet
    extends UnmodifiableAttributeSet
    implements PrintRequestAttributeSet,
    Serializable {
        public UnmodifiablePrintRequestAttributeSet(PrintRequestAttributeSet attributeSet) {
            super(attributeSet);
        }
    }

    private static class UnmodifiablePrintServiceAttributeSet
    extends UnmodifiableAttributeSet
    implements PrintServiceAttributeSet,
    Serializable {
        public UnmodifiablePrintServiceAttributeSet(PrintServiceAttributeSet attributeSet) {
            super(attributeSet);
        }
    }
}

