# -*- encoding: utf-8 -*-

require File.dirname(__FILE__) + '/helper.rb'

class TestColorName < Test::Unit::TestCase

  ColorName = Color::RGB::JP::Base::ColorName

  def test_new_and_accessor
    c = ColorName.new("const", "漢字", "ひらがな", "カタカナ", "romaji")
    assert_equal("const", c.const_name)
    assert_equal("漢字", c.kanji)
    assert_equal("ひらがな", c.hiragana)
    assert_equal("カタカナ", c.katakana)
    assert_equal("romaji", c.romaji)
  end

  def test_encoding
    c = ColorName.new("SakuraIro", "桜色", "さくらいろ", "サクライロ", "sakura-iro")
    assert_equal("SakuraIro", c.const_name)
    assert_equal(Fixture::UTF_8::SakuraIroKanji, c.kanji)
    assert_equal(Fixture::UTF_8::SakuraIroHiragana, c.hiragana)
    assert_equal(Fixture::UTF_8::SakuraIroKatakana, c.katakana)
    assert_equal("sakura-iro", c.romaji)

    assert_equal(Fixture::Shift_JIS::SakuraIroKanji, c.kanji("Shift_JIS"))
    assert_equal(Fixture::Shift_JIS::SakuraIroHiragana, c.hiragana("Shift_JIS"))
    assert_equal(Fixture::Shift_JIS::SakuraIroKatakana, c.katakana("Shift_JIS"))

    assert_equal(Fixture::EUC_JP::SakuraIroKanji, c.kanji("EUC-JP"))
    assert_equal(Fixture::EUC_JP::SakuraIroHiragana, c.hiragana("EUC-JP"))
    assert_equal(Fixture::EUC_JP::SakuraIroKatakana, c.katakana("EUC-JP"))
  end

  def test_to_s
    c = ColorName.new("SakuraIro", "桜色", "さくらいろ", "サクライロ", "sakura-iro")
    assert_equal("sakura-iro", c.to_s)

    c = ColorName.new("", "", "", "", "kuro")
    assert_equal("kuro", c.to_s)
  end

  def test_names_and_to_a
    c = ColorName.new("SakuraIro", "桜色", "さくらいろ", "サクライロ", "sakura-iro")

    assert_equal([Fixture::UTF_8::SakuraIroKanji,
                  Fixture::UTF_8::SakuraIroHiragana,
                  Fixture::UTF_8::SakuraIroKatakana,
                  "sakura-iro"],
                 c.names)

    assert_equal([Fixture::Shift_JIS::SakuraIroKanji,
                  Fixture::Shift_JIS::SakuraIroHiragana,
                  Fixture::Shift_JIS::SakuraIroKatakana,
                  "sakura-iro"],
                 c.names("Shift_JIS"))

    assert_equal([Fixture::EUC_JP::SakuraIroKanji,
                  Fixture::EUC_JP::SakuraIroHiragana,
                  Fixture::EUC_JP::SakuraIroKatakana,
                  "sakura-iro"],
                 c.names("EUC-JP"))

    assert_equal([Fixture::UTF_8::SakuraIroKanji,
                  Fixture::UTF_8::SakuraIroHiragana,
                  Fixture::UTF_8::SakuraIroKatakana,
                  "sakura-iro"],
                 c.to_a)

    assert_equal([Fixture::UTF_8::SakuraIroKanji,
                  Fixture::UTF_8::SakuraIroHiragana,
                  Fixture::UTF_8::SakuraIroKatakana,
                  "sakura-iro"],
                 c.to_a("UTF-8"))
  end

end
