require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_KTRACE_H_)) {
    eval 'sub _SYS_KTRACE_H_ () {1;}' unless defined(&_SYS_KTRACE_H_);
    require 'sys/mutex.ph';
    require 'sys/lwp.ph';
    require 'sys/signal.ph';
    require 'sys/time.ph';
    require 'sys/uio.ph';
    eval 'sub KTROP_SET () {0;}' unless defined(&KTROP_SET);
    eval 'sub KTROP_CLEAR () {1;}' unless defined(&KTROP_CLEAR);
    eval 'sub KTROP_CLEARFILE () {2;}' unless defined(&KTROP_CLEARFILE);
    eval 'sub KTROP_MASK () {0x3;}' unless defined(&KTROP_MASK);
    eval 'sub KTROP {
        my($o) = @_;
	    eval q((($o) &KTROP_MASK));
    }' unless defined(&KTROP);
    eval 'sub KTRFLAG_DESCEND () {4;}' unless defined(&KTRFLAG_DESCEND);
    if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : undef)) {
    } else {
    }
    eval 'sub ktr_lid () { ($_v->{_v2}->{_lid});}' unless defined(&ktr_lid);
    eval 'sub ktr_olid () { ($_v->{_v1}->{_lid});}' unless defined(&ktr_olid);
    eval 'sub ktr_time () { ($_v->{_v2}->{_ts});}' unless defined(&ktr_time);
    eval 'sub ktr_otv () { ($_v->{_v0}->{_tv});}' unless defined(&ktr_otv);
    eval 'sub ktr_ots () { ($_v->{_v1}->{_ts});}' unless defined(&ktr_ots);
    eval 'sub ktr_ts () { ($_v->{_v2}->{_ts});}' unless defined(&ktr_ts);
    eval 'sub ktr_unused () { ($_v->{_v0}->{_buf});}' unless defined(&ktr_unused);
    eval 'sub KTR_SHIMLEN () { &offsetof(\'struct ktr_header\',  &ktr_pid);}' unless defined(&KTR_SHIMLEN);
    eval 'sub KTRPOINT {
        my($p, $type) = @_;
	    eval q(((($p)-> &p_traceflag & (1<<($type))) != 0));
    }' unless defined(&KTRPOINT);
    eval 'sub KTR_SYSCALL () {1;}' unless defined(&KTR_SYSCALL);
    eval 'sub KTR_SYSRET () {2;}' unless defined(&KTR_SYSRET);
    eval 'sub KTR_NAMEI () {3;}' unless defined(&KTR_NAMEI);
    eval 'sub KTR_GENIO () {4;}' unless defined(&KTR_GENIO);
    eval 'sub KTR_PSIG () {5;}' unless defined(&KTR_PSIG);
    eval 'sub KTR_CSW () {6;}' unless defined(&KTR_CSW);
    eval 'sub KTR_EMUL () {7;}' unless defined(&KTR_EMUL);
    eval 'sub KTR_USER () {8;}' unless defined(&KTR_USER);
    eval 'sub KTR_USER_MAXIDLEN () {20;}' unless defined(&KTR_USER_MAXIDLEN);
    eval 'sub KTR_USER_MAXLEN () {2048;}' unless defined(&KTR_USER_MAXLEN);
    eval 'sub KTR_EXEC_ARG () {10;}' unless defined(&KTR_EXEC_ARG);
    eval 'sub KTR_EXEC_ENV () {11;}' unless defined(&KTR_EXEC_ENV);
    eval 'sub KTR_SAUPCALL () {13;}' unless defined(&KTR_SAUPCALL);
    eval 'sub KTR_MIB () {14;}' unless defined(&KTR_MIB);
    eval 'sub KTR_EXEC_FD () {15;}' unless defined(&KTR_EXEC_FD);
    eval 'sub KTRFAC_MASK () {0xffffff;}' unless defined(&KTRFAC_MASK);
    eval 'sub KTRFAC_SYSCALL () {(1<< &KTR_SYSCALL);}' unless defined(&KTRFAC_SYSCALL);
    eval 'sub KTRFAC_SYSRET () {(1<< &KTR_SYSRET);}' unless defined(&KTRFAC_SYSRET);
    eval 'sub KTRFAC_NAMEI () {(1<< &KTR_NAMEI);}' unless defined(&KTRFAC_NAMEI);
    eval 'sub KTRFAC_GENIO () {(1<< &KTR_GENIO);}' unless defined(&KTRFAC_GENIO);
    eval 'sub KTRFAC_PSIG () {(1<< &KTR_PSIG);}' unless defined(&KTRFAC_PSIG);
    eval 'sub KTRFAC_CSW () {(1<< &KTR_CSW);}' unless defined(&KTRFAC_CSW);
    eval 'sub KTRFAC_EMUL () {(1<< &KTR_EMUL);}' unless defined(&KTRFAC_EMUL);
    eval 'sub KTRFAC_USER () {(1<< &KTR_USER);}' unless defined(&KTRFAC_USER);
    eval 'sub KTRFAC_EXEC_ARG () {(1<< &KTR_EXEC_ARG);}' unless defined(&KTRFAC_EXEC_ARG);
    eval 'sub KTRFAC_EXEC_ENV () {(1<< &KTR_EXEC_ENV);}' unless defined(&KTRFAC_EXEC_ENV);
    eval 'sub KTRFAC_MIB () {(1<< &KTR_MIB);}' unless defined(&KTRFAC_MIB);
    eval 'sub KTRFAC_EXEC_FD () {(1<< &KTR_EXEC_FD);}' unless defined(&KTRFAC_EXEC_FD);
    eval 'sub __KTRACE_FLAG_BITS () {"\\177\\020" "b\\1SYSCALL\\0" "b\\2SYSRET\\0" "b\\3NAMEI\\0" "b\\4GENIO\\0" "b\\5PSIG\\0" "b\\6CSW\\0" "b\\7EMUL\\0" "b\\10USER\\0" "b\\12EXEC_ARG\\0" "b\\13EXEC_ENV\\0" "b\\15SAUPCALL\\0" "b\\16MIB\\0" "b\\17EXEC_FD\\0" "f\\30\\4VERSION\\0" "b\\36TRC_EMUL\\0" "b\\37INHERIT\\0" "b\\40PERSISTENT\\0";}' unless defined(&__KTRACE_FLAG_BITS);
    eval 'sub KTRFAC_PERSISTENT () {0x80000000;}' unless defined(&KTRFAC_PERSISTENT);
    eval 'sub KTRFAC_INHERIT () {0x40000000;}' unless defined(&KTRFAC_INHERIT);
    eval 'sub KTRFAC_TRC_EMUL () {0x10000000;}' unless defined(&KTRFAC_TRC_EMUL);
    eval 'sub KTRFAC_VER_MASK () {0xf000000;}' unless defined(&KTRFAC_VER_MASK);
    eval 'sub KTRFAC_VER_SHIFT () {24;}' unless defined(&KTRFAC_VER_SHIFT);
    eval 'sub KTRFAC_VERSION {
        my($tf) = @_;
	    eval q(((($tf) &  &KTRFAC_VER_MASK) >>  &KTRFAC_VER_SHIFT));
    }' unless defined(&KTRFAC_VERSION);
    eval 'sub KTRFACv0 () {(0<<  &KTRFAC_VER_SHIFT);}' unless defined(&KTRFACv0);
    eval 'sub KTRFACv1 () {(1<<  &KTRFAC_VER_SHIFT);}' unless defined(&KTRFACv1);
    eval 'sub KTRFACv2 () {(2<<  &KTRFAC_VER_SHIFT);}' unless defined(&KTRFACv2);
    unless(defined(&_KERNEL)) {
	require 'sys/cdefs.ph';
    } else {
	eval 'sub ktrenter {
	    my($l) = @_;
    	    eval q({  &if (( ($l->{l_pflag}) &  &LP_KTRACTIVE) != 0) 1;  ($l->{l_pflag}) |=  &LP_KTRACTIVE; 0; });
	}' unless defined(&ktrenter);
	eval 'sub ktrexit {
	    my($l) = @_;
    	    eval q({  ($l->{l_pflag}) &= ~ &LP_KTRACTIVE; });
	}' unless defined(&ktrexit);
	eval 'sub ktrpoint {
	    my($fac) = @_;
    	    eval q({  &__predict_false( &ktrace_on)  &&  &__predict_false( &ktr_point(1<< $fac)); });
	}' unless defined(&ktrpoint);
	eval 'sub ktrcsw {
	    my($a,$b,$c) = @_;
    	    eval q({  &if ( &__predict_false( &ktrace_on))  &ktr_csw($a, $b, $c); });
	}' unless defined(&ktrcsw);
	eval 'sub ktremul {
	    my($void) = @_;
    	    eval q({  &if ( &__predict_false( &ktrace_on))  &ktr_emul(); });
	}' unless defined(&ktremul);
	eval 'sub ktrgenio {
	    my($a,$b,$c,$d,$e) = @_;
    	    eval q({  &if ( &__predict_false( &ktrace_on))  &ktr_genio($a, $b, $c, $d, $e); });
	}' unless defined(&ktrgenio);
	eval 'sub ktrgeniov {
	    my($a,$b,$c,$d,$e) = @_;
    	    eval q({  &if ( &__predict_false( &ktrace_on))  &ktr_geniov($a, $b, $c, $d, $e); });
	}' unless defined(&ktrgeniov);
	eval 'sub ktrmibio {
	    my($a,$b,$c,$d,$e) = @_;
    	    eval q({  &if ( &__predict_false( &ktrace_on))  &ktr_mibio($a, $b, $c, $d, $e); });
	}' unless defined(&ktrmibio);
	eval 'sub ktrnamei {
	    my($a,$b) = @_;
    	    eval q({  &if ( &__predict_false( &ktrace_on))  &ktr_namei($a, $b); });
	}' unless defined(&ktrnamei);
	eval 'sub ktrnamei2 {
	    my($a,$b,$c,$d) = @_;
    	    eval q({  &if ( &__predict_false( &ktrace_on))  &ktr_namei2($a, $b, $c, $d); });
	}' unless defined(&ktrnamei2);
	eval 'sub ktrpsig {
	    my($a,$b,$c,$d) = @_;
    	    eval q({  &if ( &__predict_false( &ktrace_on))  &ktr_psig($a, $b, $c, $d); });
	}' unless defined(&ktrpsig);
	eval 'sub ktrsyscall {
	    my($code,$narg) = @_;
    	    eval q({  &if ( &__predict_false( &ktrace_on))  &ktr_syscall($code,  &args, $narg); });
	}' unless defined(&ktrsyscall);
	eval 'sub ktrsysret {
	    my($a,$b,$c) = @_;
    	    eval q({  &if ( &__predict_false( &ktrace_on))  &ktr_sysret($a, $b, $c); });
	}' unless defined(&ktrsysret);
	eval 'sub ktrkuser {
	    my($a,$b,$c) = @_;
    	    eval q({  &if ( &__predict_false( &ktrace_on))  &ktr_kuser($a, $b, $c); });
	}' unless defined(&ktrkuser);
	eval 'sub ktrmib {
	    my($a,$b) = @_;
    	    eval q({  &if ( &__predict_false( &ktrace_on))  &ktr_mib($a, $b); });
	}' unless defined(&ktrmib);
	eval 'sub ktrexecarg {
	    my($a,$b) = @_;
    	    eval q({  &if ( &__predict_false( &ktrace_on))  &ktr_execarg($a, $b); });
	}' unless defined(&ktrexecarg);
	eval 'sub ktrexecenv {
	    my($a,$b) = @_;
    	    eval q({  &if ( &__predict_false( &ktrace_on))  &ktr_execenv($a, $b); });
	}' unless defined(&ktrexecenv);
	eval 'sub ktrexecfd {
	    my($fd,$dtype) = @_;
    	    eval q({  &if ( &__predict_false( &ktrace_on))  &ktr_execfd($fd, $dtype); });
	}' unless defined(&ktrexecfd);
	eval 'sub KTA_NOWAIT () {0x;}' unless defined(&KTA_NOWAIT);
	eval 'sub KTA_WAITOK () {0x1;}' unless defined(&KTA_WAITOK);
	eval 'sub KTA_LARGE () {0x2;}' unless defined(&KTA_LARGE);
    }
}
1;
