/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.glyphs.ClosedShape;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.claribole.zvtm.glyphs.projection.ProjCirImage;

public class VCirImage
extends ClosedShape {
    long vw;
    long vh;
    long vs;
    float ar;
    AffineTransform at;
    ProjCirImage[] pc;
    Image image;
    float scaleFactor = 1.0f;
    float trueCoef = 1.0f;
    float relCoef = 1.0f;

    public VCirImage(long x, long y, int z, long s, Image img, Color c, float or) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.vs = s;
        this.image = img;
        this.ar = (float)this.image.getWidth(null) / (float)this.image.getHeight(null);
        this.size = this.vs;
        this.computeSize();
        this.orient = or;
        this.setColor(c);
        this.setBorderColor(Color.black);
    }

    public VCirImage(long x, long y, int z, long s, Image img, Color c, Color bc, float or) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.vs = s;
        this.image = img;
        this.ar = (float)this.image.getWidth(null) / (float)this.image.getHeight(null);
        this.size = this.vs;
        this.computeSize();
        this.orient = or;
        this.setColor(c);
        this.setBorderColor(bc);
    }

    public void initCams(int nbCam) {
        this.pc = new ProjCirImage[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new ProjCirImage();
        }
    }

    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                ProjCirImage[] ta = this.pc;
                this.pc = new ProjCirImage[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new ProjCirImage();
            } else {
                System.err.println("VCirImage:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new ProjCirImage[1];
            this.pc[0] = new ProjCirImage();
        } else {
            System.err.println("VCirImage:Error while adding camera " + verifIndex);
        }
    }

    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
        this.borderColor = this.bColor;
    }

    public float getOrient() {
        return this.orient;
    }

    public void orientTo(float angle) {
        this.orient = angle;
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void orientToNS(float angle) {
        this.orient = angle;
    }

    public float getSize() {
        return this.size;
    }

    void computeSize() {
        this.vw = Math.round((double)(this.size * this.ar) / Math.sqrt(Math.pow(this.ar, 2.0) + 1.0));
        this.vh = Math.round((double)this.size / Math.sqrt(Math.pow(this.ar, 2.0) + 1.0));
        this.scaleFactor = (float)((double)this.size / Math.sqrt(Math.pow(this.image.getWidth(null) / 2, 2.0) + Math.pow(this.image.getHeight(null) / 2, 2.0)));
    }

    public void sizeTo(float radius) {
        this.size = radius;
        this.vs = Math.round(this.size);
        this.computeSize();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void reSize(float factor) {
        this.size *= factor;
        this.vs = Math.round(this.size);
        this.computeSize();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setImage(Image i) {
        this.image = i;
        this.ar = (float)this.image.getWidth(null) / (float)this.image.getHeight(null);
        this.computeSize();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setRelativeImageSize(float f) {
        this.relCoef = f;
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public float getRelativeImageSize() {
        return this.relCoef;
    }

    public boolean fillsView(long w, long h, int camIndex) {
        return Math.sqrt(Math.pow(w - (long)this.pc[camIndex].cx, 2.0) + Math.pow(h - (long)this.pc[camIndex].cy, 2.0)) <= (double)this.pc[camIndex].cs && Math.sqrt(Math.pow(this.pc[camIndex].cx, 2.0) + Math.pow(h - (long)this.pc[camIndex].cy, 2.0)) <= (double)this.pc[camIndex].cs && Math.sqrt(Math.pow(w - (long)this.pc[camIndex].cx, 2.0) + Math.pow(this.pc[camIndex].cy, 2.0)) <= (double)this.pc[camIndex].cs && Math.sqrt(Math.pow(this.pc[camIndex].cx, 2.0) + Math.pow(this.pc[camIndex].cy, 2.0)) <= (double)this.pc[camIndex].cs;
    }

    public boolean coordInside(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        return Math.sqrt(Math.pow(jpx - this.pc[camIndex].cx, 2.0) + Math.pow(jpy - this.pc[camIndex].cy, 2.0)) <= (double)this.pc[camIndex].cs;
    }

    public boolean visibleInDisc(long dvx, long dvy, long dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return Math.sqrt(Math.pow(this.vx - dvx, 2.0) + Math.pow(this.vy - dvy, 2.0)) < (double)(dvr + this.vs);
    }

    public short mouseInOut(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        if (this.coordInside(jpx, jpy, camIndex, cvx, cvy)) {
            if (!this.pc[camIndex].prevMouseIn) {
                this.pc[camIndex].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[camIndex].prevMouseIn) {
            this.pc[camIndex].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = d.width / 2 + Math.round((float)(this.vx - c.posx) * this.coef);
        this.pc[i].cy = d.height / 2 - Math.round((float)(this.vy - c.posy) * this.coef);
        this.pc[i].cs = Math.round((float)this.vs * this.coef);
        this.pc[i].cw = Math.round((float)this.vw * this.coef * this.relCoef);
        this.pc[i].ch = Math.round((float)this.vh * this.coef * this.relCoef);
    }

    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, long lensx, long lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * lensMag;
        this.pc[i].lcx = lensWidth / 2 + Math.round((float)(this.vx - lensx) * this.coef);
        this.pc[i].lcy = lensHeight / 2 - Math.round((float)(this.vy - lensy) * this.coef);
        this.pc[i].lcs = Math.round((float)this.vs * this.coef);
        this.pc[i].lcw = Math.round((float)this.vw * this.coef * this.relCoef);
        this.pc[i].lch = Math.round((float)this.vh * this.coef * this.relCoef);
    }

    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].cs > 1) {
            if (this.filled) {
                g.setColor(this.color);
                g.fillOval(dx + this.pc[i].cx - this.pc[i].cs, dy + this.pc[i].cy - this.pc[i].cs, 2 * this.pc[i].cs, 2 * this.pc[i].cs);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.drawOval(dx + this.pc[i].cx - this.pc[i].cs, dy + this.pc[i].cy - this.pc[i].cs, 2 * this.pc[i].cs, 2 * this.pc[i].cs);
                    g.setStroke(stdS);
                } else {
                    g.drawOval(dx + this.pc[i].cx - this.pc[i].cs, dy + this.pc[i].cy - this.pc[i].cs, 2 * this.pc[i].cs, 2 * this.pc[i].cs);
                }
            }
            this.trueCoef = this.scaleFactor * this.coef * this.relCoef;
            if (Math.abs(this.trueCoef - 1.0f) < 0.01f) {
                this.trueCoef = 1.0f;
            }
            if (this.trueCoef != 1.0f) {
                this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch);
                if (this.orient != 0.0f) {
                    this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[i].cw, this.pc[i].ch));
                }
                this.at.concatenate(AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef));
                g.drawImage(this.image, this.at, null);
            } else if (this.orient == 0.0f) {
                g.drawImage(this.image, dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, null);
            } else {
                this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch);
                this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[i].cw, this.pc[i].ch));
                if (this.trueCoef != 1.0f) {
                    this.at.concatenate(AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef));
                }
                g.drawImage(this.image, this.at, null);
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
        }
    }

    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].lcs > 1) {
            if (this.filled) {
                g.setColor(this.color);
                g.fillOval(dx + this.pc[i].lcx - this.pc[i].lcs, dy + this.pc[i].cy - this.pc[i].lcs, 2 * this.pc[i].lcs, 2 * this.pc[i].lcs);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.drawOval(dx + this.pc[i].lcx - this.pc[i].lcs, dy + this.pc[i].cy - this.pc[i].lcs, 2 * this.pc[i].lcs, 2 * this.pc[i].lcs);
                    g.setStroke(stdS);
                } else {
                    g.drawOval(dx + this.pc[i].lcx - this.pc[i].lcs, dy + this.pc[i].cy - this.pc[i].lcs, 2 * this.pc[i].lcs, 2 * this.pc[i].lcs);
                }
            }
            this.trueCoef = this.scaleFactor * this.coef * this.relCoef;
            if (Math.abs(this.trueCoef - 1.0f) < 0.01f) {
                this.trueCoef = 1.0f;
            }
            if (this.trueCoef != 1.0f) {
                this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].cy - this.pc[i].lch);
                if (this.orient != 0.0f) {
                    this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[i].lcw, this.pc[i].lch));
                }
                this.at.concatenate(AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef));
                g.drawImage(this.image, this.at, null);
            } else if (this.orient == 0.0f) {
                g.drawImage(this.image, dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].cy - this.pc[i].lch, null);
            } else {
                this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].cy - this.pc[i].lch);
                this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[i].lcw, this.pc[i].lch));
                if (this.trueCoef != 1.0f) {
                    this.at.concatenate(AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef));
                }
                g.drawImage(this.image, this.at, null);
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].cy, 1, 1);
        }
    }

    public Object clone() {
        VCirImage res = new VCirImage(this.vx, this.vy, 0, this.vs, this.image, this.color, this.orient);
        res.borderColor = this.borderColor;
        res.mouseInsideColor = this.mouseInsideColor;
        res.bColor = this.bColor;
        return res;
    }
}

