/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file WarningList_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'esearch.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef esearch__OBJTOOLS_EUTILS_ESEARCH_WARNINGLIST_BASE_HPP
#define esearch__OBJTOOLS_EUTILS_ESEARCH_WARNINGLIST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

#ifndef BEGIN_esearch_SCOPE
#  define BEGIN_esearch_SCOPE BEGIN_SCOPE(esearch)
#  define END_esearch_SCOPE END_SCOPE(esearch)
#endif
BEGIN_esearch_SCOPE // namespace esearch::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_EUTILS_EXPORT CWarningList_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CWarningList_Base(void);
    // destructor
    virtual ~CWarningList_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef NCBI_NS_STD::list< NCBI_NS_STD::string > TPhraseIgnored;
    typedef NCBI_NS_STD::list< NCBI_NS_STD::string > TQuotedPhraseNotFound;
    typedef NCBI_NS_STD::list< NCBI_NS_STD::string > TOutputMessage;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_PhraseIgnored,
        e_QuotedPhraseNotFound,
        e_OutputMessage
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// .+ 
    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_STD::string > TPhraseIgnored
    ///  Check whether the PhraseIgnored data member has been assigned a value.
    bool IsSetPhraseIgnored(void) const;
    /// Check whether it is safe or not to call GetPhraseIgnored method.
    bool CanGetPhraseIgnored(void) const;
    void ResetPhraseIgnored(void);
    const TPhraseIgnored& GetPhraseIgnored(void) const;
    TPhraseIgnored& SetPhraseIgnored(void);

    /// .+ 
    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_STD::string > TQuotedPhraseNotFound
    ///  Check whether the QuotedPhraseNotFound data member has been assigned a value.
    bool IsSetQuotedPhraseNotFound(void) const;
    /// Check whether it is safe or not to call GetQuotedPhraseNotFound method.
    bool CanGetQuotedPhraseNotFound(void) const;
    void ResetQuotedPhraseNotFound(void);
    const TQuotedPhraseNotFound& GetQuotedPhraseNotFound(void) const;
    TQuotedPhraseNotFound& SetQuotedPhraseNotFound(void);

    /// .+ 
    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_STD::string > TOutputMessage
    ///  Check whether the OutputMessage data member has been assigned a value.
    bool IsSetOutputMessage(void) const;
    /// Check whether it is safe or not to call GetOutputMessage method.
    bool CanGetOutputMessage(void) const;
    void ResetOutputMessage(void);
    const TOutputMessage& GetOutputMessage(void) const;
    TOutputMessage& SetOutputMessage(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CWarningList_Base(const CWarningList_Base&);
    CWarningList_Base& operator=(const CWarningList_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::list< NCBI_NS_STD::string > m_PhraseIgnored;
    NCBI_NS_STD::list< NCBI_NS_STD::string > m_QuotedPhraseNotFound;
    NCBI_NS_STD::list< NCBI_NS_STD::string > m_OutputMessage;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CWarningList_Base::IsSetPhraseIgnored(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CWarningList_Base::CanGetPhraseIgnored(void) const
{
    return true;
}

inline
const CWarningList_Base::TPhraseIgnored& CWarningList_Base::GetPhraseIgnored(void) const
{
    return m_PhraseIgnored;
}

inline
CWarningList_Base::TPhraseIgnored& CWarningList_Base::SetPhraseIgnored(void)
{
    m_set_State[0] |= 0x1;
    return m_PhraseIgnored;
}

inline
bool CWarningList_Base::IsSetQuotedPhraseNotFound(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CWarningList_Base::CanGetQuotedPhraseNotFound(void) const
{
    return true;
}

inline
const CWarningList_Base::TQuotedPhraseNotFound& CWarningList_Base::GetQuotedPhraseNotFound(void) const
{
    return m_QuotedPhraseNotFound;
}

inline
CWarningList_Base::TQuotedPhraseNotFound& CWarningList_Base::SetQuotedPhraseNotFound(void)
{
    m_set_State[0] |= 0x4;
    return m_QuotedPhraseNotFound;
}

inline
bool CWarningList_Base::IsSetOutputMessage(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CWarningList_Base::CanGetOutputMessage(void) const
{
    return true;
}

inline
const CWarningList_Base::TOutputMessage& CWarningList_Base::GetOutputMessage(void) const
{
    return m_OutputMessage;
}

inline
CWarningList_Base::TOutputMessage& CWarningList_Base::SetOutputMessage(void)
{
    m_set_State[0] |= 0x10;
    return m_OutputMessage;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_esearch_SCOPE // namespace esearch::


#endif // esearch__OBJTOOLS_EUTILS_ESEARCH_WARNINGLIST_BASE_HPP
