/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TermSet_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'esearch.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef esearch__OBJTOOLS_EUTILS_ESEARCH_TERMSET_BASE_HPP
#define esearch__OBJTOOLS_EUTILS_ESEARCH_TERMSET_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_esearch_SCOPE
#  define BEGIN_esearch_SCOPE BEGIN_SCOPE(esearch)
#  define END_esearch_SCOPE END_SCOPE(esearch)
#endif
BEGIN_esearch_SCOPE // namespace esearch::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_EUTILS_EXPORT CTermSet_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CTermSet_Base(void);
    // destructor
    virtual ~CTermSet_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef NCBI_NS_STD::string TTerm;
    typedef NCBI_NS_STD::string TField;
    typedef NCBI_NS_STD::string TCount;
    typedef NCBI_NS_STD::string TExplode;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Term,
        e_Field,
        e_Count,
        e_Explode
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// .+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TTerm
    ///  Check whether the Term data member has been assigned a value.
    bool IsSetTerm(void) const;
    /// Check whether it is safe or not to call GetTerm method.
    bool CanGetTerm(void) const;
    void ResetTerm(void);
    const TTerm& GetTerm(void) const;
    void SetTerm(const TTerm& value);
    void SetTerm(TTerm&& value);
    TTerm& SetTerm(void);

    /// .+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TField
    ///  Check whether the Field data member has been assigned a value.
    bool IsSetField(void) const;
    /// Check whether it is safe or not to call GetField method.
    bool CanGetField(void) const;
    void ResetField(void);
    const TField& GetField(void) const;
    void SetField(const TField& value);
    void SetField(TField&& value);
    TField& SetField(void);

    /// \d+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TCount
    ///  Check whether the Count data member has been assigned a value.
    bool IsSetCount(void) const;
    /// Check whether it is safe or not to call GetCount method.
    bool CanGetCount(void) const;
    void ResetCount(void);
    const TCount& GetCount(void) const;
    void SetCount(const TCount& value);
    void SetCount(TCount&& value);
    TCount& SetCount(void);

    /// (Y|N) 
    /// mandatory
    /// typedef NCBI_NS_STD::string TExplode
    ///  Check whether the Explode data member has been assigned a value.
    bool IsSetExplode(void) const;
    /// Check whether it is safe or not to call GetExplode method.
    bool CanGetExplode(void) const;
    void ResetExplode(void);
    const TExplode& GetExplode(void) const;
    void SetExplode(const TExplode& value);
    void SetExplode(TExplode&& value);
    TExplode& SetExplode(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTermSet_Base(const CTermSet_Base&);
    CTermSet_Base& operator=(const CTermSet_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::string m_Term;
    NCBI_NS_STD::string m_Field;
    NCBI_NS_STD::string m_Count;
    NCBI_NS_STD::string m_Explode;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTermSet_Base::IsSetTerm(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTermSet_Base::CanGetTerm(void) const
{
    return IsSetTerm();
}

inline
const CTermSet_Base::TTerm& CTermSet_Base::GetTerm(void) const
{
    if (!CanGetTerm()) {
        ThrowUnassigned(0);
    }
    return m_Term;
}

inline
void CTermSet_Base::SetTerm(const CTermSet_Base::TTerm& value)
{
    m_Term = value;
    m_set_State[0] |= 0x3;
}

inline
void CTermSet_Base::SetTerm(CTermSet_Base::TTerm&& value)
{
    m_Term = std::forward<CTermSet_Base::TTerm>(value);
    m_set_State[0] |= 0x3;
}

inline
CTermSet_Base::TTerm& CTermSet_Base::SetTerm(void)
{
#ifdef _DEBUG
    if (!IsSetTerm()) {
        m_Term = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Term;
}

inline
bool CTermSet_Base::IsSetField(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTermSet_Base::CanGetField(void) const
{
    return IsSetField();
}

inline
const CTermSet_Base::TField& CTermSet_Base::GetField(void) const
{
    if (!CanGetField()) {
        ThrowUnassigned(1);
    }
    return m_Field;
}

inline
void CTermSet_Base::SetField(const CTermSet_Base::TField& value)
{
    m_Field = value;
    m_set_State[0] |= 0xc;
}

inline
void CTermSet_Base::SetField(CTermSet_Base::TField&& value)
{
    m_Field = std::forward<CTermSet_Base::TField>(value);
    m_set_State[0] |= 0xc;
}

inline
CTermSet_Base::TField& CTermSet_Base::SetField(void)
{
#ifdef _DEBUG
    if (!IsSetField()) {
        m_Field = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Field;
}

inline
bool CTermSet_Base::IsSetCount(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CTermSet_Base::CanGetCount(void) const
{
    return IsSetCount();
}

inline
const CTermSet_Base::TCount& CTermSet_Base::GetCount(void) const
{
    if (!CanGetCount()) {
        ThrowUnassigned(2);
    }
    return m_Count;
}

inline
void CTermSet_Base::SetCount(const CTermSet_Base::TCount& value)
{
    m_Count = value;
    m_set_State[0] |= 0x30;
}

inline
void CTermSet_Base::SetCount(CTermSet_Base::TCount&& value)
{
    m_Count = std::forward<CTermSet_Base::TCount>(value);
    m_set_State[0] |= 0x30;
}

inline
CTermSet_Base::TCount& CTermSet_Base::SetCount(void)
{
#ifdef _DEBUG
    if (!IsSetCount()) {
        m_Count = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Count;
}

inline
bool CTermSet_Base::IsSetExplode(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CTermSet_Base::CanGetExplode(void) const
{
    return IsSetExplode();
}

inline
const CTermSet_Base::TExplode& CTermSet_Base::GetExplode(void) const
{
    if (!CanGetExplode()) {
        ThrowUnassigned(3);
    }
    return m_Explode;
}

inline
void CTermSet_Base::SetExplode(const CTermSet_Base::TExplode& value)
{
    m_Explode = value;
    m_set_State[0] |= 0xc0;
}

inline
void CTermSet_Base::SetExplode(CTermSet_Base::TExplode&& value)
{
    m_Explode = std::forward<CTermSet_Base::TExplode>(value);
    m_set_State[0] |= 0xc0;
}

inline
CTermSet_Base::TExplode& CTermSet_Base::SetExplode(void)
{
#ifdef _DEBUG
    if (!IsSetExplode()) {
        m_Explode = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Explode;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_esearch_SCOPE // namespace esearch::


#endif // esearch__OBJTOOLS_EUTILS_ESEARCH_TERMSET_BASE_HPP
