/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Field_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'einfo.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef einfo__OBJTOOLS_EUTILS_EINFO_FIELD_BASE_HPP
#define einfo__OBJTOOLS_EUTILS_EINFO_FIELD_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_einfo_SCOPE
#  define BEGIN_einfo_SCOPE BEGIN_SCOPE(einfo)
#  define END_einfo_SCOPE END_SCOPE(einfo)
#endif
BEGIN_einfo_SCOPE // namespace einfo::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_EUTILS_EXPORT CField_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CField_Base(void);
    // destructor
    virtual ~CField_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef NCBI_NS_STD::string TName;
    typedef NCBI_NS_STD::string TFullName;
    typedef NCBI_NS_STD::string TDescription;
    typedef NCBI_NS_STD::string TTermCount;
    typedef NCBI_NS_STD::string TIsDate;
    typedef NCBI_NS_STD::string TIsNumerical;
    typedef NCBI_NS_STD::string TSingleToken;
    typedef NCBI_NS_STD::string THierarchy;
    typedef NCBI_NS_STD::string TIsHidden;
    typedef NCBI_NS_STD::string TIsRangable;
    typedef NCBI_NS_STD::string TIsTruncatable;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Name,
        e_FullName,
        e_Description,
        e_TermCount,
        e_IsDate,
        e_IsNumerical,
        e_SingleToken,
        e_Hierarchy,
        e_IsHidden,
        e_IsRangable,
        e_IsTruncatable
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 12> TmemberIndex;

    // getters
    // setters

    /// .+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// .+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TFullName
    ///  Check whether the FullName data member has been assigned a value.
    bool IsSetFullName(void) const;
    /// Check whether it is safe or not to call GetFullName method.
    bool CanGetFullName(void) const;
    void ResetFullName(void);
    const TFullName& GetFullName(void) const;
    void SetFullName(const TFullName& value);
    void SetFullName(TFullName&& value);
    TFullName& SetFullName(void);

    /// .+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TDescription
    ///  Check whether the Description data member has been assigned a value.
    bool IsSetDescription(void) const;
    /// Check whether it is safe or not to call GetDescription method.
    bool CanGetDescription(void) const;
    void ResetDescription(void);
    const TDescription& GetDescription(void) const;
    void SetDescription(const TDescription& value);
    void SetDescription(TDescription&& value);
    TDescription& SetDescription(void);

    /// \d+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TTermCount
    ///  Check whether the TermCount data member has been assigned a value.
    bool IsSetTermCount(void) const;
    /// Check whether it is safe or not to call GetTermCount method.
    bool CanGetTermCount(void) const;
    void ResetTermCount(void);
    const TTermCount& GetTermCount(void) const;
    void SetTermCount(const TTermCount& value);
    void SetTermCount(TTermCount&& value);
    TTermCount& SetTermCount(void);

    /// (Y|N) 
    /// mandatory
    /// typedef NCBI_NS_STD::string TIsDate
    ///  Check whether the IsDate data member has been assigned a value.
    bool IsSetIsDate(void) const;
    /// Check whether it is safe or not to call GetIsDate method.
    bool CanGetIsDate(void) const;
    void ResetIsDate(void);
    const TIsDate& GetIsDate(void) const;
    void SetIsDate(const TIsDate& value);
    void SetIsDate(TIsDate&& value);
    TIsDate& SetIsDate(void);

    /// (Y|N) 
    /// mandatory
    /// typedef NCBI_NS_STD::string TIsNumerical
    ///  Check whether the IsNumerical data member has been assigned a value.
    bool IsSetIsNumerical(void) const;
    /// Check whether it is safe or not to call GetIsNumerical method.
    bool CanGetIsNumerical(void) const;
    void ResetIsNumerical(void);
    const TIsNumerical& GetIsNumerical(void) const;
    void SetIsNumerical(const TIsNumerical& value);
    void SetIsNumerical(TIsNumerical&& value);
    TIsNumerical& SetIsNumerical(void);

    /// (Y|N) 
    /// mandatory
    /// typedef NCBI_NS_STD::string TSingleToken
    ///  Check whether the SingleToken data member has been assigned a value.
    bool IsSetSingleToken(void) const;
    /// Check whether it is safe or not to call GetSingleToken method.
    bool CanGetSingleToken(void) const;
    void ResetSingleToken(void);
    const TSingleToken& GetSingleToken(void) const;
    void SetSingleToken(const TSingleToken& value);
    void SetSingleToken(TSingleToken&& value);
    TSingleToken& SetSingleToken(void);

    /// (Y|N) 
    /// mandatory
    /// typedef NCBI_NS_STD::string THierarchy
    ///  Check whether the Hierarchy data member has been assigned a value.
    bool IsSetHierarchy(void) const;
    /// Check whether it is safe or not to call GetHierarchy method.
    bool CanGetHierarchy(void) const;
    void ResetHierarchy(void);
    const THierarchy& GetHierarchy(void) const;
    void SetHierarchy(const THierarchy& value);
    void SetHierarchy(THierarchy&& value);
    THierarchy& SetHierarchy(void);

    /// (Y|N) 
    /// mandatory
    /// typedef NCBI_NS_STD::string TIsHidden
    ///  Check whether the IsHidden data member has been assigned a value.
    bool IsSetIsHidden(void) const;
    /// Check whether it is safe or not to call GetIsHidden method.
    bool CanGetIsHidden(void) const;
    void ResetIsHidden(void);
    const TIsHidden& GetIsHidden(void) const;
    void SetIsHidden(const TIsHidden& value);
    void SetIsHidden(TIsHidden&& value);
    TIsHidden& SetIsHidden(void);

    /// (Y|N) 
    /// optional
    /// typedef NCBI_NS_STD::string TIsRangable
    ///  Check whether the IsRangable data member has been assigned a value.
    bool IsSetIsRangable(void) const;
    /// Check whether it is safe or not to call GetIsRangable method.
    bool CanGetIsRangable(void) const;
    void ResetIsRangable(void);
    const TIsRangable& GetIsRangable(void) const;
    void SetIsRangable(const TIsRangable& value);
    void SetIsRangable(TIsRangable&& value);
    TIsRangable& SetIsRangable(void);

    /// (Y|N) 
    /// optional
    /// typedef NCBI_NS_STD::string TIsTruncatable
    ///  Check whether the IsTruncatable data member has been assigned a value.
    bool IsSetIsTruncatable(void) const;
    /// Check whether it is safe or not to call GetIsTruncatable method.
    bool CanGetIsTruncatable(void) const;
    void ResetIsTruncatable(void);
    const TIsTruncatable& GetIsTruncatable(void) const;
    void SetIsTruncatable(const TIsTruncatable& value);
    void SetIsTruncatable(TIsTruncatable&& value);
    TIsTruncatable& SetIsTruncatable(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CField_Base(const CField_Base&);
    CField_Base& operator=(const CField_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::string m_Name;
    NCBI_NS_STD::string m_FullName;
    NCBI_NS_STD::string m_Description;
    NCBI_NS_STD::string m_TermCount;
    NCBI_NS_STD::string m_IsDate;
    NCBI_NS_STD::string m_IsNumerical;
    NCBI_NS_STD::string m_SingleToken;
    NCBI_NS_STD::string m_Hierarchy;
    NCBI_NS_STD::string m_IsHidden;
    NCBI_NS_STD::string m_IsRangable;
    NCBI_NS_STD::string m_IsTruncatable;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CField_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CField_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CField_Base::TName& CField_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(0);
    }
    return m_Name;
}

inline
void CField_Base::SetName(const CField_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0x3;
}

inline
void CField_Base::SetName(CField_Base::TName&& value)
{
    m_Name = std::forward<CField_Base::TName>(value);
    m_set_State[0] |= 0x3;
}

inline
CField_Base::TName& CField_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Name;
}

inline
bool CField_Base::IsSetFullName(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CField_Base::CanGetFullName(void) const
{
    return IsSetFullName();
}

inline
const CField_Base::TFullName& CField_Base::GetFullName(void) const
{
    if (!CanGetFullName()) {
        ThrowUnassigned(1);
    }
    return m_FullName;
}

inline
void CField_Base::SetFullName(const CField_Base::TFullName& value)
{
    m_FullName = value;
    m_set_State[0] |= 0xc;
}

inline
void CField_Base::SetFullName(CField_Base::TFullName&& value)
{
    m_FullName = std::forward<CField_Base::TFullName>(value);
    m_set_State[0] |= 0xc;
}

inline
CField_Base::TFullName& CField_Base::SetFullName(void)
{
#ifdef _DEBUG
    if (!IsSetFullName()) {
        m_FullName = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_FullName;
}

inline
bool CField_Base::IsSetDescription(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CField_Base::CanGetDescription(void) const
{
    return IsSetDescription();
}

inline
const CField_Base::TDescription& CField_Base::GetDescription(void) const
{
    if (!CanGetDescription()) {
        ThrowUnassigned(2);
    }
    return m_Description;
}

inline
void CField_Base::SetDescription(const CField_Base::TDescription& value)
{
    m_Description = value;
    m_set_State[0] |= 0x30;
}

inline
void CField_Base::SetDescription(CField_Base::TDescription&& value)
{
    m_Description = std::forward<CField_Base::TDescription>(value);
    m_set_State[0] |= 0x30;
}

inline
CField_Base::TDescription& CField_Base::SetDescription(void)
{
#ifdef _DEBUG
    if (!IsSetDescription()) {
        m_Description = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Description;
}

inline
bool CField_Base::IsSetTermCount(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CField_Base::CanGetTermCount(void) const
{
    return IsSetTermCount();
}

inline
const CField_Base::TTermCount& CField_Base::GetTermCount(void) const
{
    if (!CanGetTermCount()) {
        ThrowUnassigned(3);
    }
    return m_TermCount;
}

inline
void CField_Base::SetTermCount(const CField_Base::TTermCount& value)
{
    m_TermCount = value;
    m_set_State[0] |= 0xc0;
}

inline
void CField_Base::SetTermCount(CField_Base::TTermCount&& value)
{
    m_TermCount = std::forward<CField_Base::TTermCount>(value);
    m_set_State[0] |= 0xc0;
}

inline
CField_Base::TTermCount& CField_Base::SetTermCount(void)
{
#ifdef _DEBUG
    if (!IsSetTermCount()) {
        m_TermCount = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_TermCount;
}

inline
bool CField_Base::IsSetIsDate(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CField_Base::CanGetIsDate(void) const
{
    return IsSetIsDate();
}

inline
const CField_Base::TIsDate& CField_Base::GetIsDate(void) const
{
    if (!CanGetIsDate()) {
        ThrowUnassigned(4);
    }
    return m_IsDate;
}

inline
void CField_Base::SetIsDate(const CField_Base::TIsDate& value)
{
    m_IsDate = value;
    m_set_State[0] |= 0x300;
}

inline
void CField_Base::SetIsDate(CField_Base::TIsDate&& value)
{
    m_IsDate = std::forward<CField_Base::TIsDate>(value);
    m_set_State[0] |= 0x300;
}

inline
CField_Base::TIsDate& CField_Base::SetIsDate(void)
{
#ifdef _DEBUG
    if (!IsSetIsDate()) {
        m_IsDate = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_IsDate;
}

inline
bool CField_Base::IsSetIsNumerical(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CField_Base::CanGetIsNumerical(void) const
{
    return IsSetIsNumerical();
}

inline
const CField_Base::TIsNumerical& CField_Base::GetIsNumerical(void) const
{
    if (!CanGetIsNumerical()) {
        ThrowUnassigned(5);
    }
    return m_IsNumerical;
}

inline
void CField_Base::SetIsNumerical(const CField_Base::TIsNumerical& value)
{
    m_IsNumerical = value;
    m_set_State[0] |= 0xc00;
}

inline
void CField_Base::SetIsNumerical(CField_Base::TIsNumerical&& value)
{
    m_IsNumerical = std::forward<CField_Base::TIsNumerical>(value);
    m_set_State[0] |= 0xc00;
}

inline
CField_Base::TIsNumerical& CField_Base::SetIsNumerical(void)
{
#ifdef _DEBUG
    if (!IsSetIsNumerical()) {
        m_IsNumerical = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_IsNumerical;
}

inline
bool CField_Base::IsSetSingleToken(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CField_Base::CanGetSingleToken(void) const
{
    return IsSetSingleToken();
}

inline
const CField_Base::TSingleToken& CField_Base::GetSingleToken(void) const
{
    if (!CanGetSingleToken()) {
        ThrowUnassigned(6);
    }
    return m_SingleToken;
}

inline
void CField_Base::SetSingleToken(const CField_Base::TSingleToken& value)
{
    m_SingleToken = value;
    m_set_State[0] |= 0x3000;
}

inline
void CField_Base::SetSingleToken(CField_Base::TSingleToken&& value)
{
    m_SingleToken = std::forward<CField_Base::TSingleToken>(value);
    m_set_State[0] |= 0x3000;
}

inline
CField_Base::TSingleToken& CField_Base::SetSingleToken(void)
{
#ifdef _DEBUG
    if (!IsSetSingleToken()) {
        m_SingleToken = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_SingleToken;
}

inline
bool CField_Base::IsSetHierarchy(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CField_Base::CanGetHierarchy(void) const
{
    return IsSetHierarchy();
}

inline
const CField_Base::THierarchy& CField_Base::GetHierarchy(void) const
{
    if (!CanGetHierarchy()) {
        ThrowUnassigned(7);
    }
    return m_Hierarchy;
}

inline
void CField_Base::SetHierarchy(const CField_Base::THierarchy& value)
{
    m_Hierarchy = value;
    m_set_State[0] |= 0xc000;
}

inline
void CField_Base::SetHierarchy(CField_Base::THierarchy&& value)
{
    m_Hierarchy = std::forward<CField_Base::THierarchy>(value);
    m_set_State[0] |= 0xc000;
}

inline
CField_Base::THierarchy& CField_Base::SetHierarchy(void)
{
#ifdef _DEBUG
    if (!IsSetHierarchy()) {
        m_Hierarchy = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Hierarchy;
}

inline
bool CField_Base::IsSetIsHidden(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CField_Base::CanGetIsHidden(void) const
{
    return IsSetIsHidden();
}

inline
const CField_Base::TIsHidden& CField_Base::GetIsHidden(void) const
{
    if (!CanGetIsHidden()) {
        ThrowUnassigned(8);
    }
    return m_IsHidden;
}

inline
void CField_Base::SetIsHidden(const CField_Base::TIsHidden& value)
{
    m_IsHidden = value;
    m_set_State[0] |= 0x30000;
}

inline
void CField_Base::SetIsHidden(CField_Base::TIsHidden&& value)
{
    m_IsHidden = std::forward<CField_Base::TIsHidden>(value);
    m_set_State[0] |= 0x30000;
}

inline
CField_Base::TIsHidden& CField_Base::SetIsHidden(void)
{
#ifdef _DEBUG
    if (!IsSetIsHidden()) {
        m_IsHidden = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_IsHidden;
}

inline
bool CField_Base::IsSetIsRangable(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CField_Base::CanGetIsRangable(void) const
{
    return IsSetIsRangable();
}

inline
const CField_Base::TIsRangable& CField_Base::GetIsRangable(void) const
{
    if (!CanGetIsRangable()) {
        ThrowUnassigned(9);
    }
    return m_IsRangable;
}

inline
void CField_Base::SetIsRangable(const CField_Base::TIsRangable& value)
{
    m_IsRangable = value;
    m_set_State[0] |= 0xc0000;
}

inline
void CField_Base::SetIsRangable(CField_Base::TIsRangable&& value)
{
    m_IsRangable = std::forward<CField_Base::TIsRangable>(value);
    m_set_State[0] |= 0xc0000;
}

inline
CField_Base::TIsRangable& CField_Base::SetIsRangable(void)
{
#ifdef _DEBUG
    if (!IsSetIsRangable()) {
        m_IsRangable = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_IsRangable;
}

inline
bool CField_Base::IsSetIsTruncatable(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CField_Base::CanGetIsTruncatable(void) const
{
    return IsSetIsTruncatable();
}

inline
const CField_Base::TIsTruncatable& CField_Base::GetIsTruncatable(void) const
{
    if (!CanGetIsTruncatable()) {
        ThrowUnassigned(10);
    }
    return m_IsTruncatable;
}

inline
void CField_Base::SetIsTruncatable(const CField_Base::TIsTruncatable& value)
{
    m_IsTruncatable = value;
    m_set_State[0] |= 0x300000;
}

inline
void CField_Base::SetIsTruncatable(CField_Base::TIsTruncatable&& value)
{
    m_IsTruncatable = std::forward<CField_Base::TIsTruncatable>(value);
    m_set_State[0] |= 0x300000;
}

inline
CField_Base::TIsTruncatable& CField_Base::SetIsTruncatable(void)
{
#ifdef _DEBUG
    if (!IsSetIsTruncatable()) {
        m_IsTruncatable = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_IsTruncatable;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_einfo_SCOPE // namespace einfo::


#endif // einfo__OBJTOOLS_EUTILS_EINFO_FIELD_BASE_HPP
