/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file EHistoryResult_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'ehistory.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef ehistory__OBJTOOLS_EUTILS_EHISTORY_EHISTORYRESULT_BASE_HPP
#define ehistory__OBJTOOLS_EUTILS_EHISTORY_EHISTORYRESULT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

#ifndef BEGIN_ehistory_SCOPE
#  define BEGIN_ehistory_SCOPE BEGIN_SCOPE(ehistory)
#  define END_ehistory_SCOPE END_SCOPE(ehistory)
#endif
BEGIN_ehistory_SCOPE // namespace ehistory::


// forward declarations
class CEHistoryItem;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_EUTILS_EXPORT CEHistoryResult_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CEHistoryResult_Base(void);
    // destructor
    virtual ~CEHistoryResult_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef NCBI_NS_STD::string TWebEnv;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CEHistoryItem > > TEHistoryItem;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_WebEnv,
        e_eHistoryItem
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// \S+ 
    /// optional
    /// typedef NCBI_NS_STD::string TWebEnv
    ///  Check whether the WebEnv data member has been assigned a value.
    bool IsSetWebEnv(void) const;
    /// Check whether it is safe or not to call GetWebEnv method.
    bool CanGetWebEnv(void) const;
    void ResetWebEnv(void);
    const TWebEnv& GetWebEnv(void) const;
    void SetWebEnv(const TWebEnv& value);
    void SetWebEnv(TWebEnv&& value);
    TWebEnv& SetWebEnv(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CEHistoryItem > > TEHistoryItem
    ///  Check whether the EHistoryItem data member has been assigned a value.
    bool IsSetEHistoryItem(void) const;
    /// Check whether it is safe or not to call GetEHistoryItem method.
    bool CanGetEHistoryItem(void) const;
    void ResetEHistoryItem(void);
    const TEHistoryItem& GetEHistoryItem(void) const;
    TEHistoryItem& SetEHistoryItem(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CEHistoryResult_Base(const CEHistoryResult_Base&);
    CEHistoryResult_Base& operator=(const CEHistoryResult_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::string m_WebEnv;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CEHistoryItem > > m_EHistoryItem;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CEHistoryResult_Base::IsSetWebEnv(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CEHistoryResult_Base::CanGetWebEnv(void) const
{
    return IsSetWebEnv();
}

inline
const CEHistoryResult_Base::TWebEnv& CEHistoryResult_Base::GetWebEnv(void) const
{
    if (!CanGetWebEnv()) {
        ThrowUnassigned(0);
    }
    return m_WebEnv;
}

inline
void CEHistoryResult_Base::SetWebEnv(const CEHistoryResult_Base::TWebEnv& value)
{
    m_WebEnv = value;
    m_set_State[0] |= 0x3;
}

inline
void CEHistoryResult_Base::SetWebEnv(CEHistoryResult_Base::TWebEnv&& value)
{
    m_WebEnv = std::forward<CEHistoryResult_Base::TWebEnv>(value);
    m_set_State[0] |= 0x3;
}

inline
CEHistoryResult_Base::TWebEnv& CEHistoryResult_Base::SetWebEnv(void)
{
#ifdef _DEBUG
    if (!IsSetWebEnv()) {
        m_WebEnv = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_WebEnv;
}

inline
bool CEHistoryResult_Base::IsSetEHistoryItem(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CEHistoryResult_Base::CanGetEHistoryItem(void) const
{
    return true;
}

inline
const CEHistoryResult_Base::TEHistoryItem& CEHistoryResult_Base::GetEHistoryItem(void) const
{
    return m_EHistoryItem;
}

inline
CEHistoryResult_Base::TEHistoryItem& CEHistoryResult_Base::SetEHistoryItem(void)
{
    m_set_State[0] |= 0x4;
    return m_EHistoryItem;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_ehistory_SCOPE // namespace ehistory::


#endif // ehistory__OBJTOOLS_EUTILS_EHISTORY_EHISTORYRESULT_BASE_HPP
