/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file SupplMeshName_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_SUPPLMESHNAME_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_SUPPLMESHNAME_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CSupplMeshName_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CSupplMeshName_Base(void);
    // destructor
    virtual ~CSupplMeshName_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_Type {
            eAttlist_Type_Disease    = 1,
            eAttlist_Type_Protocol   = 2,
            eAttlist_Type_Organism   = 3,
            eAttlist_Type_Anatomy    = 4,
            eAttlist_Type_Population = 5
        };
        
        /// Access to EAttlist_Type's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_Type)(void);
        
        // types
        typedef EAttlist_Type TType;
        typedef NCBI_NS_STD::string TUI;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_Type,
            e_UI
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef EAttlist_Type TType
        ///  Check whether the Type data member has been assigned a value.
        bool IsSetType(void) const;
        /// Check whether it is safe or not to call GetType method.
        bool CanGetType(void) const;
        void ResetType(void);
        TType GetType(void) const;
        void SetType(TType value);
        TType& SetType(void);
    
        /// mandatory
        /// typedef NCBI_NS_STD::string TUI
        ///  Check whether the UI data member has been assigned a value.
        bool IsSetUI(void) const;
        /// Check whether it is safe or not to call GetUI method.
        bool CanGetUI(void) const;
        void ResetUI(void);
        const TUI& GetUI(void) const;
        void SetUI(const TUI& value);
        void SetUI(TUI&& value);
        TUI& SetUI(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        EAttlist_Type m_Type;
        NCBI_NS_STD::string m_UI;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef NCBI_NS_STD::string TSupplMeshName;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_SupplMeshName
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef NCBI_NS_STD::string TSupplMeshName
    ///  Check whether the SupplMeshName data member has been assigned a value.
    bool IsSetSupplMeshName(void) const;
    /// Check whether it is safe or not to call GetSupplMeshName method.
    bool CanGetSupplMeshName(void) const;
    void ResetSupplMeshName(void);
    const TSupplMeshName& GetSupplMeshName(void) const;
    void SetSupplMeshName(const TSupplMeshName& value);
    void SetSupplMeshName(TSupplMeshName&& value);
    TSupplMeshName& SetSupplMeshName(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSupplMeshName_Base(const CSupplMeshName_Base&);
    CSupplMeshName_Base& operator=(const CSupplMeshName_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::string m_SupplMeshName;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSupplMeshName_Base::C_Attlist::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSupplMeshName_Base::C_Attlist::CanGetType(void) const
{
    return IsSetType();
}

inline
void CSupplMeshName_Base::C_Attlist::ResetType(void)
{
    m_Type = (EAttlist_Type)(0);
    m_set_State[0] &= ~0x3;
}

inline
CSupplMeshName_Base::C_Attlist::TType CSupplMeshName_Base::C_Attlist::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CSupplMeshName_Base::C_Attlist::SetType(CSupplMeshName_Base::C_Attlist::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CSupplMeshName_Base::C_Attlist::TType& CSupplMeshName_Base::C_Attlist::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CSupplMeshName_Base::C_Attlist::IsSetUI(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSupplMeshName_Base::C_Attlist::CanGetUI(void) const
{
    return IsSetUI();
}

inline
const CSupplMeshName_Base::C_Attlist::TUI& CSupplMeshName_Base::C_Attlist::GetUI(void) const
{
    if (!CanGetUI()) {
        ThrowUnassigned(1);
    }
    return m_UI;
}

inline
void CSupplMeshName_Base::C_Attlist::SetUI(const CSupplMeshName_Base::C_Attlist::TUI& value)
{
    m_UI = value;
    m_set_State[0] |= 0xc;
}

inline
void CSupplMeshName_Base::C_Attlist::SetUI(CSupplMeshName_Base::C_Attlist::TUI&& value)
{
    m_UI = std::forward<CSupplMeshName_Base::C_Attlist::TUI>(value);
    m_set_State[0] |= 0xc;
}

inline
CSupplMeshName_Base::C_Attlist::TUI& CSupplMeshName_Base::C_Attlist::SetUI(void)
{
#ifdef _DEBUG
    if (!IsSetUI()) {
        m_UI = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_UI;
}

inline
bool CSupplMeshName_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CSupplMeshName_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CSupplMeshName_Base::TAttlist& CSupplMeshName_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CSupplMeshName_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CSupplMeshName_Base::TAttlist& CSupplMeshName_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CSupplMeshName_Base::IsSetSupplMeshName(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSupplMeshName_Base::CanGetSupplMeshName(void) const
{
    return IsSetSupplMeshName();
}

inline
const CSupplMeshName_Base::TSupplMeshName& CSupplMeshName_Base::GetSupplMeshName(void) const
{
    if (!CanGetSupplMeshName()) {
        ThrowUnassigned(1);
    }
    return m_SupplMeshName;
}

inline
void CSupplMeshName_Base::SetSupplMeshName(const CSupplMeshName_Base::TSupplMeshName& value)
{
    m_SupplMeshName = value;
    m_set_State[0] |= 0xc;
}

inline
void CSupplMeshName_Base::SetSupplMeshName(CSupplMeshName_Base::TSupplMeshName&& value)
{
    m_SupplMeshName = std::forward<CSupplMeshName_Base::TSupplMeshName>(value);
    m_set_State[0] |= 0xc;
}

inline
CSupplMeshName_Base::TSupplMeshName& CSupplMeshName_Base::SetSupplMeshName(void)
{
#ifdef _DEBUG
    if (!IsSetSupplMeshName()) {
        m_SupplMeshName = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_SupplMeshName;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_SUPPLMESHNAME_BASE_HPP
