/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Reference_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_REFERENCE_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_REFERENCE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CArticleIdList;
class CCitation;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CReference_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CReference_Base(void);
    // destructor
    virtual ~CReference_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CCitation TCitation;
    typedef CArticleIdList TArticleIdList;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Citation,
        e_ArticleIdList
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CCitation TCitation
    ///  Check whether the Citation data member has been assigned a value.
    bool IsSetCitation(void) const;
    /// Check whether it is safe or not to call GetCitation method.
    bool CanGetCitation(void) const;
    void ResetCitation(void);
    const TCitation& GetCitation(void) const;
    void SetCitation(TCitation& value);
    TCitation& SetCitation(void);

    /// optional
    /// typedef CArticleIdList TArticleIdList
    ///  Check whether the ArticleIdList data member has been assigned a value.
    bool IsSetArticleIdList(void) const;
    /// Check whether it is safe or not to call GetArticleIdList method.
    bool CanGetArticleIdList(void) const;
    void ResetArticleIdList(void);
    const TArticleIdList& GetArticleIdList(void) const;
    void SetArticleIdList(TArticleIdList& value);
    TArticleIdList& SetArticleIdList(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CReference_Base(const CReference_Base&);
    CReference_Base& operator=(const CReference_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TCitation > m_Citation;
    NCBI_NS_NCBI::CRef< TArticleIdList > m_ArticleIdList;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CReference_Base::IsSetCitation(void) const
{
    return m_Citation.NotEmpty();
}

inline
bool CReference_Base::CanGetCitation(void) const
{
    return true;
}

inline
const CReference_Base::TCitation& CReference_Base::GetCitation(void) const
{
    if ( !m_Citation ) {
        const_cast<CReference_Base*>(this)->ResetCitation();
    }
    return (*m_Citation);
}

inline
CReference_Base::TCitation& CReference_Base::SetCitation(void)
{
    if ( !m_Citation ) {
        ResetCitation();
    }
    return (*m_Citation);
}

inline
bool CReference_Base::IsSetArticleIdList(void) const
{
    return m_ArticleIdList.NotEmpty();
}

inline
bool CReference_Base::CanGetArticleIdList(void) const
{
    return IsSetArticleIdList();
}

inline
const CReference_Base::TArticleIdList& CReference_Base::GetArticleIdList(void) const
{
    if (!CanGetArticleIdList()) {
        ThrowUnassigned(1);
    }
    return (*m_ArticleIdList);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_REFERENCE_BASE_HPP
