/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ReferenceList_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_REFERENCELIST_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_REFERENCELIST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CPubmedTitle;
class CReference;
class CReferenceList;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CReferenceList_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CReferenceList_Base(void);
    // destructor
    virtual ~CReferenceList_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CPubmedTitle TTitle;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CReference > > TReference;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CReferenceList > > TReferenceList;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Title,
        e_Reference,
        e_ReferenceList
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef CPubmedTitle TTitle
    ///  Check whether the Title data member has been assigned a value.
    bool IsSetTitle(void) const;
    /// Check whether it is safe or not to call GetTitle method.
    bool CanGetTitle(void) const;
    void ResetTitle(void);
    const TTitle& GetTitle(void) const;
    void SetTitle(TTitle& value);
    TTitle& SetTitle(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CReference > > TReference
    ///  Check whether the Reference data member has been assigned a value.
    bool IsSetReference(void) const;
    /// Check whether it is safe or not to call GetReference method.
    bool CanGetReference(void) const;
    void ResetReference(void);
    const TReference& GetReference(void) const;
    TReference& SetReference(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CReferenceList > > TReferenceList
    ///  Check whether the ReferenceList data member has been assigned a value.
    bool IsSetReferenceList(void) const;
    /// Check whether it is safe or not to call GetReferenceList method.
    bool CanGetReferenceList(void) const;
    void ResetReferenceList(void);
    const TReferenceList& GetReferenceList(void) const;
    TReferenceList& SetReferenceList(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CReferenceList_Base(const CReferenceList_Base&);
    CReferenceList_Base& operator=(const CReferenceList_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TTitle > m_Title;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CReference > > m_Reference;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CReferenceList > > m_ReferenceList;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CReferenceList_Base::IsSetTitle(void) const
{
    return m_Title.NotEmpty();
}

inline
bool CReferenceList_Base::CanGetTitle(void) const
{
    return IsSetTitle();
}

inline
const CReferenceList_Base::TTitle& CReferenceList_Base::GetTitle(void) const
{
    if (!CanGetTitle()) {
        ThrowUnassigned(0);
    }
    return (*m_Title);
}

inline
bool CReferenceList_Base::IsSetReference(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CReferenceList_Base::CanGetReference(void) const
{
    return true;
}

inline
const CReferenceList_Base::TReference& CReferenceList_Base::GetReference(void) const
{
    return m_Reference;
}

inline
CReferenceList_Base::TReference& CReferenceList_Base::SetReference(void)
{
    m_set_State[0] |= 0x4;
    return m_Reference;
}

inline
bool CReferenceList_Base::IsSetReferenceList(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CReferenceList_Base::CanGetReferenceList(void) const
{
    return true;
}

inline
const CReferenceList_Base::TReferenceList& CReferenceList_Base::GetReferenceList(void) const
{
    return m_ReferenceList;
}

inline
CReferenceList_Base::TReferenceList& CReferenceList_Base::SetReferenceList(void)
{
    m_set_State[0] |= 0x10;
    return m_ReferenceList;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_REFERENCELIST_BASE_HPP
