/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PersonalNameSubject_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_PERSONALNAMESUBJECT_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_PERSONALNAMESUBJECT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CForeName;
class CInitials;
class CLastName;
class CSuffix;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CPersonalNameSubject_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CPersonalNameSubject_Base(void);
    // destructor
    virtual ~CPersonalNameSubject_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CLastName TLastName;
    typedef CForeName TForeName;
    typedef CInitials TInitials;
    typedef CSuffix TSuffix;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_LastName,
        e_ForeName,
        e_Initials,
        e_Suffix
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CLastName TLastName
    ///  Check whether the LastName data member has been assigned a value.
    bool IsSetLastName(void) const;
    /// Check whether it is safe or not to call GetLastName method.
    bool CanGetLastName(void) const;
    void ResetLastName(void);
    const TLastName& GetLastName(void) const;
    void SetLastName(TLastName& value);
    TLastName& SetLastName(void);

    /// optional
    /// typedef CForeName TForeName
    ///  Check whether the ForeName data member has been assigned a value.
    bool IsSetForeName(void) const;
    /// Check whether it is safe or not to call GetForeName method.
    bool CanGetForeName(void) const;
    void ResetForeName(void);
    const TForeName& GetForeName(void) const;
    void SetForeName(TForeName& value);
    TForeName& SetForeName(void);

    /// optional
    /// typedef CInitials TInitials
    ///  Check whether the Initials data member has been assigned a value.
    bool IsSetInitials(void) const;
    /// Check whether it is safe or not to call GetInitials method.
    bool CanGetInitials(void) const;
    void ResetInitials(void);
    const TInitials& GetInitials(void) const;
    void SetInitials(TInitials& value);
    TInitials& SetInitials(void);

    /// optional
    /// typedef CSuffix TSuffix
    ///  Check whether the Suffix data member has been assigned a value.
    bool IsSetSuffix(void) const;
    /// Check whether it is safe or not to call GetSuffix method.
    bool CanGetSuffix(void) const;
    void ResetSuffix(void);
    const TSuffix& GetSuffix(void) const;
    void SetSuffix(TSuffix& value);
    TSuffix& SetSuffix(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPersonalNameSubject_Base(const CPersonalNameSubject_Base&);
    CPersonalNameSubject_Base& operator=(const CPersonalNameSubject_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TLastName > m_LastName;
    NCBI_NS_NCBI::CRef< TForeName > m_ForeName;
    NCBI_NS_NCBI::CRef< TInitials > m_Initials;
    NCBI_NS_NCBI::CRef< TSuffix > m_Suffix;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPersonalNameSubject_Base::IsSetLastName(void) const
{
    return m_LastName.NotEmpty();
}

inline
bool CPersonalNameSubject_Base::CanGetLastName(void) const
{
    return true;
}

inline
const CPersonalNameSubject_Base::TLastName& CPersonalNameSubject_Base::GetLastName(void) const
{
    if ( !m_LastName ) {
        const_cast<CPersonalNameSubject_Base*>(this)->ResetLastName();
    }
    return (*m_LastName);
}

inline
CPersonalNameSubject_Base::TLastName& CPersonalNameSubject_Base::SetLastName(void)
{
    if ( !m_LastName ) {
        ResetLastName();
    }
    return (*m_LastName);
}

inline
bool CPersonalNameSubject_Base::IsSetForeName(void) const
{
    return m_ForeName.NotEmpty();
}

inline
bool CPersonalNameSubject_Base::CanGetForeName(void) const
{
    return IsSetForeName();
}

inline
const CPersonalNameSubject_Base::TForeName& CPersonalNameSubject_Base::GetForeName(void) const
{
    if (!CanGetForeName()) {
        ThrowUnassigned(1);
    }
    return (*m_ForeName);
}

inline
bool CPersonalNameSubject_Base::IsSetInitials(void) const
{
    return m_Initials.NotEmpty();
}

inline
bool CPersonalNameSubject_Base::CanGetInitials(void) const
{
    return IsSetInitials();
}

inline
const CPersonalNameSubject_Base::TInitials& CPersonalNameSubject_Base::GetInitials(void) const
{
    if (!CanGetInitials()) {
        ThrowUnassigned(2);
    }
    return (*m_Initials);
}

inline
bool CPersonalNameSubject_Base::IsSetSuffix(void) const
{
    return m_Suffix.NotEmpty();
}

inline
bool CPersonalNameSubject_Base::CanGetSuffix(void) const
{
    return IsSetSuffix();
}

inline
const CPersonalNameSubject_Base::TSuffix& CPersonalNameSubject_Base::GetSuffix(void) const
{
    if (!CanGetSuffix()) {
        ThrowUnassigned(3);
    }
    return (*m_Suffix);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_PERSONALNAMESUBJECT_BASE_HPP
