/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Mo_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_MO_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_MO_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objtools/eutils/efetch/Token_content.hpp>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CMo_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CMo_Base(void);
    // destructor
    virtual ~CMo_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_mathvariant {
            eAttlist_mathvariant_normal                 =  1,
            eAttlist_mathvariant_bold                   =  2,
            eAttlist_mathvariant_italic                 =  3,
            eAttlist_mathvariant_bold_italic            =  4,
            eAttlist_mathvariant_double_struck          =  5,
            eAttlist_mathvariant_bold_fraktur           =  6,
            eAttlist_mathvariant_script                 =  7,
            eAttlist_mathvariant_bold_script            =  8,
            eAttlist_mathvariant_fraktur                =  9,
            eAttlist_mathvariant_sans_serif             = 10,
            eAttlist_mathvariant_bold_sans_serif        = 11,
            eAttlist_mathvariant_sans_serif_italic      = 12,
            eAttlist_mathvariant_sans_serif_bold_italic = 13,
            eAttlist_mathvariant_monospace              = 14,
            eAttlist_mathvariant_initial                = 15,
            eAttlist_mathvariant_tailed                 = 16,
            eAttlist_mathvariant_looped                 = 17,
            eAttlist_mathvariant_stretched              = 18
        };
        
        /// Access to EAttlist_mathvariant's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_mathvariant)(void);
        
        enum EAttlist_dir {
            eAttlist_dir_ltr = 1,
            eAttlist_dir_rtl = 2
        };
        
        /// Access to EAttlist_dir's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_dir)(void);
        
        enum EAttlist_fontweight {
            eAttlist_fontweight_normal = 1,
            eAttlist_fontweight_bold   = 2
        };
        
        /// Access to EAttlist_fontweight's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_fontweight)(void);
        
        enum EAttlist_fontstyle {
            eAttlist_fontstyle_normal = 1,
            eAttlist_fontstyle_italic = 2
        };
        
        /// Access to EAttlist_fontstyle's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_fontstyle)(void);
        
        enum EAttlist_form {
            eAttlist_form_prefix  = 1,
            eAttlist_form_infix   = 2,
            eAttlist_form_postfix = 3
        };
        
        /// Access to EAttlist_form's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_form)(void);
        
        enum EAttlist_fence {
            eAttlist_fence_true  = 1,
            eAttlist_fence_false = 2
        };
        
        /// Access to EAttlist_fence's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_fence)(void);
        
        enum EAttlist_separator {
            eAttlist_separator_true  = 1,
            eAttlist_separator_false = 2
        };
        
        /// Access to EAttlist_separator's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_separator)(void);
        
        enum EAttlist_stretchy {
            eAttlist_stretchy_true  = 1,
            eAttlist_stretchy_false = 2
        };
        
        /// Access to EAttlist_stretchy's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_stretchy)(void);
        
        enum EAttlist_symmetric {
            eAttlist_symmetric_true  = 1,
            eAttlist_symmetric_false = 2
        };
        
        /// Access to EAttlist_symmetric's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_symmetric)(void);
        
        enum EAttlist_largeop {
            eAttlist_largeop_true  = 1,
            eAttlist_largeop_false = 2
        };
        
        /// Access to EAttlist_largeop's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_largeop)(void);
        
        enum EAttlist_movablelimits {
            eAttlist_movablelimits_true  = 1,
            eAttlist_movablelimits_false = 2
        };
        
        /// Access to EAttlist_movablelimits's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_movablelimits)(void);
        
        enum EAttlist_accent {
            eAttlist_accent_true  = 1,
            eAttlist_accent_false = 2
        };
        
        /// Access to EAttlist_accent's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_accent)(void);
        
        enum EAttlist_linebreak {
            eAttlist_linebreak_auto      = 1,
            eAttlist_linebreak_newline   = 2,
            eAttlist_linebreak_nobreak   = 3,
            eAttlist_linebreak_goodbreak = 4,
            eAttlist_linebreak_badbreak  = 5
        };
        
        /// Access to EAttlist_linebreak's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_linebreak)(void);
        
        enum EAttlist_linebreakstyle {
            eAttlist_linebreakstyle_before              = 1,
            eAttlist_linebreakstyle_after               = 2,
            eAttlist_linebreakstyle_duplicate           = 3,
            eAttlist_linebreakstyle_infixlinebreakstyle = 4
        };
        
        /// Access to EAttlist_linebreakstyle's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_linebreakstyle)(void);
        
        enum EAttlist_indentalign {
            eAttlist_indentalign_left   = 1,
            eAttlist_indentalign_center = 2,
            eAttlist_indentalign_right  = 3,
            eAttlist_indentalign_auto   = 4,
            eAttlist_indentalign_id     = 5
        };
        
        /// Access to EAttlist_indentalign's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_indentalign)(void);
        
        enum EAttlist_indentalignfirst {
            eAttlist_indentalignfirst_left        = 1,
            eAttlist_indentalignfirst_center      = 2,
            eAttlist_indentalignfirst_right       = 3,
            eAttlist_indentalignfirst_auto        = 4,
            eAttlist_indentalignfirst_id          = 5,
            eAttlist_indentalignfirst_indentalign = 6
        };
        
        /// Access to EAttlist_indentalignfirst's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_indentalignfirst)(void);
        
        enum EAttlist_indentalignlast {
            eAttlist_indentalignlast_left        = 1,
            eAttlist_indentalignlast_center      = 2,
            eAttlist_indentalignlast_right       = 3,
            eAttlist_indentalignlast_auto        = 4,
            eAttlist_indentalignlast_id          = 5,
            eAttlist_indentalignlast_indentalign = 6
        };
        
        /// Access to EAttlist_indentalignlast's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_indentalignlast)(void);
        
        // types
        typedef NCBI_NS_STD::string TId;
        typedef NCBI_NS_STD::string TXref;
        typedef NCBI_NS_STD::string TClass;
        typedef NCBI_NS_STD::string TStyle;
        typedef NCBI_NS_STD::string THref;
        typedef NCBI_NS_STD::string TMathcolor;
        typedef NCBI_NS_STD::string TMathbackground;
        typedef EAttlist_mathvariant TMathvariant;
        typedef NCBI_NS_STD::string TMathsize;
        typedef EAttlist_dir TDir;
        typedef NCBI_NS_STD::string TFontfamily;
        typedef EAttlist_fontweight TFontweight;
        typedef EAttlist_fontstyle TFontstyle;
        typedef NCBI_NS_STD::string TFontsize;
        typedef NCBI_NS_STD::string TColor;
        typedef NCBI_NS_STD::string TBackground;
        typedef EAttlist_form TForm;
        typedef EAttlist_fence TFence;
        typedef EAttlist_separator TSeparator;
        typedef NCBI_NS_STD::string TLspace;
        typedef NCBI_NS_STD::string TRspace;
        typedef EAttlist_stretchy TStretchy;
        typedef EAttlist_symmetric TSymmetric;
        typedef NCBI_NS_STD::string TMaxsize;
        typedef NCBI_NS_STD::string TMinsize;
        typedef EAttlist_largeop TLargeop;
        typedef EAttlist_movablelimits TMovablelimits;
        typedef EAttlist_accent TAccent;
        typedef EAttlist_linebreak TLinebreak;
        typedef NCBI_NS_STD::string TLineleading;
        typedef EAttlist_linebreakstyle TLinebreakstyle;
        typedef NCBI_NS_STD::string TLinebreakmultchar;
        typedef EAttlist_indentalign TIndentalign;
        typedef NCBI_NS_STD::string TIndentshift;
        typedef NCBI_NS_STD::string TIndenttarget;
        typedef EAttlist_indentalignfirst TIndentalignfirst;
        typedef NCBI_NS_STD::string TIndentshiftfirst;
        typedef EAttlist_indentalignlast TIndentalignlast;
        typedef NCBI_NS_STD::string TIndentshiftlast;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_id,
            e_xref,
            e_class,
            e_style,
            e_href,
            e_mathcolor,
            e_mathbackground,
            e_mathvariant,
            e_mathsize,
            e_dir,
            e_fontfamily,
            e_fontweight,
            e_fontstyle,
            e_fontsize,
            e_color,
            e_background,
            e_form,
            e_fence,
            e_separator,
            e_lspace,
            e_rspace,
            e_stretchy,
            e_symmetric,
            e_maxsize,
            e_minsize,
            e_largeop,
            e_movablelimits,
            e_accent,
            e_linebreak,
            e_lineleading,
            e_linebreakstyle,
            e_linebreakmultchar,
            e_indentalign,
            e_indentshift,
            e_indenttarget,
            e_indentalignfirst,
            e_indentshiftfirst,
            e_indentalignlast,
            e_indentshiftlast
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 40> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::string TId
        ///  Check whether the Id data member has been assigned a value.
        bool IsSetId(void) const;
        /// Check whether it is safe or not to call GetId method.
        bool CanGetId(void) const;
        void ResetId(void);
        const TId& GetId(void) const;
        void SetId(const TId& value);
        void SetId(TId&& value);
        TId& SetId(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TXref
        ///  Check whether the Xref data member has been assigned a value.
        bool IsSetXref(void) const;
        /// Check whether it is safe or not to call GetXref method.
        bool CanGetXref(void) const;
        void ResetXref(void);
        const TXref& GetXref(void) const;
        void SetXref(const TXref& value);
        void SetXref(TXref&& value);
        TXref& SetXref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TClass
        ///  Check whether the Class data member has been assigned a value.
        bool IsSetClass(void) const;
        /// Check whether it is safe or not to call GetClass method.
        bool CanGetClass(void) const;
        void ResetClass(void);
        const TClass& GetClass(void) const;
        void SetClass(const TClass& value);
        void SetClass(TClass&& value);
        TClass& SetClass(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TStyle
        ///  Check whether the Style data member has been assigned a value.
        bool IsSetStyle(void) const;
        /// Check whether it is safe or not to call GetStyle method.
        bool CanGetStyle(void) const;
        void ResetStyle(void);
        const TStyle& GetStyle(void) const;
        void SetStyle(const TStyle& value);
        void SetStyle(TStyle&& value);
        TStyle& SetStyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string THref
        ///  Check whether the Href data member has been assigned a value.
        bool IsSetHref(void) const;
        /// Check whether it is safe or not to call GetHref method.
        bool CanGetHref(void) const;
        void ResetHref(void);
        const THref& GetHref(void) const;
        void SetHref(const THref& value);
        void SetHref(THref&& value);
        THref& SetHref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathcolor
        ///  Check whether the Mathcolor data member has been assigned a value.
        bool IsSetMathcolor(void) const;
        /// Check whether it is safe or not to call GetMathcolor method.
        bool CanGetMathcolor(void) const;
        void ResetMathcolor(void);
        const TMathcolor& GetMathcolor(void) const;
        void SetMathcolor(const TMathcolor& value);
        void SetMathcolor(TMathcolor&& value);
        TMathcolor& SetMathcolor(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathbackground
        ///  Check whether the Mathbackground data member has been assigned a value.
        bool IsSetMathbackground(void) const;
        /// Check whether it is safe or not to call GetMathbackground method.
        bool CanGetMathbackground(void) const;
        void ResetMathbackground(void);
        const TMathbackground& GetMathbackground(void) const;
        void SetMathbackground(const TMathbackground& value);
        void SetMathbackground(TMathbackground&& value);
        TMathbackground& SetMathbackground(void);
    
        /// optional
        /// typedef EAttlist_mathvariant TMathvariant
        ///  Check whether the Mathvariant data member has been assigned a value.
        bool IsSetMathvariant(void) const;
        /// Check whether it is safe or not to call GetMathvariant method.
        bool CanGetMathvariant(void) const;
        void ResetMathvariant(void);
        TMathvariant GetMathvariant(void) const;
        void SetMathvariant(TMathvariant value);
        TMathvariant& SetMathvariant(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathsize
        ///  Check whether the Mathsize data member has been assigned a value.
        bool IsSetMathsize(void) const;
        /// Check whether it is safe or not to call GetMathsize method.
        bool CanGetMathsize(void) const;
        void ResetMathsize(void);
        const TMathsize& GetMathsize(void) const;
        void SetMathsize(const TMathsize& value);
        void SetMathsize(TMathsize&& value);
        TMathsize& SetMathsize(void);
    
        /// optional
        /// typedef EAttlist_dir TDir
        ///  Check whether the Dir data member has been assigned a value.
        bool IsSetDir(void) const;
        /// Check whether it is safe or not to call GetDir method.
        bool CanGetDir(void) const;
        void ResetDir(void);
        TDir GetDir(void) const;
        void SetDir(TDir value);
        TDir& SetDir(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TFontfamily
        ///  Check whether the Fontfamily data member has been assigned a value.
        bool IsSetFontfamily(void) const;
        /// Check whether it is safe or not to call GetFontfamily method.
        bool CanGetFontfamily(void) const;
        void ResetFontfamily(void);
        const TFontfamily& GetFontfamily(void) const;
        void SetFontfamily(const TFontfamily& value);
        void SetFontfamily(TFontfamily&& value);
        TFontfamily& SetFontfamily(void);
    
        /// optional
        /// typedef EAttlist_fontweight TFontweight
        ///  Check whether the Fontweight data member has been assigned a value.
        bool IsSetFontweight(void) const;
        /// Check whether it is safe or not to call GetFontweight method.
        bool CanGetFontweight(void) const;
        void ResetFontweight(void);
        TFontweight GetFontweight(void) const;
        void SetFontweight(TFontweight value);
        TFontweight& SetFontweight(void);
    
        /// optional
        /// typedef EAttlist_fontstyle TFontstyle
        ///  Check whether the Fontstyle data member has been assigned a value.
        bool IsSetFontstyle(void) const;
        /// Check whether it is safe or not to call GetFontstyle method.
        bool CanGetFontstyle(void) const;
        void ResetFontstyle(void);
        TFontstyle GetFontstyle(void) const;
        void SetFontstyle(TFontstyle value);
        TFontstyle& SetFontstyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TFontsize
        ///  Check whether the Fontsize data member has been assigned a value.
        bool IsSetFontsize(void) const;
        /// Check whether it is safe or not to call GetFontsize method.
        bool CanGetFontsize(void) const;
        void ResetFontsize(void);
        const TFontsize& GetFontsize(void) const;
        void SetFontsize(const TFontsize& value);
        void SetFontsize(TFontsize&& value);
        TFontsize& SetFontsize(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TColor
        ///  Check whether the Color data member has been assigned a value.
        bool IsSetColor(void) const;
        /// Check whether it is safe or not to call GetColor method.
        bool CanGetColor(void) const;
        void ResetColor(void);
        const TColor& GetColor(void) const;
        void SetColor(const TColor& value);
        void SetColor(TColor&& value);
        TColor& SetColor(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TBackground
        ///  Check whether the Background data member has been assigned a value.
        bool IsSetBackground(void) const;
        /// Check whether it is safe or not to call GetBackground method.
        bool CanGetBackground(void) const;
        void ResetBackground(void);
        const TBackground& GetBackground(void) const;
        void SetBackground(const TBackground& value);
        void SetBackground(TBackground&& value);
        TBackground& SetBackground(void);
    
        /// optional
        /// typedef EAttlist_form TForm
        ///  Check whether the Form data member has been assigned a value.
        bool IsSetForm(void) const;
        /// Check whether it is safe or not to call GetForm method.
        bool CanGetForm(void) const;
        void ResetForm(void);
        TForm GetForm(void) const;
        void SetForm(TForm value);
        TForm& SetForm(void);
    
        /// optional
        /// typedef EAttlist_fence TFence
        ///  Check whether the Fence data member has been assigned a value.
        bool IsSetFence(void) const;
        /// Check whether it is safe or not to call GetFence method.
        bool CanGetFence(void) const;
        void ResetFence(void);
        TFence GetFence(void) const;
        void SetFence(TFence value);
        TFence& SetFence(void);
    
        /// optional
        /// typedef EAttlist_separator TSeparator
        ///  Check whether the Separator data member has been assigned a value.
        bool IsSetSeparator(void) const;
        /// Check whether it is safe or not to call GetSeparator method.
        bool CanGetSeparator(void) const;
        void ResetSeparator(void);
        TSeparator GetSeparator(void) const;
        void SetSeparator(TSeparator value);
        TSeparator& SetSeparator(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TLspace
        ///  Check whether the Lspace data member has been assigned a value.
        bool IsSetLspace(void) const;
        /// Check whether it is safe or not to call GetLspace method.
        bool CanGetLspace(void) const;
        void ResetLspace(void);
        const TLspace& GetLspace(void) const;
        void SetLspace(const TLspace& value);
        void SetLspace(TLspace&& value);
        TLspace& SetLspace(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TRspace
        ///  Check whether the Rspace data member has been assigned a value.
        bool IsSetRspace(void) const;
        /// Check whether it is safe or not to call GetRspace method.
        bool CanGetRspace(void) const;
        void ResetRspace(void);
        const TRspace& GetRspace(void) const;
        void SetRspace(const TRspace& value);
        void SetRspace(TRspace&& value);
        TRspace& SetRspace(void);
    
        /// optional
        /// typedef EAttlist_stretchy TStretchy
        ///  Check whether the Stretchy data member has been assigned a value.
        bool IsSetStretchy(void) const;
        /// Check whether it is safe or not to call GetStretchy method.
        bool CanGetStretchy(void) const;
        void ResetStretchy(void);
        TStretchy GetStretchy(void) const;
        void SetStretchy(TStretchy value);
        TStretchy& SetStretchy(void);
    
        /// optional
        /// typedef EAttlist_symmetric TSymmetric
        ///  Check whether the Symmetric data member has been assigned a value.
        bool IsSetSymmetric(void) const;
        /// Check whether it is safe or not to call GetSymmetric method.
        bool CanGetSymmetric(void) const;
        void ResetSymmetric(void);
        TSymmetric GetSymmetric(void) const;
        void SetSymmetric(TSymmetric value);
        TSymmetric& SetSymmetric(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMaxsize
        ///  Check whether the Maxsize data member has been assigned a value.
        bool IsSetMaxsize(void) const;
        /// Check whether it is safe or not to call GetMaxsize method.
        bool CanGetMaxsize(void) const;
        void ResetMaxsize(void);
        const TMaxsize& GetMaxsize(void) const;
        void SetMaxsize(const TMaxsize& value);
        void SetMaxsize(TMaxsize&& value);
        TMaxsize& SetMaxsize(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMinsize
        ///  Check whether the Minsize data member has been assigned a value.
        bool IsSetMinsize(void) const;
        /// Check whether it is safe or not to call GetMinsize method.
        bool CanGetMinsize(void) const;
        void ResetMinsize(void);
        const TMinsize& GetMinsize(void) const;
        void SetMinsize(const TMinsize& value);
        void SetMinsize(TMinsize&& value);
        TMinsize& SetMinsize(void);
    
        /// optional
        /// typedef EAttlist_largeop TLargeop
        ///  Check whether the Largeop data member has been assigned a value.
        bool IsSetLargeop(void) const;
        /// Check whether it is safe or not to call GetLargeop method.
        bool CanGetLargeop(void) const;
        void ResetLargeop(void);
        TLargeop GetLargeop(void) const;
        void SetLargeop(TLargeop value);
        TLargeop& SetLargeop(void);
    
        /// optional
        /// typedef EAttlist_movablelimits TMovablelimits
        ///  Check whether the Movablelimits data member has been assigned a value.
        bool IsSetMovablelimits(void) const;
        /// Check whether it is safe or not to call GetMovablelimits method.
        bool CanGetMovablelimits(void) const;
        void ResetMovablelimits(void);
        TMovablelimits GetMovablelimits(void) const;
        void SetMovablelimits(TMovablelimits value);
        TMovablelimits& SetMovablelimits(void);
    
        /// optional
        /// typedef EAttlist_accent TAccent
        ///  Check whether the Accent data member has been assigned a value.
        bool IsSetAccent(void) const;
        /// Check whether it is safe or not to call GetAccent method.
        bool CanGetAccent(void) const;
        void ResetAccent(void);
        TAccent GetAccent(void) const;
        void SetAccent(TAccent value);
        TAccent& SetAccent(void);
    
        /// optional
        /// typedef EAttlist_linebreak TLinebreak
        ///  Check whether the Linebreak data member has been assigned a value.
        bool IsSetLinebreak(void) const;
        /// Check whether it is safe or not to call GetLinebreak method.
        bool CanGetLinebreak(void) const;
        void ResetLinebreak(void);
        TLinebreak GetLinebreak(void) const;
        void SetLinebreak(TLinebreak value);
        TLinebreak& SetLinebreak(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TLineleading
        ///  Check whether the Lineleading data member has been assigned a value.
        bool IsSetLineleading(void) const;
        /// Check whether it is safe or not to call GetLineleading method.
        bool CanGetLineleading(void) const;
        void ResetLineleading(void);
        const TLineleading& GetLineleading(void) const;
        void SetLineleading(const TLineleading& value);
        void SetLineleading(TLineleading&& value);
        TLineleading& SetLineleading(void);
    
        /// optional
        /// typedef EAttlist_linebreakstyle TLinebreakstyle
        ///  Check whether the Linebreakstyle data member has been assigned a value.
        bool IsSetLinebreakstyle(void) const;
        /// Check whether it is safe or not to call GetLinebreakstyle method.
        bool CanGetLinebreakstyle(void) const;
        void ResetLinebreakstyle(void);
        TLinebreakstyle GetLinebreakstyle(void) const;
        void SetLinebreakstyle(TLinebreakstyle value);
        TLinebreakstyle& SetLinebreakstyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TLinebreakmultchar
        ///  Check whether the Linebreakmultchar data member has been assigned a value.
        bool IsSetLinebreakmultchar(void) const;
        /// Check whether it is safe or not to call GetLinebreakmultchar method.
        bool CanGetLinebreakmultchar(void) const;
        void ResetLinebreakmultchar(void);
        const TLinebreakmultchar& GetLinebreakmultchar(void) const;
        void SetLinebreakmultchar(const TLinebreakmultchar& value);
        void SetLinebreakmultchar(TLinebreakmultchar&& value);
        TLinebreakmultchar& SetLinebreakmultchar(void);
    
        /// optional
        /// typedef EAttlist_indentalign TIndentalign
        ///  Check whether the Indentalign data member has been assigned a value.
        bool IsSetIndentalign(void) const;
        /// Check whether it is safe or not to call GetIndentalign method.
        bool CanGetIndentalign(void) const;
        void ResetIndentalign(void);
        TIndentalign GetIndentalign(void) const;
        void SetIndentalign(TIndentalign value);
        TIndentalign& SetIndentalign(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TIndentshift
        ///  Check whether the Indentshift data member has been assigned a value.
        bool IsSetIndentshift(void) const;
        /// Check whether it is safe or not to call GetIndentshift method.
        bool CanGetIndentshift(void) const;
        void ResetIndentshift(void);
        const TIndentshift& GetIndentshift(void) const;
        void SetIndentshift(const TIndentshift& value);
        void SetIndentshift(TIndentshift&& value);
        TIndentshift& SetIndentshift(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TIndenttarget
        ///  Check whether the Indenttarget data member has been assigned a value.
        bool IsSetIndenttarget(void) const;
        /// Check whether it is safe or not to call GetIndenttarget method.
        bool CanGetIndenttarget(void) const;
        void ResetIndenttarget(void);
        const TIndenttarget& GetIndenttarget(void) const;
        void SetIndenttarget(const TIndenttarget& value);
        void SetIndenttarget(TIndenttarget&& value);
        TIndenttarget& SetIndenttarget(void);
    
        /// optional
        /// typedef EAttlist_indentalignfirst TIndentalignfirst
        ///  Check whether the Indentalignfirst data member has been assigned a value.
        bool IsSetIndentalignfirst(void) const;
        /// Check whether it is safe or not to call GetIndentalignfirst method.
        bool CanGetIndentalignfirst(void) const;
        void ResetIndentalignfirst(void);
        TIndentalignfirst GetIndentalignfirst(void) const;
        void SetIndentalignfirst(TIndentalignfirst value);
        TIndentalignfirst& SetIndentalignfirst(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TIndentshiftfirst
        ///  Check whether the Indentshiftfirst data member has been assigned a value.
        bool IsSetIndentshiftfirst(void) const;
        /// Check whether it is safe or not to call GetIndentshiftfirst method.
        bool CanGetIndentshiftfirst(void) const;
        void ResetIndentshiftfirst(void);
        const TIndentshiftfirst& GetIndentshiftfirst(void) const;
        void SetIndentshiftfirst(const TIndentshiftfirst& value);
        void SetIndentshiftfirst(TIndentshiftfirst&& value);
        TIndentshiftfirst& SetIndentshiftfirst(void);
    
        /// optional
        /// typedef EAttlist_indentalignlast TIndentalignlast
        ///  Check whether the Indentalignlast data member has been assigned a value.
        bool IsSetIndentalignlast(void) const;
        /// Check whether it is safe or not to call GetIndentalignlast method.
        bool CanGetIndentalignlast(void) const;
        void ResetIndentalignlast(void);
        TIndentalignlast GetIndentalignlast(void) const;
        void SetIndentalignlast(TIndentalignlast value);
        TIndentalignlast& SetIndentalignlast(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TIndentshiftlast
        ///  Check whether the Indentshiftlast data member has been assigned a value.
        bool IsSetIndentshiftlast(void) const;
        /// Check whether it is safe or not to call GetIndentshiftlast method.
        bool CanGetIndentshiftlast(void) const;
        void ResetIndentshiftlast(void);
        const TIndentshiftlast& GetIndentshiftlast(void) const;
        void SetIndentshiftlast(const TIndentshiftlast& value);
        void SetIndentshiftlast(TIndentshiftlast&& value);
        TIndentshiftlast& SetIndentshiftlast(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[3];
        NCBI_NS_STD::string m_Id;
        NCBI_NS_STD::string m_Xref;
        NCBI_NS_STD::string m_Class;
        NCBI_NS_STD::string m_Style;
        NCBI_NS_STD::string m_Href;
        NCBI_NS_STD::string m_Mathcolor;
        NCBI_NS_STD::string m_Mathbackground;
        EAttlist_mathvariant m_Mathvariant;
        NCBI_NS_STD::string m_Mathsize;
        EAttlist_dir m_Dir;
        NCBI_NS_STD::string m_Fontfamily;
        EAttlist_fontweight m_Fontweight;
        EAttlist_fontstyle m_Fontstyle;
        NCBI_NS_STD::string m_Fontsize;
        NCBI_NS_STD::string m_Color;
        NCBI_NS_STD::string m_Background;
        EAttlist_form m_Form;
        EAttlist_fence m_Fence;
        EAttlist_separator m_Separator;
        NCBI_NS_STD::string m_Lspace;
        NCBI_NS_STD::string m_Rspace;
        EAttlist_stretchy m_Stretchy;
        EAttlist_symmetric m_Symmetric;
        NCBI_NS_STD::string m_Maxsize;
        NCBI_NS_STD::string m_Minsize;
        EAttlist_largeop m_Largeop;
        EAttlist_movablelimits m_Movablelimits;
        EAttlist_accent m_Accent;
        EAttlist_linebreak m_Linebreak;
        NCBI_NS_STD::string m_Lineleading;
        EAttlist_linebreakstyle m_Linebreakstyle;
        NCBI_NS_STD::string m_Linebreakmultchar;
        EAttlist_indentalign m_Indentalign;
        NCBI_NS_STD::string m_Indentshift;
        NCBI_NS_STD::string m_Indenttarget;
        EAttlist_indentalignfirst m_Indentalignfirst;
        NCBI_NS_STD::string m_Indentshiftfirst;
        EAttlist_indentalignlast m_Indentalignlast;
        NCBI_NS_STD::string m_Indentshiftlast;
    };
    /////////////////////////////////////////////////////////////////////////////
    class C_E_Mo : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_E_Mo(void);
        // destructor
        ~C_E_Mo(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        typedef CToken_content C_Token_content;
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,    ///< No variant selected
            e__CharData,
            e_Token_content
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 3 ///< == e_Token_content+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static NCBI_NS_STD::string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    NCBI_NS_NCBI::EResetVariant reset,
                    NCBI_NS_NCBI::CObjectMemoryPool* pool);
    
        // types
        typedef NCBI_NS_STD::string T_CharData;
        typedef C_Token_content TToken_content;
    
        // getters
        // setters
    
        // typedef NCBI_NS_STD::string T_CharData
        bool Is_CharData(void) const;
        const T_CharData& Get_CharData(void) const;
        T_CharData& Set_CharData(void);
        void Set_CharData(const T_CharData& value);
    
        // typedef C_Token_content TToken_content
        bool IsToken_content(void) const;
        const TToken_content& GetToken_content(void) const;
        TToken_content& SetToken_content(void);
        void SetToken_content(TToken_content& value);
    
    
    private:
        // copy constructor and assignment operator
        C_E_Mo(const C_E_Mo& );
        C_E_Mo& operator=(const C_E_Mo& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    // types
    typedef C_Attlist TAttlist;
    typedef C_E_Mo C_E;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_Mo > > TMo;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_mo
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_Mo > > TMo
    ///  Check whether the Mo data member has been assigned a value.
    bool IsSetMo(void) const;
    /// Check whether it is safe or not to call GetMo method.
    bool CanGetMo(void) const;
    void ResetMo(void);
    const TMo& GetMo(void) const;
    TMo& SetMo(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMo_Base(const CMo_Base&);
    CMo_Base& operator=(const CMo_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_Mo > > m_Mo;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMo_Base::C_Attlist::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetId(void) const
{
    return IsSetId();
}

inline
const CMo_Base::C_Attlist::TId& CMo_Base::C_Attlist::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CMo_Base::C_Attlist::SetId(const CMo_Base::C_Attlist::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
void CMo_Base::C_Attlist::SetId(CMo_Base::C_Attlist::TId&& value)
{
    m_Id = std::forward<CMo_Base::C_Attlist::TId>(value);
    m_set_State[0] |= 0x3;
}

inline
CMo_Base::C_Attlist::TId& CMo_Base::C_Attlist::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CMo_Base::C_Attlist::IsSetXref(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetXref(void) const
{
    return IsSetXref();
}

inline
const CMo_Base::C_Attlist::TXref& CMo_Base::C_Attlist::GetXref(void) const
{
    if (!CanGetXref()) {
        ThrowUnassigned(1);
    }
    return m_Xref;
}

inline
void CMo_Base::C_Attlist::SetXref(const CMo_Base::C_Attlist::TXref& value)
{
    m_Xref = value;
    m_set_State[0] |= 0xc;
}

inline
void CMo_Base::C_Attlist::SetXref(CMo_Base::C_Attlist::TXref&& value)
{
    m_Xref = std::forward<CMo_Base::C_Attlist::TXref>(value);
    m_set_State[0] |= 0xc;
}

inline
CMo_Base::C_Attlist::TXref& CMo_Base::C_Attlist::SetXref(void)
{
#ifdef _DEBUG
    if (!IsSetXref()) {
        m_Xref = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Xref;
}

inline
bool CMo_Base::C_Attlist::IsSetClass(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetClass(void) const
{
    return IsSetClass();
}

inline
const CMo_Base::C_Attlist::TClass& CMo_Base::C_Attlist::GetClass(void) const
{
    if (!CanGetClass()) {
        ThrowUnassigned(2);
    }
    return m_Class;
}

inline
void CMo_Base::C_Attlist::SetClass(const CMo_Base::C_Attlist::TClass& value)
{
    m_Class = value;
    m_set_State[0] |= 0x30;
}

inline
void CMo_Base::C_Attlist::SetClass(CMo_Base::C_Attlist::TClass&& value)
{
    m_Class = std::forward<CMo_Base::C_Attlist::TClass>(value);
    m_set_State[0] |= 0x30;
}

inline
CMo_Base::C_Attlist::TClass& CMo_Base::C_Attlist::SetClass(void)
{
#ifdef _DEBUG
    if (!IsSetClass()) {
        m_Class = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Class;
}

inline
bool CMo_Base::C_Attlist::IsSetStyle(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetStyle(void) const
{
    return IsSetStyle();
}

inline
const CMo_Base::C_Attlist::TStyle& CMo_Base::C_Attlist::GetStyle(void) const
{
    if (!CanGetStyle()) {
        ThrowUnassigned(3);
    }
    return m_Style;
}

inline
void CMo_Base::C_Attlist::SetStyle(const CMo_Base::C_Attlist::TStyle& value)
{
    m_Style = value;
    m_set_State[0] |= 0xc0;
}

inline
void CMo_Base::C_Attlist::SetStyle(CMo_Base::C_Attlist::TStyle&& value)
{
    m_Style = std::forward<CMo_Base::C_Attlist::TStyle>(value);
    m_set_State[0] |= 0xc0;
}

inline
CMo_Base::C_Attlist::TStyle& CMo_Base::C_Attlist::SetStyle(void)
{
#ifdef _DEBUG
    if (!IsSetStyle()) {
        m_Style = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Style;
}

inline
bool CMo_Base::C_Attlist::IsSetHref(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetHref(void) const
{
    return IsSetHref();
}

inline
const CMo_Base::C_Attlist::THref& CMo_Base::C_Attlist::GetHref(void) const
{
    if (!CanGetHref()) {
        ThrowUnassigned(4);
    }
    return m_Href;
}

inline
void CMo_Base::C_Attlist::SetHref(const CMo_Base::C_Attlist::THref& value)
{
    m_Href = value;
    m_set_State[0] |= 0x300;
}

inline
void CMo_Base::C_Attlist::SetHref(CMo_Base::C_Attlist::THref&& value)
{
    m_Href = std::forward<CMo_Base::C_Attlist::THref>(value);
    m_set_State[0] |= 0x300;
}

inline
CMo_Base::C_Attlist::THref& CMo_Base::C_Attlist::SetHref(void)
{
#ifdef _DEBUG
    if (!IsSetHref()) {
        m_Href = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Href;
}

inline
bool CMo_Base::C_Attlist::IsSetMathcolor(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetMathcolor(void) const
{
    return IsSetMathcolor();
}

inline
const CMo_Base::C_Attlist::TMathcolor& CMo_Base::C_Attlist::GetMathcolor(void) const
{
    if (!CanGetMathcolor()) {
        ThrowUnassigned(5);
    }
    return m_Mathcolor;
}

inline
void CMo_Base::C_Attlist::SetMathcolor(const CMo_Base::C_Attlist::TMathcolor& value)
{
    m_Mathcolor = value;
    m_set_State[0] |= 0xc00;
}

inline
void CMo_Base::C_Attlist::SetMathcolor(CMo_Base::C_Attlist::TMathcolor&& value)
{
    m_Mathcolor = std::forward<CMo_Base::C_Attlist::TMathcolor>(value);
    m_set_State[0] |= 0xc00;
}

inline
CMo_Base::C_Attlist::TMathcolor& CMo_Base::C_Attlist::SetMathcolor(void)
{
#ifdef _DEBUG
    if (!IsSetMathcolor()) {
        m_Mathcolor = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Mathcolor;
}

inline
bool CMo_Base::C_Attlist::IsSetMathbackground(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetMathbackground(void) const
{
    return IsSetMathbackground();
}

inline
const CMo_Base::C_Attlist::TMathbackground& CMo_Base::C_Attlist::GetMathbackground(void) const
{
    if (!CanGetMathbackground()) {
        ThrowUnassigned(6);
    }
    return m_Mathbackground;
}

inline
void CMo_Base::C_Attlist::SetMathbackground(const CMo_Base::C_Attlist::TMathbackground& value)
{
    m_Mathbackground = value;
    m_set_State[0] |= 0x3000;
}

inline
void CMo_Base::C_Attlist::SetMathbackground(CMo_Base::C_Attlist::TMathbackground&& value)
{
    m_Mathbackground = std::forward<CMo_Base::C_Attlist::TMathbackground>(value);
    m_set_State[0] |= 0x3000;
}

inline
CMo_Base::C_Attlist::TMathbackground& CMo_Base::C_Attlist::SetMathbackground(void)
{
#ifdef _DEBUG
    if (!IsSetMathbackground()) {
        m_Mathbackground = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Mathbackground;
}

inline
bool CMo_Base::C_Attlist::IsSetMathvariant(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetMathvariant(void) const
{
    return IsSetMathvariant();
}

inline
void CMo_Base::C_Attlist::ResetMathvariant(void)
{
    m_Mathvariant = (EAttlist_mathvariant)(0);
    m_set_State[0] &= ~0xc000;
}

inline
CMo_Base::C_Attlist::TMathvariant CMo_Base::C_Attlist::GetMathvariant(void) const
{
    if (!CanGetMathvariant()) {
        ThrowUnassigned(7);
    }
    return m_Mathvariant;
}

inline
void CMo_Base::C_Attlist::SetMathvariant(CMo_Base::C_Attlist::TMathvariant value)
{
    m_Mathvariant = value;
    m_set_State[0] |= 0xc000;
}

inline
CMo_Base::C_Attlist::TMathvariant& CMo_Base::C_Attlist::SetMathvariant(void)
{
#ifdef _DEBUG
    if (!IsSetMathvariant()) {
        memset(&m_Mathvariant,UnassignedByte(),sizeof(m_Mathvariant));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Mathvariant;
}

inline
bool CMo_Base::C_Attlist::IsSetMathsize(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetMathsize(void) const
{
    return IsSetMathsize();
}

inline
const CMo_Base::C_Attlist::TMathsize& CMo_Base::C_Attlist::GetMathsize(void) const
{
    if (!CanGetMathsize()) {
        ThrowUnassigned(8);
    }
    return m_Mathsize;
}

inline
void CMo_Base::C_Attlist::SetMathsize(const CMo_Base::C_Attlist::TMathsize& value)
{
    m_Mathsize = value;
    m_set_State[0] |= 0x30000;
}

inline
void CMo_Base::C_Attlist::SetMathsize(CMo_Base::C_Attlist::TMathsize&& value)
{
    m_Mathsize = std::forward<CMo_Base::C_Attlist::TMathsize>(value);
    m_set_State[0] |= 0x30000;
}

inline
CMo_Base::C_Attlist::TMathsize& CMo_Base::C_Attlist::SetMathsize(void)
{
#ifdef _DEBUG
    if (!IsSetMathsize()) {
        m_Mathsize = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Mathsize;
}

inline
bool CMo_Base::C_Attlist::IsSetDir(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetDir(void) const
{
    return IsSetDir();
}

inline
void CMo_Base::C_Attlist::ResetDir(void)
{
    m_Dir = (EAttlist_dir)(0);
    m_set_State[0] &= ~0xc0000;
}

inline
CMo_Base::C_Attlist::TDir CMo_Base::C_Attlist::GetDir(void) const
{
    if (!CanGetDir()) {
        ThrowUnassigned(9);
    }
    return m_Dir;
}

inline
void CMo_Base::C_Attlist::SetDir(CMo_Base::C_Attlist::TDir value)
{
    m_Dir = value;
    m_set_State[0] |= 0xc0000;
}

inline
CMo_Base::C_Attlist::TDir& CMo_Base::C_Attlist::SetDir(void)
{
#ifdef _DEBUG
    if (!IsSetDir()) {
        memset(&m_Dir,UnassignedByte(),sizeof(m_Dir));
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Dir;
}

inline
bool CMo_Base::C_Attlist::IsSetFontfamily(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetFontfamily(void) const
{
    return IsSetFontfamily();
}

inline
const CMo_Base::C_Attlist::TFontfamily& CMo_Base::C_Attlist::GetFontfamily(void) const
{
    if (!CanGetFontfamily()) {
        ThrowUnassigned(10);
    }
    return m_Fontfamily;
}

inline
void CMo_Base::C_Attlist::SetFontfamily(const CMo_Base::C_Attlist::TFontfamily& value)
{
    m_Fontfamily = value;
    m_set_State[0] |= 0x300000;
}

inline
void CMo_Base::C_Attlist::SetFontfamily(CMo_Base::C_Attlist::TFontfamily&& value)
{
    m_Fontfamily = std::forward<CMo_Base::C_Attlist::TFontfamily>(value);
    m_set_State[0] |= 0x300000;
}

inline
CMo_Base::C_Attlist::TFontfamily& CMo_Base::C_Attlist::SetFontfamily(void)
{
#ifdef _DEBUG
    if (!IsSetFontfamily()) {
        m_Fontfamily = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_Fontfamily;
}

inline
bool CMo_Base::C_Attlist::IsSetFontweight(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetFontweight(void) const
{
    return IsSetFontweight();
}

inline
void CMo_Base::C_Attlist::ResetFontweight(void)
{
    m_Fontweight = (EAttlist_fontweight)(0);
    m_set_State[0] &= ~0xc00000;
}

inline
CMo_Base::C_Attlist::TFontweight CMo_Base::C_Attlist::GetFontweight(void) const
{
    if (!CanGetFontweight()) {
        ThrowUnassigned(11);
    }
    return m_Fontweight;
}

inline
void CMo_Base::C_Attlist::SetFontweight(CMo_Base::C_Attlist::TFontweight value)
{
    m_Fontweight = value;
    m_set_State[0] |= 0xc00000;
}

inline
CMo_Base::C_Attlist::TFontweight& CMo_Base::C_Attlist::SetFontweight(void)
{
#ifdef _DEBUG
    if (!IsSetFontweight()) {
        memset(&m_Fontweight,UnassignedByte(),sizeof(m_Fontweight));
    }
#endif
    m_set_State[0] |= 0x400000;
    return m_Fontweight;
}

inline
bool CMo_Base::C_Attlist::IsSetFontstyle(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetFontstyle(void) const
{
    return IsSetFontstyle();
}

inline
void CMo_Base::C_Attlist::ResetFontstyle(void)
{
    m_Fontstyle = (EAttlist_fontstyle)(0);
    m_set_State[0] &= ~0x3000000;
}

inline
CMo_Base::C_Attlist::TFontstyle CMo_Base::C_Attlist::GetFontstyle(void) const
{
    if (!CanGetFontstyle()) {
        ThrowUnassigned(12);
    }
    return m_Fontstyle;
}

inline
void CMo_Base::C_Attlist::SetFontstyle(CMo_Base::C_Attlist::TFontstyle value)
{
    m_Fontstyle = value;
    m_set_State[0] |= 0x3000000;
}

inline
CMo_Base::C_Attlist::TFontstyle& CMo_Base::C_Attlist::SetFontstyle(void)
{
#ifdef _DEBUG
    if (!IsSetFontstyle()) {
        memset(&m_Fontstyle,UnassignedByte(),sizeof(m_Fontstyle));
    }
#endif
    m_set_State[0] |= 0x1000000;
    return m_Fontstyle;
}

inline
bool CMo_Base::C_Attlist::IsSetFontsize(void) const
{
    return ((m_set_State[0] & 0xc000000) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetFontsize(void) const
{
    return IsSetFontsize();
}

inline
const CMo_Base::C_Attlist::TFontsize& CMo_Base::C_Attlist::GetFontsize(void) const
{
    if (!CanGetFontsize()) {
        ThrowUnassigned(13);
    }
    return m_Fontsize;
}

inline
void CMo_Base::C_Attlist::SetFontsize(const CMo_Base::C_Attlist::TFontsize& value)
{
    m_Fontsize = value;
    m_set_State[0] |= 0xc000000;
}

inline
void CMo_Base::C_Attlist::SetFontsize(CMo_Base::C_Attlist::TFontsize&& value)
{
    m_Fontsize = std::forward<CMo_Base::C_Attlist::TFontsize>(value);
    m_set_State[0] |= 0xc000000;
}

inline
CMo_Base::C_Attlist::TFontsize& CMo_Base::C_Attlist::SetFontsize(void)
{
#ifdef _DEBUG
    if (!IsSetFontsize()) {
        m_Fontsize = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000000;
    return m_Fontsize;
}

inline
bool CMo_Base::C_Attlist::IsSetColor(void) const
{
    return ((m_set_State[0] & 0x30000000) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetColor(void) const
{
    return IsSetColor();
}

inline
const CMo_Base::C_Attlist::TColor& CMo_Base::C_Attlist::GetColor(void) const
{
    if (!CanGetColor()) {
        ThrowUnassigned(14);
    }
    return m_Color;
}

inline
void CMo_Base::C_Attlist::SetColor(const CMo_Base::C_Attlist::TColor& value)
{
    m_Color = value;
    m_set_State[0] |= 0x30000000;
}

inline
void CMo_Base::C_Attlist::SetColor(CMo_Base::C_Attlist::TColor&& value)
{
    m_Color = std::forward<CMo_Base::C_Attlist::TColor>(value);
    m_set_State[0] |= 0x30000000;
}

inline
CMo_Base::C_Attlist::TColor& CMo_Base::C_Attlist::SetColor(void)
{
#ifdef _DEBUG
    if (!IsSetColor()) {
        m_Color = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000000;
    return m_Color;
}

inline
bool CMo_Base::C_Attlist::IsSetBackground(void) const
{
    return ((m_set_State[0] & 0xc0000000) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetBackground(void) const
{
    return IsSetBackground();
}

inline
const CMo_Base::C_Attlist::TBackground& CMo_Base::C_Attlist::GetBackground(void) const
{
    if (!CanGetBackground()) {
        ThrowUnassigned(15);
    }
    return m_Background;
}

inline
void CMo_Base::C_Attlist::SetBackground(const CMo_Base::C_Attlist::TBackground& value)
{
    m_Background = value;
    m_set_State[0] |= 0xc0000000;
}

inline
void CMo_Base::C_Attlist::SetBackground(CMo_Base::C_Attlist::TBackground&& value)
{
    m_Background = std::forward<CMo_Base::C_Attlist::TBackground>(value);
    m_set_State[0] |= 0xc0000000;
}

inline
CMo_Base::C_Attlist::TBackground& CMo_Base::C_Attlist::SetBackground(void)
{
#ifdef _DEBUG
    if (!IsSetBackground()) {
        m_Background = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000000;
    return m_Background;
}

inline
bool CMo_Base::C_Attlist::IsSetForm(void) const
{
    return ((m_set_State[1] & 0x3) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetForm(void) const
{
    return IsSetForm();
}

inline
void CMo_Base::C_Attlist::ResetForm(void)
{
    m_Form = (EAttlist_form)(0);
    m_set_State[1] &= ~0x3;
}

inline
CMo_Base::C_Attlist::TForm CMo_Base::C_Attlist::GetForm(void) const
{
    if (!CanGetForm()) {
        ThrowUnassigned(16);
    }
    return m_Form;
}

inline
void CMo_Base::C_Attlist::SetForm(CMo_Base::C_Attlist::TForm value)
{
    m_Form = value;
    m_set_State[1] |= 0x3;
}

inline
CMo_Base::C_Attlist::TForm& CMo_Base::C_Attlist::SetForm(void)
{
#ifdef _DEBUG
    if (!IsSetForm()) {
        memset(&m_Form,UnassignedByte(),sizeof(m_Form));
    }
#endif
    m_set_State[1] |= 0x1;
    return m_Form;
}

inline
bool CMo_Base::C_Attlist::IsSetFence(void) const
{
    return ((m_set_State[1] & 0xc) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetFence(void) const
{
    return IsSetFence();
}

inline
void CMo_Base::C_Attlist::ResetFence(void)
{
    m_Fence = (EAttlist_fence)(0);
    m_set_State[1] &= ~0xc;
}

inline
CMo_Base::C_Attlist::TFence CMo_Base::C_Attlist::GetFence(void) const
{
    if (!CanGetFence()) {
        ThrowUnassigned(17);
    }
    return m_Fence;
}

inline
void CMo_Base::C_Attlist::SetFence(CMo_Base::C_Attlist::TFence value)
{
    m_Fence = value;
    m_set_State[1] |= 0xc;
}

inline
CMo_Base::C_Attlist::TFence& CMo_Base::C_Attlist::SetFence(void)
{
#ifdef _DEBUG
    if (!IsSetFence()) {
        memset(&m_Fence,UnassignedByte(),sizeof(m_Fence));
    }
#endif
    m_set_State[1] |= 0x4;
    return m_Fence;
}

inline
bool CMo_Base::C_Attlist::IsSetSeparator(void) const
{
    return ((m_set_State[1] & 0x30) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetSeparator(void) const
{
    return IsSetSeparator();
}

inline
void CMo_Base::C_Attlist::ResetSeparator(void)
{
    m_Separator = (EAttlist_separator)(0);
    m_set_State[1] &= ~0x30;
}

inline
CMo_Base::C_Attlist::TSeparator CMo_Base::C_Attlist::GetSeparator(void) const
{
    if (!CanGetSeparator()) {
        ThrowUnassigned(18);
    }
    return m_Separator;
}

inline
void CMo_Base::C_Attlist::SetSeparator(CMo_Base::C_Attlist::TSeparator value)
{
    m_Separator = value;
    m_set_State[1] |= 0x30;
}

inline
CMo_Base::C_Attlist::TSeparator& CMo_Base::C_Attlist::SetSeparator(void)
{
#ifdef _DEBUG
    if (!IsSetSeparator()) {
        memset(&m_Separator,UnassignedByte(),sizeof(m_Separator));
    }
#endif
    m_set_State[1] |= 0x10;
    return m_Separator;
}

inline
bool CMo_Base::C_Attlist::IsSetLspace(void) const
{
    return ((m_set_State[1] & 0xc0) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetLspace(void) const
{
    return IsSetLspace();
}

inline
const CMo_Base::C_Attlist::TLspace& CMo_Base::C_Attlist::GetLspace(void) const
{
    if (!CanGetLspace()) {
        ThrowUnassigned(19);
    }
    return m_Lspace;
}

inline
void CMo_Base::C_Attlist::SetLspace(const CMo_Base::C_Attlist::TLspace& value)
{
    m_Lspace = value;
    m_set_State[1] |= 0xc0;
}

inline
void CMo_Base::C_Attlist::SetLspace(CMo_Base::C_Attlist::TLspace&& value)
{
    m_Lspace = std::forward<CMo_Base::C_Attlist::TLspace>(value);
    m_set_State[1] |= 0xc0;
}

inline
CMo_Base::C_Attlist::TLspace& CMo_Base::C_Attlist::SetLspace(void)
{
#ifdef _DEBUG
    if (!IsSetLspace()) {
        m_Lspace = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x40;
    return m_Lspace;
}

inline
bool CMo_Base::C_Attlist::IsSetRspace(void) const
{
    return ((m_set_State[1] & 0x300) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetRspace(void) const
{
    return IsSetRspace();
}

inline
const CMo_Base::C_Attlist::TRspace& CMo_Base::C_Attlist::GetRspace(void) const
{
    if (!CanGetRspace()) {
        ThrowUnassigned(20);
    }
    return m_Rspace;
}

inline
void CMo_Base::C_Attlist::SetRspace(const CMo_Base::C_Attlist::TRspace& value)
{
    m_Rspace = value;
    m_set_State[1] |= 0x300;
}

inline
void CMo_Base::C_Attlist::SetRspace(CMo_Base::C_Attlist::TRspace&& value)
{
    m_Rspace = std::forward<CMo_Base::C_Attlist::TRspace>(value);
    m_set_State[1] |= 0x300;
}

inline
CMo_Base::C_Attlist::TRspace& CMo_Base::C_Attlist::SetRspace(void)
{
#ifdef _DEBUG
    if (!IsSetRspace()) {
        m_Rspace = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x100;
    return m_Rspace;
}

inline
bool CMo_Base::C_Attlist::IsSetStretchy(void) const
{
    return ((m_set_State[1] & 0xc00) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetStretchy(void) const
{
    return IsSetStretchy();
}

inline
void CMo_Base::C_Attlist::ResetStretchy(void)
{
    m_Stretchy = (EAttlist_stretchy)(0);
    m_set_State[1] &= ~0xc00;
}

inline
CMo_Base::C_Attlist::TStretchy CMo_Base::C_Attlist::GetStretchy(void) const
{
    if (!CanGetStretchy()) {
        ThrowUnassigned(21);
    }
    return m_Stretchy;
}

inline
void CMo_Base::C_Attlist::SetStretchy(CMo_Base::C_Attlist::TStretchy value)
{
    m_Stretchy = value;
    m_set_State[1] |= 0xc00;
}

inline
CMo_Base::C_Attlist::TStretchy& CMo_Base::C_Attlist::SetStretchy(void)
{
#ifdef _DEBUG
    if (!IsSetStretchy()) {
        memset(&m_Stretchy,UnassignedByte(),sizeof(m_Stretchy));
    }
#endif
    m_set_State[1] |= 0x400;
    return m_Stretchy;
}

inline
bool CMo_Base::C_Attlist::IsSetSymmetric(void) const
{
    return ((m_set_State[1] & 0x3000) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetSymmetric(void) const
{
    return IsSetSymmetric();
}

inline
void CMo_Base::C_Attlist::ResetSymmetric(void)
{
    m_Symmetric = (EAttlist_symmetric)(0);
    m_set_State[1] &= ~0x3000;
}

inline
CMo_Base::C_Attlist::TSymmetric CMo_Base::C_Attlist::GetSymmetric(void) const
{
    if (!CanGetSymmetric()) {
        ThrowUnassigned(22);
    }
    return m_Symmetric;
}

inline
void CMo_Base::C_Attlist::SetSymmetric(CMo_Base::C_Attlist::TSymmetric value)
{
    m_Symmetric = value;
    m_set_State[1] |= 0x3000;
}

inline
CMo_Base::C_Attlist::TSymmetric& CMo_Base::C_Attlist::SetSymmetric(void)
{
#ifdef _DEBUG
    if (!IsSetSymmetric()) {
        memset(&m_Symmetric,UnassignedByte(),sizeof(m_Symmetric));
    }
#endif
    m_set_State[1] |= 0x1000;
    return m_Symmetric;
}

inline
bool CMo_Base::C_Attlist::IsSetMaxsize(void) const
{
    return ((m_set_State[1] & 0xc000) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetMaxsize(void) const
{
    return IsSetMaxsize();
}

inline
const CMo_Base::C_Attlist::TMaxsize& CMo_Base::C_Attlist::GetMaxsize(void) const
{
    if (!CanGetMaxsize()) {
        ThrowUnassigned(23);
    }
    return m_Maxsize;
}

inline
void CMo_Base::C_Attlist::SetMaxsize(const CMo_Base::C_Attlist::TMaxsize& value)
{
    m_Maxsize = value;
    m_set_State[1] |= 0xc000;
}

inline
void CMo_Base::C_Attlist::SetMaxsize(CMo_Base::C_Attlist::TMaxsize&& value)
{
    m_Maxsize = std::forward<CMo_Base::C_Attlist::TMaxsize>(value);
    m_set_State[1] |= 0xc000;
}

inline
CMo_Base::C_Attlist::TMaxsize& CMo_Base::C_Attlist::SetMaxsize(void)
{
#ifdef _DEBUG
    if (!IsSetMaxsize()) {
        m_Maxsize = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x4000;
    return m_Maxsize;
}

inline
bool CMo_Base::C_Attlist::IsSetMinsize(void) const
{
    return ((m_set_State[1] & 0x30000) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetMinsize(void) const
{
    return IsSetMinsize();
}

inline
const CMo_Base::C_Attlist::TMinsize& CMo_Base::C_Attlist::GetMinsize(void) const
{
    if (!CanGetMinsize()) {
        ThrowUnassigned(24);
    }
    return m_Minsize;
}

inline
void CMo_Base::C_Attlist::SetMinsize(const CMo_Base::C_Attlist::TMinsize& value)
{
    m_Minsize = value;
    m_set_State[1] |= 0x30000;
}

inline
void CMo_Base::C_Attlist::SetMinsize(CMo_Base::C_Attlist::TMinsize&& value)
{
    m_Minsize = std::forward<CMo_Base::C_Attlist::TMinsize>(value);
    m_set_State[1] |= 0x30000;
}

inline
CMo_Base::C_Attlist::TMinsize& CMo_Base::C_Attlist::SetMinsize(void)
{
#ifdef _DEBUG
    if (!IsSetMinsize()) {
        m_Minsize = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x10000;
    return m_Minsize;
}

inline
bool CMo_Base::C_Attlist::IsSetLargeop(void) const
{
    return ((m_set_State[1] & 0xc0000) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetLargeop(void) const
{
    return IsSetLargeop();
}

inline
void CMo_Base::C_Attlist::ResetLargeop(void)
{
    m_Largeop = (EAttlist_largeop)(0);
    m_set_State[1] &= ~0xc0000;
}

inline
CMo_Base::C_Attlist::TLargeop CMo_Base::C_Attlist::GetLargeop(void) const
{
    if (!CanGetLargeop()) {
        ThrowUnassigned(25);
    }
    return m_Largeop;
}

inline
void CMo_Base::C_Attlist::SetLargeop(CMo_Base::C_Attlist::TLargeop value)
{
    m_Largeop = value;
    m_set_State[1] |= 0xc0000;
}

inline
CMo_Base::C_Attlist::TLargeop& CMo_Base::C_Attlist::SetLargeop(void)
{
#ifdef _DEBUG
    if (!IsSetLargeop()) {
        memset(&m_Largeop,UnassignedByte(),sizeof(m_Largeop));
    }
#endif
    m_set_State[1] |= 0x40000;
    return m_Largeop;
}

inline
bool CMo_Base::C_Attlist::IsSetMovablelimits(void) const
{
    return ((m_set_State[1] & 0x300000) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetMovablelimits(void) const
{
    return IsSetMovablelimits();
}

inline
void CMo_Base::C_Attlist::ResetMovablelimits(void)
{
    m_Movablelimits = (EAttlist_movablelimits)(0);
    m_set_State[1] &= ~0x300000;
}

inline
CMo_Base::C_Attlist::TMovablelimits CMo_Base::C_Attlist::GetMovablelimits(void) const
{
    if (!CanGetMovablelimits()) {
        ThrowUnassigned(26);
    }
    return m_Movablelimits;
}

inline
void CMo_Base::C_Attlist::SetMovablelimits(CMo_Base::C_Attlist::TMovablelimits value)
{
    m_Movablelimits = value;
    m_set_State[1] |= 0x300000;
}

inline
CMo_Base::C_Attlist::TMovablelimits& CMo_Base::C_Attlist::SetMovablelimits(void)
{
#ifdef _DEBUG
    if (!IsSetMovablelimits()) {
        memset(&m_Movablelimits,UnassignedByte(),sizeof(m_Movablelimits));
    }
#endif
    m_set_State[1] |= 0x100000;
    return m_Movablelimits;
}

inline
bool CMo_Base::C_Attlist::IsSetAccent(void) const
{
    return ((m_set_State[1] & 0xc00000) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetAccent(void) const
{
    return IsSetAccent();
}

inline
void CMo_Base::C_Attlist::ResetAccent(void)
{
    m_Accent = (EAttlist_accent)(0);
    m_set_State[1] &= ~0xc00000;
}

inline
CMo_Base::C_Attlist::TAccent CMo_Base::C_Attlist::GetAccent(void) const
{
    if (!CanGetAccent()) {
        ThrowUnassigned(27);
    }
    return m_Accent;
}

inline
void CMo_Base::C_Attlist::SetAccent(CMo_Base::C_Attlist::TAccent value)
{
    m_Accent = value;
    m_set_State[1] |= 0xc00000;
}

inline
CMo_Base::C_Attlist::TAccent& CMo_Base::C_Attlist::SetAccent(void)
{
#ifdef _DEBUG
    if (!IsSetAccent()) {
        memset(&m_Accent,UnassignedByte(),sizeof(m_Accent));
    }
#endif
    m_set_State[1] |= 0x400000;
    return m_Accent;
}

inline
bool CMo_Base::C_Attlist::IsSetLinebreak(void) const
{
    return ((m_set_State[1] & 0x3000000) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetLinebreak(void) const
{
    return IsSetLinebreak();
}

inline
void CMo_Base::C_Attlist::ResetLinebreak(void)
{
    m_Linebreak = (EAttlist_linebreak)(0);
    m_set_State[1] &= ~0x3000000;
}

inline
CMo_Base::C_Attlist::TLinebreak CMo_Base::C_Attlist::GetLinebreak(void) const
{
    if (!CanGetLinebreak()) {
        ThrowUnassigned(28);
    }
    return m_Linebreak;
}

inline
void CMo_Base::C_Attlist::SetLinebreak(CMo_Base::C_Attlist::TLinebreak value)
{
    m_Linebreak = value;
    m_set_State[1] |= 0x3000000;
}

inline
CMo_Base::C_Attlist::TLinebreak& CMo_Base::C_Attlist::SetLinebreak(void)
{
#ifdef _DEBUG
    if (!IsSetLinebreak()) {
        memset(&m_Linebreak,UnassignedByte(),sizeof(m_Linebreak));
    }
#endif
    m_set_State[1] |= 0x1000000;
    return m_Linebreak;
}

inline
bool CMo_Base::C_Attlist::IsSetLineleading(void) const
{
    return ((m_set_State[1] & 0xc000000) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetLineleading(void) const
{
    return IsSetLineleading();
}

inline
const CMo_Base::C_Attlist::TLineleading& CMo_Base::C_Attlist::GetLineleading(void) const
{
    if (!CanGetLineleading()) {
        ThrowUnassigned(29);
    }
    return m_Lineleading;
}

inline
void CMo_Base::C_Attlist::SetLineleading(const CMo_Base::C_Attlist::TLineleading& value)
{
    m_Lineleading = value;
    m_set_State[1] |= 0xc000000;
}

inline
void CMo_Base::C_Attlist::SetLineleading(CMo_Base::C_Attlist::TLineleading&& value)
{
    m_Lineleading = std::forward<CMo_Base::C_Attlist::TLineleading>(value);
    m_set_State[1] |= 0xc000000;
}

inline
CMo_Base::C_Attlist::TLineleading& CMo_Base::C_Attlist::SetLineleading(void)
{
#ifdef _DEBUG
    if (!IsSetLineleading()) {
        m_Lineleading = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x4000000;
    return m_Lineleading;
}

inline
bool CMo_Base::C_Attlist::IsSetLinebreakstyle(void) const
{
    return ((m_set_State[1] & 0x30000000) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetLinebreakstyle(void) const
{
    return IsSetLinebreakstyle();
}

inline
void CMo_Base::C_Attlist::ResetLinebreakstyle(void)
{
    m_Linebreakstyle = (EAttlist_linebreakstyle)(0);
    m_set_State[1] &= ~0x30000000;
}

inline
CMo_Base::C_Attlist::TLinebreakstyle CMo_Base::C_Attlist::GetLinebreakstyle(void) const
{
    if (!CanGetLinebreakstyle()) {
        ThrowUnassigned(30);
    }
    return m_Linebreakstyle;
}

inline
void CMo_Base::C_Attlist::SetLinebreakstyle(CMo_Base::C_Attlist::TLinebreakstyle value)
{
    m_Linebreakstyle = value;
    m_set_State[1] |= 0x30000000;
}

inline
CMo_Base::C_Attlist::TLinebreakstyle& CMo_Base::C_Attlist::SetLinebreakstyle(void)
{
#ifdef _DEBUG
    if (!IsSetLinebreakstyle()) {
        memset(&m_Linebreakstyle,UnassignedByte(),sizeof(m_Linebreakstyle));
    }
#endif
    m_set_State[1] |= 0x10000000;
    return m_Linebreakstyle;
}

inline
bool CMo_Base::C_Attlist::IsSetLinebreakmultchar(void) const
{
    return ((m_set_State[1] & 0xc0000000) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetLinebreakmultchar(void) const
{
    return IsSetLinebreakmultchar();
}

inline
const CMo_Base::C_Attlist::TLinebreakmultchar& CMo_Base::C_Attlist::GetLinebreakmultchar(void) const
{
    if (!CanGetLinebreakmultchar()) {
        ThrowUnassigned(31);
    }
    return m_Linebreakmultchar;
}

inline
void CMo_Base::C_Attlist::SetLinebreakmultchar(const CMo_Base::C_Attlist::TLinebreakmultchar& value)
{
    m_Linebreakmultchar = value;
    m_set_State[1] |= 0xc0000000;
}

inline
void CMo_Base::C_Attlist::SetLinebreakmultchar(CMo_Base::C_Attlist::TLinebreakmultchar&& value)
{
    m_Linebreakmultchar = std::forward<CMo_Base::C_Attlist::TLinebreakmultchar>(value);
    m_set_State[1] |= 0xc0000000;
}

inline
CMo_Base::C_Attlist::TLinebreakmultchar& CMo_Base::C_Attlist::SetLinebreakmultchar(void)
{
#ifdef _DEBUG
    if (!IsSetLinebreakmultchar()) {
        m_Linebreakmultchar = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x40000000;
    return m_Linebreakmultchar;
}

inline
bool CMo_Base::C_Attlist::IsSetIndentalign(void) const
{
    return ((m_set_State[2] & 0x3) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetIndentalign(void) const
{
    return IsSetIndentalign();
}

inline
void CMo_Base::C_Attlist::ResetIndentalign(void)
{
    m_Indentalign = (EAttlist_indentalign)(0);
    m_set_State[2] &= ~0x3;
}

inline
CMo_Base::C_Attlist::TIndentalign CMo_Base::C_Attlist::GetIndentalign(void) const
{
    if (!CanGetIndentalign()) {
        ThrowUnassigned(32);
    }
    return m_Indentalign;
}

inline
void CMo_Base::C_Attlist::SetIndentalign(CMo_Base::C_Attlist::TIndentalign value)
{
    m_Indentalign = value;
    m_set_State[2] |= 0x3;
}

inline
CMo_Base::C_Attlist::TIndentalign& CMo_Base::C_Attlist::SetIndentalign(void)
{
#ifdef _DEBUG
    if (!IsSetIndentalign()) {
        memset(&m_Indentalign,UnassignedByte(),sizeof(m_Indentalign));
    }
#endif
    m_set_State[2] |= 0x1;
    return m_Indentalign;
}

inline
bool CMo_Base::C_Attlist::IsSetIndentshift(void) const
{
    return ((m_set_State[2] & 0xc) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetIndentshift(void) const
{
    return IsSetIndentshift();
}

inline
const CMo_Base::C_Attlist::TIndentshift& CMo_Base::C_Attlist::GetIndentshift(void) const
{
    if (!CanGetIndentshift()) {
        ThrowUnassigned(33);
    }
    return m_Indentshift;
}

inline
void CMo_Base::C_Attlist::SetIndentshift(const CMo_Base::C_Attlist::TIndentshift& value)
{
    m_Indentshift = value;
    m_set_State[2] |= 0xc;
}

inline
void CMo_Base::C_Attlist::SetIndentshift(CMo_Base::C_Attlist::TIndentshift&& value)
{
    m_Indentshift = std::forward<CMo_Base::C_Attlist::TIndentshift>(value);
    m_set_State[2] |= 0xc;
}

inline
CMo_Base::C_Attlist::TIndentshift& CMo_Base::C_Attlist::SetIndentshift(void)
{
#ifdef _DEBUG
    if (!IsSetIndentshift()) {
        m_Indentshift = UnassignedString();
    }
#endif
    m_set_State[2] |= 0x4;
    return m_Indentshift;
}

inline
bool CMo_Base::C_Attlist::IsSetIndenttarget(void) const
{
    return ((m_set_State[2] & 0x30) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetIndenttarget(void) const
{
    return IsSetIndenttarget();
}

inline
const CMo_Base::C_Attlist::TIndenttarget& CMo_Base::C_Attlist::GetIndenttarget(void) const
{
    if (!CanGetIndenttarget()) {
        ThrowUnassigned(34);
    }
    return m_Indenttarget;
}

inline
void CMo_Base::C_Attlist::SetIndenttarget(const CMo_Base::C_Attlist::TIndenttarget& value)
{
    m_Indenttarget = value;
    m_set_State[2] |= 0x30;
}

inline
void CMo_Base::C_Attlist::SetIndenttarget(CMo_Base::C_Attlist::TIndenttarget&& value)
{
    m_Indenttarget = std::forward<CMo_Base::C_Attlist::TIndenttarget>(value);
    m_set_State[2] |= 0x30;
}

inline
CMo_Base::C_Attlist::TIndenttarget& CMo_Base::C_Attlist::SetIndenttarget(void)
{
#ifdef _DEBUG
    if (!IsSetIndenttarget()) {
        m_Indenttarget = UnassignedString();
    }
#endif
    m_set_State[2] |= 0x10;
    return m_Indenttarget;
}

inline
bool CMo_Base::C_Attlist::IsSetIndentalignfirst(void) const
{
    return ((m_set_State[2] & 0xc0) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetIndentalignfirst(void) const
{
    return IsSetIndentalignfirst();
}

inline
void CMo_Base::C_Attlist::ResetIndentalignfirst(void)
{
    m_Indentalignfirst = (EAttlist_indentalignfirst)(0);
    m_set_State[2] &= ~0xc0;
}

inline
CMo_Base::C_Attlist::TIndentalignfirst CMo_Base::C_Attlist::GetIndentalignfirst(void) const
{
    if (!CanGetIndentalignfirst()) {
        ThrowUnassigned(35);
    }
    return m_Indentalignfirst;
}

inline
void CMo_Base::C_Attlist::SetIndentalignfirst(CMo_Base::C_Attlist::TIndentalignfirst value)
{
    m_Indentalignfirst = value;
    m_set_State[2] |= 0xc0;
}

inline
CMo_Base::C_Attlist::TIndentalignfirst& CMo_Base::C_Attlist::SetIndentalignfirst(void)
{
#ifdef _DEBUG
    if (!IsSetIndentalignfirst()) {
        memset(&m_Indentalignfirst,UnassignedByte(),sizeof(m_Indentalignfirst));
    }
#endif
    m_set_State[2] |= 0x40;
    return m_Indentalignfirst;
}

inline
bool CMo_Base::C_Attlist::IsSetIndentshiftfirst(void) const
{
    return ((m_set_State[2] & 0x300) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetIndentshiftfirst(void) const
{
    return IsSetIndentshiftfirst();
}

inline
const CMo_Base::C_Attlist::TIndentshiftfirst& CMo_Base::C_Attlist::GetIndentshiftfirst(void) const
{
    if (!CanGetIndentshiftfirst()) {
        ThrowUnassigned(36);
    }
    return m_Indentshiftfirst;
}

inline
void CMo_Base::C_Attlist::SetIndentshiftfirst(const CMo_Base::C_Attlist::TIndentshiftfirst& value)
{
    m_Indentshiftfirst = value;
    m_set_State[2] |= 0x300;
}

inline
void CMo_Base::C_Attlist::SetIndentshiftfirst(CMo_Base::C_Attlist::TIndentshiftfirst&& value)
{
    m_Indentshiftfirst = std::forward<CMo_Base::C_Attlist::TIndentshiftfirst>(value);
    m_set_State[2] |= 0x300;
}

inline
CMo_Base::C_Attlist::TIndentshiftfirst& CMo_Base::C_Attlist::SetIndentshiftfirst(void)
{
#ifdef _DEBUG
    if (!IsSetIndentshiftfirst()) {
        m_Indentshiftfirst = UnassignedString();
    }
#endif
    m_set_State[2] |= 0x100;
    return m_Indentshiftfirst;
}

inline
bool CMo_Base::C_Attlist::IsSetIndentalignlast(void) const
{
    return ((m_set_State[2] & 0xc00) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetIndentalignlast(void) const
{
    return IsSetIndentalignlast();
}

inline
void CMo_Base::C_Attlist::ResetIndentalignlast(void)
{
    m_Indentalignlast = (EAttlist_indentalignlast)(0);
    m_set_State[2] &= ~0xc00;
}

inline
CMo_Base::C_Attlist::TIndentalignlast CMo_Base::C_Attlist::GetIndentalignlast(void) const
{
    if (!CanGetIndentalignlast()) {
        ThrowUnassigned(37);
    }
    return m_Indentalignlast;
}

inline
void CMo_Base::C_Attlist::SetIndentalignlast(CMo_Base::C_Attlist::TIndentalignlast value)
{
    m_Indentalignlast = value;
    m_set_State[2] |= 0xc00;
}

inline
CMo_Base::C_Attlist::TIndentalignlast& CMo_Base::C_Attlist::SetIndentalignlast(void)
{
#ifdef _DEBUG
    if (!IsSetIndentalignlast()) {
        memset(&m_Indentalignlast,UnassignedByte(),sizeof(m_Indentalignlast));
    }
#endif
    m_set_State[2] |= 0x400;
    return m_Indentalignlast;
}

inline
bool CMo_Base::C_Attlist::IsSetIndentshiftlast(void) const
{
    return ((m_set_State[2] & 0x3000) != 0);
}

inline
bool CMo_Base::C_Attlist::CanGetIndentshiftlast(void) const
{
    return IsSetIndentshiftlast();
}

inline
const CMo_Base::C_Attlist::TIndentshiftlast& CMo_Base::C_Attlist::GetIndentshiftlast(void) const
{
    if (!CanGetIndentshiftlast()) {
        ThrowUnassigned(38);
    }
    return m_Indentshiftlast;
}

inline
void CMo_Base::C_Attlist::SetIndentshiftlast(const CMo_Base::C_Attlist::TIndentshiftlast& value)
{
    m_Indentshiftlast = value;
    m_set_State[2] |= 0x3000;
}

inline
void CMo_Base::C_Attlist::SetIndentshiftlast(CMo_Base::C_Attlist::TIndentshiftlast&& value)
{
    m_Indentshiftlast = std::forward<CMo_Base::C_Attlist::TIndentshiftlast>(value);
    m_set_State[2] |= 0x3000;
}

inline
CMo_Base::C_Attlist::TIndentshiftlast& CMo_Base::C_Attlist::SetIndentshiftlast(void)
{
#ifdef _DEBUG
    if (!IsSetIndentshiftlast()) {
        m_Indentshiftlast = UnassignedString();
    }
#endif
    m_set_State[2] |= 0x1000;
    return m_Indentshiftlast;
}

inline
CMo_Base::C_E_Mo::E_Choice CMo_Base::C_E_Mo::Which(void) const
{
    return m_choice;
}

inline
void CMo_Base::C_E_Mo::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CMo_Base::C_E_Mo::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CMo_Base::C_E_Mo::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CMo_Base::C_E_Mo::Is_CharData(void) const
{
    return m_choice == e__CharData;
}

inline
const CMo_Base::C_E_Mo::T_CharData& CMo_Base::C_E_Mo::Get_CharData(void) const
{
    CheckSelected(e__CharData);
    return *m_string;
}

inline
CMo_Base::C_E_Mo::T_CharData& CMo_Base::C_E_Mo::Set_CharData(void)
{
    Select(e__CharData, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CMo_Base::C_E_Mo::IsToken_content(void) const
{
    return m_choice == e_Token_content;
}

inline
bool CMo_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CMo_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CMo_Base::TAttlist& CMo_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CMo_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CMo_Base::TAttlist& CMo_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CMo_Base::IsSetMo(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMo_Base::CanGetMo(void) const
{
    return true;
}

inline
const CMo_Base::TMo& CMo_Base::GetMo(void) const
{
    return m_Mo;
}

inline
CMo_Base::TMo& CMo_Base::SetMo(void)
{
    m_set_State[0] |= 0x4;
    return m_Mo;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_MO_BASE_HPP
