/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Mfrac_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_MFRAC_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_MFRAC_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objtools/eutils/efetch/MathExpression.hpp>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CMfrac_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CMfrac_Base(void);
    // destructor
    virtual ~CMfrac_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_numalign {
            eAttlist_numalign_left   = 1,
            eAttlist_numalign_center = 2,
            eAttlist_numalign_right  = 3
        };
        
        /// Access to EAttlist_numalign's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_numalign)(void);
        
        enum EAttlist_denomalign {
            eAttlist_denomalign_left   = 1,
            eAttlist_denomalign_center = 2,
            eAttlist_denomalign_right  = 3
        };
        
        /// Access to EAttlist_denomalign's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_denomalign)(void);
        
        enum EAttlist_bevelled {
            eAttlist_bevelled_true  = 1,
            eAttlist_bevelled_false = 2
        };
        
        /// Access to EAttlist_bevelled's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_bevelled)(void);
        
        // types
        typedef NCBI_NS_STD::string TId;
        typedef NCBI_NS_STD::string TXref;
        typedef NCBI_NS_STD::string TClass;
        typedef NCBI_NS_STD::string TStyle;
        typedef NCBI_NS_STD::string THref;
        typedef NCBI_NS_STD::string TMathcolor;
        typedef NCBI_NS_STD::string TMathbackground;
        typedef NCBI_NS_STD::string TLinethickness;
        typedef EAttlist_numalign TNumalign;
        typedef EAttlist_denomalign TDenomalign;
        typedef EAttlist_bevelled TBevelled;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_id,
            e_xref,
            e_class,
            e_style,
            e_href,
            e_mathcolor,
            e_mathbackground,
            e_linethickness,
            e_numalign,
            e_denomalign,
            e_bevelled
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 12> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::string TId
        ///  Check whether the Id data member has been assigned a value.
        bool IsSetId(void) const;
        /// Check whether it is safe or not to call GetId method.
        bool CanGetId(void) const;
        void ResetId(void);
        const TId& GetId(void) const;
        void SetId(const TId& value);
        void SetId(TId&& value);
        TId& SetId(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TXref
        ///  Check whether the Xref data member has been assigned a value.
        bool IsSetXref(void) const;
        /// Check whether it is safe or not to call GetXref method.
        bool CanGetXref(void) const;
        void ResetXref(void);
        const TXref& GetXref(void) const;
        void SetXref(const TXref& value);
        void SetXref(TXref&& value);
        TXref& SetXref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TClass
        ///  Check whether the Class data member has been assigned a value.
        bool IsSetClass(void) const;
        /// Check whether it is safe or not to call GetClass method.
        bool CanGetClass(void) const;
        void ResetClass(void);
        const TClass& GetClass(void) const;
        void SetClass(const TClass& value);
        void SetClass(TClass&& value);
        TClass& SetClass(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TStyle
        ///  Check whether the Style data member has been assigned a value.
        bool IsSetStyle(void) const;
        /// Check whether it is safe or not to call GetStyle method.
        bool CanGetStyle(void) const;
        void ResetStyle(void);
        const TStyle& GetStyle(void) const;
        void SetStyle(const TStyle& value);
        void SetStyle(TStyle&& value);
        TStyle& SetStyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string THref
        ///  Check whether the Href data member has been assigned a value.
        bool IsSetHref(void) const;
        /// Check whether it is safe or not to call GetHref method.
        bool CanGetHref(void) const;
        void ResetHref(void);
        const THref& GetHref(void) const;
        void SetHref(const THref& value);
        void SetHref(THref&& value);
        THref& SetHref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathcolor
        ///  Check whether the Mathcolor data member has been assigned a value.
        bool IsSetMathcolor(void) const;
        /// Check whether it is safe or not to call GetMathcolor method.
        bool CanGetMathcolor(void) const;
        void ResetMathcolor(void);
        const TMathcolor& GetMathcolor(void) const;
        void SetMathcolor(const TMathcolor& value);
        void SetMathcolor(TMathcolor&& value);
        TMathcolor& SetMathcolor(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathbackground
        ///  Check whether the Mathbackground data member has been assigned a value.
        bool IsSetMathbackground(void) const;
        /// Check whether it is safe or not to call GetMathbackground method.
        bool CanGetMathbackground(void) const;
        void ResetMathbackground(void);
        const TMathbackground& GetMathbackground(void) const;
        void SetMathbackground(const TMathbackground& value);
        void SetMathbackground(TMathbackground&& value);
        TMathbackground& SetMathbackground(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TLinethickness
        ///  Check whether the Linethickness data member has been assigned a value.
        bool IsSetLinethickness(void) const;
        /// Check whether it is safe or not to call GetLinethickness method.
        bool CanGetLinethickness(void) const;
        void ResetLinethickness(void);
        const TLinethickness& GetLinethickness(void) const;
        void SetLinethickness(const TLinethickness& value);
        void SetLinethickness(TLinethickness&& value);
        TLinethickness& SetLinethickness(void);
    
        /// optional
        /// typedef EAttlist_numalign TNumalign
        ///  Check whether the Numalign data member has been assigned a value.
        bool IsSetNumalign(void) const;
        /// Check whether it is safe or not to call GetNumalign method.
        bool CanGetNumalign(void) const;
        void ResetNumalign(void);
        TNumalign GetNumalign(void) const;
        void SetNumalign(TNumalign value);
        TNumalign& SetNumalign(void);
    
        /// optional
        /// typedef EAttlist_denomalign TDenomalign
        ///  Check whether the Denomalign data member has been assigned a value.
        bool IsSetDenomalign(void) const;
        /// Check whether it is safe or not to call GetDenomalign method.
        bool CanGetDenomalign(void) const;
        void ResetDenomalign(void);
        TDenomalign GetDenomalign(void) const;
        void SetDenomalign(TDenomalign value);
        TDenomalign& SetDenomalign(void);
    
        /// optional
        /// typedef EAttlist_bevelled TBevelled
        ///  Check whether the Bevelled data member has been assigned a value.
        bool IsSetBevelled(void) const;
        /// Check whether it is safe or not to call GetBevelled method.
        bool CanGetBevelled(void) const;
        void ResetBevelled(void);
        TBevelled GetBevelled(void) const;
        void SetBevelled(TBevelled value);
        TBevelled& SetBevelled(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::string m_Id;
        NCBI_NS_STD::string m_Xref;
        NCBI_NS_STD::string m_Class;
        NCBI_NS_STD::string m_Style;
        NCBI_NS_STD::string m_Href;
        NCBI_NS_STD::string m_Mathcolor;
        NCBI_NS_STD::string m_Mathbackground;
        NCBI_NS_STD::string m_Linethickness;
        EAttlist_numalign m_Numalign;
        EAttlist_denomalign m_Denomalign;
        EAttlist_bevelled m_Bevelled;
    };
    /////////////////////////////////////////////////////////////////////////////
    class C_E_MathExpression : public CMathExpression
    {
        typedef CMathExpression Tparent;
    public:
        C_E_MathExpression(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    };
    // types
    typedef C_Attlist TAttlist;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_MathExpression > > TMathExpression;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_MathExpression
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_MathExpression > > TMathExpression
    ///  Check whether the MathExpression data member has been assigned a value.
    bool IsSetMathExpression(void) const;
    /// Check whether it is safe or not to call GetMathExpression method.
    bool CanGetMathExpression(void) const;
    void ResetMathExpression(void);
    const TMathExpression& GetMathExpression(void) const;
    TMathExpression& SetMathExpression(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMfrac_Base(const CMfrac_Base&);
    CMfrac_Base& operator=(const CMfrac_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_MathExpression > > m_MathExpression;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMfrac_Base::C_Attlist::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMfrac_Base::C_Attlist::CanGetId(void) const
{
    return IsSetId();
}

inline
const CMfrac_Base::C_Attlist::TId& CMfrac_Base::C_Attlist::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CMfrac_Base::C_Attlist::SetId(const CMfrac_Base::C_Attlist::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
void CMfrac_Base::C_Attlist::SetId(CMfrac_Base::C_Attlist::TId&& value)
{
    m_Id = std::forward<CMfrac_Base::C_Attlist::TId>(value);
    m_set_State[0] |= 0x3;
}

inline
CMfrac_Base::C_Attlist::TId& CMfrac_Base::C_Attlist::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CMfrac_Base::C_Attlist::IsSetXref(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMfrac_Base::C_Attlist::CanGetXref(void) const
{
    return IsSetXref();
}

inline
const CMfrac_Base::C_Attlist::TXref& CMfrac_Base::C_Attlist::GetXref(void) const
{
    if (!CanGetXref()) {
        ThrowUnassigned(1);
    }
    return m_Xref;
}

inline
void CMfrac_Base::C_Attlist::SetXref(const CMfrac_Base::C_Attlist::TXref& value)
{
    m_Xref = value;
    m_set_State[0] |= 0xc;
}

inline
void CMfrac_Base::C_Attlist::SetXref(CMfrac_Base::C_Attlist::TXref&& value)
{
    m_Xref = std::forward<CMfrac_Base::C_Attlist::TXref>(value);
    m_set_State[0] |= 0xc;
}

inline
CMfrac_Base::C_Attlist::TXref& CMfrac_Base::C_Attlist::SetXref(void)
{
#ifdef _DEBUG
    if (!IsSetXref()) {
        m_Xref = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Xref;
}

inline
bool CMfrac_Base::C_Attlist::IsSetClass(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMfrac_Base::C_Attlist::CanGetClass(void) const
{
    return IsSetClass();
}

inline
const CMfrac_Base::C_Attlist::TClass& CMfrac_Base::C_Attlist::GetClass(void) const
{
    if (!CanGetClass()) {
        ThrowUnassigned(2);
    }
    return m_Class;
}

inline
void CMfrac_Base::C_Attlist::SetClass(const CMfrac_Base::C_Attlist::TClass& value)
{
    m_Class = value;
    m_set_State[0] |= 0x30;
}

inline
void CMfrac_Base::C_Attlist::SetClass(CMfrac_Base::C_Attlist::TClass&& value)
{
    m_Class = std::forward<CMfrac_Base::C_Attlist::TClass>(value);
    m_set_State[0] |= 0x30;
}

inline
CMfrac_Base::C_Attlist::TClass& CMfrac_Base::C_Attlist::SetClass(void)
{
#ifdef _DEBUG
    if (!IsSetClass()) {
        m_Class = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Class;
}

inline
bool CMfrac_Base::C_Attlist::IsSetStyle(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMfrac_Base::C_Attlist::CanGetStyle(void) const
{
    return IsSetStyle();
}

inline
const CMfrac_Base::C_Attlist::TStyle& CMfrac_Base::C_Attlist::GetStyle(void) const
{
    if (!CanGetStyle()) {
        ThrowUnassigned(3);
    }
    return m_Style;
}

inline
void CMfrac_Base::C_Attlist::SetStyle(const CMfrac_Base::C_Attlist::TStyle& value)
{
    m_Style = value;
    m_set_State[0] |= 0xc0;
}

inline
void CMfrac_Base::C_Attlist::SetStyle(CMfrac_Base::C_Attlist::TStyle&& value)
{
    m_Style = std::forward<CMfrac_Base::C_Attlist::TStyle>(value);
    m_set_State[0] |= 0xc0;
}

inline
CMfrac_Base::C_Attlist::TStyle& CMfrac_Base::C_Attlist::SetStyle(void)
{
#ifdef _DEBUG
    if (!IsSetStyle()) {
        m_Style = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Style;
}

inline
bool CMfrac_Base::C_Attlist::IsSetHref(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMfrac_Base::C_Attlist::CanGetHref(void) const
{
    return IsSetHref();
}

inline
const CMfrac_Base::C_Attlist::THref& CMfrac_Base::C_Attlist::GetHref(void) const
{
    if (!CanGetHref()) {
        ThrowUnassigned(4);
    }
    return m_Href;
}

inline
void CMfrac_Base::C_Attlist::SetHref(const CMfrac_Base::C_Attlist::THref& value)
{
    m_Href = value;
    m_set_State[0] |= 0x300;
}

inline
void CMfrac_Base::C_Attlist::SetHref(CMfrac_Base::C_Attlist::THref&& value)
{
    m_Href = std::forward<CMfrac_Base::C_Attlist::THref>(value);
    m_set_State[0] |= 0x300;
}

inline
CMfrac_Base::C_Attlist::THref& CMfrac_Base::C_Attlist::SetHref(void)
{
#ifdef _DEBUG
    if (!IsSetHref()) {
        m_Href = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Href;
}

inline
bool CMfrac_Base::C_Attlist::IsSetMathcolor(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMfrac_Base::C_Attlist::CanGetMathcolor(void) const
{
    return IsSetMathcolor();
}

inline
const CMfrac_Base::C_Attlist::TMathcolor& CMfrac_Base::C_Attlist::GetMathcolor(void) const
{
    if (!CanGetMathcolor()) {
        ThrowUnassigned(5);
    }
    return m_Mathcolor;
}

inline
void CMfrac_Base::C_Attlist::SetMathcolor(const CMfrac_Base::C_Attlist::TMathcolor& value)
{
    m_Mathcolor = value;
    m_set_State[0] |= 0xc00;
}

inline
void CMfrac_Base::C_Attlist::SetMathcolor(CMfrac_Base::C_Attlist::TMathcolor&& value)
{
    m_Mathcolor = std::forward<CMfrac_Base::C_Attlist::TMathcolor>(value);
    m_set_State[0] |= 0xc00;
}

inline
CMfrac_Base::C_Attlist::TMathcolor& CMfrac_Base::C_Attlist::SetMathcolor(void)
{
#ifdef _DEBUG
    if (!IsSetMathcolor()) {
        m_Mathcolor = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Mathcolor;
}

inline
bool CMfrac_Base::C_Attlist::IsSetMathbackground(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CMfrac_Base::C_Attlist::CanGetMathbackground(void) const
{
    return IsSetMathbackground();
}

inline
const CMfrac_Base::C_Attlist::TMathbackground& CMfrac_Base::C_Attlist::GetMathbackground(void) const
{
    if (!CanGetMathbackground()) {
        ThrowUnassigned(6);
    }
    return m_Mathbackground;
}

inline
void CMfrac_Base::C_Attlist::SetMathbackground(const CMfrac_Base::C_Attlist::TMathbackground& value)
{
    m_Mathbackground = value;
    m_set_State[0] |= 0x3000;
}

inline
void CMfrac_Base::C_Attlist::SetMathbackground(CMfrac_Base::C_Attlist::TMathbackground&& value)
{
    m_Mathbackground = std::forward<CMfrac_Base::C_Attlist::TMathbackground>(value);
    m_set_State[0] |= 0x3000;
}

inline
CMfrac_Base::C_Attlist::TMathbackground& CMfrac_Base::C_Attlist::SetMathbackground(void)
{
#ifdef _DEBUG
    if (!IsSetMathbackground()) {
        m_Mathbackground = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Mathbackground;
}

inline
bool CMfrac_Base::C_Attlist::IsSetLinethickness(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CMfrac_Base::C_Attlist::CanGetLinethickness(void) const
{
    return IsSetLinethickness();
}

inline
const CMfrac_Base::C_Attlist::TLinethickness& CMfrac_Base::C_Attlist::GetLinethickness(void) const
{
    if (!CanGetLinethickness()) {
        ThrowUnassigned(7);
    }
    return m_Linethickness;
}

inline
void CMfrac_Base::C_Attlist::SetLinethickness(const CMfrac_Base::C_Attlist::TLinethickness& value)
{
    m_Linethickness = value;
    m_set_State[0] |= 0xc000;
}

inline
void CMfrac_Base::C_Attlist::SetLinethickness(CMfrac_Base::C_Attlist::TLinethickness&& value)
{
    m_Linethickness = std::forward<CMfrac_Base::C_Attlist::TLinethickness>(value);
    m_set_State[0] |= 0xc000;
}

inline
CMfrac_Base::C_Attlist::TLinethickness& CMfrac_Base::C_Attlist::SetLinethickness(void)
{
#ifdef _DEBUG
    if (!IsSetLinethickness()) {
        m_Linethickness = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Linethickness;
}

inline
bool CMfrac_Base::C_Attlist::IsSetNumalign(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CMfrac_Base::C_Attlist::CanGetNumalign(void) const
{
    return IsSetNumalign();
}

inline
void CMfrac_Base::C_Attlist::ResetNumalign(void)
{
    m_Numalign = (EAttlist_numalign)(0);
    m_set_State[0] &= ~0x30000;
}

inline
CMfrac_Base::C_Attlist::TNumalign CMfrac_Base::C_Attlist::GetNumalign(void) const
{
    if (!CanGetNumalign()) {
        ThrowUnassigned(8);
    }
    return m_Numalign;
}

inline
void CMfrac_Base::C_Attlist::SetNumalign(CMfrac_Base::C_Attlist::TNumalign value)
{
    m_Numalign = value;
    m_set_State[0] |= 0x30000;
}

inline
CMfrac_Base::C_Attlist::TNumalign& CMfrac_Base::C_Attlist::SetNumalign(void)
{
#ifdef _DEBUG
    if (!IsSetNumalign()) {
        memset(&m_Numalign,UnassignedByte(),sizeof(m_Numalign));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Numalign;
}

inline
bool CMfrac_Base::C_Attlist::IsSetDenomalign(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CMfrac_Base::C_Attlist::CanGetDenomalign(void) const
{
    return IsSetDenomalign();
}

inline
void CMfrac_Base::C_Attlist::ResetDenomalign(void)
{
    m_Denomalign = (EAttlist_denomalign)(0);
    m_set_State[0] &= ~0xc0000;
}

inline
CMfrac_Base::C_Attlist::TDenomalign CMfrac_Base::C_Attlist::GetDenomalign(void) const
{
    if (!CanGetDenomalign()) {
        ThrowUnassigned(9);
    }
    return m_Denomalign;
}

inline
void CMfrac_Base::C_Attlist::SetDenomalign(CMfrac_Base::C_Attlist::TDenomalign value)
{
    m_Denomalign = value;
    m_set_State[0] |= 0xc0000;
}

inline
CMfrac_Base::C_Attlist::TDenomalign& CMfrac_Base::C_Attlist::SetDenomalign(void)
{
#ifdef _DEBUG
    if (!IsSetDenomalign()) {
        memset(&m_Denomalign,UnassignedByte(),sizeof(m_Denomalign));
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Denomalign;
}

inline
bool CMfrac_Base::C_Attlist::IsSetBevelled(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CMfrac_Base::C_Attlist::CanGetBevelled(void) const
{
    return IsSetBevelled();
}

inline
void CMfrac_Base::C_Attlist::ResetBevelled(void)
{
    m_Bevelled = (EAttlist_bevelled)(0);
    m_set_State[0] &= ~0x300000;
}

inline
CMfrac_Base::C_Attlist::TBevelled CMfrac_Base::C_Attlist::GetBevelled(void) const
{
    if (!CanGetBevelled()) {
        ThrowUnassigned(10);
    }
    return m_Bevelled;
}

inline
void CMfrac_Base::C_Attlist::SetBevelled(CMfrac_Base::C_Attlist::TBevelled value)
{
    m_Bevelled = value;
    m_set_State[0] |= 0x300000;
}

inline
CMfrac_Base::C_Attlist::TBevelled& CMfrac_Base::C_Attlist::SetBevelled(void)
{
#ifdef _DEBUG
    if (!IsSetBevelled()) {
        memset(&m_Bevelled,UnassignedByte(),sizeof(m_Bevelled));
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_Bevelled;
}

inline
CMfrac_Base::C_E_MathExpression::C_E_MathExpression(void)
{
}

inline
bool CMfrac_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CMfrac_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CMfrac_Base::TAttlist& CMfrac_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CMfrac_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CMfrac_Base::TAttlist& CMfrac_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CMfrac_Base::IsSetMathExpression(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMfrac_Base::CanGetMathExpression(void) const
{
    return true;
}

inline
const CMfrac_Base::TMathExpression& CMfrac_Base::GetMathExpression(void) const
{
    return m_MathExpression;
}

inline
CMfrac_Base::TMathExpression& CMfrac_Base::SetMathExpression(void)
{
    m_set_State[0] |= 0x4;
    return m_MathExpression;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_MFRAC_BASE_HPP
