/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file LocationLabel_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_LOCATIONLABEL_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_LOCATIONLABEL_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CLocationLabel_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CLocationLabel_Base(void);
    // destructor
    virtual ~CLocationLabel_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_Type {
            eAttlist_Type_part     = 1,
            eAttlist_Type_chapter  = 2,
            eAttlist_Type_section  = 3,
            eAttlist_Type_appendix = 4,
            eAttlist_Type_figure   = 5,
            eAttlist_Type_table    = 6,
            eAttlist_Type_box      = 7
        };
        
        /// Access to EAttlist_Type's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_Type)(void);
        
        // types
        typedef EAttlist_Type TType;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_Type
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef EAttlist_Type TType
        ///  Check whether the Type data member has been assigned a value.
        bool IsSetType(void) const;
        /// Check whether it is safe or not to call GetType method.
        bool CanGetType(void) const;
        void ResetType(void);
        TType GetType(void) const;
        void SetType(TType value);
        TType& SetType(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        EAttlist_Type m_Type;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef NCBI_NS_STD::string TLocationLabel;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_LocationLabel
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef NCBI_NS_STD::string TLocationLabel
    ///  Check whether the LocationLabel data member has been assigned a value.
    bool IsSetLocationLabel(void) const;
    /// Check whether it is safe or not to call GetLocationLabel method.
    bool CanGetLocationLabel(void) const;
    void ResetLocationLabel(void);
    const TLocationLabel& GetLocationLabel(void) const;
    void SetLocationLabel(const TLocationLabel& value);
    void SetLocationLabel(TLocationLabel&& value);
    TLocationLabel& SetLocationLabel(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CLocationLabel_Base(const CLocationLabel_Base&);
    CLocationLabel_Base& operator=(const CLocationLabel_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::string m_LocationLabel;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CLocationLabel_Base::C_Attlist::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CLocationLabel_Base::C_Attlist::CanGetType(void) const
{
    return IsSetType();
}

inline
void CLocationLabel_Base::C_Attlist::ResetType(void)
{
    m_Type = (EAttlist_Type)(0);
    m_set_State[0] &= ~0x3;
}

inline
CLocationLabel_Base::C_Attlist::TType CLocationLabel_Base::C_Attlist::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CLocationLabel_Base::C_Attlist::SetType(CLocationLabel_Base::C_Attlist::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CLocationLabel_Base::C_Attlist::TType& CLocationLabel_Base::C_Attlist::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CLocationLabel_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CLocationLabel_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CLocationLabel_Base::TAttlist& CLocationLabel_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CLocationLabel_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CLocationLabel_Base::TAttlist& CLocationLabel_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CLocationLabel_Base::IsSetLocationLabel(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CLocationLabel_Base::CanGetLocationLabel(void) const
{
    return IsSetLocationLabel();
}

inline
const CLocationLabel_Base::TLocationLabel& CLocationLabel_Base::GetLocationLabel(void) const
{
    if (!CanGetLocationLabel()) {
        ThrowUnassigned(1);
    }
    return m_LocationLabel;
}

inline
void CLocationLabel_Base::SetLocationLabel(const CLocationLabel_Base::TLocationLabel& value)
{
    m_LocationLabel = value;
    m_set_State[0] |= 0xc;
}

inline
void CLocationLabel_Base::SetLocationLabel(CLocationLabel_Base::TLocationLabel&& value)
{
    m_LocationLabel = std::forward<CLocationLabel_Base::TLocationLabel>(value);
    m_set_State[0] |= 0xc;
}

inline
CLocationLabel_Base::TLocationLabel& CLocationLabel_Base::SetLocationLabel(void)
{
#ifdef _DEBUG
    if (!IsSetLocationLabel()) {
        m_LocationLabel = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_LocationLabel;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_LOCATIONLABEL_BASE_HPP
