/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file JournalIssue_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_JOURNALISSUE_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_JOURNALISSUE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CIssue;
class CPubDate;
class CVolume;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CJournalIssue_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CJournalIssue_Base(void);
    // destructor
    virtual ~CJournalIssue_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_CitedMedium {
            eAttlist_CitedMedium_Internet = 1,
            eAttlist_CitedMedium_Print    = 2
        };
        
        /// Access to EAttlist_CitedMedium's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_CitedMedium)(void);
        
        // types
        typedef EAttlist_CitedMedium TCitedMedium;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_CitedMedium
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef EAttlist_CitedMedium TCitedMedium
        ///  Check whether the CitedMedium data member has been assigned a value.
        bool IsSetCitedMedium(void) const;
        /// Check whether it is safe or not to call GetCitedMedium method.
        bool CanGetCitedMedium(void) const;
        void ResetCitedMedium(void);
        TCitedMedium GetCitedMedium(void) const;
        void SetCitedMedium(TCitedMedium value);
        TCitedMedium& SetCitedMedium(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        EAttlist_CitedMedium m_CitedMedium;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef CVolume TVolume;
    typedef CIssue TIssue;
    typedef CPubDate TPubDate;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_Volume,
        e_Issue,
        e_PubDate
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// optional
    /// typedef CVolume TVolume
    ///  Check whether the Volume data member has been assigned a value.
    bool IsSetVolume(void) const;
    /// Check whether it is safe or not to call GetVolume method.
    bool CanGetVolume(void) const;
    void ResetVolume(void);
    const TVolume& GetVolume(void) const;
    void SetVolume(TVolume& value);
    TVolume& SetVolume(void);

    /// optional
    /// typedef CIssue TIssue
    ///  Check whether the Issue data member has been assigned a value.
    bool IsSetIssue(void) const;
    /// Check whether it is safe or not to call GetIssue method.
    bool CanGetIssue(void) const;
    void ResetIssue(void);
    const TIssue& GetIssue(void) const;
    void SetIssue(TIssue& value);
    TIssue& SetIssue(void);

    /// mandatory
    /// typedef CPubDate TPubDate
    ///  Check whether the PubDate data member has been assigned a value.
    bool IsSetPubDate(void) const;
    /// Check whether it is safe or not to call GetPubDate method.
    bool CanGetPubDate(void) const;
    void ResetPubDate(void);
    const TPubDate& GetPubDate(void) const;
    void SetPubDate(TPubDate& value);
    TPubDate& SetPubDate(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CJournalIssue_Base(const CJournalIssue_Base&);
    CJournalIssue_Base& operator=(const CJournalIssue_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_NCBI::CRef< TVolume > m_Volume;
    NCBI_NS_NCBI::CRef< TIssue > m_Issue;
    NCBI_NS_NCBI::CRef< TPubDate > m_PubDate;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CJournalIssue_Base::C_Attlist::IsSetCitedMedium(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CJournalIssue_Base::C_Attlist::CanGetCitedMedium(void) const
{
    return IsSetCitedMedium();
}

inline
void CJournalIssue_Base::C_Attlist::ResetCitedMedium(void)
{
    m_CitedMedium = (EAttlist_CitedMedium)(0);
    m_set_State[0] &= ~0x3;
}

inline
CJournalIssue_Base::C_Attlist::TCitedMedium CJournalIssue_Base::C_Attlist::GetCitedMedium(void) const
{
    if (!CanGetCitedMedium()) {
        ThrowUnassigned(0);
    }
    return m_CitedMedium;
}

inline
void CJournalIssue_Base::C_Attlist::SetCitedMedium(CJournalIssue_Base::C_Attlist::TCitedMedium value)
{
    m_CitedMedium = value;
    m_set_State[0] |= 0x3;
}

inline
CJournalIssue_Base::C_Attlist::TCitedMedium& CJournalIssue_Base::C_Attlist::SetCitedMedium(void)
{
#ifdef _DEBUG
    if (!IsSetCitedMedium()) {
        memset(&m_CitedMedium,UnassignedByte(),sizeof(m_CitedMedium));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_CitedMedium;
}

inline
bool CJournalIssue_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CJournalIssue_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CJournalIssue_Base::TAttlist& CJournalIssue_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CJournalIssue_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CJournalIssue_Base::TAttlist& CJournalIssue_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CJournalIssue_Base::IsSetVolume(void) const
{
    return m_Volume.NotEmpty();
}

inline
bool CJournalIssue_Base::CanGetVolume(void) const
{
    return IsSetVolume();
}

inline
const CJournalIssue_Base::TVolume& CJournalIssue_Base::GetVolume(void) const
{
    if (!CanGetVolume()) {
        ThrowUnassigned(1);
    }
    return (*m_Volume);
}

inline
bool CJournalIssue_Base::IsSetIssue(void) const
{
    return m_Issue.NotEmpty();
}

inline
bool CJournalIssue_Base::CanGetIssue(void) const
{
    return IsSetIssue();
}

inline
const CJournalIssue_Base::TIssue& CJournalIssue_Base::GetIssue(void) const
{
    if (!CanGetIssue()) {
        ThrowUnassigned(2);
    }
    return (*m_Issue);
}

inline
bool CJournalIssue_Base::IsSetPubDate(void) const
{
    return m_PubDate.NotEmpty();
}

inline
bool CJournalIssue_Base::CanGetPubDate(void) const
{
    return true;
}

inline
const CJournalIssue_Base::TPubDate& CJournalIssue_Base::GetPubDate(void) const
{
    if ( !m_PubDate ) {
        const_cast<CJournalIssue_Base*>(this)->ResetPubDate();
    }
    return (*m_PubDate);
}

inline
CJournalIssue_Base::TPubDate& CJournalIssue_Base::SetPubDate(void)
{
    if ( !m_PubDate ) {
        ResetPubDate();
    }
    return (*m_PubDate);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_JOURNALISSUE_BASE_HPP
