/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Investigator_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_INVESTIGATOR_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_INVESTIGATOR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CAffiliationInfo;
class CForeName;
class CIdentifier;
class CInitials;
class CLastName;
class CSuffix;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CInvestigator_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CInvestigator_Base(void);
    // destructor
    virtual ~CInvestigator_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_ValidYN {
            eAttlist_ValidYN_Y = 1,
            eAttlist_ValidYN_N = 2
        };
        
        /// Access to EAttlist_ValidYN's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_ValidYN)(void);
        
        // types
        typedef EAttlist_ValidYN TValidYN;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_ValidYN
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// optional with default eAttlist_ValidYN_Y
        /// typedef EAttlist_ValidYN TValidYN
        ///  Check whether the ValidYN data member has been assigned a value.
        bool IsSetValidYN(void) const;
        /// Check whether it is safe or not to call GetValidYN method.
        bool CanGetValidYN(void) const;
        void ResetValidYN(void);
        void SetDefaultValidYN(void);
        TValidYN GetValidYN(void) const;
        void SetValidYN(TValidYN value);
        TValidYN& SetValidYN(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        EAttlist_ValidYN m_ValidYN;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef CLastName TLastName;
    typedef CForeName TForeName;
    typedef CInitials TInitials;
    typedef CSuffix TSuffix;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CIdentifier > > TIdentifier;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CAffiliationInfo > > TAffiliationInfo;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_LastName,
        e_ForeName,
        e_Initials,
        e_Suffix,
        e_Identifier,
        e_AffiliationInfo
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef CLastName TLastName
    ///  Check whether the LastName data member has been assigned a value.
    bool IsSetLastName(void) const;
    /// Check whether it is safe or not to call GetLastName method.
    bool CanGetLastName(void) const;
    void ResetLastName(void);
    const TLastName& GetLastName(void) const;
    void SetLastName(TLastName& value);
    TLastName& SetLastName(void);

    /// optional
    /// typedef CForeName TForeName
    ///  Check whether the ForeName data member has been assigned a value.
    bool IsSetForeName(void) const;
    /// Check whether it is safe or not to call GetForeName method.
    bool CanGetForeName(void) const;
    void ResetForeName(void);
    const TForeName& GetForeName(void) const;
    void SetForeName(TForeName& value);
    TForeName& SetForeName(void);

    /// optional
    /// typedef CInitials TInitials
    ///  Check whether the Initials data member has been assigned a value.
    bool IsSetInitials(void) const;
    /// Check whether it is safe or not to call GetInitials method.
    bool CanGetInitials(void) const;
    void ResetInitials(void);
    const TInitials& GetInitials(void) const;
    void SetInitials(TInitials& value);
    TInitials& SetInitials(void);

    /// optional
    /// typedef CSuffix TSuffix
    ///  Check whether the Suffix data member has been assigned a value.
    bool IsSetSuffix(void) const;
    /// Check whether it is safe or not to call GetSuffix method.
    bool CanGetSuffix(void) const;
    void ResetSuffix(void);
    const TSuffix& GetSuffix(void) const;
    void SetSuffix(TSuffix& value);
    TSuffix& SetSuffix(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CIdentifier > > TIdentifier
    ///  Check whether the Identifier data member has been assigned a value.
    bool IsSetIdentifier(void) const;
    /// Check whether it is safe or not to call GetIdentifier method.
    bool CanGetIdentifier(void) const;
    void ResetIdentifier(void);
    const TIdentifier& GetIdentifier(void) const;
    TIdentifier& SetIdentifier(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CAffiliationInfo > > TAffiliationInfo
    ///  Check whether the AffiliationInfo data member has been assigned a value.
    bool IsSetAffiliationInfo(void) const;
    /// Check whether it is safe or not to call GetAffiliationInfo method.
    bool CanGetAffiliationInfo(void) const;
    void ResetAffiliationInfo(void);
    const TAffiliationInfo& GetAffiliationInfo(void) const;
    TAffiliationInfo& SetAffiliationInfo(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CInvestigator_Base(const CInvestigator_Base&);
    CInvestigator_Base& operator=(const CInvestigator_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_NCBI::CRef< TLastName > m_LastName;
    NCBI_NS_NCBI::CRef< TForeName > m_ForeName;
    NCBI_NS_NCBI::CRef< TInitials > m_Initials;
    NCBI_NS_NCBI::CRef< TSuffix > m_Suffix;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CIdentifier > > m_Identifier;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CAffiliationInfo > > m_AffiliationInfo;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CInvestigator_Base::C_Attlist::IsSetValidYN(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CInvestigator_Base::C_Attlist::CanGetValidYN(void) const
{
    return true;
}

inline
void CInvestigator_Base::C_Attlist::ResetValidYN(void)
{
    m_ValidYN = eAttlist_ValidYN_Y;
    m_set_State[0] &= ~0x3;
}

inline
void CInvestigator_Base::C_Attlist::SetDefaultValidYN(void)
{
    ResetValidYN();
    m_set_State[0] |= 0x1;
}

inline
CInvestigator_Base::C_Attlist::TValidYN CInvestigator_Base::C_Attlist::GetValidYN(void) const
{
    return m_ValidYN;
}

inline
void CInvestigator_Base::C_Attlist::SetValidYN(CInvestigator_Base::C_Attlist::TValidYN value)
{
    m_ValidYN = value;
    m_set_State[0] |= 0x3;
}

inline
CInvestigator_Base::C_Attlist::TValidYN& CInvestigator_Base::C_Attlist::SetValidYN(void)
{
#ifdef _DEBUG
    if (!IsSetValidYN()) {
        memset(&m_ValidYN,UnassignedByte(),sizeof(m_ValidYN));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_ValidYN;
}

inline
bool CInvestigator_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CInvestigator_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CInvestigator_Base::TAttlist& CInvestigator_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CInvestigator_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CInvestigator_Base::TAttlist& CInvestigator_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CInvestigator_Base::IsSetLastName(void) const
{
    return m_LastName.NotEmpty();
}

inline
bool CInvestigator_Base::CanGetLastName(void) const
{
    return true;
}

inline
const CInvestigator_Base::TLastName& CInvestigator_Base::GetLastName(void) const
{
    if ( !m_LastName ) {
        const_cast<CInvestigator_Base*>(this)->ResetLastName();
    }
    return (*m_LastName);
}

inline
CInvestigator_Base::TLastName& CInvestigator_Base::SetLastName(void)
{
    if ( !m_LastName ) {
        ResetLastName();
    }
    return (*m_LastName);
}

inline
bool CInvestigator_Base::IsSetForeName(void) const
{
    return m_ForeName.NotEmpty();
}

inline
bool CInvestigator_Base::CanGetForeName(void) const
{
    return IsSetForeName();
}

inline
const CInvestigator_Base::TForeName& CInvestigator_Base::GetForeName(void) const
{
    if (!CanGetForeName()) {
        ThrowUnassigned(2);
    }
    return (*m_ForeName);
}

inline
bool CInvestigator_Base::IsSetInitials(void) const
{
    return m_Initials.NotEmpty();
}

inline
bool CInvestigator_Base::CanGetInitials(void) const
{
    return IsSetInitials();
}

inline
const CInvestigator_Base::TInitials& CInvestigator_Base::GetInitials(void) const
{
    if (!CanGetInitials()) {
        ThrowUnassigned(3);
    }
    return (*m_Initials);
}

inline
bool CInvestigator_Base::IsSetSuffix(void) const
{
    return m_Suffix.NotEmpty();
}

inline
bool CInvestigator_Base::CanGetSuffix(void) const
{
    return IsSetSuffix();
}

inline
const CInvestigator_Base::TSuffix& CInvestigator_Base::GetSuffix(void) const
{
    if (!CanGetSuffix()) {
        ThrowUnassigned(4);
    }
    return (*m_Suffix);
}

inline
bool CInvestigator_Base::IsSetIdentifier(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CInvestigator_Base::CanGetIdentifier(void) const
{
    return true;
}

inline
const CInvestigator_Base::TIdentifier& CInvestigator_Base::GetIdentifier(void) const
{
    return m_Identifier;
}

inline
CInvestigator_Base::TIdentifier& CInvestigator_Base::SetIdentifier(void)
{
    m_set_State[0] |= 0x400;
    return m_Identifier;
}

inline
bool CInvestigator_Base::IsSetAffiliationInfo(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CInvestigator_Base::CanGetAffiliationInfo(void) const
{
    return true;
}

inline
const CInvestigator_Base::TAffiliationInfo& CInvestigator_Base::GetAffiliationInfo(void) const
{
    return m_AffiliationInfo;
}

inline
CInvestigator_Base::TAffiliationInfo& CInvestigator_Base::SetAffiliationInfo(void)
{
    m_set_State[0] |= 0x1000;
    return m_AffiliationInfo;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_INVESTIGATOR_BASE_HPP
