/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ISSN_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_ISSN_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_ISSN_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CISSN_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CISSN_Base(void);
    // destructor
    virtual ~CISSN_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_IssnType {
            eAttlist_IssnType_Electronic = 1,
            eAttlist_IssnType_Print      = 2
        };
        
        /// Access to EAttlist_IssnType's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_IssnType)(void);
        
        // types
        typedef EAttlist_IssnType TIssnType;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_IssnType
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef EAttlist_IssnType TIssnType
        ///  Check whether the IssnType data member has been assigned a value.
        bool IsSetIssnType(void) const;
        /// Check whether it is safe or not to call GetIssnType method.
        bool CanGetIssnType(void) const;
        void ResetIssnType(void);
        TIssnType GetIssnType(void) const;
        void SetIssnType(TIssnType value);
        TIssnType& SetIssnType(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        EAttlist_IssnType m_IssnType;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef NCBI_NS_STD::string TISSN;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_ISSN
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef NCBI_NS_STD::string TISSN
    ///  Check whether the ISSN data member has been assigned a value.
    bool IsSetISSN(void) const;
    /// Check whether it is safe or not to call GetISSN method.
    bool CanGetISSN(void) const;
    void ResetISSN(void);
    const TISSN& GetISSN(void) const;
    void SetISSN(const TISSN& value);
    void SetISSN(TISSN&& value);
    TISSN& SetISSN(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CISSN_Base(const CISSN_Base&);
    CISSN_Base& operator=(const CISSN_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::string m_ISSN;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CISSN_Base::C_Attlist::IsSetIssnType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CISSN_Base::C_Attlist::CanGetIssnType(void) const
{
    return IsSetIssnType();
}

inline
void CISSN_Base::C_Attlist::ResetIssnType(void)
{
    m_IssnType = (EAttlist_IssnType)(0);
    m_set_State[0] &= ~0x3;
}

inline
CISSN_Base::C_Attlist::TIssnType CISSN_Base::C_Attlist::GetIssnType(void) const
{
    if (!CanGetIssnType()) {
        ThrowUnassigned(0);
    }
    return m_IssnType;
}

inline
void CISSN_Base::C_Attlist::SetIssnType(CISSN_Base::C_Attlist::TIssnType value)
{
    m_IssnType = value;
    m_set_State[0] |= 0x3;
}

inline
CISSN_Base::C_Attlist::TIssnType& CISSN_Base::C_Attlist::SetIssnType(void)
{
#ifdef _DEBUG
    if (!IsSetIssnType()) {
        memset(&m_IssnType,UnassignedByte(),sizeof(m_IssnType));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_IssnType;
}

inline
bool CISSN_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CISSN_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CISSN_Base::TAttlist& CISSN_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CISSN_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CISSN_Base::TAttlist& CISSN_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CISSN_Base::IsSetISSN(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CISSN_Base::CanGetISSN(void) const
{
    return IsSetISSN();
}

inline
const CISSN_Base::TISSN& CISSN_Base::GetISSN(void) const
{
    if (!CanGetISSN()) {
        ThrowUnassigned(1);
    }
    return m_ISSN;
}

inline
void CISSN_Base::SetISSN(const CISSN_Base::TISSN& value)
{
    m_ISSN = value;
    m_set_State[0] |= 0xc;
}

inline
void CISSN_Base::SetISSN(CISSN_Base::TISSN&& value)
{
    m_ISSN = std::forward<CISSN_Base::TISSN>(value);
    m_set_State[0] |= 0xc;
}

inline
CISSN_Base::TISSN& CISSN_Base::SetISSN(void)
{
#ifdef _DEBUG
    if (!IsSetISSN()) {
        m_ISSN = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_ISSN;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_ISSN_BASE_HPP
