/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file EndingDate_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_ENDINGDATE_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_ENDINGDATE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CDay;
class CMonth;
class CSeason;
class CYear;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CEndingDate_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CEndingDate_Base(void);
    // destructor
    virtual ~CEndingDate_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_MS : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_MS(void);
        // destructor
        ~C_MS(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class C_MD : public NCBI_NS_NCBI::CSerialObject
        {
            typedef NCBI_NS_NCBI::CSerialObject Tparent;
        public:
            // constructor
            C_MD(void);
            // destructor
            ~C_MD(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            // types
            typedef CMonth TMonth;
            typedef CDay TDay;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_Month,
                e_Day
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
        
            // getters
            // setters
        
            /// mandatory
            /// typedef CMonth TMonth
            ///  Check whether the Month data member has been assigned a value.
            bool IsSetMonth(void) const;
            /// Check whether it is safe or not to call GetMonth method.
            bool CanGetMonth(void) const;
            void ResetMonth(void);
            const TMonth& GetMonth(void) const;
            void SetMonth(TMonth& value);
            TMonth& SetMonth(void);
        
            /// optional
            /// typedef CDay TDay
            ///  Check whether the Day data member has been assigned a value.
            bool IsSetDay(void) const;
            /// Check whether it is safe or not to call GetDay method.
            bool CanGetDay(void) const;
            void ResetDay(void);
            const TDay& GetDay(void) const;
            void SetDay(TDay& value);
            TDay& SetDay(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_MD(const C_MD&);
            C_MD& operator=(const C_MD&);
        
            // data
            Uint4 m_set_State[1];
            NCBI_NS_NCBI::CRef< TMonth > m_Month;
            NCBI_NS_NCBI::CRef< TDay > m_Day;
        };
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_MD,
            e_Season
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 3 ///< == e_Season+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static NCBI_NS_STD::string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    NCBI_NS_NCBI::EResetVariant reset,
                    NCBI_NS_NCBI::CObjectMemoryPool* pool);
    
        // types
        typedef C_MD TMD;
        typedef CSeason TSeason;
    
        // getters
        // setters
    
        // typedef C_MD TMD
        bool IsMD(void) const;
        const TMD& GetMD(void) const;
        TMD& SetMD(void);
        void SetMD(TMD& value);
    
        // typedef CSeason TSeason
        bool IsSeason(void) const;
        const TSeason& GetSeason(void) const;
        TSeason& SetSeason(void);
        void SetSeason(TSeason& value);
    
    
    private:
        // copy constructor and assignment operator
        C_MS(const C_MS& );
        C_MS& operator=(const C_MS& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
    // types
    typedef CYear TYear;
    typedef C_MS TMS;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Year,
        e_MS
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CYear TYear
    ///  Check whether the Year data member has been assigned a value.
    bool IsSetYear(void) const;
    /// Check whether it is safe or not to call GetYear method.
    bool CanGetYear(void) const;
    void ResetYear(void);
    const TYear& GetYear(void) const;
    void SetYear(TYear& value);
    TYear& SetYear(void);

    /// optional
    /// typedef C_MS TMS
    ///  Check whether the MS data member has been assigned a value.
    bool IsSetMS(void) const;
    /// Check whether it is safe or not to call GetMS method.
    bool CanGetMS(void) const;
    void ResetMS(void);
    const TMS& GetMS(void) const;
    void SetMS(TMS& value);
    TMS& SetMS(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CEndingDate_Base(const CEndingDate_Base&);
    CEndingDate_Base& operator=(const CEndingDate_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TYear > m_Year;
    NCBI_NS_NCBI::CRef< TMS > m_MS;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CEndingDate_Base::C_MS::C_MD::IsSetMonth(void) const
{
    return m_Month.NotEmpty();
}

inline
bool CEndingDate_Base::C_MS::C_MD::CanGetMonth(void) const
{
    return true;
}

inline
const CEndingDate_Base::C_MS::C_MD::TMonth& CEndingDate_Base::C_MS::C_MD::GetMonth(void) const
{
    if ( !m_Month ) {
        const_cast<C_MD*>(this)->ResetMonth();
    }
    return (*m_Month);
}

inline
CEndingDate_Base::C_MS::C_MD::TMonth& CEndingDate_Base::C_MS::C_MD::SetMonth(void)
{
    if ( !m_Month ) {
        ResetMonth();
    }
    return (*m_Month);
}

inline
bool CEndingDate_Base::C_MS::C_MD::IsSetDay(void) const
{
    return m_Day.NotEmpty();
}

inline
bool CEndingDate_Base::C_MS::C_MD::CanGetDay(void) const
{
    return IsSetDay();
}

inline
const CEndingDate_Base::C_MS::C_MD::TDay& CEndingDate_Base::C_MS::C_MD::GetDay(void) const
{
    if (!CanGetDay()) {
        ThrowUnassigned(1);
    }
    return (*m_Day);
}

inline
CEndingDate_Base::C_MS::E_Choice CEndingDate_Base::C_MS::Which(void) const
{
    return m_choice;
}

inline
void CEndingDate_Base::C_MS::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CEndingDate_Base::C_MS::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CEndingDate_Base::C_MS::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CEndingDate_Base::C_MS::IsMD(void) const
{
    return m_choice == e_MD;
}

inline
bool CEndingDate_Base::C_MS::IsSeason(void) const
{
    return m_choice == e_Season;
}

inline
bool CEndingDate_Base::IsSetYear(void) const
{
    return m_Year.NotEmpty();
}

inline
bool CEndingDate_Base::CanGetYear(void) const
{
    return true;
}

inline
const CEndingDate_Base::TYear& CEndingDate_Base::GetYear(void) const
{
    if ( !m_Year ) {
        const_cast<CEndingDate_Base*>(this)->ResetYear();
    }
    return (*m_Year);
}

inline
CEndingDate_Base::TYear& CEndingDate_Base::SetYear(void)
{
    if ( !m_Year ) {
        ResetYear();
    }
    return (*m_Year);
}

inline
bool CEndingDate_Base::IsSetMS(void) const
{
    return m_MS.NotEmpty();
}

inline
bool CEndingDate_Base::CanGetMS(void) const
{
    return IsSetMS();
}

inline
const CEndingDate_Base::TMS& CEndingDate_Base::GetMS(void) const
{
    if (!CanGetMS()) {
        ThrowUnassigned(1);
    }
    return (*m_MS);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_ENDINGDATE_BASE_HPP
