/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ELocationID_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_ELOCATIONID_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_ELOCATIONID_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CELocationID_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CELocationID_Base(void);
    // destructor
    virtual ~CELocationID_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_EIdType {
            eAttlist_EIdType_doi = 1,
            eAttlist_EIdType_pii = 2
        };
        
        /// Access to EAttlist_EIdType's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_EIdType)(void);
        
        enum EAttlist_ValidYN {
            eAttlist_ValidYN_Y = 1,
            eAttlist_ValidYN_N = 2
        };
        
        /// Access to EAttlist_ValidYN's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_ValidYN)(void);
        
        // types
        typedef EAttlist_EIdType TEIdType;
        typedef EAttlist_ValidYN TValidYN;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_EIdType,
            e_ValidYN
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef EAttlist_EIdType TEIdType
        ///  Check whether the EIdType data member has been assigned a value.
        bool IsSetEIdType(void) const;
        /// Check whether it is safe or not to call GetEIdType method.
        bool CanGetEIdType(void) const;
        void ResetEIdType(void);
        TEIdType GetEIdType(void) const;
        void SetEIdType(TEIdType value);
        TEIdType& SetEIdType(void);
    
        /// optional with default eAttlist_ValidYN_Y
        /// typedef EAttlist_ValidYN TValidYN
        ///  Check whether the ValidYN data member has been assigned a value.
        bool IsSetValidYN(void) const;
        /// Check whether it is safe or not to call GetValidYN method.
        bool CanGetValidYN(void) const;
        void ResetValidYN(void);
        void SetDefaultValidYN(void);
        TValidYN GetValidYN(void) const;
        void SetValidYN(TValidYN value);
        TValidYN& SetValidYN(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        EAttlist_EIdType m_EIdType;
        EAttlist_ValidYN m_ValidYN;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef NCBI_NS_STD::string TELocationID;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_ELocationID
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef NCBI_NS_STD::string TELocationID
    ///  Check whether the ELocationID data member has been assigned a value.
    bool IsSetELocationID(void) const;
    /// Check whether it is safe or not to call GetELocationID method.
    bool CanGetELocationID(void) const;
    void ResetELocationID(void);
    const TELocationID& GetELocationID(void) const;
    void SetELocationID(const TELocationID& value);
    void SetELocationID(TELocationID&& value);
    TELocationID& SetELocationID(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CELocationID_Base(const CELocationID_Base&);
    CELocationID_Base& operator=(const CELocationID_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::string m_ELocationID;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CELocationID_Base::C_Attlist::IsSetEIdType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CELocationID_Base::C_Attlist::CanGetEIdType(void) const
{
    return IsSetEIdType();
}

inline
void CELocationID_Base::C_Attlist::ResetEIdType(void)
{
    m_EIdType = (EAttlist_EIdType)(0);
    m_set_State[0] &= ~0x3;
}

inline
CELocationID_Base::C_Attlist::TEIdType CELocationID_Base::C_Attlist::GetEIdType(void) const
{
    if (!CanGetEIdType()) {
        ThrowUnassigned(0);
    }
    return m_EIdType;
}

inline
void CELocationID_Base::C_Attlist::SetEIdType(CELocationID_Base::C_Attlist::TEIdType value)
{
    m_EIdType = value;
    m_set_State[0] |= 0x3;
}

inline
CELocationID_Base::C_Attlist::TEIdType& CELocationID_Base::C_Attlist::SetEIdType(void)
{
#ifdef _DEBUG
    if (!IsSetEIdType()) {
        memset(&m_EIdType,UnassignedByte(),sizeof(m_EIdType));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_EIdType;
}

inline
bool CELocationID_Base::C_Attlist::IsSetValidYN(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CELocationID_Base::C_Attlist::CanGetValidYN(void) const
{
    return true;
}

inline
void CELocationID_Base::C_Attlist::ResetValidYN(void)
{
    m_ValidYN = eAttlist_ValidYN_Y;
    m_set_State[0] &= ~0xc;
}

inline
void CELocationID_Base::C_Attlist::SetDefaultValidYN(void)
{
    ResetValidYN();
    m_set_State[0] |= 0x4;
}

inline
CELocationID_Base::C_Attlist::TValidYN CELocationID_Base::C_Attlist::GetValidYN(void) const
{
    return m_ValidYN;
}

inline
void CELocationID_Base::C_Attlist::SetValidYN(CELocationID_Base::C_Attlist::TValidYN value)
{
    m_ValidYN = value;
    m_set_State[0] |= 0xc;
}

inline
CELocationID_Base::C_Attlist::TValidYN& CELocationID_Base::C_Attlist::SetValidYN(void)
{
#ifdef _DEBUG
    if (!IsSetValidYN()) {
        memset(&m_ValidYN,UnassignedByte(),sizeof(m_ValidYN));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_ValidYN;
}

inline
bool CELocationID_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CELocationID_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CELocationID_Base::TAttlist& CELocationID_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CELocationID_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CELocationID_Base::TAttlist& CELocationID_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CELocationID_Base::IsSetELocationID(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CELocationID_Base::CanGetELocationID(void) const
{
    return IsSetELocationID();
}

inline
const CELocationID_Base::TELocationID& CELocationID_Base::GetELocationID(void) const
{
    if (!CanGetELocationID()) {
        ThrowUnassigned(1);
    }
    return m_ELocationID;
}

inline
void CELocationID_Base::SetELocationID(const CELocationID_Base::TELocationID& value)
{
    m_ELocationID = value;
    m_set_State[0] |= 0xc;
}

inline
void CELocationID_Base::SetELocationID(CELocationID_Base::TELocationID&& value)
{
    m_ELocationID = std::forward<CELocationID_Base::TELocationID>(value);
    m_set_State[0] |= 0xc;
}

inline
CELocationID_Base::TELocationID& CELocationID_Base::SetELocationID(void)
{
#ifdef _DEBUG
    if (!IsSetELocationID()) {
        m_ELocationID = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_ELocationID;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_ELOCATIONID_BASE_HPP
