/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file CommentsCorrections_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_COMMENTSCORRECTIONS_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_COMMENTSCORRECTIONS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CNote;
class CPMID;
class CRefSource;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CCommentsCorrections_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CCommentsCorrections_Base(void);
    // destructor
    virtual ~CCommentsCorrections_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_RefType {
            eAttlist_RefType_AssociatedDataset           =  1,
            eAttlist_RefType_AssociatedPublication       =  2,
            eAttlist_RefType_CommentIn                   =  3,
            eAttlist_RefType_CommentOn                   =  4,
            eAttlist_RefType_CorrectedandRepublishedIn   =  5,
            eAttlist_RefType_CorrectedandRepublishedFrom =  6,
            eAttlist_RefType_ErratumIn                   =  7,
            eAttlist_RefType_ErratumFor                  =  8,
            eAttlist_RefType_ExpressionOfConcernIn       =  9,
            eAttlist_RefType_ExpressionOfConcernFor      = 10,
            eAttlist_RefType_RepublishedIn               = 11,
            eAttlist_RefType_RepublishedFrom             = 12,
            eAttlist_RefType_RetractedandRepublishedIn   = 13,
            eAttlist_RefType_RetractedandRepublishedFrom = 14,
            eAttlist_RefType_RetractionIn                = 15,
            eAttlist_RefType_RetractionOf                = 16,
            eAttlist_RefType_UpdateIn                    = 17,
            eAttlist_RefType_UpdateOf                    = 18,
            eAttlist_RefType_SummaryForPatientsIn        = 19,
            eAttlist_RefType_OriginalReportIn            = 20,
            eAttlist_RefType_ReprintIn                   = 21,
            eAttlist_RefType_ReprintOf                   = 22,
            eAttlist_RefType_Cites                       = 23
        };
        
        /// Access to EAttlist_RefType's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_RefType)(void);
        
        // types
        typedef EAttlist_RefType TRefType;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_RefType
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef EAttlist_RefType TRefType
        ///  Check whether the RefType data member has been assigned a value.
        bool IsSetRefType(void) const;
        /// Check whether it is safe or not to call GetRefType method.
        bool CanGetRefType(void) const;
        void ResetRefType(void);
        TRefType GetRefType(void) const;
        void SetRefType(TRefType value);
        TRefType& SetRefType(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        EAttlist_RefType m_RefType;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef CRefSource TRefSource;
    typedef CPMID TPMID;
    typedef CNote TNote;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_RefSource,
        e_PMID,
        e_Note
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef CRefSource TRefSource
    ///  Check whether the RefSource data member has been assigned a value.
    bool IsSetRefSource(void) const;
    /// Check whether it is safe or not to call GetRefSource method.
    bool CanGetRefSource(void) const;
    void ResetRefSource(void);
    const TRefSource& GetRefSource(void) const;
    void SetRefSource(TRefSource& value);
    TRefSource& SetRefSource(void);

    /// optional
    /// typedef CPMID TPMID
    ///  Check whether the PMID data member has been assigned a value.
    bool IsSetPMID(void) const;
    /// Check whether it is safe or not to call GetPMID method.
    bool CanGetPMID(void) const;
    void ResetPMID(void);
    const TPMID& GetPMID(void) const;
    void SetPMID(TPMID& value);
    TPMID& SetPMID(void);
    void SetPMID(const NCBI_NS_STD::string& value);

    /// optional
    /// typedef CNote TNote
    ///  Check whether the Note data member has been assigned a value.
    bool IsSetNote(void) const;
    /// Check whether it is safe or not to call GetNote method.
    bool CanGetNote(void) const;
    void ResetNote(void);
    const TNote& GetNote(void) const;
    void SetNote(TNote& value);
    TNote& SetNote(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCommentsCorrections_Base(const CCommentsCorrections_Base&);
    CCommentsCorrections_Base& operator=(const CCommentsCorrections_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_NCBI::CRef< TRefSource > m_RefSource;
    NCBI_NS_NCBI::CRef< TPMID > m_PMID;
    NCBI_NS_NCBI::CRef< TNote > m_Note;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCommentsCorrections_Base::C_Attlist::IsSetRefType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCommentsCorrections_Base::C_Attlist::CanGetRefType(void) const
{
    return IsSetRefType();
}

inline
void CCommentsCorrections_Base::C_Attlist::ResetRefType(void)
{
    m_RefType = (EAttlist_RefType)(0);
    m_set_State[0] &= ~0x3;
}

inline
CCommentsCorrections_Base::C_Attlist::TRefType CCommentsCorrections_Base::C_Attlist::GetRefType(void) const
{
    if (!CanGetRefType()) {
        ThrowUnassigned(0);
    }
    return m_RefType;
}

inline
void CCommentsCorrections_Base::C_Attlist::SetRefType(CCommentsCorrections_Base::C_Attlist::TRefType value)
{
    m_RefType = value;
    m_set_State[0] |= 0x3;
}

inline
CCommentsCorrections_Base::C_Attlist::TRefType& CCommentsCorrections_Base::C_Attlist::SetRefType(void)
{
#ifdef _DEBUG
    if (!IsSetRefType()) {
        memset(&m_RefType,UnassignedByte(),sizeof(m_RefType));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_RefType;
}

inline
bool CCommentsCorrections_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CCommentsCorrections_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CCommentsCorrections_Base::TAttlist& CCommentsCorrections_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CCommentsCorrections_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CCommentsCorrections_Base::TAttlist& CCommentsCorrections_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CCommentsCorrections_Base::IsSetRefSource(void) const
{
    return m_RefSource.NotEmpty();
}

inline
bool CCommentsCorrections_Base::CanGetRefSource(void) const
{
    return true;
}

inline
const CCommentsCorrections_Base::TRefSource& CCommentsCorrections_Base::GetRefSource(void) const
{
    if ( !m_RefSource ) {
        const_cast<CCommentsCorrections_Base*>(this)->ResetRefSource();
    }
    return (*m_RefSource);
}

inline
CCommentsCorrections_Base::TRefSource& CCommentsCorrections_Base::SetRefSource(void)
{
    if ( !m_RefSource ) {
        ResetRefSource();
    }
    return (*m_RefSource);
}

inline
bool CCommentsCorrections_Base::IsSetPMID(void) const
{
    return m_PMID.NotEmpty();
}

inline
bool CCommentsCorrections_Base::CanGetPMID(void) const
{
    return IsSetPMID();
}

inline
const CCommentsCorrections_Base::TPMID& CCommentsCorrections_Base::GetPMID(void) const
{
    if (!CanGetPMID()) {
        ThrowUnassigned(2);
    }
    return (*m_PMID);
}

inline
bool CCommentsCorrections_Base::IsSetNote(void) const
{
    return m_Note.NotEmpty();
}

inline
bool CCommentsCorrections_Base::CanGetNote(void) const
{
    return IsSetNote();
}

inline
const CCommentsCorrections_Base::TNote& CCommentsCorrections_Base::GetNote(void) const
{
    if (!CanGetNote()) {
        ThrowUnassigned(3);
    }
    return (*m_Note);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_COMMENTSCORRECTIONS_BASE_HPP
