/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file BookDocumentSet_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_BOOKDOCUMENTSET_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_BOOKDOCUMENTSET_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CBookDocument;
class CDeleteDocument;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CBookDocumentSet_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CBookDocumentSet_Base(void);
    // destructor
    virtual ~CBookDocumentSet_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CBookDocument > > TBookDocument;
    typedef CDeleteDocument TDeleteDocument;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_BookDocument,
        e_DeleteDocument
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CBookDocument > > TBookDocument
    ///  Check whether the BookDocument data member has been assigned a value.
    bool IsSetBookDocument(void) const;
    /// Check whether it is safe or not to call GetBookDocument method.
    bool CanGetBookDocument(void) const;
    void ResetBookDocument(void);
    const TBookDocument& GetBookDocument(void) const;
    TBookDocument& SetBookDocument(void);

    /// optional
    /// typedef CDeleteDocument TDeleteDocument
    ///  Check whether the DeleteDocument data member has been assigned a value.
    bool IsSetDeleteDocument(void) const;
    /// Check whether it is safe or not to call GetDeleteDocument method.
    bool CanGetDeleteDocument(void) const;
    void ResetDeleteDocument(void);
    const TDeleteDocument& GetDeleteDocument(void) const;
    void SetDeleteDocument(TDeleteDocument& value);
    TDeleteDocument& SetDeleteDocument(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBookDocumentSet_Base(const CBookDocumentSet_Base&);
    CBookDocumentSet_Base& operator=(const CBookDocumentSet_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CBookDocument > > m_BookDocument;
    NCBI_NS_NCBI::CRef< TDeleteDocument > m_DeleteDocument;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBookDocumentSet_Base::IsSetBookDocument(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBookDocumentSet_Base::CanGetBookDocument(void) const
{
    return true;
}

inline
const CBookDocumentSet_Base::TBookDocument& CBookDocumentSet_Base::GetBookDocument(void) const
{
    return m_BookDocument;
}

inline
CBookDocumentSet_Base::TBookDocument& CBookDocumentSet_Base::SetBookDocument(void)
{
    m_set_State[0] |= 0x1;
    return m_BookDocument;
}

inline
bool CBookDocumentSet_Base::IsSetDeleteDocument(void) const
{
    return m_DeleteDocument.NotEmpty();
}

inline
bool CBookDocumentSet_Base::CanGetDeleteDocument(void) const
{
    return IsSetDeleteDocument();
}

inline
const CBookDocumentSet_Base::TDeleteDocument& CBookDocumentSet_Base::GetDeleteDocument(void) const
{
    if (!CanGetDeleteDocument()) {
        ThrowUnassigned(1);
    }
    return (*m_DeleteDocument);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_BOOKDOCUMENTSET_BASE_HPP
