/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file SequenceVariant_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'varrep.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_VARREP_SEQUENCEVARIANT_BASE_HPP
#define OBJECTS_VARREP_SEQUENCEVARIANT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <objects/varrep/VariantSeqType.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CVariant;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CSequenceVariant_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSequenceVariant_Base(void);
    // destructor
    virtual ~CSequenceVariant_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EComplex {
        eComplex_mosaic  = 1,
        eComplex_chimera = 2
    };
    
    /// Access to EComplex's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EComplex)(void);
    
    // types
    typedef int TSeqtype;
    typedef list< CRef< CVariant > > TSubvariants;
    typedef int TComplex;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_seqtype,
        e_subvariants,
        e_complex
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TSeqtype
    ///  Check whether the Seqtype data member has been assigned a value.
    bool IsSetSeqtype(void) const;
    /// Check whether it is safe or not to call GetSeqtype method.
    bool CanGetSeqtype(void) const;
    void ResetSeqtype(void);
    TSeqtype GetSeqtype(void) const;
    void SetSeqtype(TSeqtype value);
    TSeqtype& SetSeqtype(void);

    /// mandatory
    /// typedef list< CRef< CVariant > > TSubvariants
    ///  Check whether the Subvariants data member has been assigned a value.
    bool IsSetSubvariants(void) const;
    /// Check whether it is safe or not to call GetSubvariants method.
    bool CanGetSubvariants(void) const;
    void ResetSubvariants(void);
    const TSubvariants& GetSubvariants(void) const;
    TSubvariants& SetSubvariants(void);

    /// optional
    /// typedef int TComplex
    ///  Check whether the Complex data member has been assigned a value.
    bool IsSetComplex(void) const;
    /// Check whether it is safe or not to call GetComplex method.
    bool CanGetComplex(void) const;
    void ResetComplex(void);
    TComplex GetComplex(void) const;
    void SetComplex(TComplex value);
    TComplex& SetComplex(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSequenceVariant_Base(const CSequenceVariant_Base&);
    CSequenceVariant_Base& operator=(const CSequenceVariant_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Seqtype;
    list< CRef< CVariant > > m_Subvariants;
    int m_Complex;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSequenceVariant_Base::IsSetSeqtype(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSequenceVariant_Base::CanGetSeqtype(void) const
{
    return IsSetSeqtype();
}

inline
void CSequenceVariant_Base::ResetSeqtype(void)
{
    m_Seqtype = (int)(0);
    m_set_State[0] &= ~0x3;
}

inline
CSequenceVariant_Base::TSeqtype CSequenceVariant_Base::GetSeqtype(void) const
{
    if (!CanGetSeqtype()) {
        ThrowUnassigned(0);
    }
    return m_Seqtype;
}

inline
void CSequenceVariant_Base::SetSeqtype(CSequenceVariant_Base::TSeqtype value)
{
    m_Seqtype = value;
    m_set_State[0] |= 0x3;
}

inline
CSequenceVariant_Base::TSeqtype& CSequenceVariant_Base::SetSeqtype(void)
{
#ifdef _DEBUG
    if (!IsSetSeqtype()) {
        memset(&m_Seqtype,UnassignedByte(),sizeof(m_Seqtype));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Seqtype;
}

inline
bool CSequenceVariant_Base::IsSetSubvariants(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSequenceVariant_Base::CanGetSubvariants(void) const
{
    return true;
}

inline
const CSequenceVariant_Base::TSubvariants& CSequenceVariant_Base::GetSubvariants(void) const
{
    return m_Subvariants;
}

inline
CSequenceVariant_Base::TSubvariants& CSequenceVariant_Base::SetSubvariants(void)
{
    m_set_State[0] |= 0x4;
    return m_Subvariants;
}

inline
bool CSequenceVariant_Base::IsSetComplex(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CSequenceVariant_Base::CanGetComplex(void) const
{
    return IsSetComplex();
}

inline
void CSequenceVariant_Base::ResetComplex(void)
{
    m_Complex = (EComplex)(0);
    m_set_State[0] &= ~0x30;
}

inline
CSequenceVariant_Base::TComplex CSequenceVariant_Base::GetComplex(void) const
{
    if (!CanGetComplex()) {
        ThrowUnassigned(2);
    }
    return m_Complex;
}

inline
void CSequenceVariant_Base::SetComplex(CSequenceVariant_Base::TComplex value)
{
    m_Complex = value;
    m_set_State[0] |= 0x30;
}

inline
CSequenceVariant_Base::TComplex& CSequenceVariant_Base::SetComplex(void)
{
#ifdef _DEBUG
    if (!IsSetComplex()) {
        memset(&m_Complex,UnassignedByte(),sizeof(m_Complex));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Complex;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_VARREP_SEQUENCEVARIANT_BASE_HPP
