/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Insertion_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'varrep.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_VARREP_INSERTION_BASE_HPP
#define OBJECTS_VARREP_INSERTION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CCount;
class CSeqInterval;
class CSubsequence;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CInsertion_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CInsertion_Base(void);
    // destructor
    virtual ~CInsertion_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Seqinfo : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Seqinfo(void);
        // destructor
        ~C_Seqinfo(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Identifier,   ///< A sequence identifier (e.g. an accession id)
            e_Raw_seq,      ///< The actual nucleotide / amino-acid sequence
            e_Count,        ///< The number of elements inserted
            e_Subseq        ///< A subsequence specified by an id, type descriptor, and a range
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 5 ///< == e_Subseq+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef string TIdentifier;
        typedef string TRaw_seq;
        typedef CCount TCount;
        typedef CSubsequence TSubseq;
    
        // getters
        // setters
    
        // typedef string TIdentifier
        bool IsIdentifier(void) const;
        const TIdentifier& GetIdentifier(void) const;
        TIdentifier& SetIdentifier(void);
        void SetIdentifier(const TIdentifier& value);
    
        // typedef string TRaw_seq
        bool IsRaw_seq(void) const;
        const TRaw_seq& GetRaw_seq(void) const;
        TRaw_seq& SetRaw_seq(void);
        void SetRaw_seq(const TRaw_seq& value);
    
        // typedef CCount TCount
        bool IsCount(void) const;
        const TCount& GetCount(void) const;
        TCount& SetCount(void);
        void SetCount(TCount& value);
    
        // typedef CSubsequence TSubseq
        bool IsSubseq(void) const;
        const TSubseq& GetSubseq(void) const;
        TSubseq& SetSubseq(void);
        void SetSubseq(TSubseq& value);
    
    
    private:
        // copy constructor and assignment operator
        C_Seqinfo(const C_Seqinfo& );
        C_Seqinfo& operator=(const C_Seqinfo& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    // types
    typedef CSeqInterval TInt;
    typedef C_Seqinfo TSeqinfo;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_int,
        e_seqinfo
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CSeqInterval TInt
    ///  Check whether the Int data member has been assigned a value.
    bool IsSetInt(void) const;
    /// Check whether it is safe or not to call GetInt method.
    bool CanGetInt(void) const;
    void ResetInt(void);
    const TInt& GetInt(void) const;
    void SetInt(TInt& value);
    TInt& SetInt(void);

    /// mandatory
    /// typedef C_Seqinfo TSeqinfo
    ///  Check whether the Seqinfo data member has been assigned a value.
    bool IsSetSeqinfo(void) const;
    /// Check whether it is safe or not to call GetSeqinfo method.
    bool CanGetSeqinfo(void) const;
    void ResetSeqinfo(void);
    const TSeqinfo& GetSeqinfo(void) const;
    void SetSeqinfo(TSeqinfo& value);
    TSeqinfo& SetSeqinfo(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CInsertion_Base(const CInsertion_Base&);
    CInsertion_Base& operator=(const CInsertion_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TInt > m_Int;
    CRef< TSeqinfo > m_Seqinfo;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CInsertion_Base::C_Seqinfo::E_Choice CInsertion_Base::C_Seqinfo::Which(void) const
{
    return m_choice;
}

inline
void CInsertion_Base::C_Seqinfo::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CInsertion_Base::C_Seqinfo::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CInsertion_Base::C_Seqinfo::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CInsertion_Base::C_Seqinfo::IsIdentifier(void) const
{
    return m_choice == e_Identifier;
}

inline
const CInsertion_Base::C_Seqinfo::TIdentifier& CInsertion_Base::C_Seqinfo::GetIdentifier(void) const
{
    CheckSelected(e_Identifier);
    return *m_string;
}

inline
CInsertion_Base::C_Seqinfo::TIdentifier& CInsertion_Base::C_Seqinfo::SetIdentifier(void)
{
    Select(e_Identifier, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CInsertion_Base::C_Seqinfo::IsRaw_seq(void) const
{
    return m_choice == e_Raw_seq;
}

inline
const CInsertion_Base::C_Seqinfo::TRaw_seq& CInsertion_Base::C_Seqinfo::GetRaw_seq(void) const
{
    CheckSelected(e_Raw_seq);
    return *m_string;
}

inline
CInsertion_Base::C_Seqinfo::TRaw_seq& CInsertion_Base::C_Seqinfo::SetRaw_seq(void)
{
    Select(e_Raw_seq, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CInsertion_Base::C_Seqinfo::IsCount(void) const
{
    return m_choice == e_Count;
}

inline
bool CInsertion_Base::C_Seqinfo::IsSubseq(void) const
{
    return m_choice == e_Subseq;
}

inline
bool CInsertion_Base::IsSetInt(void) const
{
    return m_Int.NotEmpty();
}

inline
bool CInsertion_Base::CanGetInt(void) const
{
    return true;
}

inline
const CInsertion_Base::TInt& CInsertion_Base::GetInt(void) const
{
    if ( !m_Int ) {
        const_cast<CInsertion_Base*>(this)->ResetInt();
    }
    return (*m_Int);
}

inline
CInsertion_Base::TInt& CInsertion_Base::SetInt(void)
{
    if ( !m_Int ) {
        ResetInt();
    }
    return (*m_Int);
}

inline
bool CInsertion_Base::IsSetSeqinfo(void) const
{
    return m_Seqinfo.NotEmpty();
}

inline
bool CInsertion_Base::CanGetSeqinfo(void) const
{
    return true;
}

inline
const CInsertion_Base::TSeqinfo& CInsertion_Base::GetSeqinfo(void) const
{
    if ( !m_Seqinfo ) {
        const_cast<CInsertion_Base*>(this)->ResetSeqinfo();
    }
    return (*m_Seqinfo);
}

inline
CInsertion_Base::TSeqinfo& CInsertion_Base::SetSeqinfo(void)
{
    if ( !m_Seqinfo ) {
        ResetSeqinfo();
    }
    return (*m_Seqinfo);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_VARREP_INSERTION_BASE_HPP
