/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file AaSiteRange_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'varrep.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_VARREP_AASITERANGE_BASE_HPP
#define OBJECTS_VARREP_AASITERANGE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CAaSite;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CAaSiteRange_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CAaSiteRange_Base(void);
    // destructor
    virtual ~CAaSiteRange_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CAaSite TStart;
    typedef CAaSite TStop;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_start,
        e_stop
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CAaSite TStart
    ///  Check whether the Start data member has been assigned a value.
    bool IsSetStart(void) const;
    /// Check whether it is safe or not to call GetStart method.
    bool CanGetStart(void) const;
    void ResetStart(void);
    const TStart& GetStart(void) const;
    void SetStart(TStart& value);
    TStart& SetStart(void);

    /// mandatory
    /// typedef CAaSite TStop
    ///  Check whether the Stop data member has been assigned a value.
    bool IsSetStop(void) const;
    /// Check whether it is safe or not to call GetStop method.
    bool CanGetStop(void) const;
    void ResetStop(void);
    const TStop& GetStop(void) const;
    void SetStop(TStop& value);
    TStop& SetStop(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CAaSiteRange_Base(const CAaSiteRange_Base&);
    CAaSiteRange_Base& operator=(const CAaSiteRange_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TStart > m_Start;
    CRef< TStop > m_Stop;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CAaSiteRange_Base::IsSetStart(void) const
{
    return m_Start.NotEmpty();
}

inline
bool CAaSiteRange_Base::CanGetStart(void) const
{
    return true;
}

inline
const CAaSiteRange_Base::TStart& CAaSiteRange_Base::GetStart(void) const
{
    if ( !m_Start ) {
        const_cast<CAaSiteRange_Base*>(this)->ResetStart();
    }
    return (*m_Start);
}

inline
CAaSiteRange_Base::TStart& CAaSiteRange_Base::SetStart(void)
{
    if ( !m_Start ) {
        ResetStart();
    }
    return (*m_Start);
}

inline
bool CAaSiteRange_Base::IsSetStop(void) const
{
    return m_Stop.NotEmpty();
}

inline
bool CAaSiteRange_Base::CanGetStop(void) const
{
    return true;
}

inline
const CAaSiteRange_Base::TStop& CAaSiteRange_Base::GetStop(void) const
{
    if ( !m_Stop ) {
        const_cast<CAaSiteRange_Base*>(this)->ResetStop();
    }
    return (*m_Stop);
}

inline
CAaSiteRange_Base::TStop& CAaSiteRange_Base::SetStop(void)
{
    if ( !m_Stop ) {
        ResetStop();
    }
    return (*m_Stop);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_VARREP_AASITERANGE_BASE_HPP
