/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file DbsnpTooltipServiceError_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'dbsnp_tooltip_service.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_VARIATION_LIBS_DBSNP_TOOLTIP_SERVICE_DBSNPTOOLTIPSERVICEERROR_BASE_HPP
#define OBJECTS_VARIATION_LIBS_DBSNP_TOOLTIP_SERVICE_DBSNPTOOLTIPSERVICEERROR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// In case of an error, the service will return this object.
class CDbsnpTooltipServiceError_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CDbsnpTooltipServiceError_Base(void);
    // destructor
    virtual ~CDbsnpTooltipServiceError_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TMessage;
    typedef int THttp_status_code;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_message,
        e_http_status_code
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// Error description.
    /// mandatory
    /// typedef string TMessage
    ///  Check whether the Message data member has been assigned a value.
    bool IsSetMessage(void) const;
    /// Check whether it is safe or not to call GetMessage method.
    bool CanGetMessage(void) const;
    void ResetMessage(void);
    const TMessage& GetMessage(void) const;
    void SetMessage(const TMessage& value);
    void SetMessage(TMessage&& value);
    TMessage& SetMessage(void);

    /// For client convenience, HTTP status code is duplicated here.
    /// mandatory
    /// typedef int THttp_status_code
    ///  Check whether the Http_status_code data member has been assigned a value.
    bool IsSetHttp_status_code(void) const;
    /// Check whether it is safe or not to call GetHttp_status_code method.
    bool CanGetHttp_status_code(void) const;
    void ResetHttp_status_code(void);
    THttp_status_code GetHttp_status_code(void) const;
    void SetHttp_status_code(THttp_status_code value);
    THttp_status_code& SetHttp_status_code(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CDbsnpTooltipServiceError_Base(const CDbsnpTooltipServiceError_Base&);
    CDbsnpTooltipServiceError_Base& operator=(const CDbsnpTooltipServiceError_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Message;
    int m_Http_status_code;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CDbsnpTooltipServiceError_Base::IsSetMessage(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CDbsnpTooltipServiceError_Base::CanGetMessage(void) const
{
    return IsSetMessage();
}

inline
const CDbsnpTooltipServiceError_Base::TMessage& CDbsnpTooltipServiceError_Base::GetMessage(void) const
{
    if (!CanGetMessage()) {
        ThrowUnassigned(0);
    }
    return m_Message;
}

inline
void CDbsnpTooltipServiceError_Base::SetMessage(const CDbsnpTooltipServiceError_Base::TMessage& value)
{
    m_Message = value;
    m_set_State[0] |= 0x3;
}

inline
void CDbsnpTooltipServiceError_Base::SetMessage(CDbsnpTooltipServiceError_Base::TMessage&& value)
{
    m_Message = std::forward<CDbsnpTooltipServiceError_Base::TMessage>(value);
    m_set_State[0] |= 0x3;
}

inline
CDbsnpTooltipServiceError_Base::TMessage& CDbsnpTooltipServiceError_Base::SetMessage(void)
{
#ifdef _DEBUG
    if (!IsSetMessage()) {
        m_Message = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Message;
}

inline
bool CDbsnpTooltipServiceError_Base::IsSetHttp_status_code(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CDbsnpTooltipServiceError_Base::CanGetHttp_status_code(void) const
{
    return IsSetHttp_status_code();
}

inline
void CDbsnpTooltipServiceError_Base::ResetHttp_status_code(void)
{
    m_Http_status_code = 0;
    m_set_State[0] &= ~0xc;
}

inline
CDbsnpTooltipServiceError_Base::THttp_status_code CDbsnpTooltipServiceError_Base::GetHttp_status_code(void) const
{
    if (!CanGetHttp_status_code()) {
        ThrowUnassigned(1);
    }
    return m_Http_status_code;
}

inline
void CDbsnpTooltipServiceError_Base::SetHttp_status_code(CDbsnpTooltipServiceError_Base::THttp_status_code value)
{
    m_Http_status_code = value;
    m_set_State[0] |= 0xc;
}

inline
CDbsnpTooltipServiceError_Base::THttp_status_code& CDbsnpTooltipServiceError_Base::SetHttp_status_code(void)
{
#ifdef _DEBUG
    if (!IsSetHttp_status_code()) {
        memset(&m_Http_status_code,UnassignedByte(),sizeof(m_Http_status_code));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Http_status_code;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_VARIATION_LIBS_DBSNP_TOOLTIP_SERVICE_DBSNPTOOLTIPSERVICEERROR_BASE_HPP
