/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ValidError_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'valerr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_VALERR_VALIDERROR_BASE_HPP
#define OBJECTS_VALERR_VALIDERROR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <vector>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CValidErrItem;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_VALERR_EXPORT CValidError_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CValidError_Base(void);
    // destructor
    virtual ~CValidError_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CValidErrItem C_E;
    typedef vector< CRef< CValidErrItem > > TErrs;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_errs
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef vector< CRef< CValidErrItem > > TErrs
    ///  Check whether the Errs data member has been assigned a value.
    bool IsSetErrs(void) const;
    /// Check whether it is safe or not to call GetErrs method.
    bool CanGetErrs(void) const;
    void ResetErrs(void);
    const TErrs& GetErrs(void) const;
    TErrs& SetErrs(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CValidError_Base(const CValidError_Base&);
    CValidError_Base& operator=(const CValidError_Base&);

    // data
    Uint4 m_set_State[1];
    vector< CRef< CValidErrItem > > m_Errs;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CValidError_Base::IsSetErrs(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CValidError_Base::CanGetErrs(void) const
{
    return true;
}

inline
const CValidError_Base::TErrs& CValidError_Base::GetErrs(void) const
{
    return m_Errs;
}

inline
CValidError_Base::TErrs& CValidError_Base::SetErrs(void)
{
    m_set_State[0] |= 0x1;
    return m_Errs;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_VALERR_VALIDERROR_BASE_HPP
