/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_TrackSet_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_TRACKSET_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_TRACKSET_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objects/trackmgr/TMgr_TrackSetType.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CTMgr_DisplayTrack;
class CTMgr_GenomeContext;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTMgr_TrackSet_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_TrackSet_Base(void);
    // destructor
    virtual ~CTMgr_TrackSet_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TType;
    typedef string TId;
    typedef CTMgr_GenomeContext TGenome_context;
    typedef CStringUTF8 TName;
    typedef CStringUTF8 TDescription;
    typedef list< CRef< CTMgr_DisplayTrack > > TTracks;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type,
        e_id,
        e_genome_context,
        e_name,
        e_description,
        e_tracks
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// internal identifier
    /// mandatory
    /// typedef string TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(const TId& value);
    void SetId(TId&& value);
    TId& SetId(void);

    /// mandatory
    /// typedef CTMgr_GenomeContext TGenome_context
    ///  Check whether the Genome_context data member has been assigned a value.
    bool IsSetGenome_context(void) const;
    /// Check whether it is safe or not to call GetGenome_context method.
    bool CanGetGenome_context(void) const;
    void ResetGenome_context(void);
    const TGenome_context& GetGenome_context(void) const;
    void SetGenome_context(TGenome_context& value);
    TGenome_context& SetGenome_context(void);

    /// mandatory
    /// typedef CStringUTF8 TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// optional
    /// typedef CStringUTF8 TDescription
    ///  Check whether the Description data member has been assigned a value.
    bool IsSetDescription(void) const;
    /// Check whether it is safe or not to call GetDescription method.
    bool CanGetDescription(void) const;
    void ResetDescription(void);
    const TDescription& GetDescription(void) const;
    void SetDescription(const TDescription& value);
    void SetDescription(TDescription&& value);
    TDescription& SetDescription(void);

    /// mandatory
    /// typedef list< CRef< CTMgr_DisplayTrack > > TTracks
    ///  Check whether the Tracks data member has been assigned a value.
    bool IsSetTracks(void) const;
    /// Check whether it is safe or not to call GetTracks method.
    bool CanGetTracks(void) const;
    void ResetTracks(void);
    const TTracks& GetTracks(void) const;
    TTracks& SetTracks(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTMgr_TrackSet_Base(const CTMgr_TrackSet_Base&);
    CTMgr_TrackSet_Base& operator=(const CTMgr_TrackSet_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Type;
    string m_Id;
    CRef< TGenome_context > m_Genome_context;
    CStringUTF8 m_Name;
    CStringUTF8 m_Description;
    list< CRef< CTMgr_DisplayTrack > > m_Tracks;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTMgr_TrackSet_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTMgr_TrackSet_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CTMgr_TrackSet_Base::ResetType(void)
{
    m_Type = (int)(0);
    m_set_State[0] &= ~0x3;
}

inline
CTMgr_TrackSet_Base::TType CTMgr_TrackSet_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CTMgr_TrackSet_Base::SetType(CTMgr_TrackSet_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CTMgr_TrackSet_Base::TType& CTMgr_TrackSet_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CTMgr_TrackSet_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTMgr_TrackSet_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
const CTMgr_TrackSet_Base::TId& CTMgr_TrackSet_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(1);
    }
    return m_Id;
}

inline
void CTMgr_TrackSet_Base::SetId(const CTMgr_TrackSet_Base::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0xc;
}

inline
void CTMgr_TrackSet_Base::SetId(CTMgr_TrackSet_Base::TId&& value)
{
    m_Id = std::forward<CTMgr_TrackSet_Base::TId>(value);
    m_set_State[0] |= 0xc;
}

inline
CTMgr_TrackSet_Base::TId& CTMgr_TrackSet_Base::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Id;
}

inline
bool CTMgr_TrackSet_Base::IsSetGenome_context(void) const
{
    return m_Genome_context.NotEmpty();
}

inline
bool CTMgr_TrackSet_Base::CanGetGenome_context(void) const
{
    return true;
}

inline
const CTMgr_TrackSet_Base::TGenome_context& CTMgr_TrackSet_Base::GetGenome_context(void) const
{
    if ( !m_Genome_context ) {
        const_cast<CTMgr_TrackSet_Base*>(this)->ResetGenome_context();
    }
    return (*m_Genome_context);
}

inline
CTMgr_TrackSet_Base::TGenome_context& CTMgr_TrackSet_Base::SetGenome_context(void)
{
    if ( !m_Genome_context ) {
        ResetGenome_context();
    }
    return (*m_Genome_context);
}

inline
bool CTMgr_TrackSet_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CTMgr_TrackSet_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CTMgr_TrackSet_Base::TName& CTMgr_TrackSet_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(3);
    }
    return m_Name;
}

inline
void CTMgr_TrackSet_Base::SetName(const CTMgr_TrackSet_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0xc0;
}

inline
void CTMgr_TrackSet_Base::SetName(CTMgr_TrackSet_Base::TName&& value)
{
    m_Name = std::forward<CTMgr_TrackSet_Base::TName>(value);
    m_set_State[0] |= 0xc0;
}

inline
CTMgr_TrackSet_Base::TName& CTMgr_TrackSet_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedStringUTF8();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Name;
}

inline
bool CTMgr_TrackSet_Base::IsSetDescription(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CTMgr_TrackSet_Base::CanGetDescription(void) const
{
    return IsSetDescription();
}

inline
const CTMgr_TrackSet_Base::TDescription& CTMgr_TrackSet_Base::GetDescription(void) const
{
    if (!CanGetDescription()) {
        ThrowUnassigned(4);
    }
    return m_Description;
}

inline
void CTMgr_TrackSet_Base::SetDescription(const CTMgr_TrackSet_Base::TDescription& value)
{
    m_Description = value;
    m_set_State[0] |= 0x300;
}

inline
void CTMgr_TrackSet_Base::SetDescription(CTMgr_TrackSet_Base::TDescription&& value)
{
    m_Description = std::forward<CTMgr_TrackSet_Base::TDescription>(value);
    m_set_State[0] |= 0x300;
}

inline
CTMgr_TrackSet_Base::TDescription& CTMgr_TrackSet_Base::SetDescription(void)
{
#ifdef _DEBUG
    if (!IsSetDescription()) {
        m_Description = UnassignedStringUTF8();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Description;
}

inline
bool CTMgr_TrackSet_Base::IsSetTracks(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CTMgr_TrackSet_Base::CanGetTracks(void) const
{
    return true;
}

inline
const CTMgr_TrackSet_Base::TTracks& CTMgr_TrackSet_Base::GetTracks(void) const
{
    return m_Tracks;
}

inline
CTMgr_TrackSet_Base::TTracks& CTMgr_TrackSet_Base::SetTracks(void)
{
    m_set_State[0] |= 0x400;
    return m_Tracks;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_TRACKSET_BASE_HPP
