/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_TrackItems_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_TRACKITEMS_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_TRACKITEMS_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CTMgr_DTrackId;
class CTMgr_DatasetItem;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTMgr_TrackItems_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_TrackItems_Base(void);
    // destructor
    virtual ~CTMgr_TrackItems_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CTMgr_DTrackId TDtrack_id;
    typedef list< CRef< CTMgr_DatasetItem > > TData;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_dtrack_id,
        e_data
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CTMgr_DTrackId TDtrack_id
    ///  Check whether the Dtrack_id data member has been assigned a value.
    bool IsSetDtrack_id(void) const;
    /// Check whether it is safe or not to call GetDtrack_id method.
    bool CanGetDtrack_id(void) const;
    void ResetDtrack_id(void);
    const TDtrack_id& GetDtrack_id(void) const;
    void SetDtrack_id(TDtrack_id& value);
    TDtrack_id& SetDtrack_id(void);

    /// mandatory
    /// typedef list< CRef< CTMgr_DatasetItem > > TData
    ///  Check whether the Data data member has been assigned a value.
    bool IsSetData(void) const;
    /// Check whether it is safe or not to call GetData method.
    bool CanGetData(void) const;
    void ResetData(void);
    const TData& GetData(void) const;
    TData& SetData(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTMgr_TrackItems_Base(const CTMgr_TrackItems_Base&);
    CTMgr_TrackItems_Base& operator=(const CTMgr_TrackItems_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TDtrack_id > m_Dtrack_id;
    list< CRef< CTMgr_DatasetItem > > m_Data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTMgr_TrackItems_Base::IsSetDtrack_id(void) const
{
    return m_Dtrack_id.NotEmpty();
}

inline
bool CTMgr_TrackItems_Base::CanGetDtrack_id(void) const
{
    return true;
}

inline
const CTMgr_TrackItems_Base::TDtrack_id& CTMgr_TrackItems_Base::GetDtrack_id(void) const
{
    if ( !m_Dtrack_id ) {
        const_cast<CTMgr_TrackItems_Base*>(this)->ResetDtrack_id();
    }
    return (*m_Dtrack_id);
}

inline
CTMgr_TrackItems_Base::TDtrack_id& CTMgr_TrackItems_Base::SetDtrack_id(void)
{
    if ( !m_Dtrack_id ) {
        ResetDtrack_id();
    }
    return (*m_Dtrack_id);
}

inline
bool CTMgr_TrackItems_Base::IsSetData(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTMgr_TrackItems_Base::CanGetData(void) const
{
    return true;
}

inline
const CTMgr_TrackItems_Base::TData& CTMgr_TrackItems_Base::GetData(void) const
{
    return m_Data;
}

inline
CTMgr_TrackItems_Base::TData& CTMgr_TrackItems_Base::SetData(void)
{
    m_set_State[0] |= 0x4;
    return m_Data;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_TRACKITEMS_BASE_HPP
