/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_SwitchTrackException_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_SWITCHTRACKEXCEPTION_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_SWITCHTRACKEXCEPTION_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/trackmgr/TMgr_SwitchTrackExceptionC.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CTMgr_DTrackId;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTMgr_SwitchTrackException_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_SwitchTrackException_Base(void);
    // destructor
    virtual ~CTMgr_SwitchTrackException_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CTMgr_DTrackId TDtrack_id;
    typedef int TCode;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_dtrack_id,
        e_code
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CTMgr_DTrackId TDtrack_id
    ///  Check whether the Dtrack_id data member has been assigned a value.
    bool IsSetDtrack_id(void) const;
    /// Check whether it is safe or not to call GetDtrack_id method.
    bool CanGetDtrack_id(void) const;
    void ResetDtrack_id(void);
    const TDtrack_id& GetDtrack_id(void) const;
    void SetDtrack_id(TDtrack_id& value);
    TDtrack_id& SetDtrack_id(void);

    /// optional
    /// typedef int TCode
    ///  Check whether the Code data member has been assigned a value.
    bool IsSetCode(void) const;
    /// Check whether it is safe or not to call GetCode method.
    bool CanGetCode(void) const;
    void ResetCode(void);
    TCode GetCode(void) const;
    void SetCode(TCode value);
    TCode& SetCode(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTMgr_SwitchTrackException_Base(const CTMgr_SwitchTrackException_Base&);
    CTMgr_SwitchTrackException_Base& operator=(const CTMgr_SwitchTrackException_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TDtrack_id > m_Dtrack_id;
    int m_Code;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTMgr_SwitchTrackException_Base::IsSetDtrack_id(void) const
{
    return m_Dtrack_id.NotEmpty();
}

inline
bool CTMgr_SwitchTrackException_Base::CanGetDtrack_id(void) const
{
    return true;
}

inline
const CTMgr_SwitchTrackException_Base::TDtrack_id& CTMgr_SwitchTrackException_Base::GetDtrack_id(void) const
{
    if ( !m_Dtrack_id ) {
        const_cast<CTMgr_SwitchTrackException_Base*>(this)->ResetDtrack_id();
    }
    return (*m_Dtrack_id);
}

inline
CTMgr_SwitchTrackException_Base::TDtrack_id& CTMgr_SwitchTrackException_Base::SetDtrack_id(void)
{
    if ( !m_Dtrack_id ) {
        ResetDtrack_id();
    }
    return (*m_Dtrack_id);
}

inline
bool CTMgr_SwitchTrackException_Base::IsSetCode(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTMgr_SwitchTrackException_Base::CanGetCode(void) const
{
    return IsSetCode();
}

inline
void CTMgr_SwitchTrackException_Base::ResetCode(void)
{
    m_Code = (int)(0);
    m_set_State[0] &= ~0xc;
}

inline
CTMgr_SwitchTrackException_Base::TCode CTMgr_SwitchTrackException_Base::GetCode(void) const
{
    if (!CanGetCode()) {
        ThrowUnassigned(1);
    }
    return m_Code;
}

inline
void CTMgr_SwitchTrackException_Base::SetCode(CTMgr_SwitchTrackException_Base::TCode value)
{
    m_Code = value;
    m_set_State[0] |= 0xc;
}

inline
CTMgr_SwitchTrackException_Base::TCode& CTMgr_SwitchTrackException_Base::SetCode(void)
{
#ifdef _DEBUG
    if (!IsSetCode()) {
        memset(&m_Code,UnassignedByte(),sizeof(m_Code));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Code;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_SWITCHTRACKEXCEPTION_BASE_HPP
