/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_SupportedAssembliesRe_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_SUPPORTEDASSEMBLIESRE_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_SUPPORTEDASSEMBLIESRE_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CTMgr_Message;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTMgr_SupportedAssembliesReply_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_SupportedAssembliesReply_Base(void);
    // destructor
    virtual ~CTMgr_SupportedAssembliesReply_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_TRACKMGR_EXPORT C_Reply : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Reply(void);
        // destructor
        ~C_Reply(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,   ///< No variant selected
            e_Assembly_acc   ///<tax-id SET OF VisibleString
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 2 ///< == e_Assembly_acc+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef bool TAssembly_acc;
    
        // getters
        // setters
    
        // typedef bool TAssembly_acc
        bool IsAssembly_acc(void) const;
        TAssembly_acc GetAssembly_acc(void) const;
        TAssembly_acc& SetAssembly_acc(void);
        void SetAssembly_acc(TAssembly_acc value);
    
    
    private:
        // copy constructor and assignment operator
        C_Reply(const C_Reply& );
        C_Reply& operator=(const C_Reply& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            TAssembly_acc m_Assembly_acc;
        };
    };
    // types
    typedef list< CRef< CTMgr_Message > > TMessages;
    typedef C_Reply TReply;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_messages,
        e_reply
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef list< CRef< CTMgr_Message > > TMessages
    ///  Check whether the Messages data member has been assigned a value.
    bool IsSetMessages(void) const;
    /// Check whether it is safe or not to call GetMessages method.
    bool CanGetMessages(void) const;
    void ResetMessages(void);
    const TMessages& GetMessages(void) const;
    TMessages& SetMessages(void);

    /// optional
    /// typedef C_Reply TReply
    ///  Check whether the Reply data member has been assigned a value.
    bool IsSetReply(void) const;
    /// Check whether it is safe or not to call GetReply method.
    bool CanGetReply(void) const;
    void ResetReply(void);
    const TReply& GetReply(void) const;
    void SetReply(TReply& value);
    TReply& SetReply(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTMgr_SupportedAssembliesReply_Base(const CTMgr_SupportedAssembliesReply_Base&);
    CTMgr_SupportedAssembliesReply_Base& operator=(const CTMgr_SupportedAssembliesReply_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< CTMgr_Message > > m_Messages;
    CRef< TReply > m_Reply;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CTMgr_SupportedAssembliesReply_Base::C_Reply::E_Choice CTMgr_SupportedAssembliesReply_Base::C_Reply::Which(void) const
{
    return m_choice;
}

inline
void CTMgr_SupportedAssembliesReply_Base::C_Reply::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CTMgr_SupportedAssembliesReply_Base::C_Reply::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CTMgr_SupportedAssembliesReply_Base::C_Reply::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CTMgr_SupportedAssembliesReply_Base::C_Reply::IsAssembly_acc(void) const
{
    return m_choice == e_Assembly_acc;
}

inline
CTMgr_SupportedAssembliesReply_Base::C_Reply::TAssembly_acc CTMgr_SupportedAssembliesReply_Base::C_Reply::GetAssembly_acc(void) const
{
    CheckSelected(e_Assembly_acc);
    return m_Assembly_acc;
}

inline
CTMgr_SupportedAssembliesReply_Base::C_Reply::TAssembly_acc& CTMgr_SupportedAssembliesReply_Base::C_Reply::SetAssembly_acc(void)
{
    Select(e_Assembly_acc, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Assembly_acc;
}

inline
void CTMgr_SupportedAssembliesReply_Base::C_Reply::SetAssembly_acc(CTMgr_SupportedAssembliesReply_Base::C_Reply::TAssembly_acc value)
{
    Select(e_Assembly_acc, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Assembly_acc = value;
}

inline
bool CTMgr_SupportedAssembliesReply_Base::IsSetMessages(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTMgr_SupportedAssembliesReply_Base::CanGetMessages(void) const
{
    return true;
}

inline
const CTMgr_SupportedAssembliesReply_Base::TMessages& CTMgr_SupportedAssembliesReply_Base::GetMessages(void) const
{
    return m_Messages;
}

inline
CTMgr_SupportedAssembliesReply_Base::TMessages& CTMgr_SupportedAssembliesReply_Base::SetMessages(void)
{
    m_set_State[0] |= 0x1;
    return m_Messages;
}

inline
bool CTMgr_SupportedAssembliesReply_Base::IsSetReply(void) const
{
    return m_Reply.NotEmpty();
}

inline
bool CTMgr_SupportedAssembliesReply_Base::CanGetReply(void) const
{
    return IsSetReply();
}

inline
const CTMgr_SupportedAssembliesReply_Base::TReply& CTMgr_SupportedAssembliesReply_Base::GetReply(void) const
{
    if (!CanGetReply()) {
        ThrowUnassigned(1);
    }
    return (*m_Reply);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_SUPPORTEDASSEMBLIESRE_BASE_HPP
