/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_Reply_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_REPLY_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_REPLY_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CTMgr_BlastRIDReply;
class CTMgr_CreateRemoteTrackReply;
class CTMgr_CreateTracksetReply;
class CTMgr_CreateUserTrackReply;
class CTMgr_DisplayTrackReply;
class CTMgr_ItemResolverReply;
class CTMgr_RemoveUserTrackReply;
class CTMgr_RenameMyNCBICollectionReply;
class CTMgr_RetrieveTracksetReply;
class CTMgr_SupportedAssembliesReply;
class CTMgr_SwitchTrackContextReply;
class CTMgr_TrackAttrValueReply;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTMgr_Reply_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_Reply_Base(void);
    // destructor
    virtual ~CTMgr_Reply_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,            ///< No variant selected
        e_Display_tracks,
        e_Switch_display_tracks,
        e_Track_attr_values,
        e_Blast_tracks,
        e_Create_user_tracks,
        e_Create_remote_tracks,
        e_Resolve_track_items,
        e_Remove_user_tracks,
        e_Retrieve_tracksets,
        e_Create_trackset,
        e_Rename_trackset,
        e_Supported_assemblies
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 13 ///< == e_Supported_assemblies+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CTMgr_DisplayTrackReply TDisplay_tracks;
    typedef CTMgr_SwitchTrackContextReply TSwitch_display_tracks;
    typedef CTMgr_TrackAttrValueReply TTrack_attr_values;
    typedef CTMgr_BlastRIDReply TBlast_tracks;
    typedef CTMgr_CreateUserTrackReply TCreate_user_tracks;
    typedef CTMgr_CreateRemoteTrackReply TCreate_remote_tracks;
    typedef CTMgr_ItemResolverReply TResolve_track_items;
    typedef CTMgr_RemoveUserTrackReply TRemove_user_tracks;
    typedef CTMgr_RetrieveTracksetReply TRetrieve_tracksets;
    typedef CTMgr_CreateTracksetReply TCreate_trackset;
    typedef CTMgr_RenameMyNCBICollectionReply TRename_trackset;
    typedef CTMgr_SupportedAssembliesReply TSupported_assemblies;

    // getters
    // setters

    // typedef CTMgr_DisplayTrackReply TDisplay_tracks
    bool IsDisplay_tracks(void) const;
    const TDisplay_tracks& GetDisplay_tracks(void) const;
    TDisplay_tracks& SetDisplay_tracks(void);
    void SetDisplay_tracks(TDisplay_tracks& value);

    // typedef CTMgr_SwitchTrackContextReply TSwitch_display_tracks
    bool IsSwitch_display_tracks(void) const;
    const TSwitch_display_tracks& GetSwitch_display_tracks(void) const;
    TSwitch_display_tracks& SetSwitch_display_tracks(void);
    void SetSwitch_display_tracks(TSwitch_display_tracks& value);

    // typedef CTMgr_TrackAttrValueReply TTrack_attr_values
    bool IsTrack_attr_values(void) const;
    const TTrack_attr_values& GetTrack_attr_values(void) const;
    TTrack_attr_values& SetTrack_attr_values(void);
    void SetTrack_attr_values(TTrack_attr_values& value);

    // typedef CTMgr_BlastRIDReply TBlast_tracks
    bool IsBlast_tracks(void) const;
    const TBlast_tracks& GetBlast_tracks(void) const;
    TBlast_tracks& SetBlast_tracks(void);
    void SetBlast_tracks(TBlast_tracks& value);

    // typedef CTMgr_CreateUserTrackReply TCreate_user_tracks
    bool IsCreate_user_tracks(void) const;
    const TCreate_user_tracks& GetCreate_user_tracks(void) const;
    TCreate_user_tracks& SetCreate_user_tracks(void);
    void SetCreate_user_tracks(TCreate_user_tracks& value);

    // typedef CTMgr_CreateRemoteTrackReply TCreate_remote_tracks
    bool IsCreate_remote_tracks(void) const;
    const TCreate_remote_tracks& GetCreate_remote_tracks(void) const;
    TCreate_remote_tracks& SetCreate_remote_tracks(void);
    void SetCreate_remote_tracks(TCreate_remote_tracks& value);

    // typedef CTMgr_ItemResolverReply TResolve_track_items
    bool IsResolve_track_items(void) const;
    const TResolve_track_items& GetResolve_track_items(void) const;
    TResolve_track_items& SetResolve_track_items(void);
    void SetResolve_track_items(TResolve_track_items& value);

    // typedef CTMgr_RemoveUserTrackReply TRemove_user_tracks
    bool IsRemove_user_tracks(void) const;
    const TRemove_user_tracks& GetRemove_user_tracks(void) const;
    TRemove_user_tracks& SetRemove_user_tracks(void);
    void SetRemove_user_tracks(TRemove_user_tracks& value);

    // typedef CTMgr_RetrieveTracksetReply TRetrieve_tracksets
    bool IsRetrieve_tracksets(void) const;
    const TRetrieve_tracksets& GetRetrieve_tracksets(void) const;
    TRetrieve_tracksets& SetRetrieve_tracksets(void);
    void SetRetrieve_tracksets(TRetrieve_tracksets& value);

    // typedef CTMgr_CreateTracksetReply TCreate_trackset
    bool IsCreate_trackset(void) const;
    const TCreate_trackset& GetCreate_trackset(void) const;
    TCreate_trackset& SetCreate_trackset(void);
    void SetCreate_trackset(TCreate_trackset& value);

    // typedef CTMgr_RenameMyNCBICollectionReply TRename_trackset
    bool IsRename_trackset(void) const;
    const TRename_trackset& GetRename_trackset(void) const;
    TRename_trackset& SetRename_trackset(void);
    void SetRename_trackset(TRename_trackset& value);

    // typedef CTMgr_SupportedAssembliesReply TSupported_assemblies
    bool IsSupported_assemblies(void) const;
    const TSupported_assemblies& GetSupported_assemblies(void) const;
    TSupported_assemblies& SetSupported_assemblies(void);
    void SetSupported_assemblies(TSupported_assemblies& value);


private:
    // copy constructor and assignment operator
    CTMgr_Reply_Base(const CTMgr_Reply_Base& );
    CTMgr_Reply_Base& operator=(const CTMgr_Reply_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    NCBI_NS_NCBI::CSerialObject *m_object;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CTMgr_Reply_Base::E_Choice CTMgr_Reply_Base::Which(void) const
{
    return m_choice;
}

inline
void CTMgr_Reply_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CTMgr_Reply_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CTMgr_Reply_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CTMgr_Reply_Base::IsDisplay_tracks(void) const
{
    return m_choice == e_Display_tracks;
}

inline
bool CTMgr_Reply_Base::IsSwitch_display_tracks(void) const
{
    return m_choice == e_Switch_display_tracks;
}

inline
bool CTMgr_Reply_Base::IsTrack_attr_values(void) const
{
    return m_choice == e_Track_attr_values;
}

inline
bool CTMgr_Reply_Base::IsBlast_tracks(void) const
{
    return m_choice == e_Blast_tracks;
}

inline
bool CTMgr_Reply_Base::IsCreate_user_tracks(void) const
{
    return m_choice == e_Create_user_tracks;
}

inline
bool CTMgr_Reply_Base::IsCreate_remote_tracks(void) const
{
    return m_choice == e_Create_remote_tracks;
}

inline
bool CTMgr_Reply_Base::IsResolve_track_items(void) const
{
    return m_choice == e_Resolve_track_items;
}

inline
bool CTMgr_Reply_Base::IsRemove_user_tracks(void) const
{
    return m_choice == e_Remove_user_tracks;
}

inline
bool CTMgr_Reply_Base::IsRetrieve_tracksets(void) const
{
    return m_choice == e_Retrieve_tracksets;
}

inline
bool CTMgr_Reply_Base::IsCreate_trackset(void) const
{
    return m_choice == e_Create_trackset;
}

inline
bool CTMgr_Reply_Base::IsRename_trackset(void) const
{
    return m_choice == e_Rename_trackset;
}

inline
bool CTMgr_Reply_Base::IsSupported_assemblies(void) const
{
    return m_choice == e_Supported_assemblies;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_REPLY_BASE_HPP
