/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_CreateUserTrackReques_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_CREATEUSERTRACKREQUES_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_CREATEUSERTRACKREQUES_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CTMgr_Attribute;
class CTMgr_CreateUserDataItem;
class CTMgr_Identity;
class CTMgr_TrackACL_Permission;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTMgr_CreateUserTrackRequest_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_CreateUserTrackRequest_Base(void);
    // destructor
    virtual ~CTMgr_CreateUserTrackRequest_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CTMgr_Identity TIdentity;
    typedef string TTrack_name;
    typedef string TTrack_descr;
    typedef string TAssembly_acc;
    typedef list< CRef< CTMgr_Attribute > > TAttrs;
    typedef list< CRef< CTMgr_CreateUserDataItem > > TData_items;
    typedef CTMgr_TrackACL_Permission TAccess_perms;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_identity,
        e_track_name,
        e_track_descr,
        e_assembly_acc,
        e_attrs,
        e_data_items,
        e_access_perms
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CTMgr_Identity TIdentity
    ///  Check whether the Identity data member has been assigned a value.
    bool IsSetIdentity(void) const;
    /// Check whether it is safe or not to call GetIdentity method.
    bool CanGetIdentity(void) const;
    void ResetIdentity(void);
    const TIdentity& GetIdentity(void) const;
    void SetIdentity(TIdentity& value);
    TIdentity& SetIdentity(void);

    /// User-provided track name
    /// optional
    /// typedef string TTrack_name
    ///  Check whether the Track_name data member has been assigned a value.
    bool IsSetTrack_name(void) const;
    /// Check whether it is safe or not to call GetTrack_name method.
    bool CanGetTrack_name(void) const;
    void ResetTrack_name(void);
    const TTrack_name& GetTrack_name(void) const;
    void SetTrack_name(const TTrack_name& value);
    void SetTrack_name(TTrack_name&& value);
    TTrack_name& SetTrack_name(void);

    /// User-provided data description
    /// optional
    /// typedef string TTrack_descr
    ///  Check whether the Track_descr data member has been assigned a value.
    bool IsSetTrack_descr(void) const;
    /// Check whether it is safe or not to call GetTrack_descr method.
    bool CanGetTrack_descr(void) const;
    void ResetTrack_descr(void);
    const TTrack_descr& GetTrack_descr(void) const;
    void SetTrack_descr(const TTrack_descr& value);
    void SetTrack_descr(TTrack_descr&& value);
    TTrack_descr& SetTrack_descr(void);

    /// optional
    /// typedef string TAssembly_acc
    ///  Check whether the Assembly_acc data member has been assigned a value.
    bool IsSetAssembly_acc(void) const;
    /// Check whether it is safe or not to call GetAssembly_acc method.
    bool CanGetAssembly_acc(void) const;
    void ResetAssembly_acc(void);
    const TAssembly_acc& GetAssembly_acc(void) const;
    void SetAssembly_acc(const TAssembly_acc& value);
    void SetAssembly_acc(TAssembly_acc&& value);
    TAssembly_acc& SetAssembly_acc(void);

    /// optional
    /// typedef list< CRef< CTMgr_Attribute > > TAttrs
    ///  Check whether the Attrs data member has been assigned a value.
    bool IsSetAttrs(void) const;
    /// Check whether it is safe or not to call GetAttrs method.
    bool CanGetAttrs(void) const;
    void ResetAttrs(void);
    const TAttrs& GetAttrs(void) const;
    TAttrs& SetAttrs(void);

    /// mandatory
    /// typedef list< CRef< CTMgr_CreateUserDataItem > > TData_items
    ///  Check whether the Data_items data member has been assigned a value.
    bool IsSetData_items(void) const;
    /// Check whether it is safe or not to call GetData_items method.
    bool CanGetData_items(void) const;
    void ResetData_items(void);
    const TData_items& GetData_items(void) const;
    TData_items& SetData_items(void);

    /// mandatory
    /// typedef CTMgr_TrackACL_Permission TAccess_perms
    ///  Check whether the Access_perms data member has been assigned a value.
    bool IsSetAccess_perms(void) const;
    /// Check whether it is safe or not to call GetAccess_perms method.
    bool CanGetAccess_perms(void) const;
    void ResetAccess_perms(void);
    const TAccess_perms& GetAccess_perms(void) const;
    void SetAccess_perms(TAccess_perms& value);
    TAccess_perms& SetAccess_perms(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTMgr_CreateUserTrackRequest_Base(const CTMgr_CreateUserTrackRequest_Base&);
    CTMgr_CreateUserTrackRequest_Base& operator=(const CTMgr_CreateUserTrackRequest_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TIdentity > m_Identity;
    string m_Track_name;
    string m_Track_descr;
    string m_Assembly_acc;
    list< CRef< CTMgr_Attribute > > m_Attrs;
    list< CRef< CTMgr_CreateUserDataItem > > m_Data_items;
    CRef< TAccess_perms > m_Access_perms;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTMgr_CreateUserTrackRequest_Base::IsSetIdentity(void) const
{
    return m_Identity.NotEmpty();
}

inline
bool CTMgr_CreateUserTrackRequest_Base::CanGetIdentity(void) const
{
    return true;
}

inline
const CTMgr_CreateUserTrackRequest_Base::TIdentity& CTMgr_CreateUserTrackRequest_Base::GetIdentity(void) const
{
    if ( !m_Identity ) {
        const_cast<CTMgr_CreateUserTrackRequest_Base*>(this)->ResetIdentity();
    }
    return (*m_Identity);
}

inline
CTMgr_CreateUserTrackRequest_Base::TIdentity& CTMgr_CreateUserTrackRequest_Base::SetIdentity(void)
{
    if ( !m_Identity ) {
        ResetIdentity();
    }
    return (*m_Identity);
}

inline
bool CTMgr_CreateUserTrackRequest_Base::IsSetTrack_name(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTMgr_CreateUserTrackRequest_Base::CanGetTrack_name(void) const
{
    return IsSetTrack_name();
}

inline
const CTMgr_CreateUserTrackRequest_Base::TTrack_name& CTMgr_CreateUserTrackRequest_Base::GetTrack_name(void) const
{
    if (!CanGetTrack_name()) {
        ThrowUnassigned(1);
    }
    return m_Track_name;
}

inline
void CTMgr_CreateUserTrackRequest_Base::SetTrack_name(const CTMgr_CreateUserTrackRequest_Base::TTrack_name& value)
{
    m_Track_name = value;
    m_set_State[0] |= 0xc;
}

inline
void CTMgr_CreateUserTrackRequest_Base::SetTrack_name(CTMgr_CreateUserTrackRequest_Base::TTrack_name&& value)
{
    m_Track_name = std::forward<CTMgr_CreateUserTrackRequest_Base::TTrack_name>(value);
    m_set_State[0] |= 0xc;
}

inline
CTMgr_CreateUserTrackRequest_Base::TTrack_name& CTMgr_CreateUserTrackRequest_Base::SetTrack_name(void)
{
#ifdef _DEBUG
    if (!IsSetTrack_name()) {
        m_Track_name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Track_name;
}

inline
bool CTMgr_CreateUserTrackRequest_Base::IsSetTrack_descr(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CTMgr_CreateUserTrackRequest_Base::CanGetTrack_descr(void) const
{
    return IsSetTrack_descr();
}

inline
const CTMgr_CreateUserTrackRequest_Base::TTrack_descr& CTMgr_CreateUserTrackRequest_Base::GetTrack_descr(void) const
{
    if (!CanGetTrack_descr()) {
        ThrowUnassigned(2);
    }
    return m_Track_descr;
}

inline
void CTMgr_CreateUserTrackRequest_Base::SetTrack_descr(const CTMgr_CreateUserTrackRequest_Base::TTrack_descr& value)
{
    m_Track_descr = value;
    m_set_State[0] |= 0x30;
}

inline
void CTMgr_CreateUserTrackRequest_Base::SetTrack_descr(CTMgr_CreateUserTrackRequest_Base::TTrack_descr&& value)
{
    m_Track_descr = std::forward<CTMgr_CreateUserTrackRequest_Base::TTrack_descr>(value);
    m_set_State[0] |= 0x30;
}

inline
CTMgr_CreateUserTrackRequest_Base::TTrack_descr& CTMgr_CreateUserTrackRequest_Base::SetTrack_descr(void)
{
#ifdef _DEBUG
    if (!IsSetTrack_descr()) {
        m_Track_descr = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Track_descr;
}

inline
bool CTMgr_CreateUserTrackRequest_Base::IsSetAssembly_acc(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CTMgr_CreateUserTrackRequest_Base::CanGetAssembly_acc(void) const
{
    return IsSetAssembly_acc();
}

inline
const CTMgr_CreateUserTrackRequest_Base::TAssembly_acc& CTMgr_CreateUserTrackRequest_Base::GetAssembly_acc(void) const
{
    if (!CanGetAssembly_acc()) {
        ThrowUnassigned(3);
    }
    return m_Assembly_acc;
}

inline
void CTMgr_CreateUserTrackRequest_Base::SetAssembly_acc(const CTMgr_CreateUserTrackRequest_Base::TAssembly_acc& value)
{
    m_Assembly_acc = value;
    m_set_State[0] |= 0xc0;
}

inline
void CTMgr_CreateUserTrackRequest_Base::SetAssembly_acc(CTMgr_CreateUserTrackRequest_Base::TAssembly_acc&& value)
{
    m_Assembly_acc = std::forward<CTMgr_CreateUserTrackRequest_Base::TAssembly_acc>(value);
    m_set_State[0] |= 0xc0;
}

inline
CTMgr_CreateUserTrackRequest_Base::TAssembly_acc& CTMgr_CreateUserTrackRequest_Base::SetAssembly_acc(void)
{
#ifdef _DEBUG
    if (!IsSetAssembly_acc()) {
        m_Assembly_acc = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Assembly_acc;
}

inline
bool CTMgr_CreateUserTrackRequest_Base::IsSetAttrs(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CTMgr_CreateUserTrackRequest_Base::CanGetAttrs(void) const
{
    return true;
}

inline
const CTMgr_CreateUserTrackRequest_Base::TAttrs& CTMgr_CreateUserTrackRequest_Base::GetAttrs(void) const
{
    return m_Attrs;
}

inline
CTMgr_CreateUserTrackRequest_Base::TAttrs& CTMgr_CreateUserTrackRequest_Base::SetAttrs(void)
{
    m_set_State[0] |= 0x100;
    return m_Attrs;
}

inline
bool CTMgr_CreateUserTrackRequest_Base::IsSetData_items(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CTMgr_CreateUserTrackRequest_Base::CanGetData_items(void) const
{
    return true;
}

inline
const CTMgr_CreateUserTrackRequest_Base::TData_items& CTMgr_CreateUserTrackRequest_Base::GetData_items(void) const
{
    return m_Data_items;
}

inline
CTMgr_CreateUserTrackRequest_Base::TData_items& CTMgr_CreateUserTrackRequest_Base::SetData_items(void)
{
    m_set_State[0] |= 0x400;
    return m_Data_items;
}

inline
bool CTMgr_CreateUserTrackRequest_Base::IsSetAccess_perms(void) const
{
    return m_Access_perms.NotEmpty();
}

inline
bool CTMgr_CreateUserTrackRequest_Base::CanGetAccess_perms(void) const
{
    return true;
}

inline
const CTMgr_CreateUserTrackRequest_Base::TAccess_perms& CTMgr_CreateUserTrackRequest_Base::GetAccess_perms(void) const
{
    if ( !m_Access_perms ) {
        const_cast<CTMgr_CreateUserTrackRequest_Base*>(this)->ResetAccess_perms();
    }
    return (*m_Access_perms);
}

inline
CTMgr_CreateUserTrackRequest_Base::TAccess_perms& CTMgr_CreateUserTrackRequest_Base::SetAccess_perms(void)
{
    if ( !m_Access_perms ) {
        ResetAccess_perms();
    }
    return (*m_Access_perms);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_CREATEUSERTRACKREQUES_BASE_HPP
