/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Taxon1_resp_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'taxon1.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TAXON1_TAXON1_RESP_BASE_HPP
#define OBJECTS_TAXON1_TAXON1_RESP_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CTaxon1_data;
class CTaxon1_error;
class CTaxon1_info;
class CTaxon1_name;
class CTaxon2_data;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TAXON1_EXPORT CTaxon1_resp_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTaxon1_resp_Base(void);
    // destructor
    virtual ~CTaxon1_resp_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,      ///< No variant selected
        e_Error,            ///< sent on any error
        e_Init,             ///< sent by successful initiation
        e_Findname,
        e_Getdesignator,
        e_Getunique,
        e_Getidbyorg,
        e_Getorgnames,
        e_Getcde,
        e_Getranks,
        e_Getdivs,
        e_Getgcs,
        e_Getlineage,
        e_Getchildren,
        e_Getbyid,
        e_Lookup,
        e_Getorgmod,
        e_Fini,
        e_Id4gi,
        e_Taxabyid,
        e_Taxachildren,
        e_Taxalineage,
        e_Maxtaxid,
        e_Getproptypes,
        e_Getorgprop,
        e_Searchname,
        e_Dumpnames4class,
        e_Getdomain         ///< [0]:id,nof_fields,name, [1..nof_fields]:field_no,val_type,field_name, [:nof_fields]:val_id,int_val or str_len(-1 for null),str_val
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 28 ///< == e_Getdomain+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CTaxon1_error TError;
    typedef list< CRef< CTaxon1_name > > TFindname;
    typedef int TGetdesignator;
    typedef NCBI_NS_NCBI::TTaxId TGetunique;
    typedef int TGetidbyorg;
    typedef list< CRef< CTaxon1_name > > TGetorgnames;
    typedef list< CRef< CTaxon1_info > > TGetcde;
    typedef list< CRef< CTaxon1_info > > TGetranks;
    typedef list< CRef< CTaxon1_info > > TGetdivs;
    typedef list< CRef< CTaxon1_info > > TGetgcs;
    typedef list< CRef< CTaxon1_info > > TGetlineage;
    typedef list< CRef< CTaxon1_info > > TGetchildren;
    typedef CTaxon1_data TGetbyid;
    typedef CTaxon1_data TLookup;
    typedef list< CRef< CTaxon1_info > > TGetorgmod;
    typedef NCBI_NS_NCBI::TTaxId TId4gi;
    typedef CTaxon2_data TTaxabyid;
    typedef list< CRef< CTaxon1_name > > TTaxachildren;
    typedef list< CRef< CTaxon1_name > > TTaxalineage;
    typedef NCBI_NS_NCBI::TTaxId TMaxtaxid;
    typedef list< CRef< CTaxon1_info > > TGetproptypes;
    typedef list< CRef< CTaxon1_info > > TGetorgprop;
    typedef list< CRef< CTaxon1_name > > TSearchname;
    typedef list< CRef< CTaxon1_name > > TDumpnames4class;
    typedef list< CRef< CTaxon1_info > > TGetdomain;

    // getters
    // setters

    // typedef CTaxon1_error TError
    bool IsError(void) const;
    const TError& GetError(void) const;
    TError& SetError(void);
    void SetError(TError& value);


    bool IsInit(void) const;
    void SetInit(void);

    // typedef list< CRef< CTaxon1_name > > TFindname
    bool IsFindname(void) const;
    const TFindname& GetFindname(void) const;
    TFindname& SetFindname(void);

    // typedef int TGetdesignator
    bool IsGetdesignator(void) const;
    TGetdesignator GetGetdesignator(void) const;
    TGetdesignator& SetGetdesignator(void);
    void SetGetdesignator(TGetdesignator value);

    // typedef NCBI_NS_NCBI::TTaxId TGetunique
    bool IsGetunique(void) const;
    TGetunique GetGetunique(void) const;
    TGetunique& SetGetunique(void);
    void SetGetunique(TGetunique value);

    // typedef int TGetidbyorg
    bool IsGetidbyorg(void) const;
    TGetidbyorg GetGetidbyorg(void) const;
    TGetidbyorg& SetGetidbyorg(void);
    void SetGetidbyorg(TGetidbyorg value);

    // typedef list< CRef< CTaxon1_name > > TGetorgnames
    bool IsGetorgnames(void) const;
    const TGetorgnames& GetGetorgnames(void) const;
    TGetorgnames& SetGetorgnames(void);

    // typedef list< CRef< CTaxon1_info > > TGetcde
    bool IsGetcde(void) const;
    const TGetcde& GetGetcde(void) const;
    TGetcde& SetGetcde(void);

    // typedef list< CRef< CTaxon1_info > > TGetranks
    bool IsGetranks(void) const;
    const TGetranks& GetGetranks(void) const;
    TGetranks& SetGetranks(void);

    // typedef list< CRef< CTaxon1_info > > TGetdivs
    bool IsGetdivs(void) const;
    const TGetdivs& GetGetdivs(void) const;
    TGetdivs& SetGetdivs(void);

    // typedef list< CRef< CTaxon1_info > > TGetgcs
    bool IsGetgcs(void) const;
    const TGetgcs& GetGetgcs(void) const;
    TGetgcs& SetGetgcs(void);

    // typedef list< CRef< CTaxon1_info > > TGetlineage
    bool IsGetlineage(void) const;
    const TGetlineage& GetGetlineage(void) const;
    TGetlineage& SetGetlineage(void);

    // typedef list< CRef< CTaxon1_info > > TGetchildren
    bool IsGetchildren(void) const;
    const TGetchildren& GetGetchildren(void) const;
    TGetchildren& SetGetchildren(void);

    // typedef CTaxon1_data TGetbyid
    bool IsGetbyid(void) const;
    const TGetbyid& GetGetbyid(void) const;
    TGetbyid& SetGetbyid(void);
    void SetGetbyid(TGetbyid& value);

    // typedef CTaxon1_data TLookup
    bool IsLookup(void) const;
    const TLookup& GetLookup(void) const;
    TLookup& SetLookup(void);
    void SetLookup(TLookup& value);

    // typedef list< CRef< CTaxon1_info > > TGetorgmod
    bool IsGetorgmod(void) const;
    const TGetorgmod& GetGetorgmod(void) const;
    TGetorgmod& SetGetorgmod(void);


    bool IsFini(void) const;
    void SetFini(void);

    // typedef NCBI_NS_NCBI::TTaxId TId4gi
    bool IsId4gi(void) const;
    TId4gi GetId4gi(void) const;
    TId4gi& SetId4gi(void);
    void SetId4gi(TId4gi value);

    // typedef CTaxon2_data TTaxabyid
    bool IsTaxabyid(void) const;
    const TTaxabyid& GetTaxabyid(void) const;
    TTaxabyid& SetTaxabyid(void);
    void SetTaxabyid(TTaxabyid& value);

    // typedef list< CRef< CTaxon1_name > > TTaxachildren
    bool IsTaxachildren(void) const;
    const TTaxachildren& GetTaxachildren(void) const;
    TTaxachildren& SetTaxachildren(void);

    // typedef list< CRef< CTaxon1_name > > TTaxalineage
    bool IsTaxalineage(void) const;
    const TTaxalineage& GetTaxalineage(void) const;
    TTaxalineage& SetTaxalineage(void);

    // typedef NCBI_NS_NCBI::TTaxId TMaxtaxid
    bool IsMaxtaxid(void) const;
    TMaxtaxid GetMaxtaxid(void) const;
    TMaxtaxid& SetMaxtaxid(void);
    void SetMaxtaxid(TMaxtaxid value);

    // typedef list< CRef< CTaxon1_info > > TGetproptypes
    bool IsGetproptypes(void) const;
    const TGetproptypes& GetGetproptypes(void) const;
    TGetproptypes& SetGetproptypes(void);

    // typedef list< CRef< CTaxon1_info > > TGetorgprop
    bool IsGetorgprop(void) const;
    const TGetorgprop& GetGetorgprop(void) const;
    TGetorgprop& SetGetorgprop(void);

    // typedef list< CRef< CTaxon1_name > > TSearchname
    bool IsSearchname(void) const;
    const TSearchname& GetSearchname(void) const;
    TSearchname& SetSearchname(void);

    // typedef list< CRef< CTaxon1_name > > TDumpnames4class
    bool IsDumpnames4class(void) const;
    const TDumpnames4class& GetDumpnames4class(void) const;
    TDumpnames4class& SetDumpnames4class(void);

    // typedef list< CRef< CTaxon1_info > > TGetdomain
    bool IsGetdomain(void) const;
    const TGetdomain& GetGetdomain(void) const;
    TGetdomain& SetGetdomain(void);


private:
    // copy constructor and assignment operator
    CTaxon1_resp_Base(const CTaxon1_resp_Base& );
    CTaxon1_resp_Base& operator=(const CTaxon1_resp_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        NCBI_NS_NCBI::CUnionBuffer<TFindname> m_Findname;
        TGetdesignator m_Getdesignator;
        int m_Getunique;
        TGetidbyorg m_Getidbyorg;
        NCBI_NS_NCBI::CUnionBuffer<TGetorgnames> m_Getorgnames;
        NCBI_NS_NCBI::CUnionBuffer<TGetcde> m_Getcde;
        NCBI_NS_NCBI::CUnionBuffer<TGetranks> m_Getranks;
        NCBI_NS_NCBI::CUnionBuffer<TGetdivs> m_Getdivs;
        NCBI_NS_NCBI::CUnionBuffer<TGetgcs> m_Getgcs;
        NCBI_NS_NCBI::CUnionBuffer<TGetlineage> m_Getlineage;
        NCBI_NS_NCBI::CUnionBuffer<TGetchildren> m_Getchildren;
        NCBI_NS_NCBI::CUnionBuffer<TGetorgmod> m_Getorgmod;
        int m_Id4gi;
        NCBI_NS_NCBI::CUnionBuffer<TTaxachildren> m_Taxachildren;
        NCBI_NS_NCBI::CUnionBuffer<TTaxalineage> m_Taxalineage;
        int m_Maxtaxid;
        NCBI_NS_NCBI::CUnionBuffer<TGetproptypes> m_Getproptypes;
        NCBI_NS_NCBI::CUnionBuffer<TGetorgprop> m_Getorgprop;
        NCBI_NS_NCBI::CUnionBuffer<TSearchname> m_Searchname;
        NCBI_NS_NCBI::CUnionBuffer<TDumpnames4class> m_Dumpnames4class;
        NCBI_NS_NCBI::CUnionBuffer<TGetdomain> m_Getdomain;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CTaxon1_resp_Base::E_Choice CTaxon1_resp_Base::Which(void) const
{
    return m_choice;
}

inline
void CTaxon1_resp_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CTaxon1_resp_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CTaxon1_resp_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CTaxon1_resp_Base::IsError(void) const
{
    return m_choice == e_Error;
}

inline
bool CTaxon1_resp_Base::IsInit(void) const
{
    return m_choice == e_Init;
}

inline
void CTaxon1_resp_Base::SetInit(void)
{
    Select(e_Init, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CTaxon1_resp_Base::IsFindname(void) const
{
    return m_choice == e_Findname;
}

inline
const CTaxon1_resp_Base::TFindname& CTaxon1_resp_Base::GetFindname(void) const
{
    CheckSelected(e_Findname);
    return *m_Findname;
}

inline
CTaxon1_resp_Base::TFindname& CTaxon1_resp_Base::SetFindname(void)
{
    Select(e_Findname, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Findname;
}

inline
bool CTaxon1_resp_Base::IsGetdesignator(void) const
{
    return m_choice == e_Getdesignator;
}

inline
CTaxon1_resp_Base::TGetdesignator CTaxon1_resp_Base::GetGetdesignator(void) const
{
    CheckSelected(e_Getdesignator);
    return m_Getdesignator;
}

inline
CTaxon1_resp_Base::TGetdesignator& CTaxon1_resp_Base::SetGetdesignator(void)
{
    Select(e_Getdesignator, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Getdesignator;
}

inline
void CTaxon1_resp_Base::SetGetdesignator(CTaxon1_resp_Base::TGetdesignator value)
{
    Select(e_Getdesignator, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Getdesignator = value;
}

inline
bool CTaxon1_resp_Base::IsGetunique(void) const
{
    return m_choice == e_Getunique;
}

inline
CTaxon1_resp_Base::TGetunique CTaxon1_resp_Base::GetGetunique(void) const
{
    CheckSelected(e_Getunique);
    return reinterpret_cast<const TGetunique&>(m_Getunique);
}

inline
CTaxon1_resp_Base::TGetunique& CTaxon1_resp_Base::SetGetunique(void)
{
    Select(e_Getunique, NCBI_NS_NCBI::eDoNotResetVariant);
    return reinterpret_cast<TGetunique&>(m_Getunique);
}

inline
void CTaxon1_resp_Base::SetGetunique(CTaxon1_resp_Base::TGetunique value)
{
    Select(e_Getunique, NCBI_NS_NCBI::eDoNotResetVariant);
    reinterpret_cast<TGetunique&>(m_Getunique) = value;
}

inline
bool CTaxon1_resp_Base::IsGetidbyorg(void) const
{
    return m_choice == e_Getidbyorg;
}

inline
CTaxon1_resp_Base::TGetidbyorg CTaxon1_resp_Base::GetGetidbyorg(void) const
{
    CheckSelected(e_Getidbyorg);
    return m_Getidbyorg;
}

inline
CTaxon1_resp_Base::TGetidbyorg& CTaxon1_resp_Base::SetGetidbyorg(void)
{
    Select(e_Getidbyorg, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Getidbyorg;
}

inline
void CTaxon1_resp_Base::SetGetidbyorg(CTaxon1_resp_Base::TGetidbyorg value)
{
    Select(e_Getidbyorg, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Getidbyorg = value;
}

inline
bool CTaxon1_resp_Base::IsGetorgnames(void) const
{
    return m_choice == e_Getorgnames;
}

inline
const CTaxon1_resp_Base::TGetorgnames& CTaxon1_resp_Base::GetGetorgnames(void) const
{
    CheckSelected(e_Getorgnames);
    return *m_Getorgnames;
}

inline
CTaxon1_resp_Base::TGetorgnames& CTaxon1_resp_Base::SetGetorgnames(void)
{
    Select(e_Getorgnames, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Getorgnames;
}

inline
bool CTaxon1_resp_Base::IsGetcde(void) const
{
    return m_choice == e_Getcde;
}

inline
const CTaxon1_resp_Base::TGetcde& CTaxon1_resp_Base::GetGetcde(void) const
{
    CheckSelected(e_Getcde);
    return *m_Getcde;
}

inline
CTaxon1_resp_Base::TGetcde& CTaxon1_resp_Base::SetGetcde(void)
{
    Select(e_Getcde, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Getcde;
}

inline
bool CTaxon1_resp_Base::IsGetranks(void) const
{
    return m_choice == e_Getranks;
}

inline
const CTaxon1_resp_Base::TGetranks& CTaxon1_resp_Base::GetGetranks(void) const
{
    CheckSelected(e_Getranks);
    return *m_Getranks;
}

inline
CTaxon1_resp_Base::TGetranks& CTaxon1_resp_Base::SetGetranks(void)
{
    Select(e_Getranks, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Getranks;
}

inline
bool CTaxon1_resp_Base::IsGetdivs(void) const
{
    return m_choice == e_Getdivs;
}

inline
const CTaxon1_resp_Base::TGetdivs& CTaxon1_resp_Base::GetGetdivs(void) const
{
    CheckSelected(e_Getdivs);
    return *m_Getdivs;
}

inline
CTaxon1_resp_Base::TGetdivs& CTaxon1_resp_Base::SetGetdivs(void)
{
    Select(e_Getdivs, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Getdivs;
}

inline
bool CTaxon1_resp_Base::IsGetgcs(void) const
{
    return m_choice == e_Getgcs;
}

inline
const CTaxon1_resp_Base::TGetgcs& CTaxon1_resp_Base::GetGetgcs(void) const
{
    CheckSelected(e_Getgcs);
    return *m_Getgcs;
}

inline
CTaxon1_resp_Base::TGetgcs& CTaxon1_resp_Base::SetGetgcs(void)
{
    Select(e_Getgcs, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Getgcs;
}

inline
bool CTaxon1_resp_Base::IsGetlineage(void) const
{
    return m_choice == e_Getlineage;
}

inline
const CTaxon1_resp_Base::TGetlineage& CTaxon1_resp_Base::GetGetlineage(void) const
{
    CheckSelected(e_Getlineage);
    return *m_Getlineage;
}

inline
CTaxon1_resp_Base::TGetlineage& CTaxon1_resp_Base::SetGetlineage(void)
{
    Select(e_Getlineage, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Getlineage;
}

inline
bool CTaxon1_resp_Base::IsGetchildren(void) const
{
    return m_choice == e_Getchildren;
}

inline
const CTaxon1_resp_Base::TGetchildren& CTaxon1_resp_Base::GetGetchildren(void) const
{
    CheckSelected(e_Getchildren);
    return *m_Getchildren;
}

inline
CTaxon1_resp_Base::TGetchildren& CTaxon1_resp_Base::SetGetchildren(void)
{
    Select(e_Getchildren, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Getchildren;
}

inline
bool CTaxon1_resp_Base::IsGetbyid(void) const
{
    return m_choice == e_Getbyid;
}

inline
bool CTaxon1_resp_Base::IsLookup(void) const
{
    return m_choice == e_Lookup;
}

inline
bool CTaxon1_resp_Base::IsGetorgmod(void) const
{
    return m_choice == e_Getorgmod;
}

inline
const CTaxon1_resp_Base::TGetorgmod& CTaxon1_resp_Base::GetGetorgmod(void) const
{
    CheckSelected(e_Getorgmod);
    return *m_Getorgmod;
}

inline
CTaxon1_resp_Base::TGetorgmod& CTaxon1_resp_Base::SetGetorgmod(void)
{
    Select(e_Getorgmod, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Getorgmod;
}

inline
bool CTaxon1_resp_Base::IsFini(void) const
{
    return m_choice == e_Fini;
}

inline
void CTaxon1_resp_Base::SetFini(void)
{
    Select(e_Fini, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CTaxon1_resp_Base::IsId4gi(void) const
{
    return m_choice == e_Id4gi;
}

inline
CTaxon1_resp_Base::TId4gi CTaxon1_resp_Base::GetId4gi(void) const
{
    CheckSelected(e_Id4gi);
    return reinterpret_cast<const TId4gi&>(m_Id4gi);
}

inline
CTaxon1_resp_Base::TId4gi& CTaxon1_resp_Base::SetId4gi(void)
{
    Select(e_Id4gi, NCBI_NS_NCBI::eDoNotResetVariant);
    return reinterpret_cast<TId4gi&>(m_Id4gi);
}

inline
void CTaxon1_resp_Base::SetId4gi(CTaxon1_resp_Base::TId4gi value)
{
    Select(e_Id4gi, NCBI_NS_NCBI::eDoNotResetVariant);
    reinterpret_cast<TId4gi&>(m_Id4gi) = value;
}

inline
bool CTaxon1_resp_Base::IsTaxabyid(void) const
{
    return m_choice == e_Taxabyid;
}

inline
bool CTaxon1_resp_Base::IsTaxachildren(void) const
{
    return m_choice == e_Taxachildren;
}

inline
const CTaxon1_resp_Base::TTaxachildren& CTaxon1_resp_Base::GetTaxachildren(void) const
{
    CheckSelected(e_Taxachildren);
    return *m_Taxachildren;
}

inline
CTaxon1_resp_Base::TTaxachildren& CTaxon1_resp_Base::SetTaxachildren(void)
{
    Select(e_Taxachildren, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Taxachildren;
}

inline
bool CTaxon1_resp_Base::IsTaxalineage(void) const
{
    return m_choice == e_Taxalineage;
}

inline
const CTaxon1_resp_Base::TTaxalineage& CTaxon1_resp_Base::GetTaxalineage(void) const
{
    CheckSelected(e_Taxalineage);
    return *m_Taxalineage;
}

inline
CTaxon1_resp_Base::TTaxalineage& CTaxon1_resp_Base::SetTaxalineage(void)
{
    Select(e_Taxalineage, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Taxalineage;
}

inline
bool CTaxon1_resp_Base::IsMaxtaxid(void) const
{
    return m_choice == e_Maxtaxid;
}

inline
CTaxon1_resp_Base::TMaxtaxid CTaxon1_resp_Base::GetMaxtaxid(void) const
{
    CheckSelected(e_Maxtaxid);
    return reinterpret_cast<const TMaxtaxid&>(m_Maxtaxid);
}

inline
CTaxon1_resp_Base::TMaxtaxid& CTaxon1_resp_Base::SetMaxtaxid(void)
{
    Select(e_Maxtaxid, NCBI_NS_NCBI::eDoNotResetVariant);
    return reinterpret_cast<TMaxtaxid&>(m_Maxtaxid);
}

inline
void CTaxon1_resp_Base::SetMaxtaxid(CTaxon1_resp_Base::TMaxtaxid value)
{
    Select(e_Maxtaxid, NCBI_NS_NCBI::eDoNotResetVariant);
    reinterpret_cast<TMaxtaxid&>(m_Maxtaxid) = value;
}

inline
bool CTaxon1_resp_Base::IsGetproptypes(void) const
{
    return m_choice == e_Getproptypes;
}

inline
const CTaxon1_resp_Base::TGetproptypes& CTaxon1_resp_Base::GetGetproptypes(void) const
{
    CheckSelected(e_Getproptypes);
    return *m_Getproptypes;
}

inline
CTaxon1_resp_Base::TGetproptypes& CTaxon1_resp_Base::SetGetproptypes(void)
{
    Select(e_Getproptypes, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Getproptypes;
}

inline
bool CTaxon1_resp_Base::IsGetorgprop(void) const
{
    return m_choice == e_Getorgprop;
}

inline
const CTaxon1_resp_Base::TGetorgprop& CTaxon1_resp_Base::GetGetorgprop(void) const
{
    CheckSelected(e_Getorgprop);
    return *m_Getorgprop;
}

inline
CTaxon1_resp_Base::TGetorgprop& CTaxon1_resp_Base::SetGetorgprop(void)
{
    Select(e_Getorgprop, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Getorgprop;
}

inline
bool CTaxon1_resp_Base::IsSearchname(void) const
{
    return m_choice == e_Searchname;
}

inline
const CTaxon1_resp_Base::TSearchname& CTaxon1_resp_Base::GetSearchname(void) const
{
    CheckSelected(e_Searchname);
    return *m_Searchname;
}

inline
CTaxon1_resp_Base::TSearchname& CTaxon1_resp_Base::SetSearchname(void)
{
    Select(e_Searchname, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Searchname;
}

inline
bool CTaxon1_resp_Base::IsDumpnames4class(void) const
{
    return m_choice == e_Dumpnames4class;
}

inline
const CTaxon1_resp_Base::TDumpnames4class& CTaxon1_resp_Base::GetDumpnames4class(void) const
{
    CheckSelected(e_Dumpnames4class);
    return *m_Dumpnames4class;
}

inline
CTaxon1_resp_Base::TDumpnames4class& CTaxon1_resp_Base::SetDumpnames4class(void)
{
    Select(e_Dumpnames4class, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Dumpnames4class;
}

inline
bool CTaxon1_resp_Base::IsGetdomain(void) const
{
    return m_choice == e_Getdomain;
}

inline
const CTaxon1_resp_Base::TGetdomain& CTaxon1_resp_Base::GetGetdomain(void) const
{
    CheckSelected(e_Getdomain);
    return *m_Getdomain;
}

inline
CTaxon1_resp_Base::TGetdomain& CTaxon1_resp_Base::SetGetdomain(void)
{
    Select(e_Getdomain, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Getdomain;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TAXON1_TAXON1_RESP_BASE_HPP
