/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file SeqTable_single_data_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqtable.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQTABLE_SEQTABLE_SINGLE_DATA_BASE_HPP
#define OBJECTS_SEQTABLE_SEQTABLE_SINGLE_DATA_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <vector>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_id;
class CSeq_interval;
class CSeq_loc;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQ_EXPORT CSeqTable_single_data_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeqTable_single_data_Base(void);
    // destructor
    virtual ~CSeqTable_single_data_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_Int,          ///< integer
        e_Real,         ///< real
        e_String,       ///< string
        e_Bytes,        ///< byte array
        e_Bit,          ///< bit
        e_Loc,          ///< location
        e_Id,
        e_Interval,
        e_Int8
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 10 ///< == e_Int8+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef int TInt;
    typedef double TReal;
    typedef CStringUTF8 TString;
    typedef vector< char > TBytes;
    typedef bool TBit;
    typedef CSeq_loc TLoc;
    typedef CSeq_id TId;
    typedef CSeq_interval TInterval;
    typedef Int8 TInt8;

    // getters
    // setters

    // typedef int TInt
    bool IsInt(void) const;
    TInt GetInt(void) const;
    TInt& SetInt(void);
    void SetInt(TInt value);

    // typedef double TReal
    bool IsReal(void) const;
    TReal GetReal(void) const;
    TReal& SetReal(void);
    void SetReal(TReal value);

    // typedef CStringUTF8 TString
    bool IsString(void) const;
    const TString& GetString(void) const;
    TString& SetString(void);
    void SetString(const TString& value);

    // typedef vector< char > TBytes
    bool IsBytes(void) const;
    const TBytes& GetBytes(void) const;
    TBytes& SetBytes(void);

    // typedef bool TBit
    bool IsBit(void) const;
    TBit GetBit(void) const;
    TBit& SetBit(void);
    void SetBit(TBit value);

    // typedef CSeq_loc TLoc
    bool IsLoc(void) const;
    const TLoc& GetLoc(void) const;
    TLoc& SetLoc(void);
    void SetLoc(TLoc& value);

    // typedef CSeq_id TId
    bool IsId(void) const;
    const TId& GetId(void) const;
    TId& SetId(void);
    void SetId(TId& value);

    // typedef CSeq_interval TInterval
    bool IsInterval(void) const;
    const TInterval& GetInterval(void) const;
    TInterval& SetInterval(void);
    void SetInterval(TInterval& value);

    // typedef Int8 TInt8
    bool IsInt8(void) const;
    TInt8 GetInt8(void) const;
    TInt8& SetInt8(void);
    void SetInt8(TInt8 value);


private:
    // copy constructor and assignment operator
    CSeqTable_single_data_Base(const CSeqTable_single_data_Base& );
    CSeqTable_single_data_Base& operator=(const CSeqTable_single_data_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        TInt m_Int;
        TReal m_Real;
        NCBI_NS_NCBI::CUnionBuffer<TBytes> m_Bytes;
        TBit m_Bit;
        TInt8 m_Int8;
        NCBI_NS_NCBI::CUnionBuffer<CStringUTF8> m_string_utf8;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CSeqTable_single_data_Base::E_Choice CSeqTable_single_data_Base::Which(void) const
{
    return m_choice;
}

inline
void CSeqTable_single_data_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CSeqTable_single_data_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CSeqTable_single_data_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CSeqTable_single_data_Base::IsInt(void) const
{
    return m_choice == e_Int;
}

inline
CSeqTable_single_data_Base::TInt CSeqTable_single_data_Base::GetInt(void) const
{
    CheckSelected(e_Int);
    return m_Int;
}

inline
CSeqTable_single_data_Base::TInt& CSeqTable_single_data_Base::SetInt(void)
{
    Select(e_Int, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Int;
}

inline
void CSeqTable_single_data_Base::SetInt(CSeqTable_single_data_Base::TInt value)
{
    Select(e_Int, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Int = value;
}

inline
bool CSeqTable_single_data_Base::IsReal(void) const
{
    return m_choice == e_Real;
}

inline
CSeqTable_single_data_Base::TReal CSeqTable_single_data_Base::GetReal(void) const
{
    CheckSelected(e_Real);
    return m_Real;
}

inline
CSeqTable_single_data_Base::TReal& CSeqTable_single_data_Base::SetReal(void)
{
    Select(e_Real, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Real;
}

inline
void CSeqTable_single_data_Base::SetReal(CSeqTable_single_data_Base::TReal value)
{
    Select(e_Real, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Real = value;
}

inline
bool CSeqTable_single_data_Base::IsString(void) const
{
    return m_choice == e_String;
}

inline
const CSeqTable_single_data_Base::TString& CSeqTable_single_data_Base::GetString(void) const
{
    CheckSelected(e_String);
    return *m_string_utf8;
}

inline
CSeqTable_single_data_Base::TString& CSeqTable_single_data_Base::SetString(void)
{
    Select(e_String, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string_utf8;
}

inline
bool CSeqTable_single_data_Base::IsBytes(void) const
{
    return m_choice == e_Bytes;
}

inline
const CSeqTable_single_data_Base::TBytes& CSeqTable_single_data_Base::GetBytes(void) const
{
    CheckSelected(e_Bytes);
    return *m_Bytes;
}

inline
CSeqTable_single_data_Base::TBytes& CSeqTable_single_data_Base::SetBytes(void)
{
    Select(e_Bytes, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Bytes;
}

inline
bool CSeqTable_single_data_Base::IsBit(void) const
{
    return m_choice == e_Bit;
}

inline
CSeqTable_single_data_Base::TBit CSeqTable_single_data_Base::GetBit(void) const
{
    CheckSelected(e_Bit);
    return m_Bit;
}

inline
CSeqTable_single_data_Base::TBit& CSeqTable_single_data_Base::SetBit(void)
{
    Select(e_Bit, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Bit;
}

inline
void CSeqTable_single_data_Base::SetBit(CSeqTable_single_data_Base::TBit value)
{
    Select(e_Bit, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Bit = value;
}

inline
bool CSeqTable_single_data_Base::IsLoc(void) const
{
    return m_choice == e_Loc;
}

inline
bool CSeqTable_single_data_Base::IsId(void) const
{
    return m_choice == e_Id;
}

inline
bool CSeqTable_single_data_Base::IsInterval(void) const
{
    return m_choice == e_Interval;
}

inline
bool CSeqTable_single_data_Base::IsInt8(void) const
{
    return m_choice == e_Int8;
}

inline
CSeqTable_single_data_Base::TInt8 CSeqTable_single_data_Base::GetInt8(void) const
{
    CheckSelected(e_Int8);
    return m_Int8;
}

inline
CSeqTable_single_data_Base::TInt8& CSeqTable_single_data_Base::SetInt8(void)
{
    Select(e_Int8, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Int8;
}

inline
void CSeqTable_single_data_Base::SetInt8(CSeqTable_single_data_Base::TInt8 value)
{
    Select(e_Int8, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Int8 = value;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQTABLE_SEQTABLE_SINGLE_DATA_BASE_HPP
