/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file SeqTable_multi_data_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqtable.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQTABLE_SEQTABLE_MULTI_DATA_BASE_HPP
#define OBJECTS_SEQTABLE_SEQTABLE_MULTI_DATA_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <vector>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBVector_data;
class CCommonBytes_table;
class CCommonString_table;
class CScaled_int_multi_data;
class CScaled_real_multi_data;
class CSeqTable_multi_data;
class CSeq_id;
class CSeq_interval;
class CSeq_loc;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQ_EXPORT CSeqTable_multi_data_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeqTable_multi_data_Base(void);
    // destructor
    virtual ~CSeqTable_multi_data_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,    ///< No variant selected
        e_Int,            ///< a set of 4-byte integers, one per row
        e_Real,           ///< a set of reals, one per row
        e_String,         ///< a set of strings, one per row
        e_Bytes,          ///< a set of byte arrays, one per row
        e_Common_string,  ///< a set of string with small set of possible values
        e_Common_bytes,   ///< a set of byte arrays with small set of possible values
        e_Bit,            ///< a set of bits, one per row  Most-significant bit in each octet comes first.
        e_Loc,            ///< a set of locations, one per row
        e_Id,
        e_Interval,
        e_Int_delta,      ///< delta-encoded data (int/bit -> int)
        e_Int_scaled,     ///< scaled data (int/bit -> int)
        e_Real_scaled,    ///< scaled data (int/bit -> real)
        e_Bit_bvector,    ///< a set of bit, represented as serialized bvector,  see include/util/bitset/bm.h
        e_Int1,           ///< a set of signed 1-byte integers encoded as sequential octets
        e_Int2,           ///< a set of signed 2-byte integers
        e_Int8            ///< a set of signed 8-byte integers
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 18 ///< == e_Int8+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef vector< int > TInt;
    typedef vector< double > TReal;
    typedef vector< CStringUTF8 > TString;
    typedef vector< vector< char >* > TBytes;
    typedef CCommonString_table TCommon_string;
    typedef CCommonBytes_table TCommon_bytes;
    typedef vector< char > TBit;
    typedef vector< CRef< CSeq_loc > > TLoc;
    typedef vector< CRef< CSeq_id > > TId;
    typedef vector< CRef< CSeq_interval > > TInterval;
    typedef CSeqTable_multi_data TInt_delta;
    typedef CScaled_int_multi_data TInt_scaled;
    typedef CScaled_real_multi_data TReal_scaled;
    typedef CBVector_data TBit_bvector;
    typedef vector< char > TInt1;
    typedef vector< Int2 > TInt2;
    typedef vector< Int8 > TInt8;

    // getters
    // setters

    // typedef vector< int > TInt
    bool IsInt(void) const;
    const TInt& GetInt(void) const;
    TInt& SetInt(void);

    // typedef vector< double > TReal
    bool IsReal(void) const;
    const TReal& GetReal(void) const;
    TReal& SetReal(void);

    // typedef vector< CStringUTF8 > TString
    bool IsString(void) const;
    const TString& GetString(void) const;
    TString& SetString(void);

    // typedef vector< vector< char >* > TBytes
    bool IsBytes(void) const;
    const TBytes& GetBytes(void) const;
    TBytes& SetBytes(void);

    // typedef CCommonString_table TCommon_string
    bool IsCommon_string(void) const;
    const TCommon_string& GetCommon_string(void) const;
    TCommon_string& SetCommon_string(void);
    void SetCommon_string(TCommon_string& value);

    // typedef CCommonBytes_table TCommon_bytes
    bool IsCommon_bytes(void) const;
    const TCommon_bytes& GetCommon_bytes(void) const;
    TCommon_bytes& SetCommon_bytes(void);
    void SetCommon_bytes(TCommon_bytes& value);

    // typedef vector< char > TBit
    bool IsBit(void) const;
    const TBit& GetBit(void) const;
    TBit& SetBit(void);

    // typedef vector< CRef< CSeq_loc > > TLoc
    bool IsLoc(void) const;
    const TLoc& GetLoc(void) const;
    TLoc& SetLoc(void);

    // typedef vector< CRef< CSeq_id > > TId
    bool IsId(void) const;
    const TId& GetId(void) const;
    TId& SetId(void);

    // typedef vector< CRef< CSeq_interval > > TInterval
    bool IsInterval(void) const;
    const TInterval& GetInterval(void) const;
    TInterval& SetInterval(void);

    // typedef CSeqTable_multi_data TInt_delta
    bool IsInt_delta(void) const;
    const TInt_delta& GetInt_delta(void) const;
    TInt_delta& SetInt_delta(void);
    void SetInt_delta(TInt_delta& value);

    // typedef CScaled_int_multi_data TInt_scaled
    bool IsInt_scaled(void) const;
    const TInt_scaled& GetInt_scaled(void) const;
    TInt_scaled& SetInt_scaled(void);
    void SetInt_scaled(TInt_scaled& value);

    // typedef CScaled_real_multi_data TReal_scaled
    bool IsReal_scaled(void) const;
    const TReal_scaled& GetReal_scaled(void) const;
    TReal_scaled& SetReal_scaled(void);
    void SetReal_scaled(TReal_scaled& value);

    // typedef CBVector_data TBit_bvector
    bool IsBit_bvector(void) const;
    const TBit_bvector& GetBit_bvector(void) const;
    TBit_bvector& SetBit_bvector(void);
    void SetBit_bvector(TBit_bvector& value);

    // typedef vector< char > TInt1
    bool IsInt1(void) const;
    const TInt1& GetInt1(void) const;
    TInt1& SetInt1(void);

    // typedef vector< Int2 > TInt2
    bool IsInt2(void) const;
    const TInt2& GetInt2(void) const;
    TInt2& SetInt2(void);

    // typedef vector< Int8 > TInt8
    bool IsInt8(void) const;
    const TInt8& GetInt8(void) const;
    TInt8& SetInt8(void);


private:
    // copy constructor and assignment operator
    CSeqTable_multi_data_Base(const CSeqTable_multi_data_Base& );
    CSeqTable_multi_data_Base& operator=(const CSeqTable_multi_data_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        NCBI_NS_NCBI::CUnionBuffer<TInt> m_Int;
        NCBI_NS_NCBI::CUnionBuffer<TReal> m_Real;
        NCBI_NS_NCBI::CUnionBuffer<TString> m_String;
        NCBI_NS_NCBI::CUnionBuffer<TBytes> m_Bytes;
        NCBI_NS_NCBI::CUnionBuffer<TBit> m_Bit;
        NCBI_NS_NCBI::CUnionBuffer<TLoc> m_Loc;
        NCBI_NS_NCBI::CUnionBuffer<TId> m_Id;
        NCBI_NS_NCBI::CUnionBuffer<TInterval> m_Interval;
        NCBI_NS_NCBI::CUnionBuffer<TInt1> m_Int1;
        NCBI_NS_NCBI::CUnionBuffer<TInt2> m_Int2;
        NCBI_NS_NCBI::CUnionBuffer<TInt8> m_Int8;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CSeqTable_multi_data_Base::E_Choice CSeqTable_multi_data_Base::Which(void) const
{
    return m_choice;
}

inline
void CSeqTable_multi_data_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CSeqTable_multi_data_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CSeqTable_multi_data_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CSeqTable_multi_data_Base::IsInt(void) const
{
    return m_choice == e_Int;
}

inline
const CSeqTable_multi_data_Base::TInt& CSeqTable_multi_data_Base::GetInt(void) const
{
    CheckSelected(e_Int);
    return *m_Int;
}

inline
CSeqTable_multi_data_Base::TInt& CSeqTable_multi_data_Base::SetInt(void)
{
    Select(e_Int, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Int;
}

inline
bool CSeqTable_multi_data_Base::IsReal(void) const
{
    return m_choice == e_Real;
}

inline
const CSeqTable_multi_data_Base::TReal& CSeqTable_multi_data_Base::GetReal(void) const
{
    CheckSelected(e_Real);
    return *m_Real;
}

inline
CSeqTable_multi_data_Base::TReal& CSeqTable_multi_data_Base::SetReal(void)
{
    Select(e_Real, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Real;
}

inline
bool CSeqTable_multi_data_Base::IsString(void) const
{
    return m_choice == e_String;
}

inline
const CSeqTable_multi_data_Base::TString& CSeqTable_multi_data_Base::GetString(void) const
{
    CheckSelected(e_String);
    return *m_String;
}

inline
CSeqTable_multi_data_Base::TString& CSeqTable_multi_data_Base::SetString(void)
{
    Select(e_String, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_String;
}

inline
bool CSeqTable_multi_data_Base::IsBytes(void) const
{
    return m_choice == e_Bytes;
}

inline
const CSeqTable_multi_data_Base::TBytes& CSeqTable_multi_data_Base::GetBytes(void) const
{
    CheckSelected(e_Bytes);
    return *m_Bytes;
}

inline
CSeqTable_multi_data_Base::TBytes& CSeqTable_multi_data_Base::SetBytes(void)
{
    Select(e_Bytes, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Bytes;
}

inline
bool CSeqTable_multi_data_Base::IsCommon_string(void) const
{
    return m_choice == e_Common_string;
}

inline
bool CSeqTable_multi_data_Base::IsCommon_bytes(void) const
{
    return m_choice == e_Common_bytes;
}

inline
bool CSeqTable_multi_data_Base::IsBit(void) const
{
    return m_choice == e_Bit;
}

inline
const CSeqTable_multi_data_Base::TBit& CSeqTable_multi_data_Base::GetBit(void) const
{
    CheckSelected(e_Bit);
    return *m_Bit;
}

inline
CSeqTable_multi_data_Base::TBit& CSeqTable_multi_data_Base::SetBit(void)
{
    Select(e_Bit, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Bit;
}

inline
bool CSeqTable_multi_data_Base::IsLoc(void) const
{
    return m_choice == e_Loc;
}

inline
const CSeqTable_multi_data_Base::TLoc& CSeqTable_multi_data_Base::GetLoc(void) const
{
    CheckSelected(e_Loc);
    return *m_Loc;
}

inline
CSeqTable_multi_data_Base::TLoc& CSeqTable_multi_data_Base::SetLoc(void)
{
    Select(e_Loc, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Loc;
}

inline
bool CSeqTable_multi_data_Base::IsId(void) const
{
    return m_choice == e_Id;
}

inline
const CSeqTable_multi_data_Base::TId& CSeqTable_multi_data_Base::GetId(void) const
{
    CheckSelected(e_Id);
    return *m_Id;
}

inline
CSeqTable_multi_data_Base::TId& CSeqTable_multi_data_Base::SetId(void)
{
    Select(e_Id, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Id;
}

inline
bool CSeqTable_multi_data_Base::IsInterval(void) const
{
    return m_choice == e_Interval;
}

inline
const CSeqTable_multi_data_Base::TInterval& CSeqTable_multi_data_Base::GetInterval(void) const
{
    CheckSelected(e_Interval);
    return *m_Interval;
}

inline
CSeqTable_multi_data_Base::TInterval& CSeqTable_multi_data_Base::SetInterval(void)
{
    Select(e_Interval, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Interval;
}

inline
bool CSeqTable_multi_data_Base::IsInt_delta(void) const
{
    return m_choice == e_Int_delta;
}

inline
bool CSeqTable_multi_data_Base::IsInt_scaled(void) const
{
    return m_choice == e_Int_scaled;
}

inline
bool CSeqTable_multi_data_Base::IsReal_scaled(void) const
{
    return m_choice == e_Real_scaled;
}

inline
bool CSeqTable_multi_data_Base::IsBit_bvector(void) const
{
    return m_choice == e_Bit_bvector;
}

inline
bool CSeqTable_multi_data_Base::IsInt1(void) const
{
    return m_choice == e_Int1;
}

inline
const CSeqTable_multi_data_Base::TInt1& CSeqTable_multi_data_Base::GetInt1(void) const
{
    CheckSelected(e_Int1);
    return *m_Int1;
}

inline
CSeqTable_multi_data_Base::TInt1& CSeqTable_multi_data_Base::SetInt1(void)
{
    Select(e_Int1, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Int1;
}

inline
bool CSeqTable_multi_data_Base::IsInt2(void) const
{
    return m_choice == e_Int2;
}

inline
const CSeqTable_multi_data_Base::TInt2& CSeqTable_multi_data_Base::GetInt2(void) const
{
    CheckSelected(e_Int2);
    return *m_Int2;
}

inline
CSeqTable_multi_data_Base::TInt2& CSeqTable_multi_data_Base::SetInt2(void)
{
    Select(e_Int2, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Int2;
}

inline
bool CSeqTable_multi_data_Base::IsInt8(void) const
{
    return m_choice == e_Int8;
}

inline
const CSeqTable_multi_data_Base::TInt8& CSeqTable_multi_data_Base::GetInt8(void) const
{
    CheckSelected(e_Int8);
    return *m_Int8;
}

inline
CSeqTable_multi_data_Base::TInt8& CSeqTable_multi_data_Base::SetInt8(void)
{
    Select(e_Int8, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Int8;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQTABLE_SEQTABLE_MULTI_DATA_BASE_HPP
