/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ID2S_Seq_id_Interval_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqsplit.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQSPLIT_ID2S_SEQ_ID_INTERVAL_BASE_HPP
#define OBJECTS_SEQSPLIT_ID2S_SEQ_ID_INTERVAL_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ID2_EXPORT CID2S_Seq_id_Interval_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CID2S_Seq_id_Interval_Base(void);
    // destructor
    virtual ~CID2S_Seq_id_Interval_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CSeq_id TSeq_id;
    typedef int TStart;
    typedef int TLength;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_seq_id,
        e_start,
        e_length
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CSeq_id TSeq_id
    ///  Check whether the Seq_id data member has been assigned a value.
    bool IsSetSeq_id(void) const;
    /// Check whether it is safe or not to call GetSeq_id method.
    bool CanGetSeq_id(void) const;
    void ResetSeq_id(void);
    const TSeq_id& GetSeq_id(void) const;
    void SetSeq_id(TSeq_id& value);
    TSeq_id& SetSeq_id(void);

    /// mandatory
    /// typedef int TStart
    ///  Check whether the Start data member has been assigned a value.
    bool IsSetStart(void) const;
    /// Check whether it is safe or not to call GetStart method.
    bool CanGetStart(void) const;
    void ResetStart(void);
    TStart GetStart(void) const;
    void SetStart(TStart value);
    TStart& SetStart(void);

    /// optional with default 1
    /// typedef int TLength
    ///  Check whether the Length data member has been assigned a value.
    bool IsSetLength(void) const;
    /// Check whether it is safe or not to call GetLength method.
    bool CanGetLength(void) const;
    void ResetLength(void);
    void SetDefaultLength(void);
    TLength GetLength(void) const;
    void SetLength(TLength value);
    TLength& SetLength(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CID2S_Seq_id_Interval_Base(const CID2S_Seq_id_Interval_Base&);
    CID2S_Seq_id_Interval_Base& operator=(const CID2S_Seq_id_Interval_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TSeq_id > m_Seq_id;
    int m_Start;
    int m_Length;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CID2S_Seq_id_Interval_Base::IsSetSeq_id(void) const
{
    return m_Seq_id.NotEmpty();
}

inline
bool CID2S_Seq_id_Interval_Base::CanGetSeq_id(void) const
{
    return true;
}

inline
const CID2S_Seq_id_Interval_Base::TSeq_id& CID2S_Seq_id_Interval_Base::GetSeq_id(void) const
{
    if ( !m_Seq_id ) {
        const_cast<CID2S_Seq_id_Interval_Base*>(this)->ResetSeq_id();
    }
    return (*m_Seq_id);
}

inline
CID2S_Seq_id_Interval_Base::TSeq_id& CID2S_Seq_id_Interval_Base::SetSeq_id(void)
{
    if ( !m_Seq_id ) {
        ResetSeq_id();
    }
    return (*m_Seq_id);
}

inline
bool CID2S_Seq_id_Interval_Base::IsSetStart(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CID2S_Seq_id_Interval_Base::CanGetStart(void) const
{
    return IsSetStart();
}

inline
void CID2S_Seq_id_Interval_Base::ResetStart(void)
{
    m_Start = 0;
    m_set_State[0] &= ~0xc;
}

inline
CID2S_Seq_id_Interval_Base::TStart CID2S_Seq_id_Interval_Base::GetStart(void) const
{
    if (!CanGetStart()) {
        ThrowUnassigned(1);
    }
    return m_Start;
}

inline
void CID2S_Seq_id_Interval_Base::SetStart(CID2S_Seq_id_Interval_Base::TStart value)
{
    m_Start = value;
    m_set_State[0] |= 0xc;
}

inline
CID2S_Seq_id_Interval_Base::TStart& CID2S_Seq_id_Interval_Base::SetStart(void)
{
#ifdef _DEBUG
    if (!IsSetStart()) {
        memset(&m_Start,UnassignedByte(),sizeof(m_Start));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Start;
}

inline
bool CID2S_Seq_id_Interval_Base::IsSetLength(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CID2S_Seq_id_Interval_Base::CanGetLength(void) const
{
    return true;
}

inline
void CID2S_Seq_id_Interval_Base::ResetLength(void)
{
    m_Length = 1;
    m_set_State[0] &= ~0x30;
}

inline
void CID2S_Seq_id_Interval_Base::SetDefaultLength(void)
{
    ResetLength();
}

inline
CID2S_Seq_id_Interval_Base::TLength CID2S_Seq_id_Interval_Base::GetLength(void) const
{
    return m_Length;
}

inline
void CID2S_Seq_id_Interval_Base::SetLength(CID2S_Seq_id_Interval_Base::TLength value)
{
    m_Length = value;
    m_set_State[0] |= 0x30;
}

inline
CID2S_Seq_id_Interval_Base::TLength& CID2S_Seq_id_Interval_Base::SetLength(void)
{
#ifdef _DEBUG
    if (!IsSetLength()) {
        memset(&m_Length,UnassignedByte(),sizeof(m_Length));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Length;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQSPLIT_ID2S_SEQ_ID_INTERVAL_BASE_HPP
