/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Txinit_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_TXINIT_BASE_HPP
#define OBJECTS_SEQFEAT_TXINIT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CGene_ref;
class COrg_ref;
class CProt_ref;
class CTx_evidence;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQFEAT_EXPORT CTxinit_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTxinit_Base(void);
    // destructor
    virtual ~CTxinit_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// transcription apparatus used at this site
    enum ETxsystem {
        eTxsystem_unknown   =   0,
        eTxsystem_pol1      =   1,  ///< eukaryotic Pol I
        eTxsystem_pol2      =   2,  ///< eukaryotic Pol II
        eTxsystem_pol3      =   3,  ///< eukaryotic Pol III
        eTxsystem_bacterial =   4,
        eTxsystem_viral     =   5,
        eTxsystem_rna       =   6,  ///< RNA replicase
        eTxsystem_organelle =   7,
        eTxsystem_other     = 255
    };
    
    /// Access to ETxsystem's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ETxsystem)(void);
    
    enum EInittype {
        eInittype_unknown  = 0,
        eInittype_single   = 1,
        eInittype_multiple = 2,
        eInittype_region   = 3
    };
    
    /// Access to EInittype's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EInittype)(void);
    
    // types
    typedef string TName;
    typedef list< string > TSyn;
    typedef list< CRef< CGene_ref > > TGene;
    typedef list< CRef< CProt_ref > > TProtein;
    typedef list< string > TRna;
    typedef string TExpression;
    typedef ETxsystem TTxsystem;
    typedef string TTxdescr;
    typedef COrg_ref TTxorg;
    typedef bool TMapping_precise;
    typedef bool TLocation_accurate;
    typedef EInittype TInittype;
    typedef list< CRef< CTx_evidence > > TEvidence;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_name,
        e_syn,
        e_gene,
        e_protein,
        e_rna,
        e_expression,
        e_txsystem,
        e_txdescr,
        e_txorg,
        e_mapping_precise,
        e_location_accurate,
        e_inittype,
        e_evidence
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 14> TmemberIndex;

    // getters
    // setters

    /// descriptive name of initiation site
    /// mandatory
    /// typedef string TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// synonyms
    /// optional
    /// typedef list< string > TSyn
    ///  Check whether the Syn data member has been assigned a value.
    bool IsSetSyn(void) const;
    /// Check whether it is safe or not to call GetSyn method.
    bool CanGetSyn(void) const;
    void ResetSyn(void);
    const TSyn& GetSyn(void) const;
    TSyn& SetSyn(void);

    /// gene(s) transcribed
    /// optional
    /// typedef list< CRef< CGene_ref > > TGene
    ///  Check whether the Gene data member has been assigned a value.
    bool IsSetGene(void) const;
    /// Check whether it is safe or not to call GetGene method.
    bool CanGetGene(void) const;
    void ResetGene(void);
    const TGene& GetGene(void) const;
    TGene& SetGene(void);

    /// protein(s) produced
    /// optional
    /// typedef list< CRef< CProt_ref > > TProtein
    ///  Check whether the Protein data member has been assigned a value.
    bool IsSetProtein(void) const;
    /// Check whether it is safe or not to call GetProtein method.
    bool CanGetProtein(void) const;
    void ResetProtein(void);
    const TProtein& GetProtein(void) const;
    TProtein& SetProtein(void);

    /// rna(s) produced
    /// optional
    /// typedef list< string > TRna
    ///  Check whether the Rna data member has been assigned a value.
    bool IsSetRna(void) const;
    /// Check whether it is safe or not to call GetRna method.
    bool CanGetRna(void) const;
    void ResetRna(void);
    const TRna& GetRna(void) const;
    TRna& SetRna(void);

    /// tissue/time of expression
    /// optional
    /// typedef string TExpression
    ///  Check whether the Expression data member has been assigned a value.
    bool IsSetExpression(void) const;
    /// Check whether it is safe or not to call GetExpression method.
    bool CanGetExpression(void) const;
    void ResetExpression(void);
    const TExpression& GetExpression(void) const;
    void SetExpression(const TExpression& value);
    void SetExpression(TExpression&& value);
    TExpression& SetExpression(void);

    /// mandatory
    /// typedef ETxsystem TTxsystem
    ///  Check whether the Txsystem data member has been assigned a value.
    bool IsSetTxsystem(void) const;
    /// Check whether it is safe or not to call GetTxsystem method.
    bool CanGetTxsystem(void) const;
    void ResetTxsystem(void);
    TTxsystem GetTxsystem(void) const;
    void SetTxsystem(TTxsystem value);
    TTxsystem& SetTxsystem(void);

    /// modifiers on txsystem
    /// optional
    /// typedef string TTxdescr
    ///  Check whether the Txdescr data member has been assigned a value.
    bool IsSetTxdescr(void) const;
    /// Check whether it is safe or not to call GetTxdescr method.
    bool CanGetTxdescr(void) const;
    void ResetTxdescr(void);
    const TTxdescr& GetTxdescr(void) const;
    void SetTxdescr(const TTxdescr& value);
    void SetTxdescr(TTxdescr&& value);
    TTxdescr& SetTxdescr(void);

    /// organism supplying transcription apparatus
    /// optional
    /// typedef COrg_ref TTxorg
    ///  Check whether the Txorg data member has been assigned a value.
    bool IsSetTxorg(void) const;
    /// Check whether it is safe or not to call GetTxorg method.
    bool CanGetTxorg(void) const;
    void ResetTxorg(void);
    const TTxorg& GetTxorg(void) const;
    void SetTxorg(TTxorg& value);
    TTxorg& SetTxorg(void);

    /// mapping precise or approx
    /// optional with default false
    /// typedef bool TMapping_precise
    ///  Check whether the Mapping_precise data member has been assigned a value.
    bool IsSetMapping_precise(void) const;
    /// Check whether it is safe or not to call GetMapping_precise method.
    bool CanGetMapping_precise(void) const;
    void ResetMapping_precise(void);
    void SetDefaultMapping_precise(void);
    TMapping_precise GetMapping_precise(void) const;
    void SetMapping_precise(TMapping_precise value);
    TMapping_precise& SetMapping_precise(void);

    /// does Seq-loc reflect mapping
    /// optional with default false
    /// typedef bool TLocation_accurate
    ///  Check whether the Location_accurate data member has been assigned a value.
    bool IsSetLocation_accurate(void) const;
    /// Check whether it is safe or not to call GetLocation_accurate method.
    bool CanGetLocation_accurate(void) const;
    void ResetLocation_accurate(void);
    void SetDefaultLocation_accurate(void);
    TLocation_accurate GetLocation_accurate(void) const;
    void SetLocation_accurate(TLocation_accurate value);
    TLocation_accurate& SetLocation_accurate(void);

    /// optional
    /// typedef EInittype TInittype
    ///  Check whether the Inittype data member has been assigned a value.
    bool IsSetInittype(void) const;
    /// Check whether it is safe or not to call GetInittype method.
    bool CanGetInittype(void) const;
    void ResetInittype(void);
    TInittype GetInittype(void) const;
    void SetInittype(TInittype value);
    TInittype& SetInittype(void);

    /// optional
    /// typedef list< CRef< CTx_evidence > > TEvidence
    ///  Check whether the Evidence data member has been assigned a value.
    bool IsSetEvidence(void) const;
    /// Check whether it is safe or not to call GetEvidence method.
    bool CanGetEvidence(void) const;
    void ResetEvidence(void);
    const TEvidence& GetEvidence(void) const;
    TEvidence& SetEvidence(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTxinit_Base(const CTxinit_Base&);
    CTxinit_Base& operator=(const CTxinit_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Name;
    list< string > m_Syn;
    list< CRef< CGene_ref > > m_Gene;
    list< CRef< CProt_ref > > m_Protein;
    list< string > m_Rna;
    string m_Expression;
    ETxsystem m_Txsystem;
    string m_Txdescr;
    CRef< TTxorg > m_Txorg;
    bool m_Mapping_precise;
    bool m_Location_accurate;
    EInittype m_Inittype;
    list< CRef< CTx_evidence > > m_Evidence;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTxinit_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTxinit_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CTxinit_Base::TName& CTxinit_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(0);
    }
    return m_Name;
}

inline
void CTxinit_Base::SetName(const CTxinit_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0x3;
}

inline
void CTxinit_Base::SetName(CTxinit_Base::TName&& value)
{
    m_Name = std::forward<CTxinit_Base::TName>(value);
    m_set_State[0] |= 0x3;
}

inline
CTxinit_Base::TName& CTxinit_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Name;
}

inline
bool CTxinit_Base::IsSetSyn(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTxinit_Base::CanGetSyn(void) const
{
    return true;
}

inline
const CTxinit_Base::TSyn& CTxinit_Base::GetSyn(void) const
{
    return m_Syn;
}

inline
CTxinit_Base::TSyn& CTxinit_Base::SetSyn(void)
{
    m_set_State[0] |= 0x4;
    return m_Syn;
}

inline
bool CTxinit_Base::IsSetGene(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CTxinit_Base::CanGetGene(void) const
{
    return true;
}

inline
const CTxinit_Base::TGene& CTxinit_Base::GetGene(void) const
{
    return m_Gene;
}

inline
CTxinit_Base::TGene& CTxinit_Base::SetGene(void)
{
    m_set_State[0] |= 0x10;
    return m_Gene;
}

inline
bool CTxinit_Base::IsSetProtein(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CTxinit_Base::CanGetProtein(void) const
{
    return true;
}

inline
const CTxinit_Base::TProtein& CTxinit_Base::GetProtein(void) const
{
    return m_Protein;
}

inline
CTxinit_Base::TProtein& CTxinit_Base::SetProtein(void)
{
    m_set_State[0] |= 0x40;
    return m_Protein;
}

inline
bool CTxinit_Base::IsSetRna(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CTxinit_Base::CanGetRna(void) const
{
    return true;
}

inline
const CTxinit_Base::TRna& CTxinit_Base::GetRna(void) const
{
    return m_Rna;
}

inline
CTxinit_Base::TRna& CTxinit_Base::SetRna(void)
{
    m_set_State[0] |= 0x100;
    return m_Rna;
}

inline
bool CTxinit_Base::IsSetExpression(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CTxinit_Base::CanGetExpression(void) const
{
    return IsSetExpression();
}

inline
const CTxinit_Base::TExpression& CTxinit_Base::GetExpression(void) const
{
    if (!CanGetExpression()) {
        ThrowUnassigned(5);
    }
    return m_Expression;
}

inline
void CTxinit_Base::SetExpression(const CTxinit_Base::TExpression& value)
{
    m_Expression = value;
    m_set_State[0] |= 0xc00;
}

inline
void CTxinit_Base::SetExpression(CTxinit_Base::TExpression&& value)
{
    m_Expression = std::forward<CTxinit_Base::TExpression>(value);
    m_set_State[0] |= 0xc00;
}

inline
CTxinit_Base::TExpression& CTxinit_Base::SetExpression(void)
{
#ifdef _DEBUG
    if (!IsSetExpression()) {
        m_Expression = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Expression;
}

inline
bool CTxinit_Base::IsSetTxsystem(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CTxinit_Base::CanGetTxsystem(void) const
{
    return IsSetTxsystem();
}

inline
void CTxinit_Base::ResetTxsystem(void)
{
    m_Txsystem = (ETxsystem)(0);
    m_set_State[0] &= ~0x3000;
}

inline
CTxinit_Base::TTxsystem CTxinit_Base::GetTxsystem(void) const
{
    if (!CanGetTxsystem()) {
        ThrowUnassigned(6);
    }
    return m_Txsystem;
}

inline
void CTxinit_Base::SetTxsystem(CTxinit_Base::TTxsystem value)
{
    m_Txsystem = value;
    m_set_State[0] |= 0x3000;
}

inline
CTxinit_Base::TTxsystem& CTxinit_Base::SetTxsystem(void)
{
#ifdef _DEBUG
    if (!IsSetTxsystem()) {
        memset(&m_Txsystem,UnassignedByte(),sizeof(m_Txsystem));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Txsystem;
}

inline
bool CTxinit_Base::IsSetTxdescr(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CTxinit_Base::CanGetTxdescr(void) const
{
    return IsSetTxdescr();
}

inline
const CTxinit_Base::TTxdescr& CTxinit_Base::GetTxdescr(void) const
{
    if (!CanGetTxdescr()) {
        ThrowUnassigned(7);
    }
    return m_Txdescr;
}

inline
void CTxinit_Base::SetTxdescr(const CTxinit_Base::TTxdescr& value)
{
    m_Txdescr = value;
    m_set_State[0] |= 0xc000;
}

inline
void CTxinit_Base::SetTxdescr(CTxinit_Base::TTxdescr&& value)
{
    m_Txdescr = std::forward<CTxinit_Base::TTxdescr>(value);
    m_set_State[0] |= 0xc000;
}

inline
CTxinit_Base::TTxdescr& CTxinit_Base::SetTxdescr(void)
{
#ifdef _DEBUG
    if (!IsSetTxdescr()) {
        m_Txdescr = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Txdescr;
}

inline
bool CTxinit_Base::IsSetTxorg(void) const
{
    return m_Txorg.NotEmpty();
}

inline
bool CTxinit_Base::CanGetTxorg(void) const
{
    return IsSetTxorg();
}

inline
const CTxinit_Base::TTxorg& CTxinit_Base::GetTxorg(void) const
{
    if (!CanGetTxorg()) {
        ThrowUnassigned(8);
    }
    return (*m_Txorg);
}

inline
bool CTxinit_Base::IsSetMapping_precise(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CTxinit_Base::CanGetMapping_precise(void) const
{
    return true;
}

inline
void CTxinit_Base::ResetMapping_precise(void)
{
    m_Mapping_precise = false;
    m_set_State[0] &= ~0xc0000;
}

inline
void CTxinit_Base::SetDefaultMapping_precise(void)
{
    ResetMapping_precise();
}

inline
CTxinit_Base::TMapping_precise CTxinit_Base::GetMapping_precise(void) const
{
    return m_Mapping_precise;
}

inline
void CTxinit_Base::SetMapping_precise(CTxinit_Base::TMapping_precise value)
{
    m_Mapping_precise = value;
    m_set_State[0] |= 0xc0000;
}

inline
CTxinit_Base::TMapping_precise& CTxinit_Base::SetMapping_precise(void)
{
#ifdef _DEBUG
    if (!IsSetMapping_precise()) {
        memset(&m_Mapping_precise,UnassignedByte(),sizeof(m_Mapping_precise));
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Mapping_precise;
}

inline
bool CTxinit_Base::IsSetLocation_accurate(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CTxinit_Base::CanGetLocation_accurate(void) const
{
    return true;
}

inline
void CTxinit_Base::ResetLocation_accurate(void)
{
    m_Location_accurate = false;
    m_set_State[0] &= ~0x300000;
}

inline
void CTxinit_Base::SetDefaultLocation_accurate(void)
{
    ResetLocation_accurate();
}

inline
CTxinit_Base::TLocation_accurate CTxinit_Base::GetLocation_accurate(void) const
{
    return m_Location_accurate;
}

inline
void CTxinit_Base::SetLocation_accurate(CTxinit_Base::TLocation_accurate value)
{
    m_Location_accurate = value;
    m_set_State[0] |= 0x300000;
}

inline
CTxinit_Base::TLocation_accurate& CTxinit_Base::SetLocation_accurate(void)
{
#ifdef _DEBUG
    if (!IsSetLocation_accurate()) {
        memset(&m_Location_accurate,UnassignedByte(),sizeof(m_Location_accurate));
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_Location_accurate;
}

inline
bool CTxinit_Base::IsSetInittype(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CTxinit_Base::CanGetInittype(void) const
{
    return IsSetInittype();
}

inline
void CTxinit_Base::ResetInittype(void)
{
    m_Inittype = (EInittype)(0);
    m_set_State[0] &= ~0xc00000;
}

inline
CTxinit_Base::TInittype CTxinit_Base::GetInittype(void) const
{
    if (!CanGetInittype()) {
        ThrowUnassigned(11);
    }
    return m_Inittype;
}

inline
void CTxinit_Base::SetInittype(CTxinit_Base::TInittype value)
{
    m_Inittype = value;
    m_set_State[0] |= 0xc00000;
}

inline
CTxinit_Base::TInittype& CTxinit_Base::SetInittype(void)
{
#ifdef _DEBUG
    if (!IsSetInittype()) {
        memset(&m_Inittype,UnassignedByte(),sizeof(m_Inittype));
    }
#endif
    m_set_State[0] |= 0x400000;
    return m_Inittype;
}

inline
bool CTxinit_Base::IsSetEvidence(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CTxinit_Base::CanGetEvidence(void) const
{
    return true;
}

inline
const CTxinit_Base::TEvidence& CTxinit_Base::GetEvidence(void) const
{
    return m_Evidence;
}

inline
CTxinit_Base::TEvidence& CTxinit_Base::SetEvidence(void)
{
    m_set_State[0] |= 0x1000000;
    return m_Evidence;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_TXINIT_BASE_HPP
