/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file SubSource_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_SUBSOURCE_BASE_HPP
#define OBJECTS_SEQFEAT_SUBSOURCE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQFEAT_EXPORT CSubSource_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSubSource_Base(void);
    // destructor
    virtual ~CSubSource_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum ESubtype {
        eSubtype_chromosome            =   1,
        eSubtype_map                   =   2,
        eSubtype_clone                 =   3,
        eSubtype_subclone              =   4,
        eSubtype_haplotype             =   5,
        eSubtype_genotype              =   6,
        eSubtype_sex                   =   7,
        eSubtype_cell_line             =   8,
        eSubtype_cell_type             =   9,
        eSubtype_tissue_type           =  10,
        eSubtype_clone_lib             =  11,
        eSubtype_dev_stage             =  12,
        eSubtype_frequency             =  13,
        eSubtype_germline              =  14,
        eSubtype_rearranged            =  15,
        eSubtype_lab_host              =  16,
        eSubtype_pop_variant           =  17,
        eSubtype_tissue_lib            =  18,
        eSubtype_plasmid_name          =  19,
        eSubtype_transposon_name       =  20,
        eSubtype_insertion_seq_name    =  21,
        eSubtype_plastid_name          =  22,
        eSubtype_country               =  23,
        eSubtype_segment               =  24,
        eSubtype_endogenous_virus_name =  25,
        eSubtype_transgenic            =  26,
        eSubtype_environmental_sample  =  27,
        eSubtype_isolation_source      =  28,
        eSubtype_lat_lon               =  29,  ///< +/- decimal degrees
        eSubtype_collection_date       =  30,  ///< DD-MMM-YYYY format
        eSubtype_collected_by          =  31,  ///< name of person who collected the sample
        eSubtype_identified_by         =  32,  ///< name of person who identified the sample
        eSubtype_fwd_primer_seq        =  33,  ///< sequence (possibly more than one; semicolon-separated)
        eSubtype_rev_primer_seq        =  34,  ///< sequence (possibly more than one; semicolon-separated)
        eSubtype_fwd_primer_name       =  35,
        eSubtype_rev_primer_name       =  36,
        eSubtype_metagenomic           =  37,
        eSubtype_mating_type           =  38,
        eSubtype_linkage_group         =  39,
        eSubtype_haplogroup            =  40,
        eSubtype_whole_replicon        =  41,
        eSubtype_phenotype             =  42,
        eSubtype_altitude              =  43,
        eSubtype_other                 = 255
    };
    
    /// Access to ESubtype's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ESubtype)(void);
    
    // types
    typedef int TSubtype;
    typedef string TName;
    typedef string TAttrib;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_subtype,
        e_name,
        e_attrib
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TSubtype
    ///  Check whether the Subtype data member has been assigned a value.
    bool IsSetSubtype(void) const;
    /// Check whether it is safe or not to call GetSubtype method.
    bool CanGetSubtype(void) const;
    void ResetSubtype(void);
    TSubtype GetSubtype(void) const;
    void SetSubtype(TSubtype value);
    TSubtype& SetSubtype(void);

    /// mandatory
    /// typedef string TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// attribution/source of this name
    /// optional
    /// typedef string TAttrib
    ///  Check whether the Attrib data member has been assigned a value.
    bool IsSetAttrib(void) const;
    /// Check whether it is safe or not to call GetAttrib method.
    bool CanGetAttrib(void) const;
    void ResetAttrib(void);
    const TAttrib& GetAttrib(void) const;
    void SetAttrib(const TAttrib& value);
    void SetAttrib(TAttrib&& value);
    TAttrib& SetAttrib(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSubSource_Base(const CSubSource_Base&);
    CSubSource_Base& operator=(const CSubSource_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Subtype;
    string m_Name;
    string m_Attrib;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSubSource_Base::IsSetSubtype(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSubSource_Base::CanGetSubtype(void) const
{
    return IsSetSubtype();
}

inline
void CSubSource_Base::ResetSubtype(void)
{
    m_Subtype = (ESubtype)(0);
    m_set_State[0] &= ~0x3;
}

inline
CSubSource_Base::TSubtype CSubSource_Base::GetSubtype(void) const
{
    if (!CanGetSubtype()) {
        ThrowUnassigned(0);
    }
    return m_Subtype;
}

inline
void CSubSource_Base::SetSubtype(CSubSource_Base::TSubtype value)
{
    m_Subtype = value;
    m_set_State[0] |= 0x3;
}

inline
CSubSource_Base::TSubtype& CSubSource_Base::SetSubtype(void)
{
#ifdef _DEBUG
    if (!IsSetSubtype()) {
        memset(&m_Subtype,UnassignedByte(),sizeof(m_Subtype));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Subtype;
}

inline
bool CSubSource_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSubSource_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CSubSource_Base::TName& CSubSource_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(1);
    }
    return m_Name;
}

inline
void CSubSource_Base::SetName(const CSubSource_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0xc;
}

inline
void CSubSource_Base::SetName(CSubSource_Base::TName&& value)
{
    m_Name = std::forward<CSubSource_Base::TName>(value);
    m_set_State[0] |= 0xc;
}

inline
CSubSource_Base::TName& CSubSource_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Name;
}

inline
bool CSubSource_Base::IsSetAttrib(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CSubSource_Base::CanGetAttrib(void) const
{
    return IsSetAttrib();
}

inline
const CSubSource_Base::TAttrib& CSubSource_Base::GetAttrib(void) const
{
    if (!CanGetAttrib()) {
        ThrowUnassigned(2);
    }
    return m_Attrib;
}

inline
void CSubSource_Base::SetAttrib(const CSubSource_Base::TAttrib& value)
{
    m_Attrib = value;
    m_set_State[0] |= 0x30;
}

inline
void CSubSource_Base::SetAttrib(CSubSource_Base::TAttrib&& value)
{
    m_Attrib = std::forward<CSubSource_Base::TAttrib>(value);
    m_set_State[0] |= 0x30;
}

inline
CSubSource_Base::TAttrib& CSubSource_Base::SetAttrib(void)
{
#ifdef _DEBUG
    if (!IsSetAttrib()) {
        m_Attrib = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Attrib;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_SUBSOURCE_BASE_HPP
