/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Org_ref_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_ORG_REF_BASE_HPP
#define OBJECTS_SEQFEAT_ORG_REF_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <vector>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDbtag;
class COrgName;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///*** Org-ref ***********************************************
///*
///*  Reference to an organism
///*     defines only the organism.. lower levels of detail for biological
///*     molecules are provided by the Source object
///*
class NCBI_SEQFEAT_EXPORT COrg_ref_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    COrg_ref_Base(void);
    // destructor
    virtual ~COrg_ref_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TTaxname;
    typedef string TCommon;
    typedef list< string > TMod;
    typedef vector< CRef< CDbtag > > TDb;
    typedef list< string > TSyn;
    typedef COrgName TOrgname;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_taxname,
        e_common,
        e_mod,
        e_db,
        e_syn,
        e_orgname
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// preferred formal name
    /// optional
    /// typedef string TTaxname
    ///  Check whether the Taxname data member has been assigned a value.
    bool IsSetTaxname(void) const;
    /// Check whether it is safe or not to call GetTaxname method.
    bool CanGetTaxname(void) const;
    void ResetTaxname(void);
    const TTaxname& GetTaxname(void) const;
    void SetTaxname(const TTaxname& value);
    void SetTaxname(TTaxname&& value);
    TTaxname& SetTaxname(void);

    /// common name
    /// optional
    /// typedef string TCommon
    ///  Check whether the Common data member has been assigned a value.
    bool IsSetCommon(void) const;
    /// Check whether it is safe or not to call GetCommon method.
    bool CanGetCommon(void) const;
    void ResetCommon(void);
    const TCommon& GetCommon(void) const;
    void SetCommon(const TCommon& value);
    void SetCommon(TCommon&& value);
    TCommon& SetCommon(void);

    /// unstructured modifiers
    /// optional
    /// typedef list< string > TMod
    ///  Check whether the Mod data member has been assigned a value.
    bool IsSetMod(void) const;
    /// Check whether it is safe or not to call GetMod method.
    bool CanGetMod(void) const;
    void ResetMod(void);
    const TMod& GetMod(void) const;
    TMod& SetMod(void);

    /// ids in taxonomic or culture dbases
    /// optional
    /// typedef vector< CRef< CDbtag > > TDb
    ///  Check whether the Db data member has been assigned a value.
    bool IsSetDb(void) const;
    /// Check whether it is safe or not to call GetDb method.
    bool CanGetDb(void) const;
    void ResetDb(void);
    const TDb& GetDb(void) const;
    TDb& SetDb(void);

    /// synonyms for taxname or common
    /// optional
    /// typedef list< string > TSyn
    ///  Check whether the Syn data member has been assigned a value.
    bool IsSetSyn(void) const;
    /// Check whether it is safe or not to call GetSyn method.
    bool CanGetSyn(void) const;
    void ResetSyn(void);
    const TSyn& GetSyn(void) const;
    TSyn& SetSyn(void);

    /// optional
    /// typedef COrgName TOrgname
    ///  Check whether the Orgname data member has been assigned a value.
    bool IsSetOrgname(void) const;
    /// Check whether it is safe or not to call GetOrgname method.
    bool CanGetOrgname(void) const;
    void ResetOrgname(void);
    const TOrgname& GetOrgname(void) const;
    void SetOrgname(TOrgname& value);
    TOrgname& SetOrgname(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    COrg_ref_Base(const COrg_ref_Base&);
    COrg_ref_Base& operator=(const COrg_ref_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Taxname;
    string m_Common;
    list< string > m_Mod;
    vector< CRef< CDbtag > > m_Db;
    list< string > m_Syn;
    CRef< TOrgname > m_Orgname;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool COrg_ref_Base::IsSetTaxname(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool COrg_ref_Base::CanGetTaxname(void) const
{
    return IsSetTaxname();
}

inline
const COrg_ref_Base::TTaxname& COrg_ref_Base::GetTaxname(void) const
{
    if (!CanGetTaxname()) {
        ThrowUnassigned(0);
    }
    return m_Taxname;
}

inline
void COrg_ref_Base::SetTaxname(const COrg_ref_Base::TTaxname& value)
{
    m_Taxname = value;
    m_set_State[0] |= 0x3;
}

inline
void COrg_ref_Base::SetTaxname(COrg_ref_Base::TTaxname&& value)
{
    m_Taxname = std::forward<COrg_ref_Base::TTaxname>(value);
    m_set_State[0] |= 0x3;
}

inline
COrg_ref_Base::TTaxname& COrg_ref_Base::SetTaxname(void)
{
#ifdef _DEBUG
    if (!IsSetTaxname()) {
        m_Taxname = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Taxname;
}

inline
bool COrg_ref_Base::IsSetCommon(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool COrg_ref_Base::CanGetCommon(void) const
{
    return IsSetCommon();
}

inline
const COrg_ref_Base::TCommon& COrg_ref_Base::GetCommon(void) const
{
    if (!CanGetCommon()) {
        ThrowUnassigned(1);
    }
    return m_Common;
}

inline
void COrg_ref_Base::SetCommon(const COrg_ref_Base::TCommon& value)
{
    m_Common = value;
    m_set_State[0] |= 0xc;
}

inline
void COrg_ref_Base::SetCommon(COrg_ref_Base::TCommon&& value)
{
    m_Common = std::forward<COrg_ref_Base::TCommon>(value);
    m_set_State[0] |= 0xc;
}

inline
COrg_ref_Base::TCommon& COrg_ref_Base::SetCommon(void)
{
#ifdef _DEBUG
    if (!IsSetCommon()) {
        m_Common = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Common;
}

inline
bool COrg_ref_Base::IsSetMod(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool COrg_ref_Base::CanGetMod(void) const
{
    return true;
}

inline
const COrg_ref_Base::TMod& COrg_ref_Base::GetMod(void) const
{
    return m_Mod;
}

inline
COrg_ref_Base::TMod& COrg_ref_Base::SetMod(void)
{
    m_set_State[0] |= 0x10;
    return m_Mod;
}

inline
bool COrg_ref_Base::IsSetDb(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool COrg_ref_Base::CanGetDb(void) const
{
    return true;
}

inline
const COrg_ref_Base::TDb& COrg_ref_Base::GetDb(void) const
{
    return m_Db;
}

inline
COrg_ref_Base::TDb& COrg_ref_Base::SetDb(void)
{
    m_set_State[0] |= 0x40;
    return m_Db;
}

inline
bool COrg_ref_Base::IsSetSyn(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool COrg_ref_Base::CanGetSyn(void) const
{
    return true;
}

inline
const COrg_ref_Base::TSyn& COrg_ref_Base::GetSyn(void) const
{
    return m_Syn;
}

inline
COrg_ref_Base::TSyn& COrg_ref_Base::SetSyn(void)
{
    m_set_State[0] |= 0x100;
    return m_Syn;
}

inline
bool COrg_ref_Base::IsSetOrgname(void) const
{
    return m_Orgname.NotEmpty();
}

inline
bool COrg_ref_Base::CanGetOrgname(void) const
{
    return IsSetOrgname();
}

inline
const COrg_ref_Base::TOrgname& COrg_ref_Base::GetOrgname(void) const
{
    if (!CanGetOrgname()) {
        ThrowUnassigned(5);
    }
    return (*m_Orgname);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_ORG_REF_BASE_HPP
