/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ModelEvidenceSupport_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_MODELEVIDENCESUPPORT_BASE_HPP
#define OBJECTS_SEQFEAT_MODELEVIDENCESUPPORT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDbtag;
class CModelEvidenceItem;
class CSeq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQFEAT_EXPORT CModelEvidenceSupport_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CModelEvidenceSupport_Base(void);
    // destructor
    virtual ~CModelEvidenceSupport_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TMethod;
    typedef list< CRef< CModelEvidenceItem > > TMrna;
    typedef list< CRef< CModelEvidenceItem > > TEst;
    typedef list< CRef< CModelEvidenceItem > > TProtein;
    typedef CSeq_id TIdentification;
    typedef list< CRef< CDbtag > > TDbxref;
    typedef int TExon_count;
    typedef int TExon_length;
    typedef bool TFull_length;
    typedef bool TSupports_all_exon_combo;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_method,
        e_mrna,
        e_est,
        e_protein,
        e_identification,
        e_dbxref,
        e_exon_count,
        e_exon_length,
        e_full_length,
        e_supports_all_exon_combo
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 11> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef string TMethod
    ///  Check whether the Method data member has been assigned a value.
    bool IsSetMethod(void) const;
    /// Check whether it is safe or not to call GetMethod method.
    bool CanGetMethod(void) const;
    void ResetMethod(void);
    const TMethod& GetMethod(void) const;
    void SetMethod(const TMethod& value);
    void SetMethod(TMethod&& value);
    TMethod& SetMethod(void);

    /// optional
    /// typedef list< CRef< CModelEvidenceItem > > TMrna
    ///  Check whether the Mrna data member has been assigned a value.
    bool IsSetMrna(void) const;
    /// Check whether it is safe or not to call GetMrna method.
    bool CanGetMrna(void) const;
    void ResetMrna(void);
    const TMrna& GetMrna(void) const;
    TMrna& SetMrna(void);

    /// optional
    /// typedef list< CRef< CModelEvidenceItem > > TEst
    ///  Check whether the Est data member has been assigned a value.
    bool IsSetEst(void) const;
    /// Check whether it is safe or not to call GetEst method.
    bool CanGetEst(void) const;
    void ResetEst(void);
    const TEst& GetEst(void) const;
    TEst& SetEst(void);

    /// optional
    /// typedef list< CRef< CModelEvidenceItem > > TProtein
    ///  Check whether the Protein data member has been assigned a value.
    bool IsSetProtein(void) const;
    /// Check whether it is safe or not to call GetProtein method.
    bool CanGetProtein(void) const;
    void ResetProtein(void);
    const TProtein& GetProtein(void) const;
    TProtein& SetProtein(void);

    /// optional
    /// typedef CSeq_id TIdentification
    ///  Check whether the Identification data member has been assigned a value.
    bool IsSetIdentification(void) const;
    /// Check whether it is safe or not to call GetIdentification method.
    bool CanGetIdentification(void) const;
    void ResetIdentification(void);
    const TIdentification& GetIdentification(void) const;
    void SetIdentification(TIdentification& value);
    TIdentification& SetIdentification(void);

    /// optional
    /// typedef list< CRef< CDbtag > > TDbxref
    ///  Check whether the Dbxref data member has been assigned a value.
    bool IsSetDbxref(void) const;
    /// Check whether it is safe or not to call GetDbxref method.
    bool CanGetDbxref(void) const;
    void ResetDbxref(void);
    const TDbxref& GetDbxref(void) const;
    TDbxref& SetDbxref(void);

    /// optional
    /// typedef int TExon_count
    ///  Check whether the Exon_count data member has been assigned a value.
    bool IsSetExon_count(void) const;
    /// Check whether it is safe or not to call GetExon_count method.
    bool CanGetExon_count(void) const;
    void ResetExon_count(void);
    TExon_count GetExon_count(void) const;
    void SetExon_count(TExon_count value);
    TExon_count& SetExon_count(void);

    /// optional
    /// typedef int TExon_length
    ///  Check whether the Exon_length data member has been assigned a value.
    bool IsSetExon_length(void) const;
    /// Check whether it is safe or not to call GetExon_length method.
    bool CanGetExon_length(void) const;
    void ResetExon_length(void);
    TExon_length GetExon_length(void) const;
    void SetExon_length(TExon_length value);
    TExon_length& SetExon_length(void);

    /// optional with default false
    /// typedef bool TFull_length
    ///  Check whether the Full_length data member has been assigned a value.
    bool IsSetFull_length(void) const;
    /// Check whether it is safe or not to call GetFull_length method.
    bool CanGetFull_length(void) const;
    void ResetFull_length(void);
    void SetDefaultFull_length(void);
    TFull_length GetFull_length(void) const;
    void SetFull_length(TFull_length value);
    TFull_length& SetFull_length(void);

    /// optional with default false
    /// typedef bool TSupports_all_exon_combo
    ///  Check whether the Supports_all_exon_combo data member has been assigned a value.
    bool IsSetSupports_all_exon_combo(void) const;
    /// Check whether it is safe or not to call GetSupports_all_exon_combo method.
    bool CanGetSupports_all_exon_combo(void) const;
    void ResetSupports_all_exon_combo(void);
    void SetDefaultSupports_all_exon_combo(void);
    TSupports_all_exon_combo GetSupports_all_exon_combo(void) const;
    void SetSupports_all_exon_combo(TSupports_all_exon_combo value);
    TSupports_all_exon_combo& SetSupports_all_exon_combo(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CModelEvidenceSupport_Base(const CModelEvidenceSupport_Base&);
    CModelEvidenceSupport_Base& operator=(const CModelEvidenceSupport_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Method;
    list< CRef< CModelEvidenceItem > > m_Mrna;
    list< CRef< CModelEvidenceItem > > m_Est;
    list< CRef< CModelEvidenceItem > > m_Protein;
    CRef< TIdentification > m_Identification;
    list< CRef< CDbtag > > m_Dbxref;
    int m_Exon_count;
    int m_Exon_length;
    bool m_Full_length;
    bool m_Supports_all_exon_combo;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CModelEvidenceSupport_Base::IsSetMethod(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CModelEvidenceSupport_Base::CanGetMethod(void) const
{
    return IsSetMethod();
}

inline
const CModelEvidenceSupport_Base::TMethod& CModelEvidenceSupport_Base::GetMethod(void) const
{
    if (!CanGetMethod()) {
        ThrowUnassigned(0);
    }
    return m_Method;
}

inline
void CModelEvidenceSupport_Base::SetMethod(const CModelEvidenceSupport_Base::TMethod& value)
{
    m_Method = value;
    m_set_State[0] |= 0x3;
}

inline
void CModelEvidenceSupport_Base::SetMethod(CModelEvidenceSupport_Base::TMethod&& value)
{
    m_Method = std::forward<CModelEvidenceSupport_Base::TMethod>(value);
    m_set_State[0] |= 0x3;
}

inline
CModelEvidenceSupport_Base::TMethod& CModelEvidenceSupport_Base::SetMethod(void)
{
#ifdef _DEBUG
    if (!IsSetMethod()) {
        m_Method = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Method;
}

inline
bool CModelEvidenceSupport_Base::IsSetMrna(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CModelEvidenceSupport_Base::CanGetMrna(void) const
{
    return true;
}

inline
const CModelEvidenceSupport_Base::TMrna& CModelEvidenceSupport_Base::GetMrna(void) const
{
    return m_Mrna;
}

inline
CModelEvidenceSupport_Base::TMrna& CModelEvidenceSupport_Base::SetMrna(void)
{
    m_set_State[0] |= 0x4;
    return m_Mrna;
}

inline
bool CModelEvidenceSupport_Base::IsSetEst(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CModelEvidenceSupport_Base::CanGetEst(void) const
{
    return true;
}

inline
const CModelEvidenceSupport_Base::TEst& CModelEvidenceSupport_Base::GetEst(void) const
{
    return m_Est;
}

inline
CModelEvidenceSupport_Base::TEst& CModelEvidenceSupport_Base::SetEst(void)
{
    m_set_State[0] |= 0x10;
    return m_Est;
}

inline
bool CModelEvidenceSupport_Base::IsSetProtein(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CModelEvidenceSupport_Base::CanGetProtein(void) const
{
    return true;
}

inline
const CModelEvidenceSupport_Base::TProtein& CModelEvidenceSupport_Base::GetProtein(void) const
{
    return m_Protein;
}

inline
CModelEvidenceSupport_Base::TProtein& CModelEvidenceSupport_Base::SetProtein(void)
{
    m_set_State[0] |= 0x40;
    return m_Protein;
}

inline
bool CModelEvidenceSupport_Base::IsSetIdentification(void) const
{
    return m_Identification.NotEmpty();
}

inline
bool CModelEvidenceSupport_Base::CanGetIdentification(void) const
{
    return IsSetIdentification();
}

inline
const CModelEvidenceSupport_Base::TIdentification& CModelEvidenceSupport_Base::GetIdentification(void) const
{
    if (!CanGetIdentification()) {
        ThrowUnassigned(4);
    }
    return (*m_Identification);
}

inline
bool CModelEvidenceSupport_Base::IsSetDbxref(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CModelEvidenceSupport_Base::CanGetDbxref(void) const
{
    return true;
}

inline
const CModelEvidenceSupport_Base::TDbxref& CModelEvidenceSupport_Base::GetDbxref(void) const
{
    return m_Dbxref;
}

inline
CModelEvidenceSupport_Base::TDbxref& CModelEvidenceSupport_Base::SetDbxref(void)
{
    m_set_State[0] |= 0x400;
    return m_Dbxref;
}

inline
bool CModelEvidenceSupport_Base::IsSetExon_count(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CModelEvidenceSupport_Base::CanGetExon_count(void) const
{
    return IsSetExon_count();
}

inline
void CModelEvidenceSupport_Base::ResetExon_count(void)
{
    m_Exon_count = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CModelEvidenceSupport_Base::TExon_count CModelEvidenceSupport_Base::GetExon_count(void) const
{
    if (!CanGetExon_count()) {
        ThrowUnassigned(6);
    }
    return m_Exon_count;
}

inline
void CModelEvidenceSupport_Base::SetExon_count(CModelEvidenceSupport_Base::TExon_count value)
{
    m_Exon_count = value;
    m_set_State[0] |= 0x3000;
}

inline
CModelEvidenceSupport_Base::TExon_count& CModelEvidenceSupport_Base::SetExon_count(void)
{
#ifdef _DEBUG
    if (!IsSetExon_count()) {
        memset(&m_Exon_count,UnassignedByte(),sizeof(m_Exon_count));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Exon_count;
}

inline
bool CModelEvidenceSupport_Base::IsSetExon_length(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CModelEvidenceSupport_Base::CanGetExon_length(void) const
{
    return IsSetExon_length();
}

inline
void CModelEvidenceSupport_Base::ResetExon_length(void)
{
    m_Exon_length = 0;
    m_set_State[0] &= ~0xc000;
}

inline
CModelEvidenceSupport_Base::TExon_length CModelEvidenceSupport_Base::GetExon_length(void) const
{
    if (!CanGetExon_length()) {
        ThrowUnassigned(7);
    }
    return m_Exon_length;
}

inline
void CModelEvidenceSupport_Base::SetExon_length(CModelEvidenceSupport_Base::TExon_length value)
{
    m_Exon_length = value;
    m_set_State[0] |= 0xc000;
}

inline
CModelEvidenceSupport_Base::TExon_length& CModelEvidenceSupport_Base::SetExon_length(void)
{
#ifdef _DEBUG
    if (!IsSetExon_length()) {
        memset(&m_Exon_length,UnassignedByte(),sizeof(m_Exon_length));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Exon_length;
}

inline
bool CModelEvidenceSupport_Base::IsSetFull_length(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CModelEvidenceSupport_Base::CanGetFull_length(void) const
{
    return true;
}

inline
void CModelEvidenceSupport_Base::ResetFull_length(void)
{
    m_Full_length = false;
    m_set_State[0] &= ~0x30000;
}

inline
void CModelEvidenceSupport_Base::SetDefaultFull_length(void)
{
    ResetFull_length();
}

inline
CModelEvidenceSupport_Base::TFull_length CModelEvidenceSupport_Base::GetFull_length(void) const
{
    return m_Full_length;
}

inline
void CModelEvidenceSupport_Base::SetFull_length(CModelEvidenceSupport_Base::TFull_length value)
{
    m_Full_length = value;
    m_set_State[0] |= 0x30000;
}

inline
CModelEvidenceSupport_Base::TFull_length& CModelEvidenceSupport_Base::SetFull_length(void)
{
#ifdef _DEBUG
    if (!IsSetFull_length()) {
        memset(&m_Full_length,UnassignedByte(),sizeof(m_Full_length));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Full_length;
}

inline
bool CModelEvidenceSupport_Base::IsSetSupports_all_exon_combo(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CModelEvidenceSupport_Base::CanGetSupports_all_exon_combo(void) const
{
    return true;
}

inline
void CModelEvidenceSupport_Base::ResetSupports_all_exon_combo(void)
{
    m_Supports_all_exon_combo = false;
    m_set_State[0] &= ~0xc0000;
}

inline
void CModelEvidenceSupport_Base::SetDefaultSupports_all_exon_combo(void)
{
    ResetSupports_all_exon_combo();
}

inline
CModelEvidenceSupport_Base::TSupports_all_exon_combo CModelEvidenceSupport_Base::GetSupports_all_exon_combo(void) const
{
    return m_Supports_all_exon_combo;
}

inline
void CModelEvidenceSupport_Base::SetSupports_all_exon_combo(CModelEvidenceSupport_Base::TSupports_all_exon_combo value)
{
    m_Supports_all_exon_combo = value;
    m_set_State[0] |= 0xc0000;
}

inline
CModelEvidenceSupport_Base::TSupports_all_exon_combo& CModelEvidenceSupport_Base::SetSupports_all_exon_combo(void)
{
#ifdef _DEBUG
    if (!IsSetSupports_all_exon_combo()) {
        memset(&m_Supports_all_exon_combo,UnassignedByte(),sizeof(m_Supports_all_exon_combo));
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Supports_all_exon_combo;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_MODELEVIDENCESUPPORT_BASE_HPP
