/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Genetic_code_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_GENETIC_CODE_BASE_HPP
#define OBJECTS_SEQFEAT_GENETIC_CODE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <vector>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// each code is 64 cells long, in the order where
/// T=0,C=1,A=2,G=3, TTT=0, TTC=1, TCA=4, etc
/// NOTE: this order does NOT correspond to a Seq-data
/// encoding.  It is "natural" to codon usage instead.
/// the value in each cell is the AA coded for
/// start= AA coded only if first in peptide
///   in start array, if codon is not a legitimate start
///   codon, that cell will have the "gap" symbol for
///   that alphabet.  Otherwise it will have the AA
///   encoded when that codon is used at the start.
class NCBI_SEQFEAT_EXPORT CGenetic_code_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGenetic_code_Base(void);
    // destructor
    virtual ~CGenetic_code_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_SEQFEAT_EXPORT C_E : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_E(void);
        // destructor
        ~C_E(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Name,         ///< name of a code
            e_Id,           ///< id in dbase
            e_Ncbieaa,      ///< indexed to IUPAC extended
            e_Ncbi8aa,      ///< indexed to NCBI8aa
            e_Ncbistdaa,    ///< indexed to NCBIstdaa
            e_Sncbieaa,     ///< start, indexed to IUPAC extended
            e_Sncbi8aa,     ///< start, indexed to NCBI8aa
            e_Sncbistdaa    ///< start, indexed to NCBIstdaa
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 9 ///< == e_Sncbistdaa+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef string TName;
        typedef int TId;
        typedef string TNcbieaa;
        typedef vector< char > TNcbi8aa;
        typedef vector< char > TNcbistdaa;
        typedef string TSncbieaa;
        typedef vector< char > TSncbi8aa;
        typedef vector< char > TSncbistdaa;
    
        // getters
        // setters
    
        // typedef string TName
        bool IsName(void) const;
        const TName& GetName(void) const;
        TName& SetName(void);
        void SetName(const TName& value);
    
        // typedef int TId
        bool IsId(void) const;
        TId GetId(void) const;
        TId& SetId(void);
        void SetId(TId value);
    
        // typedef string TNcbieaa
        bool IsNcbieaa(void) const;
        const TNcbieaa& GetNcbieaa(void) const;
        TNcbieaa& SetNcbieaa(void);
        void SetNcbieaa(const TNcbieaa& value);
    
        // typedef vector< char > TNcbi8aa
        bool IsNcbi8aa(void) const;
        const TNcbi8aa& GetNcbi8aa(void) const;
        TNcbi8aa& SetNcbi8aa(void);
    
        // typedef vector< char > TNcbistdaa
        bool IsNcbistdaa(void) const;
        const TNcbistdaa& GetNcbistdaa(void) const;
        TNcbistdaa& SetNcbistdaa(void);
    
        // typedef string TSncbieaa
        bool IsSncbieaa(void) const;
        const TSncbieaa& GetSncbieaa(void) const;
        TSncbieaa& SetSncbieaa(void);
        void SetSncbieaa(const TSncbieaa& value);
    
        // typedef vector< char > TSncbi8aa
        bool IsSncbi8aa(void) const;
        const TSncbi8aa& GetSncbi8aa(void) const;
        TSncbi8aa& SetSncbi8aa(void);
    
        // typedef vector< char > TSncbistdaa
        bool IsSncbistdaa(void) const;
        const TSncbistdaa& GetSncbistdaa(void) const;
        TSncbistdaa& SetSncbistdaa(void);
    
    
    private:
        // copy constructor and assignment operator
        C_E(const C_E& );
        C_E& operator=(const C_E& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            TId m_Id;
            NCBI_NS_NCBI::CUnionBuffer<TNcbi8aa> m_Ncbi8aa;
            NCBI_NS_NCBI::CUnionBuffer<TNcbistdaa> m_Ncbistdaa;
            NCBI_NS_NCBI::CUnionBuffer<TSncbi8aa> m_Sncbi8aa;
            NCBI_NS_NCBI::CUnionBuffer<TSncbistdaa> m_Sncbistdaa;
            NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
            void* m_dummy_pointer_for_alignment;
        };
    };
    // types
    typedef list< CRef< C_E > > Tdata;

    // getters
    // setters

    /// mandatory
    /// typedef list< CRef< C_E > > Tdata
    ///  Check whether the  data member has been assigned a value.
    bool IsSet(void) const;
    /// Check whether it is safe or not to call Get method.
    bool CanGet(void) const;
    void Reset(void);
    const Tdata& Get(void) const;
    Tdata& Set(void);

    /// Conversion operator to 'const Tdata' type.
    operator const Tdata& (void) const;
    /// Conversion operator to 'Tdata' type.
    operator Tdata& (void);



private:
    // Prohibit copy constructor and assignment operator
    CGenetic_code_Base(const CGenetic_code_Base&);
    CGenetic_code_Base& operator=(const CGenetic_code_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< C_E > > m_data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CGenetic_code_Base::C_E::E_Choice CGenetic_code_Base::C_E::Which(void) const
{
    return m_choice;
}

inline
void CGenetic_code_Base::C_E::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CGenetic_code_Base::C_E::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CGenetic_code_Base::C_E::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CGenetic_code_Base::C_E::IsName(void) const
{
    return m_choice == e_Name;
}

inline
const CGenetic_code_Base::C_E::TName& CGenetic_code_Base::C_E::GetName(void) const
{
    CheckSelected(e_Name);
    return *m_string;
}

inline
CGenetic_code_Base::C_E::TName& CGenetic_code_Base::C_E::SetName(void)
{
    Select(e_Name, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CGenetic_code_Base::C_E::IsId(void) const
{
    return m_choice == e_Id;
}

inline
CGenetic_code_Base::C_E::TId CGenetic_code_Base::C_E::GetId(void) const
{
    CheckSelected(e_Id);
    return m_Id;
}

inline
CGenetic_code_Base::C_E::TId& CGenetic_code_Base::C_E::SetId(void)
{
    Select(e_Id, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Id;
}

inline
void CGenetic_code_Base::C_E::SetId(CGenetic_code_Base::C_E::TId value)
{
    Select(e_Id, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Id = value;
}

inline
bool CGenetic_code_Base::C_E::IsNcbieaa(void) const
{
    return m_choice == e_Ncbieaa;
}

inline
const CGenetic_code_Base::C_E::TNcbieaa& CGenetic_code_Base::C_E::GetNcbieaa(void) const
{
    CheckSelected(e_Ncbieaa);
    return *m_string;
}

inline
CGenetic_code_Base::C_E::TNcbieaa& CGenetic_code_Base::C_E::SetNcbieaa(void)
{
    Select(e_Ncbieaa, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CGenetic_code_Base::C_E::IsNcbi8aa(void) const
{
    return m_choice == e_Ncbi8aa;
}

inline
const CGenetic_code_Base::C_E::TNcbi8aa& CGenetic_code_Base::C_E::GetNcbi8aa(void) const
{
    CheckSelected(e_Ncbi8aa);
    return *m_Ncbi8aa;
}

inline
CGenetic_code_Base::C_E::TNcbi8aa& CGenetic_code_Base::C_E::SetNcbi8aa(void)
{
    Select(e_Ncbi8aa, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Ncbi8aa;
}

inline
bool CGenetic_code_Base::C_E::IsNcbistdaa(void) const
{
    return m_choice == e_Ncbistdaa;
}

inline
const CGenetic_code_Base::C_E::TNcbistdaa& CGenetic_code_Base::C_E::GetNcbistdaa(void) const
{
    CheckSelected(e_Ncbistdaa);
    return *m_Ncbistdaa;
}

inline
CGenetic_code_Base::C_E::TNcbistdaa& CGenetic_code_Base::C_E::SetNcbistdaa(void)
{
    Select(e_Ncbistdaa, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Ncbistdaa;
}

inline
bool CGenetic_code_Base::C_E::IsSncbieaa(void) const
{
    return m_choice == e_Sncbieaa;
}

inline
const CGenetic_code_Base::C_E::TSncbieaa& CGenetic_code_Base::C_E::GetSncbieaa(void) const
{
    CheckSelected(e_Sncbieaa);
    return *m_string;
}

inline
CGenetic_code_Base::C_E::TSncbieaa& CGenetic_code_Base::C_E::SetSncbieaa(void)
{
    Select(e_Sncbieaa, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CGenetic_code_Base::C_E::IsSncbi8aa(void) const
{
    return m_choice == e_Sncbi8aa;
}

inline
const CGenetic_code_Base::C_E::TSncbi8aa& CGenetic_code_Base::C_E::GetSncbi8aa(void) const
{
    CheckSelected(e_Sncbi8aa);
    return *m_Sncbi8aa;
}

inline
CGenetic_code_Base::C_E::TSncbi8aa& CGenetic_code_Base::C_E::SetSncbi8aa(void)
{
    Select(e_Sncbi8aa, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Sncbi8aa;
}

inline
bool CGenetic_code_Base::C_E::IsSncbistdaa(void) const
{
    return m_choice == e_Sncbistdaa;
}

inline
const CGenetic_code_Base::C_E::TSncbistdaa& CGenetic_code_Base::C_E::GetSncbistdaa(void) const
{
    CheckSelected(e_Sncbistdaa);
    return *m_Sncbistdaa;
}

inline
CGenetic_code_Base::C_E::TSncbistdaa& CGenetic_code_Base::C_E::SetSncbistdaa(void)
{
    Select(e_Sncbistdaa, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Sncbistdaa;
}

inline
bool CGenetic_code_Base::IsSet(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGenetic_code_Base::CanGet(void) const
{
    return true;
}

inline
const CGenetic_code_Base::Tdata& CGenetic_code_Base::Get(void) const
{
    return m_data;
}

inline
CGenetic_code_Base::Tdata& CGenetic_code_Base::Set(void)
{
    m_set_State[0] |= 0x1;
    return m_data;
}

inline
CGenetic_code_Base::operator const CGenetic_code_Base::Tdata& (void) const
{
    return m_data;
}

inline
CGenetic_code_Base::operator CGenetic_code_Base::Tdata& (void)
{
    m_set_State[0] |= 0x1;
    return m_data;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_GENETIC_CODE_BASE_HPP
