/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Ext_loc_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_EXT_LOC_BASE_HPP
#define OBJECTS_SEQFEAT_EXT_LOC_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CObject_id;
class CSeq_loc;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQFEAT_EXPORT CExt_loc_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CExt_loc_Base(void);
    // destructor
    virtual ~CExt_loc_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CObject_id TId;
    typedef CSeq_loc TLocation;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_location
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CObject_id TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(TId& value);
    TId& SetId(void);

    /// mandatory
    /// typedef CSeq_loc TLocation
    ///  Check whether the Location data member has been assigned a value.
    bool IsSetLocation(void) const;
    /// Check whether it is safe or not to call GetLocation method.
    bool CanGetLocation(void) const;
    void ResetLocation(void);
    const TLocation& GetLocation(void) const;
    void SetLocation(TLocation& value);
    TLocation& SetLocation(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CExt_loc_Base(const CExt_loc_Base&);
    CExt_loc_Base& operator=(const CExt_loc_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TId > m_Id;
    CRef< TLocation > m_Location;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CExt_loc_Base::IsSetId(void) const
{
    return m_Id.NotEmpty();
}

inline
bool CExt_loc_Base::CanGetId(void) const
{
    return true;
}

inline
const CExt_loc_Base::TId& CExt_loc_Base::GetId(void) const
{
    if ( !m_Id ) {
        const_cast<CExt_loc_Base*>(this)->ResetId();
    }
    return (*m_Id);
}

inline
CExt_loc_Base::TId& CExt_loc_Base::SetId(void)
{
    if ( !m_Id ) {
        ResetId();
    }
    return (*m_Id);
}

inline
bool CExt_loc_Base::IsSetLocation(void) const
{
    return m_Location.NotEmpty();
}

inline
bool CExt_loc_Base::CanGetLocation(void) const
{
    return true;
}

inline
const CExt_loc_Base::TLocation& CExt_loc_Base::GetLocation(void) const
{
    if ( !m_Location ) {
        const_cast<CExt_loc_Base*>(this)->ResetLocation();
    }
    return (*m_Location);
}

inline
CExt_loc_Base::TLocation& CExt_loc_Base::SetLocation(void)
{
    if ( !m_Location ) {
        ResetLocation();
    }
    return (*m_Location);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_EXT_LOC_BASE_HPP
