/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ExperimentSupport_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_EXPERIMENTSUPPORT_BASE_HPP
#define OBJECTS_SEQFEAT_EXPERIMENTSUPPORT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objects/biblio/DOI.hpp>
#include <objects/biblio/PubMedId.hpp>
#include <objects/seqfeat/EvidenceCategory.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQFEAT_EXPORT CExperimentSupport_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CExperimentSupport_Base(void);
    // destructor
    virtual ~CExperimentSupport_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TCategory;
    typedef string TExplanation;
    typedef list< CPubMedId > TPmids;
    typedef list< CDOI > TDois;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_category,
        e_explanation,
        e_pmids,
        e_dois
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef int TCategory
    ///  Check whether the Category data member has been assigned a value.
    bool IsSetCategory(void) const;
    /// Check whether it is safe or not to call GetCategory method.
    bool CanGetCategory(void) const;
    void ResetCategory(void);
    TCategory GetCategory(void) const;
    void SetCategory(TCategory value);
    TCategory& SetCategory(void);

    /// mandatory
    /// typedef string TExplanation
    ///  Check whether the Explanation data member has been assigned a value.
    bool IsSetExplanation(void) const;
    /// Check whether it is safe or not to call GetExplanation method.
    bool CanGetExplanation(void) const;
    void ResetExplanation(void);
    const TExplanation& GetExplanation(void) const;
    void SetExplanation(const TExplanation& value);
    void SetExplanation(TExplanation&& value);
    TExplanation& SetExplanation(void);

    /// optional
    /// typedef list< CPubMedId > TPmids
    ///  Check whether the Pmids data member has been assigned a value.
    bool IsSetPmids(void) const;
    /// Check whether it is safe or not to call GetPmids method.
    bool CanGetPmids(void) const;
    void ResetPmids(void);
    const TPmids& GetPmids(void) const;
    TPmids& SetPmids(void);

    /// optional
    /// typedef list< CDOI > TDois
    ///  Check whether the Dois data member has been assigned a value.
    bool IsSetDois(void) const;
    /// Check whether it is safe or not to call GetDois method.
    bool CanGetDois(void) const;
    void ResetDois(void);
    const TDois& GetDois(void) const;
    TDois& SetDois(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CExperimentSupport_Base(const CExperimentSupport_Base&);
    CExperimentSupport_Base& operator=(const CExperimentSupport_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Category;
    string m_Explanation;
    list< CPubMedId > m_Pmids;
    list< CDOI > m_Dois;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CExperimentSupport_Base::IsSetCategory(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CExperimentSupport_Base::CanGetCategory(void) const
{
    return IsSetCategory();
}

inline
void CExperimentSupport_Base::ResetCategory(void)
{
    m_Category = (int)(0);
    m_set_State[0] &= ~0x3;
}

inline
CExperimentSupport_Base::TCategory CExperimentSupport_Base::GetCategory(void) const
{
    if (!CanGetCategory()) {
        ThrowUnassigned(0);
    }
    return m_Category;
}

inline
void CExperimentSupport_Base::SetCategory(CExperimentSupport_Base::TCategory value)
{
    m_Category = value;
    m_set_State[0] |= 0x3;
}

inline
CExperimentSupport_Base::TCategory& CExperimentSupport_Base::SetCategory(void)
{
#ifdef _DEBUG
    if (!IsSetCategory()) {
        memset(&m_Category,UnassignedByte(),sizeof(m_Category));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Category;
}

inline
bool CExperimentSupport_Base::IsSetExplanation(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CExperimentSupport_Base::CanGetExplanation(void) const
{
    return IsSetExplanation();
}

inline
const CExperimentSupport_Base::TExplanation& CExperimentSupport_Base::GetExplanation(void) const
{
    if (!CanGetExplanation()) {
        ThrowUnassigned(1);
    }
    return m_Explanation;
}

inline
void CExperimentSupport_Base::SetExplanation(const CExperimentSupport_Base::TExplanation& value)
{
    m_Explanation = value;
    m_set_State[0] |= 0xc;
}

inline
void CExperimentSupport_Base::SetExplanation(CExperimentSupport_Base::TExplanation&& value)
{
    m_Explanation = std::forward<CExperimentSupport_Base::TExplanation>(value);
    m_set_State[0] |= 0xc;
}

inline
CExperimentSupport_Base::TExplanation& CExperimentSupport_Base::SetExplanation(void)
{
#ifdef _DEBUG
    if (!IsSetExplanation()) {
        m_Explanation = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Explanation;
}

inline
bool CExperimentSupport_Base::IsSetPmids(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CExperimentSupport_Base::CanGetPmids(void) const
{
    return true;
}

inline
const CExperimentSupport_Base::TPmids& CExperimentSupport_Base::GetPmids(void) const
{
    return m_Pmids;
}

inline
CExperimentSupport_Base::TPmids& CExperimentSupport_Base::SetPmids(void)
{
    m_set_State[0] |= 0x10;
    return m_Pmids;
}

inline
bool CExperimentSupport_Base::IsSetDois(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CExperimentSupport_Base::CanGetDois(void) const
{
    return true;
}

inline
const CExperimentSupport_Base::TDois& CExperimentSupport_Base::GetDois(void) const
{
    return m_Dois;
}

inline
CExperimentSupport_Base::TDois& CExperimentSupport_Base::SetDois(void)
{
    m_set_State[0] |= 0x40;
    return m_Dois;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_EXPERIMENTSUPPORT_BASE_HPP
